/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.position;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JOptionPane;
import pt.lsts.imc.state.ImcSysState;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.manager.imc.ImcMsgManager;
import pt.lsts.neptus.comm.manager.imc.ImcSystem;
import pt.lsts.neptus.comm.manager.imc.ImcSystemsHolder;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.PluginUtils;
import pt.lsts.neptus.types.coord.CoordinateUtil;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.util.ImageUtils;

@PluginDescription(icon="pt/lsts/neptus/plugins/position/position.png", name="Vehicle Position Clipboard Transferer", author="zp")
public class PositionClipboardTransferer
extends ConsolePanel {
    private static final long serialVersionUID = 1L;
    protected boolean initCalled = false;

    public PositionClipboardTransferer(ConsoleLayout console) {
        super(console);
    }

    public void initSubPanel() {
        if (this.initCalled) {
            return;
        }
        this.initCalled = true;
        this.addMenuItem("Tools>Copy Vehicle Position", ImageUtils.getIcon((String)PluginUtils.getPluginIcon(((Object)((Object)this)).getClass())), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImcSystem[] vehicles = ImcSystemsHolder.lookupActiveSystemVehicles();
                Vector<String> vids = new Vector<String>();
                for (ImcSystem s : vehicles) {
                    vids.add(s.getName());
                }
                Object answer = JOptionPane.showInputDialog((Component)PositionClipboardTransferer.this.getConsole(), "Please choose vehicle where to copy position from", "Copy vehicle position", 2, ImageUtils.getIcon((String)PluginUtils.getPluginIcon(PositionClipboardTransferer.class)), vids.toArray(new String[0]), PositionClipboardTransferer.this.getConsole().getMainSystem());
                if (answer == null) {
                    return;
                }
                NeptusLog.pub().info((Object)("<###>get position from " + answer));
                ImcSysState state = ImcMsgManager.getManager().getState(PositionClipboardTransferer.this.getConsole().getSystem((String)answer).getVehicle().getId());
                if (state == null) {
                    return;
                }
                double lat = Math.toDegrees(state.getDouble("GpsFix.GPS.lat"));
                double lon = Math.toDegrees(state.getDouble("GpsFix.GPS.lon"));
                LocationType loc = new LocationType();
                loc.setLatitudeDegs(lat);
                loc.setLongitudeDegs(lon);
                NeptusLog.pub().info((Object)("<###> " + loc));
                CoordinateUtil.copyToClipboard((LocationType)loc);
            }
        });
    }

    public void cleanSubPanel() {
    }
}

