/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.position;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.Vector;
import pt.lsts.imc.IMCMessage;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.console.plugins.MainVehicleChangeListener;
import pt.lsts.neptus.console.plugins.SubPanelChangeEvent;
import pt.lsts.neptus.console.plugins.SubPanelChangeListener;
import pt.lsts.neptus.gui.PropertiesEditor;
import pt.lsts.neptus.gui.PropertiesProvider;
import pt.lsts.neptus.plugins.NeptusMessageListener;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.PluginUtils;
import pt.lsts.neptus.renderer2d.ILayerPainter;
import pt.lsts.neptus.renderer2d.LayerPriority;
import pt.lsts.neptus.renderer2d.Renderer2DPainter;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.util.MathMiscUtils;
import pt.lsts.neptus.util.ReflectionUtil;

@PluginDescription(author="Paulo Dias", name="RemoteState Simple Display", description="Remote State simple display")
@LayerPriority(priority=60)
public class RemoteStateSimplePanel
extends ConsolePanel
implements MainVehicleChangeListener,
Renderer2DPainter,
SubPanelChangeListener,
NeptusMessageListener {
    @NeptusProperty(name="Show Icon")
    public boolean iconVisible = true;
    @NeptusProperty(name="Seconds to display ranges")
    public int secondsToDisplayRanges = 5;
    private Vector<ILayerPainter> renderers = new Vector();
    private long lastCalcPosTimeMillis = 0L;
    private double lat = Double.NaN;
    private double lon = Double.NaN;
    private double depth = Double.NaN;
    private double headingDegrees = Double.NaN;
    private static GeneralPath arrowShape = null;

    public RemoteStateSimplePanel(ConsoleLayout console) {
        super(console);
        this.setVisibility(false);
    }

    public void initSubPanel() {
        this.renderers = this.getConsole().getSubPanelsOfInterface(ILayerPainter.class);
        for (ILayerPainter str2d : this.renderers) {
            str2d.addPostRenderPainter((Renderer2DPainter)this, ((Object)((Object)this)).getClass().getSimpleName());
        }
        this.addMenuItem("Tools>" + PluginUtils.getPluginName(((Object)((Object)this)).getClass()) + ">Settings", null, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PropertiesEditor.editProperties((PropertiesProvider)RemoteStateSimplePanel.this, (Frame)RemoteStateSimplePanel.this.getConsole(), (boolean)true);
            }
        });
    }

    public String[] getObservedMessages() {
        return new String[]{"RemoteState"};
    }

    public void messageArrived(IMCMessage message) {
        try {
            double latTmp = message.getDouble("lat");
            double lonTmp = message.getDouble("lon");
            if (Double.isNaN(latTmp) || Double.isNaN(lonTmp)) {
                return;
            }
            this.lat = Math.toDegrees(latTmp);
            this.lon = Math.toDegrees(lonTmp);
            this.lastCalcPosTimeMillis = System.currentTimeMillis();
            this.depth = message.getDouble("depth");
            double headingTmp = message.getDouble("psi");
            if (!Double.isNaN(headingTmp)) {
                this.headingDegrees = Math.toDegrees(headingTmp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void subPanelChanged(SubPanelChangeEvent panelChange) {
        if (panelChange == null) {
            return;
        }
        if (ReflectionUtil.hasInterface(panelChange.getPanel().getClass(), ILayerPainter.class)) {
            ILayerPainter str2d;
            ILayerPainter sub = (ILayerPainter)panelChange.getPanel();
            if (panelChange.added()) {
                this.renderers.add(sub);
                str2d = sub;
                if (str2d != null) {
                    str2d.addPostRenderPainter((Renderer2DPainter)this, "GPS FIX");
                }
            }
            if (panelChange.removed()) {
                this.renderers.remove(sub);
                str2d = sub;
                if (str2d != null) {
                    str2d.removePostRenderPainter((Renderer2DPainter)this);
                }
            }
        }
    }

    public void paint(Graphics2D g2, StateRenderer2D renderer) {
        if (this.iconVisible) {
            if (Double.isNaN(this.lat) || Double.isNaN(this.lon)) {
                return;
            }
            double alfaPercentage = 1.0;
            long deltaTimeMillis = System.currentTimeMillis() - this.lastCalcPosTimeMillis;
            if ((double)deltaTimeMillis > (double)this.secondsToDisplayRanges * 1000.0 / 2.0) {
                alfaPercentage = 0.5;
            } else if ((double)deltaTimeMillis > (double)this.secondsToDisplayRanges * 1000.0 / 4.0) {
                alfaPercentage = 0.7;
            }
            double rotationAngle = renderer.getRotation();
            LocationType lt = new LocationType();
            lt.setLatitudeDegs(this.lat);
            lt.setLongitudeDegs(this.lon);
            Point2D centerPos = renderer.getScreenPosition(new LocationType(lt));
            Graphics2D g = (Graphics2D)g2.create();
            g.setColor(new Color(0, 0, 0, (int)(255.0 * alfaPercentage)));
            g.draw(new Ellipse2D.Double(centerPos.getX() - 10.0, centerPos.getY() - 10.0, 20.0, 20.0));
            g.setColor(new Color(139, 69, 19, (int)(255.0 * alfaPercentage)));
            g.draw(new Ellipse2D.Double(centerPos.getX() - 12.0, centerPos.getY() - 12.0, 24.0, 24.0));
            g.setColor(new Color(0, 0, 0, (int)(255.0 * alfaPercentage)));
            g.draw(new Ellipse2D.Double(centerPos.getX() - 14.0, centerPos.getY() - 14.0, 28.0, 28.0));
            g.translate(centerPos.getX(), centerPos.getY());
            Color color = new Color(139, 69, 19).darker();
            g.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)(200.0 * alfaPercentage)));
            g.fill(new Ellipse2D.Double(-7.0, -7.0, 14.0, 14.0));
            color = new Color(139, 69, 19, 0).brighter();
            g.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)(150.0 * alfaPercentage)));
            g.setStroke(new BasicStroke(2.0f));
            g.draw(new Ellipse2D.Double(-7.0, -7.0, 14.0, 14.0));
            g.setColor(new Color(0, 0, 0, (int)(150.0 * alfaPercentage)));
            g.fill(new Ellipse2D.Double(-2.0, -2.0, 4.0, 4.0));
            g.setColor(Color.BLACK);
            if (this.getConsole() != null && this.getConsole().getMainSystem() != null) {
                g.drawString("RemoteState " + this.getConsole().getMainSystem() + " :: depth=" + MathMiscUtils.round((double)this.depth, (int)1), 10, 15);
            }
            if (!Double.isNaN(this.headingDegrees)) {
                double newYaw = Math.toRadians(this.headingDegrees);
                GeneralPath shape = RemoteStateSimplePanel.getArrow();
                g.rotate(-rotationAngle);
                g.rotate(newYaw + Math.PI);
                color = Color.BLACK;
                g.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)(150.0 * alfaPercentage)));
                g.setStroke(new BasicStroke(2.0f));
                g.fill(shape);
                color = Color.BLACK.darker();
                g.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)(150.0 * alfaPercentage)));
                g.draw(shape);
                g.setColor(Color.BLACK);
                g.rotate(-(newYaw + Math.PI));
                g.rotate(rotationAngle);
            }
            g.translate(-centerPos.getX(), -centerPos.getY());
        }
    }

    public void cleanSubPanel() {
        this.renderers = this.getConsole().getSubPanelsOfInterface(ILayerPainter.class);
        for (ILayerPainter str2d : this.renderers) {
            str2d.removePostRenderPainter((Renderer2DPainter)this);
        }
    }

    private static GeneralPath getArrow() {
        if (arrowShape == null) {
            arrowShape = new GeneralPath();
            arrowShape.moveTo(-2.0f, 0.0f);
            arrowShape.lineTo(2.0f, 0.0f);
            arrowShape.lineTo(2.0f, 0.0f);
            arrowShape.lineTo(8.0f, 0.0f);
            arrowShape.lineTo(0.0f, 8.0f);
            arrowShape.lineTo(-8.0f, 0.0f);
            arrowShape.lineTo(-2.0f, 0.0f);
            arrowShape.closePath();
        }
        return arrowShape;
    }
}

