/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.position;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import pt.lsts.neptus.comm.manager.imc.ImcMsgManager;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.console.plugins.AlarmProviderOld;
import pt.lsts.neptus.console.plugins.ConsoleScript;
import pt.lsts.neptus.plugins.ConfigurationListener;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.position.DisplayPanel;
import pt.lsts.neptus.plugins.update.IPeriodicUpdates;
import pt.lsts.neptus.util.GuiUtils;

@PluginDescription(name="Generic Display", icon="pt/lsts/neptus/plugins/position/position.png", description="A display that updates itself according to a script (Javascript)")
public class ScriptedDisplay
extends ConsolePanel
implements IPeriodicUpdates,
ConfigurationListener,
AlarmProviderOld {
    private DisplayPanel display;
    @NeptusProperty(name="Update interval", description="Interval between updates in milliseconds")
    public long millisBetweenUpdates = 100L;
    @NeptusProperty(name="Title", description="Title to use")
    public String title = "";
    @NeptusProperty(name="Font Size", description="Font size (0 for auto-adjust)")
    public int fontSize = 0;
    @NeptusProperty(name="Script", description="Script to run. Use $(var) to access message fields like in $(EstimatedState.Navigation.x)")
    public String script = "java.lang.System.currentTimeMillis()%10000";
    @NeptusProperty(name="Decimal digits", description="Decimal digits, applicable only to numeric data. Use -1 for default or text data.")
    public int digits = -1;
    @NeptusProperty(name="Trailing text", description="Text appended to script (optional). Can be used to set display units.")
    public String units = "";
    @NeptusProperty(name="Alarm condition", description="Condition to generate an alarm (optional)")
    public String alarm = "";
    protected int count = 0;
    ConsoleScript conScript = new ConsoleScript();
    protected int lastState = -1;

    public String validateScript(String script) {
        try {
            new ConsoleScript().setScript(script);
        }
        catch (Exception e) {
            return e.getMessage();
        }
        return null;
    }

    public ScriptedDisplay(ConsoleLayout console) {
        super(console);
        this.initialize();
    }

    protected void initialize() {
        this.display = new DisplayPanel(this.title);
        this.setLayout(new BorderLayout());
        this.add((Component)((Object)this.display), "Center");
        this.propertiesChanged();
    }

    public long millisBetweenUpdates() {
        return this.millisBetweenUpdates;
    }

    public static int parseAlarmState(Object value) {
        if (value instanceof Boolean) {
            if (((Boolean)value).booleanValue()) {
                return 4;
            }
            return 0;
        }
        if (value instanceof Number) {
            int val = ((Number)value).intValue();
            if (val > 5 || val < -2) {
                val = -1;
            }
            return val;
        }
        return -1;
    }

    public void propertiesChanged() {
        this.count = 0;
        this.display.setTitle(this.title);
        this.display.setFontSize(this.fontSize);
        try {
            this.conScript.setScript(this.script);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean update() {
        ++this.count;
        try {
            String text = this.conScript.evaluate(ImcMsgManager.getManager().getState(this.getConsole().getMainSystem())).toString();
            if (this.digits > -1) {
                try {
                    text = GuiUtils.getNeptusDecimalFormat((int)this.digits).format(Double.parseDouble(text));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            text = text + " " + this.units;
            this.display.setText(text);
            if (this.alarm.length() > 0) {
                if (this.lastState == 4) {
                    this.display.setForeground(Color.red.darker());
                } else {
                    this.display.setForeground(Color.green.darker());
                }
            }
        }
        catch (Exception e) {
            this.display.setText(e.getMessage());
        }
        if (this.count > 10 && this.alarm.length() > 0) {
            this.count = 0;
            int alarmState = ScriptedDisplay.parseAlarmState(this.getConsole().evaluateScript(this.alarm));
            if (alarmState != this.lastState) {
                this.lastState = alarmState;
                this.getMainpanel().getAlarmlistener().updateAlarmsListeners((AlarmProviderOld)this);
            }
        }
        return true;
    }

    public int sourceState() {
        return this.lastState;
    }

    public String getAlarmMessage() {
        if (this.lastState == 4) {
            if (this.title != null) {
                return this.title + " = " + this.display.getText();
            }
            return this.display.getText();
        }
        return "ok";
    }

    public int getAlarmState() {
        return this.lastState;
    }

    public void initSubPanel() {
    }

    public void cleanSubPanel() {
    }
}

