/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.position;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.text.DecimalFormat;
import pt.lsts.imc.IMCMessage;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.plugins.ConfigurationListener;
import pt.lsts.neptus.plugins.NeptusMessageListener;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.position.DisplayPanel;
import pt.lsts.neptus.plugins.update.IPeriodicUpdates;

@PluginDescription(name="Vehicle Speed", author="ZP and Paulo Dias", icon="pt/lsts/neptus/plugins/position/position.png", description="Shows the Vehicle's speed")
public class SpeedPanel
extends ConsolePanel
implements IPeriodicUpdates,
ConfigurationListener,
NeptusMessageListener {
    private DisplayPanel displaySpeed;
    private DecimalFormat formatter = new DecimalFormat("0.00");
    private long lastUpdate = 0L;
    @NeptusProperty(name="Update interval", description="Interval between updates in milliseconds")
    public long millisBetweenUpdates = 100L;
    @NeptusProperty(name="True or Indicated Speed", description="true for True and false for Indicated Speed")
    public boolean isTrueSpeed = true;
    @NeptusProperty(name="SI Unit or knots", description="true for m/s and false for knot")
    public boolean isSIUnit = true;
    @NeptusProperty(name="Font Size", description="The font size. Use '0' for automatic.")
    public int fontSize = 16;
    protected final double m_sToKnotConv = 1.94384449244;
    private String partSpeedTxt = " speed ";
    boolean connected = true;

    public SpeedPanel(ConsoleLayout console) {
        super(console);
        this.initialize();
    }

    protected void initialize() {
        this.displaySpeed = new DisplayPanel((this.isTrueSpeed ? "true" : "ind.") + this.partSpeedTxt + (this.isSIUnit ? "(m/s)" : "(knot)"));
        this.displaySpeed.setFontSize(this.fontSize);
        this.setLayout(new BorderLayout());
        this.add((Component)((Object)this.displaySpeed), "Center");
    }

    public void propertiesChanged() {
        this.displaySpeed.setFontSize(this.fontSize);
        this.invalidate();
        this.revalidate();
    }

    public long millisBetweenUpdates() {
        return 500L;
    }

    public boolean update() {
        if (this.connected && System.currentTimeMillis() - this.lastUpdate > 3000L) {
            this.displaySpeed.setFontColor(Color.red.darker());
            this.connected = false;
        }
        if (!this.connected && System.currentTimeMillis() - this.lastUpdate < 3000L) {
            this.displaySpeed.setFontColor(Color.black);
            this.connected = true;
        }
        return true;
    }

    public void cleanSubPanel() {
    }

    public String[] getObservedMessages() {
        return new String[]{"EstimatedState"};
    }

    public void messageArrived(IMCMessage message) {
        double w;
        double v;
        double u;
        if (this.isTrueSpeed) {
            u = message.getDouble("vx");
            v = message.getDouble("vy");
            w = message.getDouble("vz");
        } else {
            u = message.getDouble("u");
            v = message.getDouble("v");
            w = message.getDouble("w");
        }
        double res = Math.sqrt(u * u + v * v + w * w);
        res = this.isSIUnit ? res : res * 1.94384449244;
        this.displaySpeed.setText(this.formatter.format(res));
        this.displaySpeed.setTitle((this.isTrueSpeed ? "true" : "ind.") + this.partSpeedTxt + (this.isSIUnit ? "(m/s)" : "(knot)"));
        this.lastUpdate = System.currentTimeMillis();
    }

    public void initSubPanel() {
    }
}

