/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.position;

import java.awt.BorderLayout;
import java.awt.Component;
import java.text.NumberFormat;
import org.jdesktop.swingx.JXLabel;
import pt.lsts.imc.IMCMessage;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.plugins.ConfigurationListener;
import pt.lsts.neptus.plugins.NeptusMessageListener;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.position.DisplayPanel;
import pt.lsts.neptus.plugins.position.OrientationIcon;
import pt.lsts.neptus.util.GuiUtils;

@PluginDescription(name="Stream Speed Display", author="zp", icon="pt/lsts/neptus/plugins/position/position.png")
public class StreamSpeed
extends ConsolePanel
implements NeptusMessageListener,
ConfigurationListener {
    @NeptusProperty(name="Font Size", description="The font size. Use '0' for automatic.")
    public int fontSize = 16;
    protected double angle = 0.0;
    protected double speed = 0.0;
    protected OrientationIcon icon = new OrientationIcon(20, 2);
    protected DisplayPanel display = new DisplayPanel("");
    protected NumberFormat nf = GuiUtils.getNeptusDecimalFormat((int)2);

    public StreamSpeed(ConsoleLayout console) {
        super(console);
        this.setLayout(new BorderLayout());
        this.display.setTitle("Stream Speed");
        this.display.setIcon(this.icon);
        this.display.setHorizontalAlignment(2);
        this.display.setTextAlignment(JXLabel.TextAlignment.RIGHT);
        this.display.setFontSize(this.fontSize);
        this.add((Component)((Object)this.display), "Center");
    }

    public void propertiesChanged() {
        this.display.setFontSize(this.fontSize);
        this.invalidate();
        this.revalidate();
    }

    public String[] getObservedMessages() {
        return new String[]{"EstimatedStreamVelocity"};
    }

    public void messageArrived(IMCMessage message) {
        double x = message.getDouble("x");
        double y = message.getDouble("y");
        this.speed = Math.sqrt(x * x + y * y);
        this.angle = Math.atan2(x, y);
        this.icon.setAngleRadians(this.angle);
        this.display.setText("    " + this.nf.format(this.speed) + " m/s");
    }

    public void initSubPanel() {
    }

    public void cleanSubPanel() {
    }
}

