/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.position;

import com.google.common.eventbus.Subscribe;
import java.awt.Graphics2D;
import pt.lsts.imc.GpsFix;
import pt.lsts.neptus.colormap.ColorMap;
import pt.lsts.neptus.colormap.ColorMapFactory;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.renderer2d.Renderer2DPainter;
import pt.lsts.neptus.renderer2d.StateRenderer2D;

@PluginDescription(name="Stream Speed Overlay")
public class StreamSpeedOverlay
extends ConsolePanel
implements Renderer2DPainter {
    private static final long serialVersionUID = 1L;
    protected double cogRads = 0.0;
    protected double speedMps = 0.0;
    protected final double MAX_SPEED = 2.0;
    ColorMap cmap = ColorMapFactory.createRedYellowGreenColorMap();

    public StreamSpeedOverlay(ConsoleLayout console) {
        super(console);
    }

    public void paint(Graphics2D g, StateRenderer2D renderer) {
        g.setColor(this.cmap.getColor(Math.max(0.0, 2.0 - this.speedMps) / 2.0));
        g.translate(renderer.getWidth() - 100, 200);
        g.rotate(this.cogRads);
        g.drawString("" + (int)this.speedMps + " m/s", 0, 0);
    }

    @Subscribe
    public void consume(GpsFix gpsfix) {
        String sysId = gpsfix.getSourceName();
        if (this.getConsole().getMainSystem() != null && sysId.equals(this.getConsole().getMainSystem())) {
            return;
        }
        this.cogRads = gpsfix.getCog();
        this.speedMps = gpsfix.getSog();
    }

    public void initSubPanel() {
    }

    public void cleanSubPanel() {
    }
}

