/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.position;

import com.google.common.eventbus.Subscribe;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.util.Vector;
import pt.lsts.imc.EstimatedStreamVelocity;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.console.plugins.MainVehicleChangeListener;
import pt.lsts.neptus.console.plugins.SubPanelChangeEvent;
import pt.lsts.neptus.console.plugins.SubPanelChangeListener;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.renderer2d.ILayerPainter;
import pt.lsts.neptus.renderer2d.LayerPriority;
import pt.lsts.neptus.renderer2d.Renderer2DPainter;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.util.ReflectionUtil;

@PluginDescription(author="Rui Gon\u00e7alves", name="StreamSpeedPanel", icon="pt/lsts/neptus/plugins/position/wind.png", description="Stream Speed Display2")
@LayerPriority(priority=100)
public class StreamSpeedPanel
extends ConsolePanel
implements MainVehicleChangeListener,
Renderer2DPainter,
SubPanelChangeListener {
    private Vector<ILayerPainter> renderers = new Vector();
    private boolean initCalled = false;
    private double strX;
    private double strY;

    public StreamSpeedPanel(ConsoleLayout console) {
        super(console);
        this.setVisibility(false);
    }

    public void initSubPanel() {
        this.renderers = this.getConsole().getSubPanelsOfInterface(ILayerPainter.class);
        for (ILayerPainter str2d : this.renderers) {
            str2d.addPostRenderPainter((Renderer2DPainter)this, ((Object)((Object)this)).getClass().getSimpleName());
        }
        if (this.initCalled) {
            return;
        }
        this.initCalled = true;
    }

    public void subPanelChanged(SubPanelChangeEvent panelChange) {
        if (panelChange == null) {
            return;
        }
        if (ReflectionUtil.hasInterface(panelChange.getPanel().getClass(), ILayerPainter.class)) {
            ILayerPainter str2d;
            ILayerPainter sub = (ILayerPainter)panelChange.getPanel();
            if (panelChange.added()) {
                this.renderers.add(sub);
                str2d = sub;
                if (str2d != null) {
                    str2d.addPostRenderPainter((Renderer2DPainter)this, "Stream Speed");
                }
            }
            if (panelChange.removed()) {
                this.renderers.remove(sub);
                str2d = sub;
                if (str2d != null) {
                    str2d.removePostRenderPainter((Renderer2DPainter)this);
                }
            }
        }
    }

    public void paint(Graphics2D g2, StateRenderer2D renderer) {
        int rWidth = renderer.getWidth();
        double rangle = renderer.getRotation();
        double windAngle = Math.atan2(this.strY, this.strX);
        rangle -= windAngle;
        int width = 70;
        int height = 80;
        int cornerX = rWidth - 100 - width;
        int cornerY = 10;
        g2.setColor(new Color(255, 255, 255, 100));
        g2.fillRect(cornerX, cornerY, width, height);
        g2.setColor(Color.BLACK);
        g2.drawRect(cornerX, cornerY, width, height);
        DecimalFormat myFormatter = new DecimalFormat("###.##");
        String output = myFormatter.format(Math.sqrt(this.strX * this.strX + this.strY * this.strY));
        String text = output + " m/s";
        Rectangle2D stringBounds = g2.getFontMetrics().getStringBounds(text, g2);
        int advance = (int)((double)(width - 20) - stringBounds.getWidth()) / 2;
        g2.drawString(text, advance + cornerX + 10, cornerY + 25);
        g2.drawString("wind", 12 + cornerX + 12, cornerY + 11);
        g2.translate(cornerX + width / 2, cornerY + height / 2 + 13);
        g2.rotate(-rangle);
        GeneralPath red = new GeneralPath();
        red.moveTo(4.0f, -15.0f);
        red.lineTo(-4.0f, -15.0f);
        red.lineTo(-5.0f, -5.0f);
        red.lineTo(5.0f, -5.0f);
        red.closePath();
        red.moveTo(6.0f, 5.0f);
        red.lineTo(-6.0f, 5.0f);
        red.lineTo(-7.0f, 15.0f);
        red.lineTo(7.0f, 15.0f);
        red.closePath();
        g2.setColor(new Color(255, 0, 0, 150));
        g2.fill(red);
        GeneralPath white = new GeneralPath();
        white.moveTo(6.0f, 5.0f);
        white.lineTo(-6.0f, 5.0f);
        white.lineTo(-5.0f, -5.0f);
        white.lineTo(5.0f, -5.0f);
        white.closePath();
        g2.setColor(new Color(255, 255, 255, 150));
        g2.fill(white);
        GeneralPath outline = new GeneralPath();
        outline.moveTo(-7.0f, 15.0f);
        outline.lineTo(7.0f, 15.0f);
        outline.lineTo(4.0f, -15.0f);
        outline.lineTo(-4.0f, -15.0f);
        outline.closePath();
        g2.setColor(Color.BLACK);
        g2.draw(outline);
        g2.translate(-(cornerX + width / 2), -(cornerY + height / 2 + 13));
    }

    public void cleanSubPanel() {
        this.renderers = this.getConsole().getSubPanelsOfInterface(ILayerPainter.class);
        for (ILayerPainter str2d : this.renderers) {
            str2d.removePostRenderPainter((Renderer2DPainter)this);
        }
    }

    @Subscribe
    public void on(EstimatedStreamVelocity msg) {
        if (!msg.getSourceName().equals(this.getConsole().getMainSystem())) {
            return;
        }
        this.strX = msg.getX();
        this.strY = msg.getY();
    }
}

