/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.position.painter;

import com.google.common.eventbus.Subscribe;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import pt.lsts.imc.CpuUsage;
import pt.lsts.imc.Current;
import pt.lsts.imc.FuelLevel;
import pt.lsts.imc.Heartbeat;
import pt.lsts.imc.StorageUsage;
import pt.lsts.imc.Voltage;
import pt.lsts.imc.state.ImcSysState;
import pt.lsts.neptus.colormap.ColorMap;
import pt.lsts.neptus.colormap.ColorMapFactory;
import pt.lsts.neptus.colormap.InterpolationColorMap;
import pt.lsts.neptus.comm.manager.imc.EntitiesResolver;
import pt.lsts.neptus.console.ConsoleLayer;
import pt.lsts.neptus.console.events.ConsoleEventMainSystemChange;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.update.Periodic;
import pt.lsts.neptus.renderer2d.LayerPriority;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.util.MathMiscUtils;

@PluginDescription(name="System Information On Map", icon="pt/lsts/neptus/plugins/position/painter/sysinfo.png", description="System Information display on map", documentation="system-info/system-info.html", category=PluginDescription.CATEGORY.INTERFACE)
@LayerPriority(priority=70)
public class SystemInfoPainter
extends ConsoleLayer {
    private static final int RECT_WIDTH = 200;
    private static final int RECT_HEIGHT = 70;
    private static final int MARGIN = 5;
    private String strCpu;
    private String strFuel;
    private String strComms;
    private String strDisk;
    @NeptusProperty(name="Enable")
    public boolean enablePainter = true;
    @NeptusProperty(name="Enable Info", description="Paint Vehicle Information on panel")
    public boolean paintInfo = true;
    @NeptusProperty(name="Display Confidence Level", description="Display Fuel Level estimation Confidence on panel")
    public boolean showConfidence = true;
    @NeptusProperty(name="Display Current", description="Display drawn Current on panel")
    public boolean showCurrent = false;
    @NeptusProperty(name="Entity Name", description="Vehicle Battery entity name")
    public String batteryEntityName = "Batteries";
    private JLabel toDraw;
    private String mainSysName;
    long lastMessageMillis = 0L;
    private int cpuUsage = 0;
    private double batteryVoltage;
    private double current;
    private float fuelLevel;
    private float confidenceLevel;
    private int storageUsage;
    private int hbCount = 0;
    private int lastHbCount = 0;
    private InterpolationColorMap rygColorMap = new InterpolationColorMap(new double[]{0.0, 0.01, 0.75, 1.0}, new Color[]{Color.black, Color.red.brighter(), Color.yellow, Color.green.brighter()});
    private InterpolationColorMap greenToBlack = new InterpolationColorMap(new double[]{0.0, 0.75, 1.0}, new Color[]{Color.black, Color.green.darker(), Color.green.brighter().brighter()});
    private ColorMap rygInverted = ColorMapFactory.createInvertedColorMap((InterpolationColorMap)this.rygColorMap);

    public void initLayer() {
        this.mainSysName = this.getConsole().getMainSystem();
        this.toDraw = new JLabel("<html></html>");
        this.strCpu = I18n.textc((String)"CPU", (String)"Use a single small word");
        this.strFuel = I18n.textc((String)"Fuel", (String)"Use a single small word");
        this.strDisk = I18n.textc((String)"Disk", (String)"Use a single small word");
        this.strComms = I18n.textc((String)"Comms", (String)"Use a single small word");
    }

    private String getColor(double percent, boolean inverted, boolean commsDead) {
        if (commsDead) {
            return "#000000";
        }
        Color c = !inverted ? this.rygColorMap.getColor(percent / 100.0) : this.rygInverted.getColor(percent / 100.0);
        return String.format("#%02X%02X%02X", c.getRed(), c.getGreen(), c.getBlue());
    }

    public void paint(Graphics2D g, StateRenderer2D renderer) {
        if (!this.enablePainter || this.mainSysName == null) {
            return;
        }
        boolean commsDead = false;
        if (System.currentTimeMillis() - this.lastMessageMillis > 10000L) {
            commsDead = true;
        }
        if (this.paintInfo) {
            if (this.lastHbCount > 5) {
                this.lastHbCount = 5;
            }
            String txt = "<html>";
            txt = txt + "<b>" + this.strCpu + ":</b> <font color=" + this.getColor(this.cpuUsage, true, commsDead) + ">" + this.cpuUsage + "%</font><br/>";
            txt = txt + "<b>" + this.strFuel + ":</b> <font color=" + this.getColor(this.fuelLevel, false, commsDead) + ">" + (int)this.fuelLevel + "%</font> <font color=#cccccc>(" + (float)((int)(this.batteryVoltage * 100.0)) / 100.0f + "V";
            if (this.showCurrent) {
                txt = txt + "@" + (float)((int)(this.current * 100.0)) / 100.0f + "A";
            }
            if (this.showConfidence) {
                txt = txt + ", ~" + MathMiscUtils.round((float)this.confidenceLevel, (int)2) + "%";
            }
            txt = txt + "</font>)<br/>";
            txt = txt + "<b>" + this.strDisk + ":</b> <font color=" + this.getColor(this.storageUsage, false, commsDead) + ">" + this.storageUsage + "%</font><br/>";
            txt = txt + "<b>" + this.strComms + ":</b> <font color=" + this.getColor(this.lastHbCount * 20, false, commsDead) + ">" + this.lastHbCount * 20 + "%</font><br/>";
            txt = txt + "</html>";
            this.toDraw.setText(txt);
            this.toDraw.setForeground(Color.white);
            this.toDraw.setHorizontalTextPosition(0);
            this.toDraw.setHorizontalAlignment(2);
            this.toDraw.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            g.setColor(new Color(0, 0, 0, 200));
            g.drawRoundRect(renderer.getWidth() - 200 - 5, renderer.getHeight() - 70 - 5, 200, 70, 20, 20);
            g.setColor(new Color(0, 0, 0, 100));
            g.fillRoundRect(renderer.getWidth() - 200 - 5, renderer.getHeight() - 70 - 5, 200, 70, 20, 20);
            g.translate(renderer.getWidth() - 200 - 5, renderer.getHeight() - 70 - 5);
            this.toDraw.setBounds(0, 0, 200, 70);
            this.toDraw.paint(g);
        }
        double ellapsed = System.currentTimeMillis() - this.lastMessageMillis;
        double val = Math.max(0.0, (3000.0 - ellapsed) / 3000.0);
        g.setColor(this.greenToBlack.getColor(val));
        g.fill(new Ellipse2D.Double(186.0, 9.0, 8.0, 8.0));
    }

    @Subscribe
    public void consume(CpuUsage msg) {
        if (!msg.getSourceName().equals(this.mainSysName)) {
            return;
        }
        this.cpuUsage = msg.getValue();
    }

    @Subscribe
    public void consume(StorageUsage msg) {
        if (!msg.getSourceName().equals(this.mainSysName)) {
            return;
        }
        this.storageUsage = 100 - msg.getValue();
    }

    @Subscribe
    public void consume(Voltage msg) {
        if (!msg.getSourceName().equals(this.mainSysName)) {
            return;
        }
        int id = EntitiesResolver.resolveId((String)this.mainSysName, (String)this.batteryEntityName);
        if (msg.getSrcEnt() != id) {
            return;
        }
        this.batteryVoltage = msg.getValue();
    }

    @Subscribe
    public void consume(Current msg) {
        if (!msg.getSourceName().equals(this.mainSysName)) {
            return;
        }
        int id = EntitiesResolver.resolveId((String)this.mainSysName, (String)this.batteryEntityName);
        if (msg.getSrcEnt() != id) {
            return;
        }
        this.current = msg.getValue();
    }

    @Subscribe
    public void consume(FuelLevel msg) {
        if (!msg.getSourceName().equals(this.mainSysName)) {
            return;
        }
        this.fuelLevel = (float)msg.getValue();
        this.confidenceLevel = (float)msg.getConfidence();
    }

    @Subscribe
    public void consume(Heartbeat msg) {
        if (!msg.getSourceName().equals(this.mainSysName)) {
            return;
        }
        ++this.hbCount;
        this.lastMessageMillis = System.currentTimeMillis();
    }

    @Subscribe
    public void consume(ConsoleEventMainSystemChange ev) {
        this.batteryVoltage = 0.0;
        this.current = 0.0;
        this.fuelLevel = 0.0f;
        this.cpuUsage = 0;
        this.storageUsage = 0;
        this.hbCount = 0;
        this.mainSysName = ev.getCurrent();
        ImcSysState state = this.getState();
        if (state != null) {
            if (state.lastHeartbeat() != null) {
                this.lastMessageMillis = state.lastHeartbeat().getTimestampMillis();
            }
            if (state.lastStorageUsage() != null) {
                this.storageUsage = 100 - state.lastStorageUsage().getValue();
            }
            if (state.lastCpuUsage() != null) {
                this.cpuUsage = state.lastCpuUsage().getValue();
            }
            if (state.lastFuelLevel() != null) {
                this.fuelLevel = (float)state.lastFuelLevel().getValue();
            }
            try {
                if (state.lastVoltage(this.batteryEntityName) != null) {
                    this.batteryVoltage = state.lastVoltage(this.batteryEntityName).getValue();
                }
            }
            catch (Exception e) {
                this.batteryVoltage = 0.0;
            }
        }
    }

    @Periodic(millisBetweenUpdates=5000)
    public boolean update() {
        this.lastHbCount = this.hbCount;
        this.hbCount = 0;
        return true;
    }

    public boolean userControlsOpacity() {
        return false;
    }

    public void cleanLayer() {
    }
}

