/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.followref;

import com.google.common.eventbus.Subscribe;
import com.l2fprod.common.propertysheet.Property;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.util.Arrays;
import javax.swing.JPopupMenu;
import pt.lsts.imc.DesiredSpeed;
import pt.lsts.imc.DesiredZ;
import pt.lsts.imc.EstimatedState;
import pt.lsts.imc.FollowRefState;
import pt.lsts.imc.FollowReference;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.Maneuver;
import pt.lsts.imc.PlanControl;
import pt.lsts.imc.PlanControlState;
import pt.lsts.imc.PlanManeuver;
import pt.lsts.imc.PlanSpecification;
import pt.lsts.imc.Reference;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.events.ConsoleEventMainSystemChange;
import pt.lsts.neptus.gui.PropertiesEditor;
import pt.lsts.neptus.gui.PropertiesProvider;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.SimpleRendererInteraction;
import pt.lsts.neptus.plugins.update.IPeriodicUpdates;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.LocationType;

@PluginDescription(name="FollowReference Control")
public class FollowReferenceControl
extends SimpleRendererInteraction
implements IPeriodicUpdates {
    private static final long serialVersionUID = 1L;
    protected boolean frefActive = false;
    protected FollowRefState lastFrefState = null;
    protected EstimatedState lastState = null;
    protected Reference ref = null;
    protected boolean movingReference = false;
    protected double radius = 8.0;
    @NeptusProperty
    public double depth = 3.0;
    @NeptusProperty
    public double speed = 1.3;
    @NeptusProperty
    public boolean useAcousticModem = false;
    @NeptusProperty
    public boolean allowControlFromWebService = false;

    public FollowReferenceControl(ConsoleLayout cl) {
        super(cl);
    }

    public long millisBetweenUpdates() {
        return 1000L;
    }

    public boolean update() {
        if (this.ref != null) {
            this.send((IMCMessage)this.ref);
        }
        return true;
    }

    @Subscribe
    public void on(EstimatedState estimatedState) {
        if (estimatedState.getSourceName().equals(this.getConsole().getMainSystem())) {
            this.lastState = estimatedState;
        }
    }

    public void setProperties(Property[] properties) {
        super.setProperties(properties);
        double z = this.depth;
        DesiredZ.Z_UNITS units = DesiredZ.Z_UNITS.DEPTH;
        if (z < 0.0) {
            units = DesiredZ.Z_UNITS.ALTITUDE;
            z = -z;
        }
        this.ref.setZ(new DesiredZ((float)z, units));
        this.ref.setSpeed(new DesiredSpeed(this.speed, DesiredSpeed.SPEED_UNITS.METERS_PS));
    }

    @Subscribe
    public void on(PlanControlState controlState) {
        if (!controlState.getSourceName().equals(this.getConsole().getMainSystem())) {
            return;
        }
        if (this.lastState == null) {
            return;
        }
        boolean wasActive = this.frefActive;
        this.frefActive = controlState.getPlanId().equals("follow_neptus") && controlState.getState() == PlanControlState.STATE.EXECUTING;
        if (!wasActive && this.frefActive) {
            this.ref = new Reference();
            LocationType loc = new LocationType(Math.toDegrees(this.lastState.getLat()), Math.toDegrees(this.lastState.getLon()));
            loc.translatePosition(this.lastState.getX(), this.lastState.getY(), 0.0);
            loc.convertToAbsoluteLatLonDepth();
            this.ref.setLat(loc.getLatitudeRads());
            this.ref.setLon(loc.getLongitudeRads());
            double z = this.depth;
            DesiredZ.Z_UNITS units = DesiredZ.Z_UNITS.DEPTH;
            if (z < 0.0) {
                units = DesiredZ.Z_UNITS.ALTITUDE;
                z = -z;
            }
            this.ref.setZ(new DesiredZ((float)z, units));
            this.ref.setSpeed(new DesiredSpeed(this.speed, DesiredSpeed.SPEED_UNITS.METERS_PS));
            this.ref.setFlags((short)7);
        }
        if (wasActive && !this.frefActive) {
            this.ref = null;
        }
    }

    @Subscribe
    public void on(FollowRefState frefState) {
        if (frefState.getSourceName().equals(this.getConsole().getMainSystem())) {
            this.lastFrefState = frefState;
        }
    }

    public void on(ConsoleEventMainSystemChange event) {
        this.frefActive = false;
        this.lastState = null;
        this.lastFrefState = null;
        this.ref = null;
    }

    public void paint(Graphics2D g, StateRenderer2D renderer) {
        super.paint(g, renderer);
        if (this.ref != null) {
            Color c = Color.red;
            if (this.lastFrefState != null && this.ref.getLat() == this.lastFrefState.getReference().getLat() && this.ref.getLon() == this.lastFrefState.getReference().getLon()) {
                c = Color.green;
            }
            LocationType loc = new LocationType(Math.toDegrees(this.ref.getLat()), Math.toDegrees(this.ref.getLon()));
            Point2D pt = renderer.getScreenPosition(loc);
            Ellipse2D.Double ellis = new Ellipse2D.Double(pt.getX() - this.radius, pt.getY() - this.radius, this.radius * 2.0, this.radius * 2.0);
            g.setColor(c);
            g.fill(ellis);
        }
    }

    public void mousePressed(MouseEvent event, StateRenderer2D source) {
        if (this.ref == null) {
            super.mousePressed(event, source);
        }
        LocationType pressed = source.getRealWorldLocation((Point2D)event.getPoint());
        pressed.convertToAbsoluteLatLonDepth();
        LocationType refLoc = new LocationType(Math.toDegrees(this.ref.getLat()), Math.toDegrees(this.ref.getLon()));
        double dist = pressed.getPixelDistanceTo(refLoc, source.getLevelOfDetail());
        if (dist < this.radius) {
            this.movingReference = true;
            this.ref.setLat(pressed.getLatitudeRads());
            this.ref.setLon(pressed.getLongitudeRads());
            source.repaint();
        } else {
            super.mousePressed(event, source);
        }
    }

    public void mouseReleased(MouseEvent event, StateRenderer2D source) {
        this.movingReference = false;
        super.mouseReleased(event, source);
    }

    public void mouseDragged(MouseEvent event, StateRenderer2D source) {
        if (!this.movingReference) {
            super.mouseDragged(event, source);
        } else {
            LocationType pressed = source.getRealWorldLocation((Point2D)event.getPoint());
            this.ref.setLat(pressed.getLatitudeRads());
            this.ref.setLon(pressed.getLongitudeRads());
            source.repaint();
        }
    }

    public void mouseClicked(final MouseEvent event, final StateRenderer2D source) {
        super.mouseClicked(event, source);
        if (event.getButton() == 3) {
            JPopupMenu popup = new JPopupMenu();
            if (!this.frefActive) {
                popup.add("Activate Follow Reference for " + this.getConsole().getMainSystem()).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        PlanControl startPlan = new PlanControl();
                        startPlan.setType(PlanControl.TYPE.REQUEST);
                        startPlan.setOp(PlanControl.OP.START);
                        startPlan.setPlanId("follow_neptus");
                        FollowReference man = new FollowReference();
                        man.setControlEnt((short)255);
                        man.setControlSrc(65535);
                        man.setAltitudeInterval(2.0);
                        if (FollowReferenceControl.this.useAcousticModem) {
                            man.setTimeout(60.0);
                        } else {
                            man.setTimeout(5.0);
                        }
                        PlanSpecification spec = new PlanSpecification();
                        spec.setPlanId("follow_neptus");
                        spec.setStartManId("1");
                        PlanManeuver pm = new PlanManeuver();
                        pm.setData((Maneuver)man);
                        pm.setManeuverId("1");
                        spec.setManeuvers(Arrays.asList(pm));
                        startPlan.setArg((IMCMessage)spec);
                        int reqId = 0;
                        startPlan.setRequestId(reqId);
                        startPlan.setFlags(0);
                        FollowReferenceControl.this.send((IMCMessage)startPlan);
                    }
                });
            } else {
                popup.add("Move Reference Here").addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        LocationType loc = source.getRealWorldLocation((Point2D)event.getPoint());
                        loc.convertToAbsoluteLatLonDepth();
                        FollowReferenceControl.this.ref.setLat(loc.getLatitudeRads());
                        FollowReferenceControl.this.ref.setLon(loc.getLongitudeRads());
                        source.repaint();
                    }
                });
                popup.add("Stop Follow Reference Control").addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        PlanControl stop = new PlanControl();
                        stop.setType(PlanControl.TYPE.REQUEST);
                        stop.setOp(PlanControl.OP.STOP);
                        FollowReferenceControl.this.send((IMCMessage)stop);
                    }
                });
            }
            popup.addSeparator();
            popup.add("Follow Reference Settings").addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PropertiesEditor.editProperties((PropertiesProvider)FollowReferenceControl.this, (Frame)FollowReferenceControl.this.getConsole(), (boolean)true);
                }
            });
            popup.show((Component)event.getSource(), event.getX(), event.getY());
        }
    }

    public boolean isExclusive() {
        return true;
    }

    public void cleanSubPanel() {
    }

    public void initSubPanel() {
    }
}

