/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.followref;

import com.google.common.eventbus.Subscribe;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Vector;
import javax.swing.JPopupMenu;
import pt.lsts.imc.AcousticOperation;
import pt.lsts.imc.EstimatedState;
import pt.lsts.imc.FollowRefState;
import pt.lsts.imc.FollowReference;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.Maneuver;
import pt.lsts.imc.PlanControl;
import pt.lsts.imc.PlanControlState;
import pt.lsts.imc.PlanManeuver;
import pt.lsts.imc.PlanSpecification;
import pt.lsts.imc.Reference;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.IMCUtils;
import pt.lsts.neptus.comm.manager.imc.ImcMsgManager;
import pt.lsts.neptus.comm.manager.imc.ImcSystem;
import pt.lsts.neptus.comm.manager.imc.ImcSystemsHolder;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.notifications.Notification;
import pt.lsts.neptus.gui.PropertiesEditor;
import pt.lsts.neptus.gui.PropertiesProvider;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.plugins.ConfigurationListener;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.PluginUtils;
import pt.lsts.neptus.plugins.SimpleRendererInteraction;
import pt.lsts.neptus.plugins.followref.ReferencePlan;
import pt.lsts.neptus.plugins.followref.ReferenceWaypoint;
import pt.lsts.neptus.plugins.update.IPeriodicUpdates;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.vehicle.VehicleType;
import pt.lsts.neptus.types.vehicle.VehiclesHolder;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.conf.ConfigFetch;

@PluginDescription(name="FollowReference Interaction", category=PluginDescription.CATEGORY.PLANNING, icon="pt/lsts/neptus/plugins/followref/geolocation.png")
public class FollowReferenceInteraction
extends SimpleRendererInteraction
implements IPeriodicUpdates,
ConfigurationListener {
    private static final long serialVersionUID = 1L;
    protected LinkedHashMap<String, FollowRefState> frefStates = new LinkedHashMap();
    protected LinkedHashMap<String, ReferencePlan> plans = new LinkedHashMap();
    protected LinkedHashMap<String, EstimatedState> states = new LinkedHashMap();
    protected HashSet<String> activeVehicles = new HashSet();
    protected ReferenceWaypoint movingWaypoint = null;
    protected ReferenceWaypoint focusedWaypoint = null;
    protected double radius = 8.0;
    protected int entity = 255;
    private String helpMsg;
    @NeptusProperty(name="Use acoustic communications", description="Setting to true will make all communications go through acoustic modem")
    public boolean useAcousticCommunications = false;
    @NeptusProperty(name="Control loop latency", description="Ammount of seconds between reference transmissions (per controller vehicle)")
    public long controlLoopLatencySecs = 1L;
    @NeptusProperty(name="Control timeout", description="Ammount of seconds after which the controlled vehicle will timeout if no new reference updates are received")
    public long referenceTimeout = 30L;

    public FollowReferenceInteraction(ConsoleLayout cl) {
        super(cl);
        this.setHelpMsg();
    }

    public long millisBetweenUpdates() {
        return this.controlLoopLatencySecs * 1000L;
    }

    public void propertiesChanged() {
    }

    public boolean update() {
        Vector<String> copy = new Vector<String>();
        copy.addAll(this.activeVehicles);
        for (String v : copy) {
            if (this.useAcousticCommunications) {
                if (this.states.containsKey(v)) {
                    ReferenceWaypoint wpt;
                    boolean prox = false;
                    LocationType loc = IMCUtils.getLocation((IMCMessage)((IMCMessage)this.states.get(v)));
                    boolean bl = prox = this.plans.get(v).currentWaypoint().getManeuverLocation().getDistanceInMeters(loc) < this.radius + 4.0;
                    if (prox && this.focusedWaypoint.equals(wpt = this.plans.get(v).popFirstWaypoint())) {
                        this.focusedWaypoint = null;
                    }
                }
            } else if (this.frefStates.containsKey(v)) {
                short prox = this.frefStates.get(v).getProximity();
                ReferenceWaypoint wpt = this.plans.get(v).currentWaypoint();
                if ((prox & 2) != 0 && (prox & 4) != 0) {
                    if (wpt.time != -1.0) {
                        if (wpt.time > 0.0) {
                            if (Double.isNaN(wpt.timeLeft())) {
                                wpt.setStartTime((double)System.currentTimeMillis() / 1000.0);
                            } else if (wpt.timeLeft() <= 0.0) {
                                this.plans.get(v).popFirstWaypoint();
                            }
                        } else {
                            this.plans.get(v).popFirstWaypoint();
                        }
                    }
                } else {
                    wpt.setStartTime(Double.NaN);
                }
            }
            if (!this.plans.containsKey(v)) continue;
            if (this.useAcousticCommunications) {
                AcousticOperation op = new AcousticOperation();
                op.setOp(AcousticOperation.OP.MSG);
                op.setSystem(v);
                op.setMsg((IMCMessage)this.plans.get(v).currentWaypoint().getReference());
                ImcSystem[] sysLst = ImcSystemsHolder.lookupSystemByService((String)"acoustic/operation", (VehicleType.SystemTypeEnum)VehicleType.SystemTypeEnum.ALL, (boolean)true);
                if (sysLst.length == 0) {
                    NeptusLog.pub().error((Object)"Cannot send reference acoustically because no system is capable of it");
                    return true;
                }
                int successCount = 0;
                for (ImcSystem sys : sysLst) {
                    if (!ImcMsgManager.getManager().sendMessage((IMCMessage)op, sys.getId(), null)) continue;
                    ++successCount;
                    NeptusLog.pub().warn((Object)("Sent reference to " + v + " acoustically via " + sys.getName()));
                }
                if (successCount != 0) continue;
                NeptusLog.pub().error((Object)"Cannot send reference acoustically because no system is capable of it");
                continue;
            }
            this.send(v, (IMCMessage)this.plans.get(v).currentWaypoint().getReference());
        }
        return true;
    }

    @Subscribe
    public void on(EstimatedState state) {
        this.states.put(state.getSourceName(), state);
    }

    @Subscribe
    public void on(PlanControlState controlState) {
        if (controlState.getPlanId() == null || controlState.getPlanId().isEmpty()) {
            return;
        }
        if (!this.frefStates.containsKey(controlState.getSourceName())) {
            return;
        }
        if (this.frefStates.get(controlState.getSourceName()).getControlSrc() != ImcMsgManager.getManager().getLocalId().intValue()) {
            if (this.activeVehicles.remove(controlState.getSourceName())) {
                this.post(Notification.warning((String)"FollowReferenceInteraction", (String)("The vehicle " + controlState.getSourceName() + " is not being controlled anymore.")));
            }
            this.frefStates.remove(controlState.getSourceName());
            return;
        }
        boolean newActivation = false;
        if (controlState.getPlanId().equals("follow_neptus") && controlState.getState() == PlanControlState.STATE.EXECUTING) {
            newActivation = this.activeVehicles.add(controlState.getSourceName());
            if (newActivation) {
                Reference ref = new Reference();
                EstimatedState lastState = this.states.get(controlState.getSourceName());
                if (lastState == null) {
                    return;
                }
                LocationType loc = new LocationType(Math.toDegrees(lastState.getLat()), Math.toDegrees(lastState.getLon()));
                loc.translatePosition(lastState.getX(), lastState.getY(), 0.0);
                loc.convertToAbsoluteLatLonDepth();
                ref.setLat(loc.getLatitudeRads());
                ref.setLon(loc.getLongitudeRads());
                ref.setFlags((short)1);
                ReferencePlan plan = new ReferencePlan(controlState.getSourceName());
                plan.addWaypointAtEnd(ref);
                this.plans.put(controlState.getSourceName(), plan);
            }
        } else if (this.activeVehicles.contains(controlState.getSourceName())) {
            this.activeVehicles.remove(controlState.getSourceName());
            this.plans.remove(controlState.getSourceName());
        }
    }

    @Subscribe
    public void on(FollowRefState frefState) {
        this.frefStates.put(frefState.getSourceName(), frefState);
    }

    public void paint(Graphics2D g, StateRenderer2D renderer) {
        super.paint(g, renderer);
        try {
            Vector<ReferenceWaypoint> wpts = new Vector<ReferenceWaypoint>();
            for (ReferencePlan p : this.plans.values()) {
                wpts.clear();
                wpts.addAll(p.getWaypoints());
                for (int i = 1; i < wpts.size(); ++i) {
                    Reference prevRef = ((ReferenceWaypoint)wpts.get(i - 1)).getReference();
                    LocationType prevLoc = new LocationType(Math.toDegrees(prevRef.getLat()), Math.toDegrees(prevRef.getLon()));
                    Point2D prevPt = renderer.getScreenPosition(prevLoc);
                    Reference ref = ((ReferenceWaypoint)wpts.get(i)).getReference();
                    LocationType loc = new LocationType(Math.toDegrees(ref.getLat()), Math.toDegrees(ref.getLon()));
                    Point2D pt = renderer.getScreenPosition(loc);
                    Ellipse2D.Double ellis = new Ellipse2D.Double(pt.getX() - this.radius, pt.getY() - this.radius, this.radius * 2.0, this.radius * 2.0);
                    g.setColor(Color.blue);
                    g.setStroke(new BasicStroke(3.0f));
                    g.draw(new Line2D.Double(prevPt, pt));
                    g.fill(ellis);
                    if (ref.getZ() != null) {
                        g.setStroke(new BasicStroke(2.0f));
                        g.setColor(Color.white);
                        switch (ref.getZ().getZUnits()) {
                            case DEPTH: {
                                g.draw(new Line2D.Double(pt.getX() - this.radius, pt.getY() - this.radius, pt.getX() + this.radius, pt.getY() - this.radius));
                                break;
                            }
                            case ALTITUDE: 
                            case HEIGHT: {
                                g.draw(new Line2D.Double(pt.getX() - this.radius, pt.getY() + this.radius, pt.getX() + this.radius, pt.getY() + this.radius));
                                break;
                            }
                        }
                    }
                    g.setColor(Color.black);
                }
            }
            for (ReferencePlan p : this.plans.values()) {
                ReferenceWaypoint wpt = p.currentWaypoint();
                Reference ref = wpt.getReference();
                FollowRefState lastFrefState = this.frefStates.get(p.system_id);
                if (ref == null || lastFrefState == null) continue;
                Color c = Color.red;
                if (lastFrefState != null && ref.getLat() == lastFrefState.getReference().getLat() && ref.getLon() == lastFrefState.getReference().getLon()) {
                    c = Color.green;
                }
                LocationType loc = new LocationType(Math.toDegrees(ref.getLat()), Math.toDegrees(ref.getLon()));
                Point2D pt = renderer.getScreenPosition(loc);
                Ellipse2D.Double ellis = new Ellipse2D.Double(pt.getX() - this.radius, pt.getY() - this.radius, this.radius * 2.0, this.radius * 2.0);
                g.setColor(c);
                g.fill(ellis);
                if (ref.getZ() != null) {
                    g.setStroke(new BasicStroke(2.0f));
                    g.setColor(Color.white);
                    switch (ref.getZ().getZUnits()) {
                        case DEPTH: {
                            g.draw(new Line2D.Double(pt.getX() - this.radius, pt.getY() - this.radius, pt.getX() + this.radius, pt.getY() - this.radius));
                            break;
                        }
                        case ALTITUDE: 
                        case HEIGHT: {
                            g.draw(new Line2D.Double(pt.getX() - this.radius, pt.getY() + this.radius, pt.getX() + this.radius, pt.getY() + this.radius));
                            break;
                        }
                    }
                }
                if (!wpt.loiter) continue;
                g.setStroke(new BasicStroke(1.5f));
                g.setColor(new Color(255, 255, 255, 128));
                double radius = Math.abs(wpt.loiterRadius * (double)renderer.getZoom());
                g.draw(new Ellipse2D.Double(pt.getX() - radius, pt.getY() - radius, radius * 2.0, radius * 2.0));
            }
            if (this.focusedWaypoint != null) {
                g.setStroke(new BasicStroke(2.0f));
                Reference ref = this.focusedWaypoint.getReference();
                LocationType loc = new LocationType(Math.toDegrees(ref.getLat()), Math.toDegrees(ref.getLon()));
                Point2D pt = renderer.getScreenPosition(loc);
                Ellipse2D.Double ellis = new Ellipse2D.Double(pt.getX() - this.radius, pt.getY() - this.radius, this.radius * 2.0, this.radius * 2.0);
                g.setColor(Color.white);
                g.draw(ellis);
                int pos = 5;
                if (ref.getZ() != null) {
                    g.drawString(ref.getZ().getZUnits().toString().toLowerCase() + ": " + ref.getZ().getValue() + " m", (int)pt.getX() + 15, (int)pt.getY() + pos);
                    pos += 15;
                }
                if (ref.getSpeed() != null) {
                    g.drawString("speed: " + ref.getSpeed().getValue(), (int)pt.getX() + 15, (int)pt.getY() + pos);
                    pos += 15;
                }
                if (!Double.isNaN(this.focusedWaypoint.timeLeft())) {
                    g.drawString("time left: " + GuiUtils.getNeptusDecimalFormat((int)0).format(Math.max(0.0, this.focusedWaypoint.timeLeft())), (int)pt.getX() + 15, (int)pt.getY() + pos);
                    pos += 15;
                } else if (this.focusedWaypoint.time > 0.0) {
                    g.drawString("time: " + GuiUtils.getNeptusDecimalFormat((int)0).format(this.focusedWaypoint.time), (int)pt.getX() + 15, (int)pt.getY() + pos);
                    pos += 15;
                } else if (this.focusedWaypoint.time == -1.0) {
                    g.drawString("time: \u221e", (int)pt.getX() + 15, (int)pt.getY() + pos);
                    pos += 15;
                }
                if (this.focusedWaypoint.loiter) {
                    g.setStroke(new BasicStroke(2.0f));
                    g.setColor(new Color(255, 255, 255, 128));
                    double radius = Math.abs(this.focusedWaypoint.loiterRadius * (double)renderer.getZoom());
                    g.draw(new Ellipse2D.Double(pt.getX() - radius, pt.getY() - radius, radius * 2.0, radius * 2.0));
                }
            }
        }
        catch (Exception e) {
            NeptusLog.pub().error((Object)e);
        }
    }

    public void mousePressed(MouseEvent event, StateRenderer2D source) {
        if (this.plans.isEmpty()) {
            super.mousePressed(event, source);
        }
        LocationType pressed = source.getRealWorldLocation((Point2D)event.getPoint());
        pressed.convertToAbsoluteLatLonDepth();
        Vector<ReferenceWaypoint> wpts = new Vector<ReferenceWaypoint>();
        for (ReferencePlan p : this.plans.values()) {
            wpts.addAll(p.getWaypoints());
        }
        ReferenceWaypoint wpt = this.waypointUnder(event.getPoint(), source);
        if (wpt != null) {
            if (event.isControlDown() && event.getButton() == 1) {
                for (ReferencePlan p : this.plans.values()) {
                    if (!p.getWaypoints().contains(wpt)) continue;
                    ReferenceWaypoint newWaypoint = p.cloneWaypoint(wpt);
                    newWaypoint.setHorizontalLocation(pressed);
                    this.movingWaypoint = newWaypoint;
                }
            } else if (event.getButton() == 1) {
                this.movingWaypoint = wpt;
            }
            source.repaint();
        } else {
            super.mousePressed(event, source);
        }
    }

    public void mouseReleased(MouseEvent event, StateRenderer2D source) {
        this.movingWaypoint = null;
        super.mouseReleased(event, source);
    }

    public void mouseDragged(MouseEvent event, StateRenderer2D source) {
        if (this.movingWaypoint == null) {
            super.mouseDragged(event, source);
        } else {
            LocationType pressed = source.getRealWorldLocation((Point2D)event.getPoint());
            pressed.convertToAbsoluteLatLonDepth();
            this.movingWaypoint.setHorizontalLocation(pressed);
            source.repaint();
        }
    }

    public ReferenceWaypoint waypointUnder(Point2D pt, StateRenderer2D source) {
        Vector<ReferenceWaypoint> wpts = new Vector<ReferenceWaypoint>();
        for (ReferencePlan p : this.plans.values()) {
            wpts.addAll(p.getWaypoints());
        }
        LocationType pressed = source.getRealWorldLocation(pt);
        pressed.convertToAbsoluteLatLonDepth();
        for (ReferenceWaypoint wpt : wpts) {
            Reference ref = wpt.getReference();
            LocationType refLoc = new LocationType(Math.toDegrees(ref.getLat()), Math.toDegrees(ref.getLon()));
            double dist = pressed.getPixelDistanceTo(refLoc, source.getLevelOfDetail());
            if (!(dist < this.radius)) continue;
            return wpt;
        }
        return null;
    }

    public void mouseMoved(MouseEvent event, StateRenderer2D source) {
        this.focusedWaypoint = this.waypointUnder(event.getPoint(), source);
    }

    public void mouseClicked(MouseEvent event, StateRenderer2D source) {
        super.mouseClicked(event, source);
        final ReferenceWaypoint wpt = this.waypointUnder(event.getPoint(), source);
        if (wpt != null && event.getButton() == 1 && event.getClickCount() >= 2) {
            PluginUtils.editPluginProperties((Object)wpt, (boolean)true);
            if (this.focusedWaypoint.equals(wpt)) {
                this.focusedWaypoint = null;
            }
        }
        if (event.getButton() == 3) {
            JPopupMenu popup = new JPopupMenu();
            if (wpt != null) {
                popup.add("Remove waypoint").addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        for (ReferencePlan p : FollowReferenceInteraction.this.plans.values()) {
                            p.removeWaypoint(wpt);
                        }
                        if (FollowReferenceInteraction.this.focusedWaypoint.equals(wpt)) {
                            FollowReferenceInteraction.this.focusedWaypoint = null;
                        }
                    }
                });
                popup.add("Waypoint parameters").addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        PluginUtils.editPluginProperties((Object)wpt, (boolean)true);
                    }
                });
                popup.addSeparator();
            }
            Vector<VehicleType> avVehicles = new Vector<VehicleType>();
            ImcSystem[] veh = ImcSystemsHolder.lookupActiveSystemVehicles();
            if (this.getConsole().getMainSystem() != null && !avVehicles.contains(VehiclesHolder.getVehicleById((String)this.getConsole().getMainSystem()))) {
                avVehicles.add(0, VehiclesHolder.getVehicleById((String)this.getConsole().getMainSystem()));
            }
            for (ImcSystem sys : veh) {
                final String sysName = sys.getName();
                if (!this.activeVehicles.contains(sysName)) {
                    popup.add("Activate Follow Reference for " + sysName).addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            PlanControl startPlan = new PlanControl();
                            startPlan.setType(PlanControl.TYPE.REQUEST);
                            startPlan.setOp(PlanControl.OP.START);
                            startPlan.setPlanId("follow_neptus");
                            FollowReference man = new FollowReference();
                            man.setControlEnt((short)FollowReferenceInteraction.this.entity);
                            man.setControlSrc(ImcMsgManager.getManager().getLocalId().intValue());
                            man.setAltitudeInterval(2.0);
                            man.setTimeout((double)FollowReferenceInteraction.this.referenceTimeout);
                            man.setLoiterRadius(15.0);
                            PlanSpecification spec = new PlanSpecification();
                            spec.setPlanId("follow_neptus");
                            spec.setStartManId("1");
                            PlanManeuver pm = new PlanManeuver();
                            pm.setData((Maneuver)man);
                            pm.setManeuverId("1");
                            spec.setManeuvers(Arrays.asList(pm));
                            startPlan.setArg((IMCMessage)spec);
                            int reqId = 0;
                            startPlan.setRequestId(reqId);
                            startPlan.setFlags(0);
                            FollowReferenceInteraction.this.send(sysName, (IMCMessage)startPlan);
                        }
                    });
                    continue;
                }
                popup.add("Stop Follow Reference Control for " + sysName).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        PlanControl stop = new PlanControl();
                        stop.setType(PlanControl.TYPE.REQUEST);
                        stop.setOp(PlanControl.OP.STOP);
                        FollowReferenceInteraction.this.send(sysName, (IMCMessage)stop);
                    }
                });
            }
            if (veh.length > 0) {
                popup.addSeparator();
            }
            popup.add("Follow Reference Settings").addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PropertiesEditor.editProperties((PropertiesProvider)FollowReferenceInteraction.this, (Frame)FollowReferenceInteraction.this.getConsole(), (boolean)true);
                }
            });
            popup.addSeparator();
            popup.add("Follow Reference Interaction Helper").addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GuiUtils.htmlMessage((Component)(ConfigFetch.getSuperParentFrame() == null ? FollowReferenceInteraction.this : ConfigFetch.getSuperParentAsFrame()), (String)(I18n.text((String)"Follow Reference Interaction Helper") + "."), (String)"", (String)FollowReferenceInteraction.this.helpMsg);
                }
            });
            popup.show((Component)event.getSource(), event.getX(), event.getY());
        }
    }

    public boolean isExclusive() {
        return true;
    }

    public void cleanSubPanel() {
    }

    public void initSubPanel() {
    }

    private void setHelpMsg() {
        this.helpMsg = "<html><font size='2'><br><div align='center'><table border='1' align='center'><tr><th>" + I18n.text((String)"Type") + "</th><th>" + I18n.text((String)"Description") + "</th></tr>" + "<tr><th>" + I18n.text((String)"Opens reference waypoint properties") + "</th><th>" + I18n.text((String)"Left Mouse double click on Reference") + "</th></tr>" + "<tr><th>" + I18n.text((String)"Add multiple waypoints") + "</th><th>" + I18n.text((String)"Press CTRL + Left Mouse Click + Drag Mouse") + "- (" + I18n.text((String)"It will show a blue dot that is referent to a new waypoint") + ")." + "</th></tr>";
    }
}

