/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.followref;

import java.util.Collection;
import java.util.Vector;
import pt.lsts.imc.Reference;
import pt.lsts.neptus.plugins.followref.ReferenceWaypoint;

public class ReferencePlan {
    protected Vector<ReferenceWaypoint> waypoints = new Vector();
    protected String system_id;

    public ReferencePlan(String systemId) {
        this.system_id = systemId;
    }

    public ReferenceWaypoint currentWaypoint() {
        if (this.waypoints.isEmpty()) {
            return null;
        }
        return this.waypoints.firstElement();
    }

    public Collection<ReferenceWaypoint> getWaypoints() {
        return this.waypoints;
    }

    public void addWaypointAtEnd(Reference ref) {
        this.waypoints.add(new ReferenceWaypoint(ref));
    }

    public void addWaypointAtEnd(ReferenceWaypoint wpt) {
        this.waypoints.add(wpt);
    }

    public ReferenceWaypoint cloneWaypoint(ReferenceWaypoint wpt) {
        if (!this.waypoints.contains(wpt)) {
            return null;
        }
        int index = this.waypoints.indexOf(wpt);
        ReferenceWaypoint clone = new ReferenceWaypoint(wpt.getReference());
        clone.time = wpt.time;
        this.waypoints.add(index + 1, clone);
        return clone;
    }

    public ReferenceWaypoint popFirstWaypoint() {
        if (this.waypoints.size() > 1) {
            return this.waypoints.remove(0);
        }
        return null;
    }

    public void removeWaypoint(ReferenceWaypoint wpt) {
        if (this.waypoints.size() > 1) {
            this.waypoints.remove(wpt);
        }
    }
}

