/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.followref;

import pt.lsts.imc.DesiredSpeed;
import pt.lsts.imc.DesiredZ;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.Reference;
import pt.lsts.neptus.mp.ManeuverLocation;
import pt.lsts.neptus.plugins.ConfigurationListener;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.types.coord.LocationType;

public class ReferenceWaypoint
implements ConfigurationListener {
    private Reference reference;
    private ManeuverLocation loc;
    protected double latitude;
    protected double longitude;
    @NeptusProperty(name="Z Reference", category="Z")
    private ManeuverLocation.Z_UNITS zUnits = ManeuverLocation.Z_UNITS.DEPTH;
    @NeptusProperty(name="Z value", category="Z")
    private double z = 0.0;
    @NeptusProperty(name="Specify speed", category="Speed")
    private boolean defineSpeed = true;
    @NeptusProperty(name="Speed units", category="Speed")
    private DesiredSpeed.SPEED_UNITS speedUnits = DesiredSpeed.SPEED_UNITS.METERS_PS;
    @NeptusProperty(name="Speed value", category="Speed")
    private double speed = 1.3;
    @NeptusProperty(name="Loiter radius (m)", category="Loiter")
    public double loiterRadius = 15.0;
    @NeptusProperty(name="Loiter", category="Loiter")
    public boolean loiter = false;
    @NeptusProperty(name="Time (seconds)", description="Time to stay at this location. -1 for infinity.", category="Time")
    public double time = 0.0;
    private double startTime = Double.NaN;

    public void propertiesChanged() {
        this.loc.setZ(this.z);
        this.loc.setZUnits(this.zUnits);
        this.reference = new Reference();
        if (this.loiter) {
            this.reference.setRadius(this.loiterRadius);
        }
        this.reference.setLat(this.loc.getLatitudeRads());
        this.reference.setLon(this.loc.getLongitudeRads());
        if (this.loc.getZUnits() != ManeuverLocation.Z_UNITS.NONE) {
            this.reference.setZ(new DesiredZ((float)this.loc.getZ(), DesiredZ.Z_UNITS.valueOf((String)this.loc.getZUnits().name())));
        }
        if (this.defineSpeed) {
            this.reference.setSpeed(new DesiredSpeed(this.speed, this.speedUnits));
        }
        this.reference.setFlags((short)(1 | (this.defineSpeed ? 2 : 0) | (this.loc.getZUnits() != ManeuverLocation.Z_UNITS.NONE ? 4 : 0) | (this.loiter ? 8 : 0)));
    }

    public double timeLeft() {
        if (this.time == 0.0 || Double.isNaN(this.startTime)) {
            return Double.NaN;
        }
        return this.time - ((double)System.currentTimeMillis() / 1000.0 - this.startTime);
    }

    public void setStartTime(double startTime) {
        this.startTime = startTime;
    }

    public ReferenceWaypoint(ManeuverLocation loc, double speed) {
        loc.convertToAbsoluteLatLonDepth();
        this.loc = loc.clone();
        this.latitude = loc.getLatitudeDegs();
        this.longitude = loc.getLongitudeDegs();
        this.speed = speed;
        this.speedUnits = DesiredSpeed.SPEED_UNITS.METERS_PS;
        this.z = loc.getZ();
        this.zUnits = loc.getZUnits();
        this.reference = new Reference();
        this.reference.setLat(loc.getLatitudeRads());
        this.reference.setLon(loc.getLongitudeRads());
        this.reference.setZ(new DesiredZ((float)loc.getZ(), DesiredZ.Z_UNITS.valueOf((String)loc.getZUnits().name())));
        this.reference.setSpeed(new DesiredSpeed(speed, DesiredSpeed.SPEED_UNITS.METERS_PS));
        this.reference.setFlags((short)7);
    }

    public ReferenceWaypoint(Reference ref) {
        boolean defineZ;
        try {
            this.reference = Reference.clone((IMCMessage)ref);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.loc = new ManeuverLocation();
        this.loc.setLatitudeRads(ref.getLat());
        this.loc.setLongitudeRads(ref.getLon());
        if (ref.getZ() != null) {
            this.loc.setZ(ref.getZ().getValue());
            this.loc.setZUnits(ManeuverLocation.Z_UNITS.valueOf((String)ref.getZ().getZUnits().name()));
        }
        boolean bl = defineZ = (ref.getFlags() & 4) != 0;
        if (!defineZ) {
            this.loc.setZUnits(ManeuverLocation.Z_UNITS.NONE);
        }
        this.loiter = (ref.getFlags() & 8) != 0;
        this.loiterRadius = ref.getRadius();
        this.latitude = this.loc.getLatitudeDegs();
        this.longitude = this.loc.getLongitudeDegs();
        this.z = this.loc.getZ();
        this.zUnits = this.loc.getZUnits();
        if (ref.getSpeed() != null) {
            this.speedUnits = ref.getSpeed().getSpeedUnits();
            this.speed = ref.getSpeed().getValue();
        }
        this.defineSpeed = (ref.getFlags() & 2) != 0;
    }

    public void setHorizontalLocation(LocationType newLoc) {
        newLoc.convertToAbsoluteLatLonDepth();
        this.loc.setLatitudeDegs(newLoc.getLatitudeDegs());
        this.loc.setLongitudeDegs(newLoc.getLongitudeDegs());
        this.reference.setLat(newLoc.getLatitudeRads());
        this.reference.setLon(newLoc.getLongitudeRads());
        this.latitude = newLoc.getLatitudeDegs();
        this.longitude = newLoc.getLongitudeDegs();
    }

    public void setZ(DesiredZ desiredZ) {
        if (desiredZ == null) {
            this.reference.setFlags((short)(this.reference.getFlags() ^ 4));
            this.reference.setZ(null);
            this.loc.setZUnits(ManeuverLocation.Z_UNITS.NONE);
            this.zUnits = ManeuverLocation.Z_UNITS.NONE;
        } else {
            this.reference.setZ(new DesiredZ((float)desiredZ.getValue(), desiredZ.getZUnits()));
            this.reference.setFlags((short)(this.reference.getFlags() | 4));
            this.loc.setZ(desiredZ.getValue());
            this.loc.setZUnits(ManeuverLocation.Z_UNITS.valueOf((String)desiredZ.getZUnits().name()));
            this.zUnits = this.loc.getZUnits();
            this.z = this.loc.getZ();
        }
    }

    public void setSpeed(DesiredSpeed speed) {
        if (speed == null) {
            this.reference.setFlags((short)(this.reference.getFlags() ^ 2));
            this.reference.setSpeed(null);
            this.defineSpeed = false;
        } else {
            this.reference.setFlags((short)(this.reference.getFlags() | 2));
            this.reference.setSpeed(new DesiredSpeed(speed.getValue(), speed.getSpeedUnits()));
            this.defineSpeed = true;
            this.speed = speed.getValue();
            this.speedUnits = speed.getSpeedUnits();
        }
    }

    public void setLoiterRadius(double radius) {
        if (radius <= 0.0) {
            this.reference.setFlags((short)(this.reference.getFlags() ^ 8));
            this.reference.setRadius(radius);
        } else {
            this.reference.setFlags((short)(this.reference.getFlags() | 8));
            this.reference.setRadius(radius);
        }
    }

    public final Reference getReference() {
        return this.reference;
    }

    public final ManeuverLocation getManeuverLocation() {
        return this.loc;
    }
}

