/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.trex;

import com.google.common.eventbus.Subscribe;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.image.ImageObserver;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.Vector;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import pt.lsts.imc.EntityParameter;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.PathControlState;
import pt.lsts.imc.PlanControlState;
import pt.lsts.imc.SetEntityParameters;
import pt.lsts.imc.TrexCommand;
import pt.lsts.imc.TrexOperation;
import pt.lsts.imc.TrexToken;
import pt.lsts.neptus.NeptusLog;
import pt.lsts.neptus.comm.manager.imc.ImcMsgManager;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.notifications.Notification;
import pt.lsts.neptus.fileeditor.SyntaxDocument;
import pt.lsts.neptus.gui.PropertiesEditor;
import pt.lsts.neptus.gui.PropertiesProvider;
import pt.lsts.neptus.mp.Maneuver;
import pt.lsts.neptus.mp.ManeuverLocation;
import pt.lsts.neptus.mp.maneuvers.LocatedManeuver;
import pt.lsts.neptus.plugins.NeptusMessageListener;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.PluginUtils;
import pt.lsts.neptus.plugins.SimpleRendererInteraction;
import pt.lsts.neptus.plugins.trex.goals.AUVDrifterSurvey;
import pt.lsts.neptus.plugins.trex.goals.TrexGoal;
import pt.lsts.neptus.plugins.trex.goals.UavSpotterSurvey;
import pt.lsts.neptus.plugins.trex.goals.VisitLocationGoal;
import pt.lsts.neptus.plugins.trex.gui.PortEditor;
import pt.lsts.neptus.renderer2d.Renderer2DPainter;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;

@PluginDescription(name="TrexMapLayer", icon="pt/lsts/neptus/plugins/trex/smallTrex.png")
public class TrexMapLayer
extends SimpleRendererInteraction
implements Renderer2DPainter,
NeptusMessageListener {
    @NeptusProperty(name="Default depth (negative for altitude)")
    public double defaultDepth = 2.0;
    @NeptusProperty(name="T-Rex Shore IP", description="Ip of the machine where T-Rex is running whith shore configuration to follow a tag.")
    public String ipShore = "localhost";
    @NeptusProperty(name="T-Rex Shore port", description="Port of the machine where T-Rex is running whith shore configuration to follow a tag.", editorClass=PortEditor.class)
    public int portShore = 8888;
    @NeptusProperty(name="Comms channel", description="Choose if Dune communicates with T-Rex through a REST API or IP.")
    public CommsChannel trexDuneComms = CommsChannel.IMC;
    @NeptusProperty(name="Name of Dune task")
    public String taskName = "TREX";
    @NeptusProperty(name="Loiter height", description="Height of waypoint for uav spotter plan.", category="UAV Spotter", userLevel=NeptusProperty.LEVEL.REGULAR)
    public int spotterHeight = 100;
    @NeptusProperty(name="Type", category="YoYo Survey")
    public AUVDrifterSurvey.PathType path = AUVDrifterSurvey.PathType.SQUARE;
    @NeptusProperty(name="Survey Size", category="YoYo Survey")
    public float size = 800.0f;
    @NeptusProperty(name="Lagrangian distortion", category="YoYo Survey", description="True if you want to apply Lagrangian distortion.")
    public boolean lagrangin = true;
    @NeptusProperty(name="Rotation", category="YoYo Survey", description="In degrees, an offset to north in clockwise.")
    public float heading = 0.0f;
    @NeptusProperty(name="Water current Speed", category="YoYo Survey", description="Speed, in mps of the surface current.")
    public float speed = 0.0f;
    @NeptusProperty(name="Notifications for received T-REX observations")
    public boolean postNotifications = true;
    private final HttpClient httpclient = new DefaultHttpClient();
    private static final long serialVersionUID = 1L;
    private Maneuver lastManeuver = null;
    protected LinkedHashMap<String, TrexGoal> sentGoals = new LinkedHashMap();
    protected LinkedHashMap<String, TrexGoal> completeGoals = new LinkedHashMap();
    protected LocationType[] surveyArea = new LocationType[4];
    protected boolean surveyEdit = false;
    protected int surveyPos = 0;
    protected boolean active = false;
    protected Vector<LocationType> sentPoints = new Vector();
    private LocationType currentRef;
    final String fixedTrexPlanId = "trex_plan";
    Image trex = null;
    private boolean trexActive = false;

    public TrexMapLayer(ConsoleLayout console) {
        super(console);
    }

    public void setActive(boolean mode, StateRenderer2D source) {
        super.setActive(mode, source);
        this.active = mode;
    }

    public void mouseClicked(MouseEvent event, StateRenderer2D source) {
        if (event.getButton() == 1 && this.surveyEdit) {
            if (this.surveyPos < 4) {
                LocationType loc = source.getRealWorldLocation((Point2D)event.getPoint());
                loc.convertToAbsoluteLatLonDepth();
                this.surveyArea[this.surveyPos++] = loc;
            }
            if (this.surveyPos >= 4) {
                int n_transects;
                double depth;
                String s_transects = JOptionPane.showInputDialog((Component)this.getConsole(), "Number of transects: ", "5");
                String s_depth = JOptionPane.showInputDialog((Component)this.getConsole(), "Depth: ", "" + this.defaultDepth);
                try {
                    depth = Double.parseDouble(s_depth);
                    n_transects = Integer.parseInt(s_transects);
                    if (n_transects < 2) {
                        throw new Exception("Number of transects should be bigger than 1");
                    }
                }
                catch (Exception e) {
                    GuiUtils.errorMessage((Component)this.getConsole(), (Exception)e);
                    return;
                }
                final String goalId = "Neptus_" + System.currentTimeMillis();
                String xml = "<Goal id='" + goalId + "' on='surveys' pred='LawnMower'>\n";
                for (int i = 0; i < 4; ++i) {
                    xml = xml + "  <Variable name='lat_" + i + "'><float value='" + this.surveyArea[i].getLatitudeDegs() + "'/></Variable>\n";
                    xml = xml + "  <Variable name='lon_" + i + "'><float value='" + this.surveyArea[i].getLongitudeDegs() + "'/></Variable>\n";
                }
                xml = xml + "  <Variable name='depth'><float value='" + depth + "'/></Variable>\n";
                xml = xml + "  <Variable name='n_slices'><int value='" + n_transects + "'/></Variable>\n";
                xml = xml + "</Goal>";
                final JEditorPane editor = SyntaxDocument.getXmlEditorPane();
                editor.setText(xml);
                JFrame frame = new JFrame("Edit goal xml");
                frame.setContentPane(new JScrollPane(editor));
                frame.setDefaultCloseOperation(2);
                frame.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosed(WindowEvent e) {
                        TrexCommand cmd = new TrexCommand();
                        cmd.setCommand(TrexCommand.COMMAND.POST_GOAL);
                        cmd.setGoalXml(editor.getText());
                        cmd.setGoalId(goalId);
                        cmd.dump((OutputStream)System.err);
                    }
                });
                frame.setSize(500, 500);
                GuiUtils.centerParent((Window)frame, (Window)this.getConsole());
                frame.setVisible(true);
                for (int i = 0; i < 4; ++i) {
                    NeptusLog.pub().info((Object)("<###> " + this.surveyArea[i].asXML()));
                }
            }
        } else if (event.getButton() == 3) {
            JPopupMenu popup = new JPopupMenu();
            LocationType loc = source.getRealWorldLocation((Point2D)event.getPoint());
            if (this.surveyEdit) {
                this.addSurveyPointsMenu(popup);
            }
            if (this.trexActive) {
                this.addDisableTrexMenu(popup);
                popup.addSeparator();
                this.addUAVSpotter(popup, loc);
                this.addClearNeptusGoalsMenu(popup);
            } else {
                this.addEnableTrexMenu(popup);
                popup.addSeparator();
                this.addClearNeptusGoalsMenu(popup);
            }
            popup.addSeparator();
            this.addVisitThisPointMenu(popup, loc);
            this.addAUVDrifter(popup, loc);
            this.addClearGoalMenu(popup);
            this.addSettingMenu(popup);
            popup.show((Component)source, event.getPoint().x, event.getPoint().y);
        }
    }

    private void addSettingMenu(JPopupMenu popup) {
        popup.add("Settings").addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PropertiesEditor.editProperties((PropertiesProvider)TrexMapLayer.this, (Frame)TrexMapLayer.this.getConsole(), (boolean)true);
            }
        });
    }

    private void addEnableTrexMenu(JPopupMenu popup) {
        popup.add("Enable TREX").addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if ((e.getModifiers() & 2) != 0) {
                    TrexMapLayer.this.startTrex();
                    return;
                }
                SetEntityParameters setParams = new SetEntityParameters();
                setParams.setName("TREX");
                EntityParameter param = new EntityParameter("Active", "true");
                Vector<EntityParameter> p = new Vector<EntityParameter>();
                p.add(param);
                setParams.setParams(p);
                switch (TrexMapLayer.this.trexDuneComms) {
                    case IMC: 
                    case REST: {
                        ImcMsgManager.getManager().sendMessageToSystem((IMCMessage)setParams, TrexMapLayer.this.getConsole().getMainSystem());
                        break;
                    }
                    case IRIDIUM: {
                        try {
                            TrexMapLayer.this.sendViaIridium(TrexMapLayer.this.getConsole().getMainSystem(), (IMCMessage)setParams);
                            break;
                        }
                        catch (Exception ex) {
                            NeptusLog.pub().error((Object)e);
                        }
                    }
                }
            }
        });
    }

    private void addClearNeptusGoalsMenu(JPopupMenu popup) {
        popup.add("Clear all goals in Neptus").addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrexMapLayer.this.sentPoints.removeAllElements();
            }
        });
    }

    private void addDisableTrexMenu(JPopupMenu popup) {
        popup.add("Disable TREX").addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if ((e.getModifiers() & 2) != 0) {
                    TrexMapLayer.this.stopTrex();
                    return;
                }
                SetEntityParameters setParams = new SetEntityParameters();
                setParams.setName("TREX");
                EntityParameter param = new EntityParameter("Active", "false");
                Vector<EntityParameter> p = new Vector<EntityParameter>();
                p.add(param);
                setParams.setParams(p);
                switch (TrexMapLayer.this.trexDuneComms) {
                    case IMC: 
                    case REST: {
                        ImcMsgManager.getManager().sendMessageToSystem((IMCMessage)setParams, TrexMapLayer.this.getConsole().getMainSystem());
                        break;
                    }
                    case IRIDIUM: {
                        try {
                            TrexMapLayer.this.sendViaIridium(TrexMapLayer.this.getConsole().getMainSystem(), (IMCMessage)setParams);
                            break;
                        }
                        catch (Exception ex) {
                            NeptusLog.pub().error((Object)e);
                        }
                    }
                }
            }
        });
    }

    private void addClearGoalMenu(JPopupMenu popup) {
        popup.add("Clear goals").addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrexMapLayer.this.sentGoals.clear();
                TrexMapLayer.this.completeGoals.clear();
                TrexMapLayer.this.lastManeuver = null;
            }
        });
    }

    private void addVisitThisPointMenu(JPopupMenu popup, final LocationType loc) {
        popup.add("Visit this point").addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                loc.convertToAbsoluteLatLonDepth();
                VisitLocationGoal visitLocationGoal = new VisitLocationGoal(loc.getLatitudeRads(), loc.getLongitudeRads());
                switch (TrexMapLayer.this.trexDuneComms) {
                    case IMC: {
                        TrexMapLayer.this.send((IMCMessage)visitLocationGoal.asIMCMsg());
                        break;
                    }
                    case IRIDIUM: {
                        try {
                            TrexMapLayer.this.sendViaIridium(TrexMapLayer.this.getConsole().getMainSystem(), (IMCMessage)visitLocationGoal.asIMCMsg());
                        }
                        catch (Exception ex) {
                            NeptusLog.pub().error((Object)e);
                        }
                        break;
                    }
                    case REST: {
                        TrexMapLayer.this.httpPostTrex(visitLocationGoal);
                    }
                }
            }
        });
    }

    private void addUAVSpotter(JPopupMenu popup, final LocationType loc) {
        popup.add("UAV spotter").addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                loc.convertToAbsoluteLatLonDepth();
                UavSpotterSurvey going = new UavSpotterSurvey(loc.getLatitudeRads(), loc.getLongitudeRads(), TrexMapLayer.this.spotterHeight);
                TrexMapLayer.this.sentPoints.add(loc);
                switch (TrexMapLayer.this.trexDuneComms) {
                    case IMC: {
                        TrexMapLayer.this.send((IMCMessage)going.asIMCMsg());
                        break;
                    }
                    case IRIDIUM: {
                        try {
                            TrexMapLayer.this.sendViaIridium(TrexMapLayer.this.getConsole().getMainSystem(), (IMCMessage)going.asIMCMsg());
                        }
                        catch (Exception ex) {
                            NeptusLog.pub().error((Object)e);
                        }
                        break;
                    }
                    case REST: {
                        TrexMapLayer.this.httpPostTrex(going);
                    }
                }
            }
        });
    }

    private void addAUVDrifter(JPopupMenu popup, final LocationType loc) {
        popup.add("YoYo Survey").addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                loc.convertToAbsoluteLatLonDepth();
                AUVDrifterSurvey going = new AUVDrifterSurvey(loc.getLatitudeRads(), loc.getLongitudeRads(), TrexMapLayer.this.size, TrexMapLayer.this.speed, TrexMapLayer.this.lagrangin, TrexMapLayer.this.path, (float)Math.toRadians(TrexMapLayer.this.heading));
                switch (TrexMapLayer.this.trexDuneComms) {
                    case IMC: {
                        TrexMapLayer.this.send((IMCMessage)going.asIMCMsg());
                        break;
                    }
                    case IRIDIUM: {
                        try {
                            TrexMapLayer.this.sendViaIridium(TrexMapLayer.this.getConsole().getMainSystem(), (IMCMessage)going.asIMCMsg());
                        }
                        catch (Exception ex) {
                            NeptusLog.pub().error((Object)e);
                        }
                        break;
                    }
                    case REST: {
                        TrexMapLayer.this.httpPostTrex(going);
                    }
                }
                TrexMapLayer.this.sentGoals.put("" + going.hashCode(), going);
            }
        });
    }

    private void startTrex() {
        TrexOperation op = new TrexOperation(TrexOperation.OP.REQUEST_PLAN, "", null);
        this.send((IMCMessage)op);
    }

    private void stopTrex() {
        TrexOperation op = new TrexOperation(TrexOperation.OP.REPORT_PLAN, "", null);
        this.send((IMCMessage)op);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void httpPostTrex(TrexGoal goal) {
        try {
            StringEntity message = new StringEntity(goal.toJson());
            HttpPost httppost = new HttpPost("http://" + this.ipShore + ":" + this.portShore + "/rest/goal");
            httppost.setHeader("Content-Type", "application/json");
            httppost.setEntity((HttpEntity)message);
            HttpResponse response = this.httpclient.execute((HttpUriRequest)httppost);
            HttpEntity entity = response.getEntity();
            String textReceived = "";
            if (entity != null) {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(entity.getContent()));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        System.out.println(line);
                        textReceived = textReceived + line + "\n";
                    }
                }
            }
            if (response.getStatusLine().getStatusCode() != 200) {
                GuiUtils.errorMessage((Component)((Object)this), (String)"POST Goal", (String)textReceived);
            }
        }
        catch (HttpHostConnectException e1) {
            GuiUtils.errorMessage((Component)((Object)this), (String)"Unable to reach T-Rex", (String)("Cannot reach T-Rex:" + e1.getMessage() + ". Is it running and listening on this port?"));
        }
        catch (IOException | IllegalStateException e1) {
            e1.printStackTrace();
        }
    }

    private void addSurveyPointsMenu(JPopupMenu popup) {
        popup.add("Clear survey points").addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TrexMapLayer.this.surveyEdit = false;
                TrexMapLayer.this.surveyPos = 0;
                TrexMapLayer.this.surveyArea = new LocationType[4];
            }
        });
    }

    public boolean isExclusive() {
        return true;
    }

    public void paint(Graphics2D g, StateRenderer2D renderer) {
        if (this.trex == null) {
            this.trex = ImageUtils.getImage((String)PluginUtils.getPluginIcon(((Object)((Object)this)).getClass()));
        }
        if (this.surveyEdit) {
            for (int i = 0; i < this.surveyPos; ++i) {
                LocationType loc = this.surveyArea[i];
                Point2D pt = renderer.getScreenPosition(loc);
                g.translate(pt.getX(), pt.getY());
                g.setColor(Color.orange);
                g.fill(new Ellipse2D.Double(-5.0, -5.0, 10.0, 10.0));
                g.setColor(Color.red.darker().darker());
                g.drawString("" + i, 8, 8);
                g.translate(-pt.getX(), -pt.getY());
            }
        }
        if (this.lastManeuver != null && this.lastManeuver instanceof LocatedManeuver) {
            ManeuverLocation loc = ((LocatedManeuver)this.lastManeuver).getManeuverLocation();
            Point2D pt = renderer.getScreenPosition((LocationType)loc);
            g.translate(pt.getX(), pt.getY());
            g.setColor(Color.red);
            g.fill(new Ellipse2D.Double(-5.0, -5.0, 10.0, 10.0));
            g.setColor(Color.red.darker().darker());
            g.drawString("TREX: " + this.lastManeuver, 10, 10);
            g.translate(-pt.getX(), -pt.getY());
        }
        g.setColor(Color.black);
        for (String goal : this.sentGoals.keySet()) {
            if (!(this.sentGoals.get(goal) instanceof Renderer2DPainter)) continue;
            ((Renderer2DPainter)this.sentGoals.get(goal)).paint((Graphics2D)g.create(), renderer);
        }
        this.paintUavGoals(g, renderer);
        if (this.active) {
            g.drawImage(this.trex, 5, 5, 32, 32, (ImageObserver)((Object)this));
        }
    }

    private void paintUavGoals(Graphics2D g, StateRenderer2D renderer) {
        Point2D pt;
        int i = 1;
        for (LocationType loc : this.sentPoints) {
            pt = renderer.getScreenPosition(loc);
            g.translate(pt.getX(), pt.getY());
            g.setColor(new Color(173, 94, 255));
            g.fill(new Ellipse2D.Double(-5.0, -5.0, 10.0, 10.0));
            g.setColor(Color.black);
            g.drawString(i + " Goal", 10, 10);
            g.translate(-pt.getX(), -pt.getY());
            ++i;
        }
        if (this.currentRef != null) {
            pt = renderer.getScreenPosition(this.currentRef);
            g.translate(pt.getX(), pt.getY());
            g.setColor(Color.green);
            g.drawOval(-5, -5, 10, 10);
            g.translate(-pt.getX(), -pt.getY());
        }
    }

    public static void main(String[] args) {
        System.out.printf("%x\n", 65094);
    }

    public void initSubPanel() {
    }

    public void cleanSubPanel() {
        this.httpclient.getConnectionManager().shutdown();
    }

    public String[] getObservedMessages() {
        String[] msgs = new String[]{"PathControlState", "PlanControlState"};
        return msgs;
    }

    @Subscribe
    public void on(TrexOperation msg) {
        if (!this.postNotifications) {
            return;
        }
        TrexToken token = msg.getToken();
        if (token == null) {
            return;
        }
        switch (msg.getOp()) {
            case POST_TOKEN: {
                String pred = token.getPredicate();
                String timeline = token.getTimeline();
                this.post(Notification.success((String)"T-REX Observation", (String)(timeline + "." + pred)));
                break;
            }
            case POST_GOAL: {
                String pred = token.getPredicate();
                String timeline = token.getTimeline();
                this.post(Notification.success((String)"T-REX Goal", (String)(timeline + "." + pred)));
                break;
            }
        }
    }

    public void messageArrived(IMCMessage message) {
        if (message instanceof PathControlState) {
            PathControlState pathState = (PathControlState)message;
            this.currentRef = new LocationType();
            this.currentRef.setLatitudeRads(pathState.getEndLat());
            this.currentRef.setLongitudeRads(pathState.getEndLon());
        } else if (message instanceof PlanControlState) {
            PlanControlState planState = (PlanControlState)message;
            if (!this.trexActive) {
                if (planState.getState() == PlanControlState.STATE.EXECUTING && planState.getPlanId().equals("trex_plan")) {
                    this.trexActive = true;
                }
            } else if (planState.getState() != PlanControlState.STATE.EXECUTING || !planState.getPlanId().equals("trex_plan")) {
                this.trexActive = false;
            }
        }
    }

    static enum CommsChannel {
        IMC,
        IRIDIUM,
        REST;

    }
}

