/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.trex;

import java.util.LinkedHashSet;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.lsf.LsfIndex;
import pt.lsts.neptus.mra.MRAPanel;
import pt.lsts.neptus.mra.plots.MRAGanttPlot;
import pt.lsts.neptus.plugins.PluginDescription;

@PluginDescription(name="TREX Timeline", active=false)
public class TrexTimeline
extends MRAGanttPlot {
    public TrexTimeline(MRAPanel panel) {
        super(panel);
    }

    public boolean canBeApplied(LsfIndex index) {
        return index.containsMessagesOfType(new String[]{"TrexToken"});
    }

    public void process(LsfIndex source) {
        LinkedHashSet<String> timelines = new LinkedHashSet<String>();
        for (IMCMessage iMCMessage : source.getIterator("TrexToken")) {
            this.startActivity(iMCMessage.getTimestamp(), iMCMessage.getString("timeline"), iMCMessage.getString("timeline") + "." + iMCMessage.getString("predicate"));
            timelines.add(iMCMessage.getString("timeline"));
        }
        for (String string : timelines) {
            this.endActivity(source.getEndTime(), string);
        }
    }
}

