/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.trex;

import com.google.common.eventbus.Subscribe;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Vector;
import javax.swing.border.EmptyBorder;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.data.category.IntervalCategoryDataset;
import org.jfree.data.gantt.Task;
import org.jfree.data.gantt.TaskSeries;
import org.jfree.data.gantt.TaskSeriesCollection;
import org.jfree.data.time.SimpleTimePeriod;
import org.jfree.data.time.TimePeriod;
import pt.lsts.imc.TrexToken;
import pt.lsts.imc.VehicleState;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.Popup;

@PluginDescription(name="TREX Timeline", icon="pt/lsts/neptus/plugins/trex/trex.png")
@Popup(accelerator=117, pos=Popup.POSITION.BOTTOM, height=300, width=800, icon="pt/lsts/neptus/plugins/trex/trex.png")
public class TrexTimelinePanel
extends ConsolePanel {
    private static final long serialVersionUID = 1L;
    protected JFreeChart chart;
    protected ChartPanel panel;
    protected TaskSeriesCollection tsc = new TaskSeriesCollection();
    protected LinkedHashMap<String, TaskSeries> series = new LinkedHashMap();
    protected LinkedHashMap<String, String> statePerTimeline = new LinkedHashMap();

    public TrexTimelinePanel(ConsoleLayout c) {
        super(c);
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
    }

    public void initSubPanel() {
        this.chart = ChartFactory.createGanttChart((String)"", (String)"", (String)"", (IntervalCategoryDataset)this.tsc, (boolean)true, (boolean)true, (boolean)false);
        this.panel = new ChartPanel(this.chart);
        this.setLayout(new BorderLayout());
        this.add((Component)this.panel, "Center");
    }

    public void cleanSubPanel() {
    }

    public JFreeChart getChart(String title, String xlabel, String ylabel) {
        if (this.chart != null) {
            this.chart = ChartFactory.createGanttChart((String)title, (String)xlabel, (String)ylabel, (IntervalCategoryDataset)this.tsc, (boolean)true, (boolean)true, (boolean)false);
        }
        return this.chart;
    }

    public final Collection<String> getSeriesNames() {
        LinkedHashSet<String> series = new LinkedHashSet<String>();
        series.addAll(this.series.keySet());
        Vector<String> col = new Vector<String>();
        col.addAll(series);
        Collections.sort(col);
        return col;
    }

    public void addTrace(String trace) {
        this.series.put(trace, new TaskSeries(trace));
        this.tsc.add(this.series.get(trace));
    }

    public void startActivity(double time, String trace, String state) {
        if (!this.series.containsKey(trace)) {
            this.addTrace(trace);
        }
        if (this.statePerTimeline.containsKey(trace)) {
            if (this.statePerTimeline.get(trace).equals(state)) {
                Task t = this.series.get(trace).get(state);
                if (t.getSubtaskCount() > 0) {
                    this.setEndTime(t.getSubtask(t.getSubtaskCount() - 1), time);
                }
                this.setEndTime(t, time);
                if (this.panel.isVisible()) {
                    this.chart.getCategoryPlot().configureRangeAxes();
                    this.panel.repaint();
                }
                return;
            }
            this.endActivity(time, trace);
        }
        this.statePerTimeline.put(trace, state);
        Task t = this.series.get(trace).get(state);
        if (t == null) {
            long start = (long)(time * 1000.0);
            long end = (long)(time * 1000.0);
            t = new Task(state, new Date(start), new Date(end));
            this.series.get(trace).add(t);
        }
        t.addSubtask(new Task(state + time, new Date((long)(time * 1000.0)), new Date((long)(time * 1000.0))));
        if (this.panel.isVisible()) {
            this.chart.getCategoryPlot().configureRangeAxes();
            this.panel.repaint();
        }
    }

    private Task setEndTime(Task t, double time) {
        TimePeriod tp = t.getDuration();
        t.setDuration((TimePeriod)new SimpleTimePeriod(tp.getStart(), new Date((long)(time * 1000.0))));
        return t;
    }

    public void endActivity(double time, String trace) {
        if (!this.series.containsKey(trace)) {
            return;
        }
        Task t = this.series.get(trace).get(this.statePerTimeline.get(trace));
        if (t.getSubtaskCount() > 0) {
            this.setEndTime(t.getSubtask(t.getSubtaskCount() - 1), time);
        }
        this.setEndTime(t, time);
        this.statePerTimeline.put(trace, null);
    }

    @Subscribe
    public void on(TrexToken token) {
        this.startActivity(token.getTimestamp(), token.getTimeline(), token.getTimeline() + "." + token.getPredicate());
    }

    @Subscribe
    public void on(VehicleState state) {
    }
}

