/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.trex.goals;

import com.l2fprod.common.propertysheet.DefaultProperty;
import com.l2fprod.common.propertysheet.Property;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.HashMap;
import java.util.Vector;
import pt.lsts.imc.TrexAttribute;
import pt.lsts.neptus.gui.PropertiesEditor;
import pt.lsts.neptus.plugins.trex.goals.TrexGoal;
import pt.lsts.neptus.renderer2d.Renderer2DPainter;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.LocationType;

public class AUVDrifterSurvey
extends TrexGoal
implements Renderer2DPainter {
    private static final String predicate = "Survey";
    private static final String timeline = "drifter";
    private Shape survey;
    private LocationType center;
    private Point2D firstPoint;
    private double rotationRads;
    private static final double pitch = Math.toRadians(15.0);
    private static final double hspeed = 1.3 * Math.cos(pitch);
    private final HashMap<Attributes, Object> attributes = new HashMap();

    public AUVDrifterSurvey(double latrad, double lonrad, float size, float speed, boolean lagrangian, PathType path, float heading) {
        super(timeline, predicate);
        this.attributes.put(Attributes.LATITUDE, latrad);
        this.attributes.put(Attributes.LONGITUDE, lonrad);
        this.attributes.put(Attributes.SIZE, Float.valueOf(size));
        this.attributes.put(Attributes.LAGRANGIAN, lagrangian);
        this.attributes.put(Attributes.PATH, (Object)path);
        this.attributes.put(Attributes.HEADING, Float.valueOf(heading));
        if (speed != 0.0f && lagrangian) {
            double speed_e = Math.sin(heading) * (double)speed;
            double speed_n = Math.cos(heading) * (double)speed;
            this.attributes.put(Attributes.SPEED_EAST, speed_e);
            this.attributes.put(Attributes.SPEED_NORTH, speed_n);
        }
        this.buildShape(path, new LocationType(Math.toDegrees(latrad), Math.toDegrees(lonrad)), size, heading, speed);
    }

    private void buildShape(PathType type, LocationType center, double size, double rotation, double speed) {
        double halfSize = size / 2.0;
        this.center = center;
        this.rotationRads = rotation;
        switch (type) {
            case GO_TO: {
                this.survey = new Line2D.Double(0.0, 0.0, 0.0, 0.0);
                this.firstPoint = new Point2D.Double(0.0, 0.0);
                break;
            }
            case BACK_FORTH: {
                this.firstPoint = new Point2D.Double(0.0, halfSize);
                this.survey = new Line2D.Double(0.0, -halfSize, 0.0, halfSize);
                break;
            }
            case UPWARD: {
                this.firstPoint = new Point2D.Double(0.0, halfSize);
                this.survey = new Line2D.Double(0.0, -halfSize, 0.0, halfSize);
                break;
            }
            case SQUARE: {
                if (speed == 0.0) {
                    this.firstPoint = new Point2D.Double(-halfSize, -halfSize);
                    this.survey = new Rectangle2D.Double(-halfSize, -halfSize, size, size);
                    break;
                }
                this.firstPoint = new Point2D.Double(-halfSize, -halfSize);
                GeneralPath gp = new GeneralPath();
                Point2D.Double[] pts = new Point2D.Double[]{new Point2D.Double(-halfSize, -halfSize), new Point2D.Double(halfSize, -halfSize - size / hspeed * speed), new Point2D.Double(halfSize, halfSize - 2.0 * (size / hspeed) * speed), new Point2D.Double(-halfSize, halfSize - 3.0 * (size / hspeed) * speed), new Point2D.Double(-halfSize, -halfSize - 4.0 * (size / hspeed) * speed)};
                gp.moveTo(-halfSize, -halfSize);
                for (int i = 1; i < 5; ++i) {
                    gp.lineTo(pts[i].getX(), pts[i].getY());
                    System.out.println(pts[i]);
                }
                this.survey = gp;
            }
        }
    }

    @Override
    public Collection<TrexAttribute> getAttributes() {
        Vector<TrexAttribute> attributes = new Vector<TrexAttribute>();
        TrexAttribute attrTemp = new TrexAttribute();
        attrTemp.setName(Attributes.LATITUDE.name);
        attrTemp.setMin(this.attributes.get((Object)Attributes.LATITUDE) + "");
        attrTemp.setMax(this.attributes.get((Object)Attributes.LATITUDE) + "");
        attrTemp.setAttrType(Attributes.LATITUDE.type);
        attributes.add(attrTemp);
        attrTemp = new TrexAttribute();
        attrTemp.setName(Attributes.LONGITUDE.name);
        attrTemp.setMin(this.attributes.get((Object)Attributes.LONGITUDE) + "");
        attrTemp.setMax(this.attributes.get((Object)Attributes.LONGITUDE) + "");
        attrTemp.setAttrType(Attributes.LATITUDE.type);
        attributes.add(attrTemp);
        attrTemp = new TrexAttribute();
        attrTemp.setName(Attributes.SIZE.name);
        attrTemp.setMin(this.attributes.get((Object)Attributes.SIZE) + "");
        attrTemp.setMax(this.attributes.get((Object)Attributes.SIZE) + "");
        attrTemp.setAttrType(Attributes.SIZE.type);
        attributes.add(attrTemp);
        attrTemp = new TrexAttribute();
        attrTemp.setName(Attributes.LAGRANGIAN.name);
        attrTemp.setMin(this.attributes.get((Object)Attributes.LAGRANGIAN) + "");
        attrTemp.setMax(this.attributes.get((Object)Attributes.LAGRANGIAN) + "");
        attrTemp.setAttrType(Attributes.LAGRANGIAN.type);
        attributes.add(attrTemp);
        attrTemp = new TrexAttribute();
        attrTemp.setName(Attributes.PATH.name);
        PathType pathObj = (PathType)((Object)this.attributes.get((Object)Attributes.PATH));
        attrTemp.setMin(pathObj.name + "");
        attrTemp.setAttrType(Attributes.PATH.type);
        attributes.add(attrTemp);
        attrTemp = new TrexAttribute();
        if (this.attributes.get((Object)Attributes.SPEED_EAST) != null && this.attributes.get((Object)Attributes.SPEED_NORTH) != null) {
            attrTemp = new TrexAttribute();
            attrTemp.setName(Attributes.SPEED_EAST.name);
            attrTemp.setMin(this.attributes.get((Object)Attributes.SPEED_EAST) + "");
            attrTemp.setMax(this.attributes.get((Object)Attributes.SPEED_EAST) + "");
            attrTemp.setAttrType(Attributes.SPEED_EAST.type);
            attributes.add(attrTemp);
            attrTemp = new TrexAttribute();
            attrTemp.setName(Attributes.SPEED_NORTH.name);
            attrTemp.setMin(this.attributes.get((Object)Attributes.SPEED_NORTH) + "");
            attrTemp.setMax(this.attributes.get((Object)Attributes.SPEED_NORTH) + "");
            attrTemp.setAttrType(Attributes.SPEED_NORTH.type);
            attributes.add(attrTemp);
        } else {
            attrTemp.setName(Attributes.HEADING.name);
            attrTemp.setMin(this.attributes.get((Object)Attributes.HEADING) + "");
            attrTemp.setMax(this.attributes.get((Object)Attributes.HEADING) + "");
            attrTemp.setAttrType(Attributes.HEADING.type);
            attributes.add(attrTemp);
        }
        return attributes;
    }

    @Override
    public void parseAttributes(Collection<TrexAttribute> attributes) {
    }

    @Override
    public Collection<DefaultProperty> getSpecificProperties() {
        Vector<DefaultProperty> props = new Vector<DefaultProperty>();
        props.add(PropertiesEditor.getPropertyInstance((String)"Latitude", Double.class, (Object)this.attributes.get((Object)Attributes.LATITUDE), (boolean)true));
        props.add(PropertiesEditor.getPropertyInstance((String)"Longitude", Double.class, (Object)this.attributes.get((Object)Attributes.LONGITUDE), (boolean)true));
        return props;
    }

    @Override
    public void setSpecificProperties(Collection<Property> properties) {
        for (Property p : properties) {
            switch (p.getName()) {
                case "Latitude": {
                    this.attributes.put(Attributes.LATITUDE, (Double)p.getValue());
                }
                case "Longitude": {
                    this.attributes.put(Attributes.LONGITUDE, (Double)p.getValue());
                }
            }
        }
    }

    public LocationType getLocation() {
        LocationType loc = new LocationType(((Double)this.attributes.get((Object)Attributes.LATITUDE)).doubleValue(), ((Double)this.attributes.get((Object)Attributes.LONGITUDE)).doubleValue());
        return loc;
    }

    public void paint(Graphics2D g, StateRenderer2D renderer) {
        g.setColor(Color.green.darker().darker());
        if (this.survey != null) {
            Point2D centerPt = renderer.getScreenPosition(this.center);
            g.translate(centerPt.getX(), centerPt.getY());
            g.rotate(this.rotationRads);
            g.scale(renderer.getZoom(), renderer.getZoom());
            g.fill(new Ellipse2D.Double(this.firstPoint.getX() - 5.0, this.firstPoint.getY() - 5.0, 10.0, 10.0));
            g.draw(this.survey);
        } else {
            System.err.println("survey is null!");
        }
    }

    @Override
    public String toJson() {
        return "{\"on\": \"" + ((TrexGoal)this).timeline + "\",\"pred\": \"" + ((TrexGoal)this).predicate + "\"," + "\"Variable\":" + "[" + "{\"float\":{\"value\": \"" + this.attributes.get((Object)Attributes.LATITUDE) + "\"}, \"name\": \"" + Attributes.LATITUDE.name + "\"}," + "{\"float\":{\"value\": \"" + this.attributes.get((Object)Attributes.LONGITUDE) + "\"}, \"name\": \"" + Attributes.LONGITUDE.name + "\"}" + "{\"" + Attributes.SIZE.type.toString().toLowerCase() + "\":{\"value\": \"" + this.attributes.get((Object)Attributes.SIZE) + "\"}, \"name\": \"" + Attributes.SIZE.name + "\"}" + "{\"" + Attributes.PATH.type.toString().toLowerCase() + "\":{\"value\": \"" + this.attributes.get((Object)Attributes.PATH) + "\"}, \"name\": \"" + Attributes.PATH.name + "\"}" + "{\"" + Attributes.LAGRANGIAN.type.toString().toLowerCase() + "\":{\"value\": \"" + this.attributes.get((Object)Attributes.LAGRANGIAN) + "\"}, \"name\": \"" + Attributes.LAGRANGIAN.name + "\"}" + "]}";
    }

    public static enum PathType {
        SQUARE("square"),
        BACK_FORTH("forth_and_back"),
        GO_TO("go_to"),
        UPWARD("upward_transect");

        public String name;

        private PathType(String name) {
            this.name = name;
        }
    }

    public static enum Attributes {
        LATITUDE("center_lat", TrexAttribute.ATTR_TYPE.FLOAT),
        LONGITUDE("center_lon", TrexAttribute.ATTR_TYPE.FLOAT),
        PATH("path", TrexAttribute.ATTR_TYPE.ENUM),
        SIZE("size", TrexAttribute.ATTR_TYPE.FLOAT),
        LAGRANGIAN("lagrangian", TrexAttribute.ATTR_TYPE.BOOL),
        HEADING("heading", TrexAttribute.ATTR_TYPE.FLOAT),
        SPEED_EAST("speed_east", TrexAttribute.ATTR_TYPE.FLOAT),
        SPEED_NORTH("speed_north", TrexAttribute.ATTR_TYPE.FLOAT);

        public String name;
        public TrexAttribute.ATTR_TYPE type;

        private Attributes(String name, TrexAttribute.ATTR_TYPE type) {
            this.name = name;
            this.type = type;
        }
    }
}

