/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.trex.goals;

import com.l2fprod.common.propertysheet.DefaultProperty;
import com.l2fprod.common.propertysheet.Property;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Vector;
import pt.lsts.imc.TrexAttribute;
import pt.lsts.imc.TrexOperation;
import pt.lsts.imc.TrexToken;
import pt.lsts.neptus.gui.PropertiesEditor;
import pt.lsts.neptus.gui.PropertiesProvider;
import pt.lsts.neptus.gui.editor.UnixTimeEditor;
import pt.lsts.neptus.plugins.trex.goals.GoalWithoutAttributes;
import pt.lsts.neptus.plugins.trex.goals.VisitLocationGoal;

public abstract class TrexGoal
implements PropertiesProvider {
    protected String goalId;
    protected String timeline;
    protected String predicate;
    protected Date minStartTime = new Date();
    protected Date maxStartTime = new Date(System.currentTimeMillis() + 86400000L);
    protected Date minEndTime = new Date();
    protected Date maxEndTime = new Date(System.currentTimeMillis() + 86400000L);
    protected boolean specifyStartDate = false;
    protected boolean specifyEndDate = false;

    public abstract Collection<TrexAttribute> getAttributes();

    public abstract void parseAttributes(Collection<TrexAttribute> var1);

    public abstract void setSpecificProperties(Collection<Property> var1);

    public abstract Collection<DefaultProperty> getSpecificProperties();

    public abstract String toJson();

    public String getTimeline() {
        return this.timeline;
    }

    public void setTimeline(String timeline) {
        this.timeline = timeline;
    }

    public String getPredicate() {
        return this.predicate;
    }

    public void setPredicate(String predicate) {
        this.predicate = predicate;
    }

    protected final Collection<TrexAttribute> getAggregatedAttributes() {
        Vector<TrexAttribute> attrs = new Vector<TrexAttribute>();
        if (this.specifyStartDate) {
            attrs.add(new TrexAttribute("start", TrexAttribute.ATTR_TYPE.INT, "" + this.minStartTime.getTime(), "" + this.maxStartTime.getTime()));
        }
        if (this.specifyEndDate) {
            attrs.add(new TrexAttribute("end", TrexAttribute.ATTR_TYPE.INT, "" + this.minEndTime.getTime(), "" + this.maxEndTime.getTime()));
        }
        attrs.addAll(this.getAttributes());
        return attrs;
    }

    protected final void parseAggregatedAttributes(Collection<TrexAttribute> attributes) {
        Vector<TrexAttribute> unparsed = new Vector<TrexAttribute>();
        unparsed.addAll(attributes);
        for (TrexAttribute t : attributes) {
            switch (t.getName()) {
                case "start": {
                    unparsed.remove(t);
                    this.minStartTime = new Date(Long.parseLong(t.getMin()));
                    this.maxStartTime = new Date(Long.parseLong(t.getMax()));
                    break;
                }
                case "end": {
                    unparsed.remove(t);
                    this.minEndTime = new Date(Long.parseLong(t.getMin()));
                    this.maxEndTime = new Date(Long.parseLong(t.getMax()));
                    break;
                }
            }
        }
        this.parseAttributes(unparsed);
    }

    public TrexGoal(String timeline, String predicate) {
        this.goalId = "N_" + System.currentTimeMillis();
        this.timeline = timeline;
        this.predicate = predicate;
    }

    public final DefaultProperty[] getProperties() {
        DefaultProperty minEndProp = PropertiesEditor.getPropertyInstance((String)"Minimum End time", Date.class, (Object)this.minEndTime, (boolean)true);
        DefaultProperty maxEndProp = PropertiesEditor.getPropertyInstance((String)"Maximum End time", Date.class, (Object)this.maxEndTime, (boolean)true);
        DefaultProperty minStartProp = PropertiesEditor.getPropertyInstance((String)"Minimum Start time", Date.class, (Object)this.minStartTime, (boolean)true);
        DefaultProperty maxStartProp = PropertiesEditor.getPropertyInstance((String)"Maximum Start time", Date.class, (Object)this.maxStartTime, (boolean)true);
        PropertiesEditor.getPropertyEditorRegistry().registerEditor((Property)minStartProp, UnixTimeEditor.class);
        PropertiesEditor.getPropertyEditorRegistry().registerEditor((Property)maxStartProp, UnixTimeEditor.class);
        PropertiesEditor.getPropertyEditorRegistry().registerEditor((Property)minEndProp, UnixTimeEditor.class);
        PropertiesEditor.getPropertyEditorRegistry().registerEditor((Property)maxEndProp, UnixTimeEditor.class);
        Vector<DefaultProperty> props = new Vector<DefaultProperty>();
        DefaultProperty[] properties = new DefaultProperty[]{PropertiesEditor.getPropertyInstance((String)"Timeline", String.class, (Object)this.timeline, (boolean)true), PropertiesEditor.getPropertyInstance((String)"Predicate", String.class, (Object)this.predicate, (boolean)true), minStartProp, maxStartProp, minEndProp, maxEndProp, PropertiesEditor.getPropertyInstance((String)"Specify Start Date", Boolean.class, (Object)this.specifyStartDate, (boolean)true), PropertiesEditor.getPropertyInstance((String)"Specify End Date", Boolean.class, (Object)this.specifyEndDate, (boolean)true)};
        props.addAll(Arrays.asList(properties));
        props.addAll(this.getSpecificProperties());
        return props.toArray(new DefaultProperty[0]);
    }

    public final void setProperties(Property[] properties) {
        Vector<Property> unprocessed = new Vector<Property>();
        unprocessed.addAll(Arrays.asList(properties));
        block20: for (Property p : properties) {
            switch (p.getName()) {
                case "Timeline": {
                    this.timeline = p.getValue().toString();
                    unprocessed.remove(p);
                    continue block20;
                }
                case "Predicate": {
                    this.predicate = p.getValue().toString();
                    unprocessed.remove(p);
                    continue block20;
                }
                case "Specify Start Date": {
                    this.specifyStartDate = (Boolean)p.getValue();
                    unprocessed.remove(p);
                    continue block20;
                }
                case "Specify End Date": {
                    this.specifyEndDate = (Boolean)p.getValue();
                    unprocessed.remove(p);
                    continue block20;
                }
                case "Minimum End time": {
                    this.minEndTime = (Date)p.getValue();
                    unprocessed.remove(p);
                    continue block20;
                }
                case "Maximum End time": {
                    this.maxEndTime = (Date)p.getValue();
                    unprocessed.remove(p);
                    continue block20;
                }
                case "Minimum Start time": {
                    this.minStartTime = (Date)p.getValue();
                    unprocessed.remove(p);
                    continue block20;
                }
                case "Maximum Start time": {
                    this.maxStartTime = (Date)p.getValue();
                    unprocessed.remove(p);
                    continue block20;
                }
            }
        }
        this.setSpecificProperties(unprocessed);
    }

    public String getPropertiesDialogTitle() {
        return this.getClass().getSimpleName() + " parameters";
    }

    public String[] getPropertiesErrors(Property[] properties) {
        return null;
    }

    public static final TrexGoal parseImcMsg(TrexToken token) {
        TrexGoal goal;
        switch (token.getTimeline() + "." + token.getPredicate()) {
            case "estimator.At": {
                goal = new VisitLocationGoal();
                break;
            }
            default: {
                goal = new GoalWithoutAttributes(token.getTimeline(), token.getPredicate());
            }
        }
        goal.parseAggregatedAttributes(token.getAttributes());
        return goal;
    }

    public final TrexOperation asIMCMsg() {
        TrexOperation trexOperation = new TrexOperation(TrexOperation.OP.POST_GOAL, this.goalId, new TrexToken(this.timeline, this.predicate, this.getAggregatedAttributes()));
        return trexOperation;
    }
}

