/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.trex.goals;

import com.l2fprod.common.propertysheet.DefaultProperty;
import com.l2fprod.common.propertysheet.Property;
import java.awt.Graphics2D;
import java.util.Collection;
import java.util.HashMap;
import java.util.Vector;
import pt.lsts.imc.TrexAttribute;
import pt.lsts.neptus.gui.PropertiesEditor;
import pt.lsts.neptus.plugins.trex.goals.TrexGoal;
import pt.lsts.neptus.renderer2d.Renderer2DPainter;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.LocationType;

public class UavSpotterSurvey
extends TrexGoal
implements Renderer2DPainter {
    private static final String predicate = "Survey";
    private static final String timeline = "spotter";
    private final HashMap<Attributes, Double> attributes = new HashMap();

    public UavSpotterSurvey(double lat_deg, double lon_deg, int spotterHeight) {
        super(timeline, predicate);
        this.attributes.put(Attributes.LATITUDE, lat_deg);
        this.attributes.put(Attributes.LONGITUDE, lon_deg);
        this.attributes.put(Attributes.HEIGHT, Double.valueOf(spotterHeight));
    }

    @Override
    public Collection<TrexAttribute> getAttributes() {
        Vector<TrexAttribute> attributes = new Vector<TrexAttribute>();
        TrexAttribute attrTemp = new TrexAttribute();
        attrTemp.setName(Attributes.LATITUDE.name);
        attrTemp.setMin(this.attributes.get((Object)Attributes.LATITUDE) + "");
        attrTemp.setMax(this.attributes.get((Object)Attributes.LATITUDE) + "");
        attrTemp.setAttrType(TrexAttribute.ATTR_TYPE.FLOAT);
        attributes.add(attrTemp);
        attrTemp = new TrexAttribute();
        attrTemp.setName(Attributes.LONGITUDE.name);
        attrTemp.setMin(this.attributes.get((Object)Attributes.LONGITUDE) + "");
        attrTemp.setMax(this.attributes.get((Object)Attributes.LONGITUDE) + "");
        attrTemp.setAttrType(TrexAttribute.ATTR_TYPE.FLOAT);
        attributes.add(attrTemp);
        attrTemp = new TrexAttribute();
        attrTemp.setName(Attributes.HEIGHT.name);
        attrTemp.setMin(this.attributes.get((Object)Attributes.HEIGHT) + "");
        attrTemp.setMax(this.attributes.get((Object)Attributes.HEIGHT) + "");
        attrTemp.setAttrType(TrexAttribute.ATTR_TYPE.FLOAT);
        attributes.add(attrTemp);
        return attributes;
    }

    @Override
    public void parseAttributes(Collection<TrexAttribute> attributes) {
    }

    @Override
    public Collection<DefaultProperty> getSpecificProperties() {
        Vector<DefaultProperty> props = new Vector<DefaultProperty>();
        props.add(PropertiesEditor.getPropertyInstance((String)"Latitude", Double.class, (Object)this.attributes.get((Object)Attributes.LATITUDE), (boolean)true));
        props.add(PropertiesEditor.getPropertyInstance((String)"Longitude", Double.class, (Object)this.attributes.get((Object)Attributes.LONGITUDE), (boolean)true));
        return props;
    }

    @Override
    public void setSpecificProperties(Collection<Property> properties) {
        for (Property p : properties) {
            switch (p.getName()) {
                case "Latitude": {
                    this.attributes.put(Attributes.LATITUDE, (Double)p.getValue());
                }
                case "Longitude": {
                    this.attributes.put(Attributes.LONGITUDE, (Double)p.getValue());
                }
            }
        }
    }

    public LocationType getLocation() {
        LocationType loc = new LocationType(this.attributes.get((Object)Attributes.LATITUDE).doubleValue(), this.attributes.get((Object)Attributes.LONGITUDE).doubleValue());
        return loc;
    }

    public void paint(Graphics2D g, StateRenderer2D renderer) {
    }

    @Override
    public String toJson() {
        return "{\"on\": \"" + ((TrexGoal)this).timeline + "\",\"pred\": \"" + ((TrexGoal)this).predicate + "\"," + "\"Variable\":" + "[" + "{\"float\":{\"value\": \"" + this.attributes.get((Object)Attributes.LATITUDE) + "\"}, \"name\": \"" + Attributes.LATITUDE.name + "\"}," + "{\"float\":{\"value\": \"" + this.attributes.get((Object)Attributes.LONGITUDE) + "\"}, \"name\": \"" + Attributes.LONGITUDE.name + "\"}" + "{\"float\":{\"value\": \"" + this.attributes.get((Object)Attributes.HEIGHT) + "\"}, \"name\": \"" + Attributes.HEIGHT.name + "\"}" + "]}";
    }

    public static enum Attributes {
        LATITUDE("center_lat"),
        LONGITUDE("center_lon"),
        HEIGHT("z");

        public String name;

        private Attributes(String name) {
            this.name = name;
        }
    }
}

