/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.trex.goals;

import com.l2fprod.common.propertysheet.DefaultProperty;
import com.l2fprod.common.propertysheet.Property;
import java.awt.Graphics2D;
import java.util.Collection;
import java.util.Vector;
import pt.lsts.imc.TrexAttribute;
import pt.lsts.neptus.gui.PropertiesEditor;
import pt.lsts.neptus.plugins.trex.goals.TrexGoal;
import pt.lsts.neptus.renderer2d.Renderer2DPainter;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.LocationType;

public class VisitLocationGoal
extends TrexGoal
implements Renderer2DPainter {
    protected double speed = 1.0;
    protected double depth = 0.0;
    protected double tolerance = 10.0;
    protected double latitude;
    protected double longitude;

    public VisitLocationGoal(double lat_deg, double lon_deg) {
        super("navigator", "At");
        this.latitude = lat_deg;
        this.longitude = lon_deg;
    }

    public VisitLocationGoal() {
        super("navigator", "At");
    }

    public VisitLocationGoal(double speed, double depth, double lat_deg, double lon_deg) {
        super("navigator", "At");
        this.speed = speed;
        this.depth = depth;
        this.latitude = lat_deg;
        this.longitude = lon_deg;
    }

    @Override
    public Collection<TrexAttribute> getAttributes() {
        Vector<TrexAttribute> attributes = new Vector<TrexAttribute>();
        TrexAttribute attrTemp = new TrexAttribute();
        attrTemp.setAttrType(TrexAttribute.ATTR_TYPE.FLOAT);
        attrTemp.setName("speed");
        attrTemp.setMin(this.speed + "");
        attrTemp.setMax(this.speed + "");
        attributes.add(attrTemp);
        attrTemp = new TrexAttribute();
        attrTemp.setAttrType(TrexAttribute.ATTR_TYPE.FLOAT);
        attrTemp.setName("latitude");
        attrTemp.setMin(this.latitude + "");
        attrTemp.setMax(this.latitude + "");
        attributes.add(attrTemp);
        attrTemp = new TrexAttribute();
        attrTemp.setAttrType(TrexAttribute.ATTR_TYPE.FLOAT);
        attrTemp.setName("longitude");
        attrTemp.setMin(this.longitude + "");
        attrTemp.setMax(this.longitude + "");
        attributes.add(attrTemp);
        attrTemp = new TrexAttribute();
        attrTemp.setAttrType(TrexAttribute.ATTR_TYPE.FLOAT);
        attrTemp.setName("z");
        attrTemp.setMin(this.depth + "");
        attrTemp.setMax(this.depth + "");
        attributes.add(attrTemp);
        return attributes;
    }

    @Override
    public void parseAttributes(Collection<TrexAttribute> attributes) {
    }

    @Override
    public Collection<DefaultProperty> getSpecificProperties() {
        Vector<DefaultProperty> props = new Vector<DefaultProperty>();
        props.add(PropertiesEditor.getPropertyInstance((String)"Depth", Double.class, (Object)this.depth, (boolean)true));
        props.add(PropertiesEditor.getPropertyInstance((String)"Speed", Double.class, (Object)this.speed, (boolean)true));
        props.add(PropertiesEditor.getPropertyInstance((String)"Latitude", Double.class, (Object)this.latitude, (boolean)true));
        props.add(PropertiesEditor.getPropertyInstance((String)"Longitude", Double.class, (Object)this.longitude, (boolean)true));
        return props;
    }

    @Override
    public void setSpecificProperties(Collection<Property> properties) {
        for (Property p : properties) {
            switch (p.getName()) {
                case "Depth": {
                    this.depth = (Double)p.getValue();
                    break;
                }
                case "Speed": {
                    this.speed = (Double)p.getValue();
                }
                case "Latitude": {
                    this.latitude = (Double)p.getValue();
                }
                case "Longitude": {
                    this.longitude = (Double)p.getValue();
                }
            }
        }
    }

    public LocationType getLocation() {
        LocationType loc = new LocationType(this.latitude, this.longitude);
        loc.setAbsoluteDepth(this.depth);
        return loc;
    }

    public void paint(Graphics2D g, StateRenderer2D renderer) {
    }

    @Override
    public String toJson() {
        return "{\"on\": \"" + this.timeline + "\",\"pred\": \"" + this.predicate + "\"," + "\"Variable\":" + "[" + "{\"float\":{\"value\": \"" + this.speed + "\"}, \"name\": \"speed\"}," + "{\"float\":{\"value\": \"" + this.latitude + "\"}, \"name\": \"latitude\"}," + "{\"float\":{\"value\": \"" + this.longitude + "\"}, \"name\": \"longitude\"}" + "]}";
    }
}

