/*
 * Decompiled with CFR 0.152.
 */
package org.ietf.uri;

import java.io.IOException;
import java.net.MalformedURLException;
import java.security.cert.Certificate;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.ietf.uri.ResourceConnection;
import org.ietf.uri.URI;
import org.ietf.uri.URL;

public abstract class JarResourceConnection
extends ResourceConnection {
    public static final String JAR_CONTENT_TYPE = "x-java/jar";
    public static final String JAR_FILE_EXTENSION = "jar";
    protected ResourceConnection jarFileResource = null;
    protected URI jarFileURI = null;
    protected String jarEntryName = null;
    protected JarFile jarFile = null;
    protected JarEntry jarEntry = null;

    protected JarResourceConnection(URI uRI, String string) throws MalformedURLException {
        super(new URL("jar:" + uRI.toExternalForm() + "!/" + string));
        this.jarFileURI = uRI;
        if (string != null && string.length() != 0) {
            this.jarEntryName = string;
        }
    }

    protected abstract JarFile getJarFile() throws IOException;

    public Attributes getAttributes() throws IOException {
        if (this.jarEntryName == null) {
            return null;
        }
        if (this.jarEntry == null) {
            this.getJarEntry();
        }
        Attributes attributes = null;
        if (this.jarEntry != null) {
            attributes = this.jarEntry.getAttributes();
        }
        return attributes;
    }

    public Certificate[] getCertificates() throws IOException {
        if (this.jarEntryName == null) {
            return null;
        }
        if (this.jarEntry == null) {
            this.getJarEntry();
        }
        Certificate[] certificateArray = null;
        if (this.jarEntry != null) {
            certificateArray = this.jarEntry.getCertificates();
        }
        return certificateArray;
    }

    public String getEntryName() {
        return this.jarEntryName;
    }

    public JarEntry getJarEntry() throws IOException {
        if (this.jarEntryName == null) {
            return null;
        }
        if (this.jarEntry == null) {
            if (this.jarFile == null) {
                this.jarFile = this.getJarFile();
            }
            this.jarEntry = this.jarFile.getJarEntry(this.jarEntryName);
        }
        return this.jarEntry;
    }

    public URI getJarFileURI() {
        return this.jarFileURI;
    }

    public Attributes getMainAttributes() throws IOException {
        Manifest manifest = this.getManifest();
        Attributes attributes = null;
        if (manifest != null) {
            attributes = manifest.getMainAttributes();
        }
        return attributes;
    }

    public Manifest getManifest() throws IOException {
        if (this.jarFile == null) {
            this.jarFile = this.getJarFile();
        }
        return this.jarFile.getManifest();
    }

    static {
        ResourceConnection.addContentTypeToDefaultMap(JAR_CONTENT_TYPE, JAR_FILE_EXTENSION);
    }
}

