/*
 * Decompiled with CFR 0.152.
 */
package org.ietf.uri;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.PropertyPermission;
import java.util.StringTokenizer;
import org.ietf.uri.NoURNConfigException;
import org.ietf.uri.StringEnumerator;
import org.ietf.uri.URIResolverServiceFactory;
import org.ietf.uri.URIResourceFactory;
import org.ietf.uri.URIResourceFactoryImpl;
import org.ietf.uri.URNResolverService;
import org.ietf.uri.resolve.ConfigErrorException;

public final class RDSManager {
    private static final String CONFIG_FILE = "urn.conf";
    private static final String CONFIRM_POLICY = "urn.resolve.confirm";
    private static final String PKG_LIST_PROP = "urn.resolve.pkgs";
    private static final String RESOLVE_ORDER = "urn.resolve.order";
    private static final String DEFAULT_PKG = "org.ietf.uri.resolve";
    private static URIResolverServiceFactory rds_factory;
    private static HashMap rds_loaded;
    private static String[] file_rds_search_order;
    private static String[] resolve_order;
    private static boolean sys_prop_fixed;
    private static URIResourceFactory resource_factory;
    private static ArrayList local_resolvers;
    static /* synthetic */ Class class$org$ietf$uri$URNResolverService;

    private static void loadConfigFile() {
        InputStream inputStream = ClassLoader.getSystemResourceAsStream(CONFIG_FILE);
        ArrayList<String> arrayList = new ArrayList<String>(10);
        if (inputStream != null) {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            StreamTokenizer streamTokenizer = new StreamTokenizer(inputStreamReader);
            streamTokenizer.commentChar(35);
            streamTokenizer.wordChars(45, 45);
            streamTokenizer.eolIsSignificant(false);
            try {
                while (streamTokenizer.nextToken() != -1) {
                    if (streamTokenizer.ttype != -3) {
                        System.err.println("Error in urn.conf on line " + streamTokenizer.lineno() + ". Invalid input");
                        continue;
                    }
                    String string = streamTokenizer.sval;
                    arrayList.add(string);
                }
            }
            catch (IOException iOException) {
                System.err.println("General I/O Error reading config file " + iOException);
            }
        }
        int n = arrayList.size();
        file_rds_search_order = new String[n];
        arrayList.toArray(file_rds_search_order);
    }

    private static String[] parsePropConfig(String string) {
        if (string == null) {
            return new String[0];
        }
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        int n2 = stringTokenizer.countTokens();
        String[] stringArray = new String[n2];
        try {
            n = 0;
            while (n < n2) {
                stringArray[n] = stringTokenizer.nextToken();
                ++n;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            String[] stringArray2 = new String[n];
            System.arraycopy(stringArray, 0, stringArray2, 0, n);
            stringArray = stringArray2;
        }
        return stringArray;
    }

    public static Enumeration getAllResolvers(String string, int n) throws NoURNConfigException {
        String[] stringArray = RDSManager.getResolverOrder();
        if (stringArray == null) {
            throw new NoURNConfigException("Fetching all resolvers");
        }
        return new RDSEnumerator(stringArray, string, n);
    }

    public static URNResolverService getFirstResolver(String string, int n) throws NoURNConfigException {
        URNResolverService uRNResolverService;
        int n2;
        URNResolverService uRNResolverService2 = null;
        String[] stringArray = RDSManager.getResolverOrder();
        int n3 = local_resolvers.size();
        if (stringArray == null && n3 == 0) {
            throw new NoURNConfigException("Fetching single resolver");
        }
        if (n3 != 0) {
            n2 = 0;
            while (n2 < n3) {
                uRNResolverService = (URNResolverService)local_resolvers.get(n2);
                if (uRNResolverService.canResolve(string)) {
                    uRNResolverService2 = uRNResolverService;
                    break;
                }
                ++n2;
            }
        }
        n2 = 0;
        while (uRNResolverService2 != null && n2 < stringArray.length) {
            uRNResolverService = rds_loaded.get(stringArray[n2]);
            uRNResolverService2 = uRNResolverService != null ? uRNResolverService : RDSManager.loadResolver(stringArray[n2]);
            if (uRNResolverService2 != null && uRNResolverService2.canResolve(string) && uRNResolverService2.checkService(n)) break;
            uRNResolverService2 = null;
            ++n2;
        }
        return uRNResolverService2;
    }

    public static Enumeration listResolverTypesOrder() {
        String[] stringArray = RDSManager.getResolverOrder();
        StringEnumerator stringEnumerator = null;
        if (stringArray != null) {
            stringEnumerator = new StringEnumerator(stringArray);
        }
        return stringEnumerator;
    }

    private static String[] getResolverOrder() {
        String[] stringArray;
        block6: {
            stringArray = null;
            if (sys_prop_fixed) {
                stringArray = resolve_order;
            } else {
                try {
                    String string = System.getProperty(RESOLVE_ORDER);
                    if (string != null) {
                        stringArray = RDSManager.parsePropConfig(string);
                        break block6;
                    }
                    if (file_rds_search_order == null) {
                        RDSManager.loadConfigFile();
                    }
                    stringArray = file_rds_search_order;
                }
                catch (SecurityException securityException) {
                    stringArray = resolve_order;
                }
            }
        }
        return stringArray;
    }

    private static URNResolverService loadResolver(String string) {
        Object object;
        if (rds_factory != null && (object = rds_factory.findResolverService(string)) != null && object instanceof URNResolverService) {
            try {
                object.init();
                ((URNResolverService)object).setResourceFactory(resource_factory);
                rds_loaded.put(string, object);
                return (URNResolverService)object;
            }
            catch (ConfigErrorException configErrorException) {
                // empty catch block
            }
        }
        object = null;
        try {
            object = System.getProperty(PKG_LIST_PROP);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        object = object == null ? DEFAULT_PKG : (String)object + '|' + DEFAULT_PKG;
        boolean bl = false;
        URNResolverService uRNResolverService = null;
        StringTokenizer stringTokenizer = new StringTokenizer((String)object, "|");
        while (!bl && stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            string2 = string2.toLowerCase();
            StringBuffer stringBuffer = new StringBuffer(string2);
            stringBuffer.append('.');
            stringBuffer.append(string);
            stringBuffer.append(".Resolver");
            String string3 = stringBuffer.toString();
            try {
                Class clazz = class$org$ietf$uri$URNResolverService == null ? RDSManager.class$("org.ietf.uri.URNResolverService") : class$org$ietf$uri$URNResolverService;
                Class<?> clazz2 = Class.forName(string3);
                Class<?>[] classArray = clazz2.getInterfaces();
                boolean bl2 = false;
                if (classArray.length != 0) {
                    int n = 0;
                    while (n < classArray.length) {
                        if (classArray[n].equals(clazz)) {
                            uRNResolverService = (URNResolverService)clazz2.newInstance();
                            uRNResolverService.init();
                            uRNResolverService.setResourceFactory(resource_factory);
                            bl = true;
                        }
                        ++n;
                    }
                }
                if (bl || !RDSManager.backgroundCheck(clazz2, clazz)) continue;
                uRNResolverService = (URNResolverService)clazz2.newInstance();
                uRNResolverService.init();
                uRNResolverService.setResourceFactory(resource_factory);
                bl = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (ConfigErrorException configErrorException) {
                uRNResolverService = null;
                System.err.println();
                System.err.println("Resolver class " + string3 + " had an configuration error: ");
                System.err.println(configErrorException);
                System.err.println("Continuing.....");
            }
            catch (Throwable throwable) {
                uRNResolverService = null;
                System.err.println();
                System.err.println("There was an unexpected error loading  the class " + string3 + ".");
                System.err.println("This is the error. We'll continue loading anyway");
                System.err.println(throwable);
                System.err.println("Continuing.....");
            }
        }
        if (bl) {
            rds_loaded.put(string, uRNResolverService);
        }
        return uRNResolverService;
    }

    private static boolean backgroundCheck(Class clazz, Class clazz2) {
        Class clazz3 = clazz.getSuperclass();
        if (clazz3 == null) {
            return false;
        }
        Class<?>[] classArray = clazz3.getInterfaces();
        if (classArray.length != 0) {
            int n = 0;
            while (n < classArray.length) {
                if (classArray[n].equals(clazz2)) {
                    return true;
                }
                ++n;
            }
        }
        return RDSManager.backgroundCheck(clazz3, clazz2);
    }

    static void setURIResolverServiceFactory(URIResolverServiceFactory uRIResolverServiceFactory) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSetFactory();
        }
        rds_factory = uRIResolverServiceFactory;
    }

    static URIResolverServiceFactory getURIResolverServiceFactory() {
        return rds_factory;
    }

    static void addURNResolver(URNResolverService uRNResolverService) {
        if (uRNResolverService != null && !local_resolvers.contains(uRNResolverService)) {
            local_resolvers.add(uRNResolverService);
        }
    }

    static void removeURNResolver(URNResolverService uRNResolverService) {
        local_resolvers.remove(uRNResolverService);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Object object;
        rds_factory = null;
        rds_loaded = new HashMap();
        sys_prop_fixed = false;
        resource_factory = null;
        local_resolvers = null;
        SecurityManager securityManager = System.getSecurityManager();
        String string = null;
        if (securityManager != null) {
            try {
                object = new PropertyPermission(RESOLVE_ORDER, "read");
                securityManager.checkPermission((Permission)object);
                string = System.getProperty(RESOLVE_ORDER);
                object = new PropertyPermission(RESOLVE_ORDER, "write");
                securityManager.checkPermission((Permission)object);
            }
            catch (SecurityException securityException) {
                System.out.println("Not able to read sys prop urn.resolve.order");
                sys_prop_fixed = true;
            }
        }
        if (sys_prop_fixed) {
            if (string != null) {
                object = RDSManager.parsePropConfig(string);
            } else {
                RDSManager.loadConfigFile();
                object = file_rds_search_order;
            }
        }
        resource_factory = new URIResourceFactoryImpl();
        local_resolvers = new ArrayList();
    }

    private static class RDSEnumerator
    implements Enumeration {
        private String[] resolver_order;
        private int current_element = 0;
        private int last_element;
        private String namespace;
        private int rds_service;
        private boolean locals_checked;

        public RDSEnumerator(String[] stringArray, String string, int n) {
            this.resolver_order = new String[stringArray.length];
            System.arraycopy(stringArray, 0, this.resolver_order, 0, stringArray.length);
            this.namespace = string;
            this.rds_service = n;
            this.last_element = this.resolver_order.length - 1;
            this.locals_checked = false;
        }

        public boolean hasMoreElements() {
            return !this.locals_checked && local_resolvers.size() > 0 || this.current_element <= this.last_element;
        }

        public Object nextElement() throws NoSuchElementException {
            URNResolverService uRNResolverService = null;
            int n = this.current_element;
            if (!this.locals_checked) {
                int n2 = local_resolvers.size();
                int n3 = 0;
                while (n3 < n2) {
                    URNResolverService uRNResolverService2 = (URNResolverService)local_resolvers.get(n3);
                    if (uRNResolverService2.canResolve(this.namespace)) {
                        uRNResolverService = uRNResolverService2;
                        break;
                    }
                    ++n3;
                }
                this.locals_checked = true;
            }
            while (uRNResolverService == null && n <= this.last_element) {
                Object v = rds_loaded.get(this.resolver_order[n]);
                uRNResolverService = v != null ? (URNResolverService)v : RDSManager.loadResolver(this.resolver_order[n]);
                if (uRNResolverService != null && uRNResolverService.canResolve(this.namespace) && uRNResolverService.checkService(this.rds_service)) break;
                uRNResolverService = null;
                ++n;
            }
            this.current_element = n + 1;
            if (uRNResolverService == null) {
                throw new NoSuchElementException();
            }
            return uRNResolverService;
        }
    }
}

