/*
 * Decompiled with CFR 0.152.
 */
package org.ietf.uri;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import org.ietf.uri.ContentHandler;
import org.ietf.uri.ContentHandlerFactory;
import org.ietf.uri.DefaultFileMap;
import org.ietf.uri.FileNameMap;
import org.ietf.uri.JavaNetContentHandlerWrapper;
import org.ietf.uri.TwoWayHashMap;
import org.ietf.uri.URIResourceStream;
import org.ietf.uri.URIResourceStreamFactory;

final class ResourceManager {
    private static final String FILE_PKG_PROP = "uri.filename.handler.pkgs";
    private static final String FILE_DEFAULT_PKG = "org.ietf.uri.filemap";
    private static final String CONTENT_PKG_PROP = "uri.content.handler.pkgs";
    private static final String CONTENT_JAVA_PROP = "java.content.handler.pkgs";
    private static final String CONTENT_DEFAULT_PKG = "org.ietf.uri.content";
    private static final String CONTENT_JAVA_PKG = "sun.net.www.content";
    private static final String PROTOCOL_PKG_PROP = "uri.protocol.handler.pkgs";
    private static final String PROTOCOL_DEFAULT_PKG = "org.ietf.uri.protocol";
    private static FileNameMap default_map;
    private static FileNameMap filename_factory;
    private static HashMap filename_handlers;
    private static ContentHandlerFactory content_factory;
    private static HashMap content_handlers;
    private static HashMap class_handlers;
    private static URIResourceStreamFactory protocol_factory;
    private static HashMap protocol_handlers;

    ResourceManager() {
    }

    static void addContentTypeToDefaultMap(String string, String string2) {
        DefaultFileMap defaultFileMap = (DefaultFileMap)default_map;
        defaultFileMap.addContentType(string, string2);
    }

    static void setFileNameMap(FileNameMap fileNameMap) throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSetFactory();
        }
        filename_factory = fileNameMap;
    }

    static FileNameMap getFileNameMap() {
        return filename_factory;
    }

    static String getMIMEType(String string) {
        String string2 = null;
        if (filename_factory != null) {
            string2 = filename_factory.getContentTypeFor(string);
        }
        if (string2 != null) {
            return string2;
        }
        String string3 = null;
        try {
            string3 = System.getProperty(FILE_PKG_PROP);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        string3 = string3 == null ? FILE_DEFAULT_PKG : string3 + '|' + FILE_DEFAULT_PKG;
        boolean bl = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string3, "|");
        while (!bl && stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken().trim();
            FileNameMap fileNameMap = (FileNameMap)filename_handlers.get(string4 = string4.toLowerCase());
            if (fileNameMap != null && (string2 = fileNameMap.getContentTypeFor(string)) != null) {
                bl = true;
                continue;
            }
            StringBuffer stringBuffer = new StringBuffer(string4);
            stringBuffer.append(".FileNameMap");
            try {
                Class<?> clazz = Class.forName(stringBuffer.toString());
                if (clazz == null) continue;
                fileNameMap = (FileNameMap)clazz.newInstance();
                filename_handlers.put(string4, fileNameMap);
                string2 = fileNameMap.getContentTypeFor(string);
                if (string2 == null) continue;
                bl = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (string2 != null) {
            return string2;
        }
        string2 = default_map.getContentTypeFor(string);
        return string2;
    }

    static String getFileExtension(String string) {
        String string2 = null;
        if (filename_factory != null) {
            string2 = filename_factory.getFileExtension(string);
        }
        if (string2 != null) {
            return string2;
        }
        String string3 = null;
        try {
            string3 = System.getProperty(FILE_PKG_PROP);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        string3 = string3 == null ? FILE_DEFAULT_PKG : string3 + '|' + FILE_DEFAULT_PKG;
        boolean bl = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string3, "|");
        while (!bl && stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken().trim();
            FileNameMap fileNameMap = (FileNameMap)filename_handlers.get(string4 = string4.toLowerCase());
            if (fileNameMap != null && (string2 = fileNameMap.getFileExtension(string)) != null) {
                bl = true;
                continue;
            }
            StringBuffer stringBuffer = new StringBuffer(string4);
            stringBuffer.append(".FileNameMap");
            try {
                Class<?> clazz = Class.forName(stringBuffer.toString());
                if (clazz == null) continue;
                fileNameMap = (FileNameMap)clazz.newInstance();
                filename_handlers.put(string4, fileNameMap);
                string2 = fileNameMap.getFileExtension(string);
                if (string2 == null) continue;
                bl = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (string2 != null) {
            return string2;
        }
        string2 = default_map.getFileExtension(string);
        return string2;
    }

    private static FileNameMap parseJavaContentTypes(File file) {
        Object object;
        TwoWayHashMap twoWayHashMap = new TwoWayHashMap();
        try {
            object = new FileInputStream(file);
            BufferedInputStream bufferedInputStream = new BufferedInputStream((InputStream)object);
            Properties properties = new Properties();
            properties.load(bufferedInputStream);
            bufferedInputStream.close();
            ((FileInputStream)object).close();
            Enumeration<Object> enumeration = properties.keys();
            block4: while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                StringTokenizer stringTokenizer = new StringTokenizer((String)properties.get(string), ";");
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    if (string2.charAt(0) != 'f' && string2.charAt(0) != 'F' || !string2.startsWith("file_extension")) continue;
                    StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "=");
                    stringTokenizer2.nextToken();
                    while (stringTokenizer2.hasMoreTokens()) {
                        String string3 = stringTokenizer2.nextToken(",=");
                        string3 = string3.substring(1);
                        twoWayHashMap.put(string3, string);
                    }
                    continue block4;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        object = null;
        try {
            object = new DefaultFileMap(twoWayHashMap);
        }
        catch (NullPointerException nullPointerException) {}
        return object;
    }

    static void setContentHandlerFactory(ContentHandlerFactory contentHandlerFactory) throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSetFactory();
        }
        content_factory = contentHandlerFactory;
    }

    static ContentHandlerFactory getContentHandlerFactory() {
        return content_factory;
    }

    static ContentHandler getContentHandler(String string) {
        Serializable serializable;
        CharSequence charSequence;
        Object object;
        if (string == null) {
            return null;
        }
        ContentHandler contentHandler = null;
        if (content_handlers != null) {
            contentHandler = (ContentHandler)content_handlers.get(string);
        }
        if (contentHandler != null) {
            return contentHandler;
        }
        if (content_factory != null) {
            contentHandler = content_factory.createContentHandler(string);
        }
        if (contentHandler != null) {
            return contentHandler;
        }
        String string2 = null;
        try {
            string2 = System.getProperty(CONTENT_PKG_PROP);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        string2 = string2 == null ? CONTENT_DEFAULT_PKG : string2 + '|' + CONTENT_DEFAULT_PKG;
        boolean bl = false;
        char[] cArray = ResourceManager.typeToPackageName(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "|");
        while (!bl && stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken().trim();
            object = ((String)object).toLowerCase();
            charSequence = new StringBuffer((String)object);
            ((StringBuffer)charSequence).append('.');
            ((StringBuffer)charSequence).append(cArray);
            try {
                serializable = Class.forName(((StringBuffer)charSequence).toString());
                if (serializable == null) continue;
                contentHandler = (ContentHandler)((Class)serializable).newInstance();
                bl = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (contentHandler != null) {
            return contentHandler;
        }
        try {
            string2 = System.getProperty(CONTENT_JAVA_PROP);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        string2 = string2 == null ? CONTENT_JAVA_PKG : string2 + '|' + CONTENT_JAVA_PKG;
        object = null;
        cArray = ResourceManager.typeToPackageName(string);
        stringTokenizer = new StringTokenizer(string2, "|");
        while (!bl && stringTokenizer.hasMoreTokens()) {
            charSequence = stringTokenizer.nextToken().trim();
            charSequence = ((String)charSequence).toLowerCase();
            serializable = new StringBuffer((String)charSequence);
            ((StringBuffer)serializable).append('.');
            ((StringBuffer)serializable).append(cArray);
            try {
                Class<?> clazz = Class.forName(((StringBuffer)serializable).toString());
                if (clazz == null) continue;
                object = (java.net.ContentHandler)clazz.newInstance();
                contentHandler = new JavaNetContentHandlerWrapper((java.net.ContentHandler)object);
                bl = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return contentHandler;
    }

    static ContentHandler getContentHandler(String string, Class[] classArray) {
        ContentHandler contentHandler = null;
        contentHandler = classArray == null || classArray.length == 0 ? ResourceManager.getContentHandler(string) : ResourceManager.getContentHandlerByClass(string, classArray);
        return contentHandler;
    }

    private static ContentHandler getContentHandlerByClass(String string, Class[] classArray) {
        Serializable serializable;
        CharSequence charSequence;
        Object object;
        if (string == null) {
            return null;
        }
        ContentHandler contentHandler = null;
        if (content_handlers != null) {
            contentHandler = (ContentHandler)content_handlers.get(string);
        }
        if (contentHandler != null && ResourceManager.checkClassMatch(contentHandler, classArray)) {
            return contentHandler;
        }
        if (content_factory != null) {
            contentHandler = content_factory.createContentHandler(string);
        }
        if (contentHandler != null) {
            return contentHandler;
        }
        String string2 = null;
        try {
            string2 = System.getProperty(CONTENT_PKG_PROP);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        string2 = string2 == null ? CONTENT_DEFAULT_PKG : string2 + '|' + CONTENT_DEFAULT_PKG;
        boolean bl = false;
        char[] cArray = ResourceManager.typeToPackageName(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "|");
        while (!bl && stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken().trim();
            object = ((String)object).toLowerCase();
            charSequence = new StringBuffer((String)object);
            ((StringBuffer)charSequence).append('.');
            ((StringBuffer)charSequence).append(cArray);
            try {
                serializable = Class.forName(((StringBuffer)charSequence).toString());
                if (serializable == null) continue;
                contentHandler = (ContentHandler)((Class)serializable).newInstance();
                bl = ResourceManager.checkClassMatch(contentHandler, classArray);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (contentHandler != null) {
            return contentHandler;
        }
        try {
            string2 = System.getProperty(CONTENT_JAVA_PROP);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        string2 = string2 == null ? CONTENT_JAVA_PKG : string2 + '|' + CONTENT_JAVA_PKG;
        object = null;
        cArray = ResourceManager.typeToPackageName(string);
        stringTokenizer = new StringTokenizer(string2, "|");
        while (!bl && stringTokenizer.hasMoreTokens()) {
            charSequence = stringTokenizer.nextToken().trim();
            charSequence = ((String)charSequence).toLowerCase();
            serializable = new StringBuffer((String)charSequence);
            ((StringBuffer)serializable).append('.');
            ((StringBuffer)serializable).append(cArray);
            try {
                Class<?> clazz = Class.forName(((StringBuffer)serializable).toString());
                if (clazz == null) continue;
                object = (java.net.ContentHandler)clazz.newInstance();
                contentHandler = new JavaNetContentHandlerWrapper((java.net.ContentHandler)object);
                bl = ResourceManager.checkClassMatch(contentHandler, classArray);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return contentHandler;
    }

    private static boolean checkClassMatch(ContentHandler contentHandler, Class[] classArray) {
        Class[] classArray2 = contentHandler.getSupportedClasses();
        int n = classArray2 == null ? 0 : classArray2.length;
        boolean bl = false;
        int n2 = 0;
        while (n2 < n && !bl) {
            int n3 = 0;
            while (n3 < classArray.length && !bl) {
                bl = classArray[n3].equals(classArray2[n2]);
                ++n3;
            }
            ++n2;
        }
        return bl;
    }

    private static char[] typeToPackageName(String string) {
        string = string.toLowerCase();
        int n = string.length();
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == '/') {
                cArray[n2] = 46;
            } else if (!('A' <= c && c <= 'Z' || 'a' <= c && c <= 'z' || '0' <= c && c <= '9')) {
                cArray[n2] = 95;
            }
            ++n2;
        }
        return cArray;
    }

    static void setProtocolHandlerFactory(URIResourceStreamFactory uRIResourceStreamFactory) throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSetFactory();
        }
        protocol_factory = uRIResourceStreamFactory;
    }

    static URIResourceStreamFactory getProtocolHandlerFactory() {
        return protocol_factory;
    }

    static URIResourceStream getProtocolHandler(String string) {
        if (string == null) {
            return null;
        }
        URIResourceStream uRIResourceStream = null;
        if (protocol_handlers != null) {
            uRIResourceStream = (URIResourceStream)protocol_handlers.get(string);
        }
        if (uRIResourceStream != null) {
            return uRIResourceStream;
        }
        if (protocol_factory != null) {
            uRIResourceStream = protocol_factory.createURIResourceStream(string);
        }
        if (uRIResourceStream != null) {
            return uRIResourceStream;
        }
        String string2 = null;
        try {
            string2 = System.getProperty(PROTOCOL_PKG_PROP);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        string2 = string2 == null ? PROTOCOL_DEFAULT_PKG : string2 + '|' + PROTOCOL_DEFAULT_PKG;
        boolean bl = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "|");
        while (!bl && stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().trim();
            string3 = string3.toLowerCase();
            StringBuffer stringBuffer = new StringBuffer(string3);
            stringBuffer.append('.');
            stringBuffer.append(string);
            stringBuffer.append(".Handler");
            try {
                Class<?> clazz = Class.forName(stringBuffer.toString());
                if (clazz == null) continue;
                uRIResourceStream = (URIResourceStream)clazz.newInstance();
                bl = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return uRIResourceStream;
    }

    static {
        filename_factory = null;
        filename_handlers = new HashMap();
        content_factory = null;
        content_handlers = new HashMap();
        class_handlers = new HashMap();
        protocol_factory = null;
        protocol_handlers = new HashMap();
        File file = new File(System.getProperty("java.home") + File.separator + "lib" + File.separator + "content-types.properties");
        default_map = ResourceManager.parseJavaContentTypes(file);
        if (default_map instanceof DefaultFileMap) {
            DefaultFileMap defaultFileMap = (DefaultFileMap)default_map;
            defaultFileMap.addContentType("image/png", "png");
            defaultFileMap.addContentType("image/targa", "tga");
            defaultFileMap.addContentType("image/tiff", "tif");
            defaultFileMap.addContentType("image/tiff", "tiff");
        }
    }
}

