/*
 * Decompiled with CFR 0.152.
 */
package org.ietf.uri;

import java.net.MalformedURLException;
import java.util.HashMap;
import org.ietf.uri.MalformedURNException;
import org.ietf.uri.URI;
import org.ietf.uri.URIConstants;
import org.ietf.uri.URL;
import org.ietf.uri.URN;

public final class URIUtils
implements URIConstants {
    private static HashMap protocol_ports = new HashMap(30);

    public static URI createURI(String string) throws MalformedURLException, MalformedURNException {
        URI uRI = null;
        uRI = string.startsWith("urn:") ? new URN(string) : new URL(string);
        return uRI;
    }

    public static String getScheme(String string) {
        char[] cArray = string.toCharArray();
        return URIUtils.getScheme(cArray);
    }

    private static String getScheme(char[] cArray) {
        int n = cArray.length;
        String string = null;
        int n2 = URIUtils.getSchemeCharLength(cArray);
        if (n2 > 0 && n2 < n && cArray[n2] == ':') {
            string = new String(cArray, 0, n2).toLowerCase();
        }
        return string;
    }

    private static int getSchemeCharLength(char[] cArray) {
        int n = 0;
        int n2 = cArray.length;
        Object var3_3 = null;
        if (!(cArray[3] != ':' || cArray[0] != 'u' && cArray[0] != 'U' || cArray[1] != 'r' && cArray[1] != 'R' || cArray[2] != 'i' && cArray[2] != 'I' && cArray[2] != 'l' && cArray[2] != 'L')) {
            n = 4;
        }
        while (n < n2 && cArray[n] != ':' && cArray[n] != '/' && cArray[n] != '?' && cArray[n] != '#') {
            ++n;
        }
        return n;
    }

    public static int getDefaultPort(String string) {
        String string2 = string.trim().toLowerCase();
        int n = 0;
        Integer n2 = (Integer)protocol_ports.get(string2);
        if (n2 != null) {
            n = n2;
        }
        return n;
    }

    public static String[] getHostAndPortFromUrl(String string) throws MalformedURLException {
        int n = string.length();
        char[] cArray = string.toCharArray();
        String string2 = URIUtils.getScheme(cArray);
        if (protocol_ports.get(string2) == null) {
            return null;
        }
        int n2 = string2.length() + 1;
        String string3 = null;
        String string4 = null;
        boolean bl = false;
        while (n2 < n && cArray[n2] == '/') {
            ++n2;
        }
        int n3 = n2;
        while (n2 < n && cArray[n2] != '/' && cArray[n2] != '?' && cArray[n2] != '#') {
            ++n2;
        }
        int n4 = n2;
        int n5 = n3;
        int n6 = n4;
        n2 = n3;
        while (n2 < n4 && cArray[n2] != '@') {
            ++n2;
        }
        if (n2 != n4) {
            n5 = n2 + 1;
            bl = true;
        }
        n2 = bl ? n2 + 1 : n3;
        while (n2 < n4 && cArray[n2] != ':') {
            ++n2;
        }
        n6 = n2 <= n4 || cArray[n2] == ':' ? n2 - 1 : n2;
        int n7 = n2 + 1;
        int n8 = n4 == cArray.length || cArray[n4] == '/' || cArray[n4] == '?' || cArray[n4] == '#' ? n4 - 1 : n4;
        string3 = new String(cArray, n5, n6 - n5 + 1);
        string4 = n7 < n4 ? new String(cArray, n7, n8 - n7 + 1) : Integer.toString(URIUtils.getDefaultPort(string2));
        String[] stringArray = new String[]{string3, string4};
        return stringArray;
    }

    private static int getEndOfAuthorityChar(char[] cArray) {
        int n = cArray.length;
        int n2 = URIUtils.getSchemeCharLength(cArray) + 1;
        boolean bl = false;
        if (n2 != cArray.length && cArray[n2] == '/' && cArray[n2 + 1] == '/') {
            bl = true;
            n2 += 2;
        }
        if (bl) {
            while (n2 < n && cArray[n2] != '/' && cArray[n2] != '?' && cArray[n2] != '#') {
                ++n2;
            }
        }
        return n2;
    }

    public static String getPath(URI uRI) {
        String string = null;
        if (uRI instanceof URN) {
            char[] cArray = ((URN)uRI).getNSS().toCharArray();
            string = URIUtils.getPath(cArray);
        } else {
            try {
                string = URIUtils.getPathFromUrlString(uRI.toExternalForm());
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return string;
    }

    private static String getPath(char[] cArray) {
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n && cArray[n2] != '?' && cArray[n2] != '#') {
            ++n2;
        }
        String string = new String(cArray, 0, n2);
        return string;
    }

    public static String getPathFromUrlString(String string) throws MalformedURLException {
        char[] cArray = string.toCharArray();
        int n = URIUtils.getEndOfAuthorityChar(cArray);
        int n2 = cArray.length - n;
        char[] cArray2 = new char[n2];
        System.arraycopy(cArray, n, cArray2, 0, n2);
        return URIUtils.getPath(cArray2);
    }

    public static String getQuery(URI uRI) {
        String string = null;
        if (uRI instanceof URN) {
            char[] cArray = ((URN)uRI).getNSS().toCharArray();
            string = URIUtils.getQuery(cArray);
        } else {
            try {
                string = URIUtils.getQueryFromUrlString(uRI.toExternalForm());
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return string;
    }

    private static String getQuery(char[] cArray) {
        int n;
        int n2 = n = 0;
        int n3 = cArray.length;
        while (n2 < n3 && cArray[n2] != '?' && cArray[n2] != '#') {
            ++n2;
        }
        if (n2 == n3 || cArray[n2] == '#') {
            return null;
        }
        n = n2 + 1;
        while (n2 < n3 && cArray[n2] != '#') {
            ++n2;
        }
        String string = new String(cArray, n, n2 - n);
        return string;
    }

    public static String getQueryFromUrlString(String string) throws MalformedURLException {
        char[] cArray = string.toCharArray();
        int n = URIUtils.getEndOfAuthorityChar(cArray);
        int n2 = cArray.length - n;
        char[] cArray2 = new char[n2];
        System.arraycopy(cArray, n, cArray2, 0, n2);
        return URIUtils.getQuery(cArray2);
    }

    public static String[] stripFile(String string) {
        String[] stringArray = new String[3];
        int n = string.indexOf(63);
        if (n == -1) {
            int n2 = string.indexOf(35);
            if (n2 == -1) {
                stringArray[0] = string;
                stringArray[1] = null;
                stringArray[2] = null;
            } else {
                stringArray[0] = string.substring(0, n2);
                stringArray[1] = null;
                stringArray[2] = string.substring(n2 + 1);
            }
        } else {
            stringArray[0] = string.substring(0, n);
            int n3 = string.indexOf(35, n + 1);
            if (n3 == -1) {
                stringArray[1] = string.substring(n + 1);
                stringArray[2] = null;
            } else {
                stringArray[1] = string.substring(n + 1, n3);
                stringArray[2] = string.substring(n3 + 1);
            }
        }
        return stringArray;
    }

    static {
        protocol_ports.put("http", new Integer(80));
        protocol_ports.put("shttp", new Integer(80));
        protocol_ports.put("https", new Integer(443));
        protocol_ports.put("http-ng", new Integer(80));
        protocol_ports.put("coffee", new Integer(80));
        protocol_ports.put("ftp", new Integer(21));
        protocol_ports.put("telnet", new Integer(23));
        protocol_ports.put("nntp", new Integer(119));
        protocol_ports.put("news", new Integer(119));
        protocol_ports.put("snews", new Integer(563));
        protocol_ports.put("hnews", new Integer(80));
        protocol_ports.put("smtp", new Integer(25));
        protocol_ports.put("gopher", new Integer(70));
        protocol_ports.put("wais", new Integer(210));
        protocol_ports.put("whois", new Integer(43));
        protocol_ports.put("whois++", new Integer(63));
        protocol_ports.put("rwhois", new Integer(4321));
        protocol_ports.put("imap", new Integer(143));
        protocol_ports.put("pop", new Integer(110));
        protocol_ports.put("prospero", new Integer(1525));
        protocol_ports.put("irc", new Integer(194));
        protocol_ports.put("ldap", new Integer(389));
        protocol_ports.put("z39.50r", new Integer(210));
        protocol_ports.put("z39.50s", new Integer(210));
        protocol_ports.put("vemmi", new Integer(575));
        protocol_ports.put("videotex", new Integer(516));
        protocol_ports.put("nfs", new Integer(2049));
    }
}

