/*
 * Decompiled with CFR 0.152.
 */
package org.ietf.uri;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.ietf.uri.MalformedURNException;
import org.ietf.uri.RDSManager;
import org.ietf.uri.ResourceConnection;
import org.ietf.uri.URC;
import org.ietf.uri.URI;
import org.ietf.uri.URL;
import org.ietf.uri.URNResolverService;
import org.ietf.uri.UnsupportedServiceException;

public final class URN
extends URI {
    private final String urn;
    private String namespace;
    private String reference;

    public URN(String string) throws MalformedURNException {
        this(string, false);
    }

    public URN(String string, boolean bl) throws MalformedURNException {
        this.urn = string.trim();
        try {
            if (!this.urn.regionMatches(true, 0, "urn:", 0, 4)) {
                throw new MalformedURNException("URN does not start with \"urn:\".");
            }
            int n = this.urn.indexOf(58, 4);
            this.namespace = this.urn.substring(4, n);
            this.reference = this.urn.substring(n + 1);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new MalformedURNException("Incomplete URN specified.");
        }
    }

    public URN(String string, String string2) {
        if (string == null || string2 == null) {
            throw new NullPointerException("Null portion of URN supplied");
        }
        this.namespace = string;
        this.reference = string2;
        this.urn = "urn:" + string + ':' + string2;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getNSS() {
        return this.reference;
    }

    public URL getURL() throws UnsupportedServiceException, IOException {
        URNResolverService uRNResolverService = RDSManager.getFirstResolver(this.namespace, 1);
        if (uRNResolverService == null) {
            throw new UnsupportedServiceException("No URL resolution is available");
        }
        return (URL)uRNResolverService.decode(this, 1);
    }

    /*
     * Unable to fully structure code
     */
    public URL[] getURLList() throws UnsupportedServiceException, IOException {
        var1_1 = RDSManager.getAllResolvers(this.namespace, 2);
        var3_2 = var1_1 != null;
        var6_3 = new LinkedList<Object>();
        var7_4 = new HashMap<String, Object>();
        while (var1_1.hasMoreElements()) {
            try {
                var4_5 = (URNResolverService)var1_1.nextElement();
            }
            catch (NoSuchElementException var8_7) {
                break;
            }
            try {
                var5_6 = var4_5.decodeList(this, 2);
                if (var5_6 == null) continue;
                var8_8 = 0;
                while (var8_8 < var5_6.length) {
                    if (!var7_4.containsKey(var5_6[var8_8].toString())) {
                        var6_3.add(var5_6[var8_8]);
                        var7_4.put(var5_6[var8_8].toString(), var5_6[var8_8]);
                    }
                    ++var8_8;
                }
            }
            catch (UnsupportedServiceException var8_9) {
                // empty catch block
            }
        }
        var1_1 = RDSManager.getAllResolvers(this.namespace, 1);
        if (var1_1 != null || var3_2) ** GOTO lbl45
        throw new UnsupportedServiceException("URL lists are not available");
lbl-1000:
        // 1 sources

        {
            try {
                var4_5 = (URNResolverService)var1_1.nextElement();
            }
            catch (NoSuchElementException var9_12) {
                break;
            }
            try {
                var8_10 = var4_5.decode(this, 1);
                if (var8_10 == null || var7_4.containsKey(var8_10.toString())) continue;
                var6_3.add(var8_10);
                var7_4.put(var8_10.toString(), var8_10);
                continue;
            }
            catch (UnsupportedServiceException var9_11) {
                // empty catch block
            }
lbl45:
            // 4 sources

            ** while (var1_1.hasMoreElements())
        }
lbl46:
        // 2 sources

        var9_13 = new URL[var6_3.size()];
        var6_3.toArray(var9_13);
        return var9_13;
    }

    public URC getURC() throws UnsupportedServiceException, IOException {
        URNResolverService uRNResolverService = RDSManager.getFirstResolver(this.namespace, 5);
        if (uRNResolverService == null) {
            throw new UnsupportedServiceException("No URL resolution is available");
        }
        return (URC)uRNResolverService.decode(this, 5);
    }

    /*
     * Unable to fully structure code
     */
    public URC[] getURCList() throws UnsupportedServiceException, IOException {
        var1_1 = RDSManager.getAllResolvers(this.namespace, 6);
        var3_2 = var1_1 != null;
        var6_3 = new LinkedList<Object>();
        while (var1_1.hasMoreElements()) {
            try {
                var4_4 = (URNResolverService)var1_1.nextElement();
            }
            catch (NoSuchElementException var7_6) {
                break;
            }
            try {
                var5_5 = var4_4.decodeList(this, 6);
                if (var5_5 == null) continue;
                var7_7 = 0;
                while (var7_7 < var5_5.length) {
                    var6_3.add(var5_5[var7_7]);
                    ++var7_7;
                }
            }
            catch (UnsupportedServiceException var7_8) {
                // empty catch block
            }
        }
        var1_1 = RDSManager.getAllResolvers(this.namespace, 5);
        if (var1_1 != null || var3_2) ** GOTO lbl39
        throw new UnsupportedServiceException("URC lists are not available");
lbl-1000:
        // 1 sources

        {
            try {
                var4_4 = (URNResolverService)var1_1.nextElement();
            }
            catch (NoSuchElementException var8_11) {
                break;
            }
            try {
                var7_9 = var4_4.decode(this, 5);
                if (var7_9 == null || var6_3.contains(var7_9)) continue;
                var6_3.add(var7_9);
                continue;
            }
            catch (UnsupportedServiceException var8_10) {
                // empty catch block
            }
lbl39:
            // 4 sources

            ** while (var1_1.hasMoreElements())
        }
lbl40:
        // 2 sources

        var8_12 = new URC[var6_3.size()];
        var6_3.toArray(var8_12);
        return var8_12;
    }

    public URN getURN() throws UnsupportedServiceException, IOException {
        return this;
    }

    /*
     * Unable to fully structure code
     */
    public URN[] getURNList() throws UnsupportedServiceException, IOException {
        var1_1 = RDSManager.getAllResolvers(this.namespace, 8);
        var3_2 = var1_1 != null;
        var6_3 = new LinkedList<Object>();
        while (var1_1.hasMoreElements()) {
            try {
                var4_4 = (URNResolverService)var1_1.nextElement();
            }
            catch (NoSuchElementException var7_6) {
                break;
            }
            try {
                var5_5 = var4_4.decodeList(this, 8);
                if (var5_5 == null) continue;
                var7_7 = 0;
                while (var7_7 < var5_5.length) {
                    var6_3.add(var5_5[var7_7]);
                    ++var7_7;
                }
            }
            catch (UnsupportedServiceException var7_8) {
                // empty catch block
            }
        }
        var1_1 = RDSManager.getAllResolvers(this.namespace, 7);
        if (var1_1 != null || var3_2) ** GOTO lbl39
        throw new UnsupportedServiceException("URN lists are not available");
lbl-1000:
        // 1 sources

        {
            try {
                var4_4 = (URNResolverService)var1_1.nextElement();
            }
            catch (NoSuchElementException var8_11) {
                break;
            }
            try {
                var7_9 = var4_4.decode(this, 7);
                if (var7_9 == null) continue;
                var6_3.add(var7_9);
                continue;
            }
            catch (UnsupportedServiceException var8_10) {
                // empty catch block
            }
lbl39:
            // 4 sources

            ** while (var1_1.hasMoreElements())
        }
lbl40:
        // 2 sources

        var8_12 = new URN[var6_3.size()];
        var6_3.toArray(var8_12);
        return var8_12;
    }

    public ResourceConnection getResource() throws UnsupportedServiceException, IOException {
        URNResolverService uRNResolverService = RDSManager.getFirstResolver(this.namespace, 3);
        if (uRNResolverService == null) {
            throw new UnsupportedServiceException("No URL resolution is available");
        }
        return (ResourceConnection)uRNResolverService.decode(this, 3);
    }

    /*
     * Unable to fully structure code
     */
    public ResourceConnection[] getResourceList() throws UnsupportedServiceException, IOException {
        var1_1 = RDSManager.getAllResolvers(this.namespace, 4);
        var3_2 = var1_1 != null;
        var6_3 = new LinkedList<Object>();
        while (var1_1.hasMoreElements()) {
            try {
                var4_4 = (URNResolverService)var1_1.nextElement();
            }
            catch (NoSuchElementException var7_6) {
                break;
            }
            try {
                var5_5 = var4_4.decodeList(this, 4);
                if (var5_5 == null) continue;
                var7_7 = 0;
                while (var7_7 < var5_5.length) {
                    var6_3.add(var5_5[var7_7]);
                    ++var7_7;
                }
            }
            catch (UnsupportedServiceException var7_8) {
                // empty catch block
            }
        }
        var1_1 = RDSManager.getAllResolvers(this.namespace, 3);
        if (var1_1 != null || var3_2) ** GOTO lbl39
        throw new UnsupportedServiceException("Resource lists are not available");
lbl-1000:
        // 1 sources

        {
            try {
                var4_4 = (URNResolverService)var1_1.nextElement();
            }
            catch (NoSuchElementException var8_11) {
                break;
            }
            try {
                var7_9 = var4_4.decode(this, 3);
                if (var7_9 == null) continue;
                var6_3.add(var7_9);
                continue;
            }
            catch (UnsupportedServiceException var8_10) {
                // empty catch block
            }
lbl39:
            // 4 sources

            ** while (var1_1.hasMoreElements())
        }
lbl40:
        // 2 sources

        var8_12 = new ResourceConnection[var6_3.size()];
        var6_3.toArray(var8_12);
        return var8_12;
    }

    public String toExternalForm() {
        return this.urn;
    }

    public boolean equals(Object object) {
        if (object instanceof URI) {
            return this.equals((URI)object);
        }
        return false;
    }

    public boolean equals(URI uRI) {
        if (!(uRI instanceof URN)) {
            return false;
        }
        URN uRN = (URN)uRI;
        return uRN.namespace.equals(this.namespace) && uRN.reference.equals(this.reference);
    }

    public String toString() {
        return this.toExternalForm();
    }

    public static void addResolver(URNResolverService uRNResolverService) {
        RDSManager.addURNResolver(uRNResolverService);
    }

    public static void removeResolver(URNResolverService uRNResolverService) {
        RDSManager.removeURNResolver(uRNResolverService);
    }
}

