/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.ogl.browser;

import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Properties;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import org.web3d.browser.NavigationStateListener;
import org.web3d.vrml.renderer.ogl.browser.OGLVRMLUniverse;

public class BrowserNavigationToolbar
extends JPanel
implements ActionListener,
NavigationStateListener {
    static final String EXAMINE_BUTTON_PROPERTY = "EXAMINE.button";
    static final String FLY_BUTTON_PROPERTY = "FLY.button";
    static final String PAN_BUTTON_PROPERTY = "PAN.button";
    static final String TILT_BUTTON_PROPERTY = "TILT.button";
    static final String WALK_BUTTON_PROPERTY = "WALK.button";
    static final String DEFAULT_EXAMINE_BUTTON = "images/navigation/ButtonExamine.gif";
    static final String DEFAULT_FLY_BUTTON = "images/navigation/ButtonFly.gif";
    static final String DEFAULT_PAN_BUTTON = "images/navigation/ButtonPan.gif";
    static final String DEFAULT_TILT_BUTTON = "images/navigation/ButtonTilt.gif";
    static final String DEFAULT_WALK_BUTTON = "images/navigation/ButtonWalk.gif";
    static final Properties DEFAULT_SKIN = new Properties();
    private static final String PROPERTY_FILE = "xj3d-skin.properties";
    private String[] navigationModes;
    private ButtonGroup navStateGroup;
    private JToggleButton flyButton;
    private JToggleButton panButton;
    private JToggleButton tiltButton;
    private JToggleButton walkButton;
    private JToggleButton examineButton;
    private OGLVRMLUniverse universe;
    static /* synthetic */ Class class$org$web3d$ogl$browser$BrowserNavigationToolbar;

    public BrowserNavigationToolbar(OGLVRMLUniverse oGLVRMLUniverse) {
        this(oGLVRMLUniverse, true);
    }

    public BrowserNavigationToolbar(OGLVRMLUniverse oGLVRMLUniverse, boolean bl) {
        this(oGLVRMLUniverse, bl, null);
    }

    public BrowserNavigationToolbar(OGLVRMLUniverse oGLVRMLUniverse, Properties properties) {
        this(oGLVRMLUniverse, true, properties);
    }

    public BrowserNavigationToolbar(OGLVRMLUniverse oGLVRMLUniverse, boolean bl, Properties properties) {
        if (properties == null) {
            properties = DEFAULT_SKIN;
        }
        this.universe = oGLVRMLUniverse;
        if (bl) {
            this.setLayout(new GridLayout(1, 5));
        } else {
            this.setLayout(new GridLayout(5, 1));
        }
        this.navStateGroup = new ButtonGroup();
        Image image = this.loadImage(properties.getProperty(FLY_BUTTON_PROPERTY, DEFAULT_FLY_BUTTON));
        this.flyButton = image == null ? new JToggleButton("Fly", false) : new JToggleButton(new ImageIcon(image, "Fly"), false);
        this.flyButton.setMargin(new Insets(0, 0, 0, 0));
        this.flyButton.setToolTipText("Fly");
        this.flyButton.addActionListener(this);
        this.flyButton.setEnabled(false);
        this.navStateGroup.add(this.flyButton);
        this.add(this.flyButton);
        image = this.loadImage(properties.getProperty(PAN_BUTTON_PROPERTY, DEFAULT_PAN_BUTTON));
        this.panButton = image == null ? new JToggleButton("Pan", false) : new JToggleButton(new ImageIcon(image, "Pan"), false);
        this.panButton.setMargin(new Insets(0, 0, 0, 0));
        this.panButton.setToolTipText("Pan");
        this.panButton.addActionListener(this);
        this.panButton.setEnabled(false);
        this.navStateGroup.add(this.panButton);
        this.add(this.panButton);
        image = this.loadImage(properties.getProperty(TILT_BUTTON_PROPERTY, DEFAULT_TILT_BUTTON));
        this.tiltButton = image == null ? new JToggleButton("Tilt", false) : new JToggleButton(new ImageIcon(image, "Tilt"), false);
        this.tiltButton.setMargin(new Insets(0, 0, 0, 0));
        this.tiltButton.setToolTipText("Tilt");
        this.tiltButton.addActionListener(this);
        this.tiltButton.setEnabled(false);
        this.navStateGroup.add(this.tiltButton);
        this.add(this.tiltButton);
        image = this.loadImage(properties.getProperty(WALK_BUTTON_PROPERTY, DEFAULT_WALK_BUTTON));
        this.walkButton = image == null ? new JToggleButton("Walk", false) : new JToggleButton(new ImageIcon(image, "Walk"), false);
        this.walkButton.setMargin(new Insets(0, 0, 0, 0));
        this.walkButton.setToolTipText("Walk");
        this.walkButton.addActionListener(this);
        this.walkButton.setEnabled(false);
        this.navStateGroup.add(this.walkButton);
        this.add(this.walkButton);
        image = this.loadImage(properties.getProperty(EXAMINE_BUTTON_PROPERTY, DEFAULT_EXAMINE_BUTTON));
        this.examineButton = image == null ? new JToggleButton("Examine", false) : new JToggleButton(new ImageIcon(image, "Examine"), false);
        this.examineButton.setMargin(new Insets(0, 0, 0, 0));
        this.examineButton.setToolTipText("Examine");
        this.examineButton.addActionListener(this);
        this.examineButton.setEnabled(false);
        this.navStateGroup.add(this.examineButton);
        this.add(this.examineButton);
    }

    public void navigationStateChanged(int n) {
        if (this.navigationModes != null) {
            String string = this.navigationModes[n];
            if (string.equalsIgnoreCase("walk")) {
                this.walkButton.setSelected(true);
            } else if (string.equalsIgnoreCase("fly")) {
                this.flyButton.setSelected(true);
            } else if (string.equalsIgnoreCase("xj3d_tilt")) {
                this.tiltButton.setSelected(true);
            } else if (string.equalsIgnoreCase("xj3d_pan")) {
                this.panButton.setSelected(true);
            } else if (string.equalsIgnoreCase("examine")) {
                this.examineButton.setSelected(true);
            }
        }
    }

    public void navigationListChanged(String[] stringArray, int n) {
        if (this.navigationModes == null || this.navigationModes.length != n) {
            this.navigationModes = new String[n];
        }
        System.arraycopy(stringArray, 0, this.navigationModes, 0, n);
        boolean bl = false;
        this.walkButton.setEnabled(false);
        this.flyButton.setEnabled(false);
        this.examineButton.setEnabled(false);
        this.panButton.setEnabled(false);
        this.tiltButton.setEnabled(false);
        for (int i = 0; i < n; ++i) {
            if (stringArray[i].equals("ANY")) {
                bl = true;
                break;
            }
            String string = stringArray[i];
            if (string.equals("WALK")) {
                this.walkButton.setEnabled(true);
                continue;
            }
            if (string.equals("FLY")) {
                this.flyButton.setEnabled(true);
                continue;
            }
            if (string.equals("EXAMINE")) {
                this.examineButton.setEnabled(true);
                continue;
            }
            if (string.equals("xj3d_PAN")) {
                this.panButton.setEnabled(true);
                continue;
            }
            if (!string.equals("xj3d_TILT")) continue;
            this.tiltButton.setEnabled(true);
        }
        if (bl) {
            this.walkButton.setEnabled(true);
            this.flyButton.setEnabled(true);
            this.examineButton.setEnabled(true);
            this.panButton.setEnabled(true);
            this.tiltButton.setEnabled(true);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.flyButton) {
            this.universe.setNavigationMode("FLY");
        } else if (object == this.panButton) {
            this.universe.setNavigationMode("xj3d_PAN");
        } else if (object == this.tiltButton) {
            this.universe.setNavigationMode("xj3d_TILT");
        } else if (object == this.walkButton) {
            this.universe.setNavigationMode("WALK");
        } else if (object == this.examineButton) {
            this.universe.setNavigationMode("EXAMINE");
        }
    }

    Image loadImage(String string) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Image image = null;
        if (string == null) {
            return null;
        }
        URL uRL = ClassLoader.getSystemResource(string);
        if (uRL != null) {
            image = toolkit.createImage(uRL);
        }
        if (image == null && (uRL = (class$org$web3d$ogl$browser$BrowserNavigationToolbar == null ? (class$org$web3d$ogl$browser$BrowserNavigationToolbar = BrowserNavigationToolbar.class$("org.web3d.ogl.browser.BrowserNavigationToolbar")) : class$org$web3d$ogl$browser$BrowserNavigationToolbar).getClassLoader().getResource(string)) != null) {
            image = toolkit.createImage(uRL);
        }
        return image;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

