/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.ogl.browser;

import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import net.java.games.jogl.GLCapabilities;
import org.ietf.uri.ContentHandlerFactory;
import org.ietf.uri.FileNameMap;
import org.ietf.uri.URI;
import org.ietf.uri.URIResourceStreamFactory;
import org.j3d.aviatrix3d.DrawableSurface;
import org.j3d.aviatrix3d.surface.SimpleAWTSurface;
import org.j3d.ui.navigation.ViewpointData;
import org.j3d.ui.navigation.ViewpointSelectionListener;
import org.web3d.browser.AWTConsoleWindow;
import org.web3d.browser.BrowserComponent;
import org.web3d.browser.BrowserCore;
import org.web3d.net.content.VRMLContentHandlerFactory;
import org.web3d.net.content.VRMLFileNameMap;
import org.web3d.net.protocol.VRML97ResourceFactory;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.lang.VRMLNodeFactory;
import org.web3d.vrml.nodes.FrameStateManager;
import org.web3d.vrml.nodes.VRMLScene;
import org.web3d.vrml.nodes.loader.ScriptLoader;
import org.web3d.vrml.nodes.loader.WorldLoader;
import org.web3d.vrml.nodes.loader.WorldLoaderManager;
import org.web3d.vrml.nodes.runtime.ExternalView;
import org.web3d.vrml.nodes.runtime.RouteManager;
import org.web3d.vrml.nodes.runtime.ScriptManager;
import org.web3d.vrml.renderer.DefaultNodeFactory;
import org.web3d.vrml.renderer.ogl.browser.OGLBrowserCanvas;
import org.web3d.vrml.renderer.ogl.browser.OGLVRMLUniverse;
import org.web3d.vrml.sav.InputSource;
import org.web3d.vrml.scripting.ScriptEngine;
import org.web3d.vrml.scripting.browser.VRML97CommonBrowser;
import org.web3d.vrml.scripting.ecmascript.JavascriptScriptEngine;
import org.web3d.vrml.scripting.external.buffer.ExternalEventQueue;
import org.web3d.vrml.scripting.external.eai.EAIBrowser;
import org.web3d.vrml.scripting.jsai.VRML97ScriptEngine;
import vrml.eai.Browser;
import vrml.eai.VrmlComponent;

public class VRMLBrowserAWTPanel
extends Panel
implements VrmlComponent,
BrowserComponent,
ViewpointSelectionListener,
ComponentListener,
WindowListener {
    static final int PAUSED_FPS = 1;
    private EAIBrowser eaiBrowser;
    private Canvas glCanvas;
    private OGLBrowserCanvas mainCanvas;
    private OGLVRMLUniverse universe;
    private WorldLoaderManager worldLoader;
    private Label descriptionLabel;
    private Label urlLabel;
    private AWTConsoleWindow console;
    private int frameCycleTime;

    public VRMLBrowserAWTPanel(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        this(false, bl, bl2, bl3, bl4, bl5, bl6);
    }

    public VRMLBrowserAWTPanel(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7) {
        super(new BorderLayout());
        this.setSize(800, 600);
        GLCapabilities gLCapabilities = new GLCapabilities();
        gLCapabilities.setDoubleBuffered(true);
        gLCapabilities.setHardwareAccelerated(true);
        SimpleAWTSurface simpleAWTSurface = new SimpleAWTSurface(gLCapabilities);
        this.mainCanvas = new OGLBrowserCanvas((DrawableSurface)simpleAWTSurface, bl);
        this.mainCanvas.initialize();
        this.glCanvas = (Canvas)simpleAWTSurface.getSurfaceObject();
        this.glCanvas.addComponentListener(this);
        this.descriptionLabel = new Label();
        this.urlLabel = new Label();
        this.add((Component)this.glCanvas, "Center");
        if (bl2) {
            this.add((Component)this.descriptionLabel, "South");
            this.add((Component)this.urlLabel, "North");
        }
        RouteManager routeManager = this.mainCanvas.getRouteManager();
        this.universe = this.mainCanvas.getUniverse();
        FrameStateManager frameStateManager = this.mainCanvas.getFrameStateManager();
        this.worldLoader = this.mainCanvas.getWorldLoaderManager();
        ScriptManager scriptManager = this.mainCanvas.getScriptManager();
        ScriptLoader scriptLoader = scriptManager.getScriptLoader();
        this.console = new AWTConsoleWindow();
        VRML97ScriptEngine vRML97ScriptEngine = new VRML97ScriptEngine((BrowserCore)this.universe, routeManager, frameStateManager, this.worldLoader);
        vRML97ScriptEngine.setErrorReporter((ErrorReporter)this.console);
        JavascriptScriptEngine javascriptScriptEngine = new JavascriptScriptEngine((BrowserCore)this.universe, routeManager, frameStateManager, this.worldLoader);
        javascriptScriptEngine.setErrorReporter((ErrorReporter)this.console);
        scriptLoader.registerScriptingEngine((ScriptEngine)vRML97ScriptEngine);
        scriptLoader.registerScriptingEngine((ScriptEngine)javascriptScriptEngine);
        this.setupProperties(this.universe, this.worldLoader);
        VRMLNodeFactory vRMLNodeFactory = DefaultNodeFactory.newInstance((String)this.universe.getIDString());
        VRML97CommonBrowser vRML97CommonBrowser = new VRML97CommonBrowser((BrowserCore)this.universe, routeManager, frameStateManager, this.worldLoader, vRMLNodeFactory);
        vRML97CommonBrowser.setErrorReporter((ErrorReporter)this.console);
        ExternalEventQueue externalEventQueue = new ExternalEventQueue((ErrorReporter)this.console);
        this.mainCanvas.getEventModelEvaluator().addExternalView((ExternalView)externalEventQueue);
        this.eaiBrowser = new EAIBrowser((BrowserCore)this.universe, vRML97CommonBrowser, externalEventQueue, (ErrorReporter)this.console);
        this.mainCanvas.setErrorReporter((ErrorReporter)this.console);
        if (bl7) {
            this.console.setVisible(true);
        }
    }

    public Browser getBrowser() {
        return this.eaiBrowser;
    }

    public int supportedSpecificationVersion() {
        return 3;
    }

    public Canvas getCanvas() {
        return this.glCanvas;
    }

    public int getRendererType() {
        return this.universe.getRendererType();
    }

    public BrowserCore getBrowserCore() {
        return this.universe;
    }

    public ErrorReporter getErrorReporter() {
        return this.console;
    }

    public void setMinimumFrameInterval(int n) {
        this.mainCanvas.setMinimumFrameInterval(n);
        this.frameCycleTime = n;
    }

    public void start() {
        this.mainCanvas.setEnabled(true);
    }

    public void stop() {
        this.mainCanvas.setEnabled(false);
    }

    public void destroy() {
        this.mainCanvas.setEnabled(false);
        this.mainCanvas.browserShutdown();
    }

    public void componentHidden(ComponentEvent componentEvent) {
        this.mainCanvas.setMinimumFrameInterval(1000);
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        Container container;
        Dimension dimension = this.glCanvas.getSize();
        int n = (int)dimension.getWidth();
        int n2 = (int)dimension.getHeight();
        if (n > 0 && n2 > 0) {
            this.universe.setViewport(new Rectangle(0, 0, n, n2));
        }
        Container container2 = this.getParent();
        while ((container = container2.getParent()) != null) {
            container2 = container;
        }
        ((Window)container2).addWindowListener(this);
    }

    public void componentShown(ComponentEvent componentEvent) {
        if (this.frameCycleTime < 0) {
            this.mainCanvas.setMinimumFrameInterval(0);
        } else {
            this.mainCanvas.setMinimumFrameInterval(this.frameCycleTime);
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
        if (this.frameCycleTime < 0) {
            this.mainCanvas.setMinimumFrameInterval(0);
        } else {
            this.mainCanvas.setMinimumFrameInterval(this.frameCycleTime);
        }
    }

    public void windowIconified(WindowEvent windowEvent) {
        this.mainCanvas.setMinimumFrameInterval(1000);
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void viewpointSelected(ViewpointData viewpointData) {
    }

    public VRMLScene getScene() {
        return this.universe.getScene();
    }

    public OGLVRMLUniverse getUniverse() {
        return this.universe;
    }

    public void loadURL(String string) throws IOException {
        WorldLoader worldLoader = this.worldLoader.fetchLoader();
        InputSource inputSource = new InputSource(string);
        VRMLScene vRMLScene = worldLoader.loadNow((BrowserCore)this.universe, inputSource, false, 2, 0);
        this.universe.setScene(vRMLScene, null);
    }

    private void setupProperties(final BrowserCore browserCore, final WorldLoaderManager worldLoaderManager) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    FileNameMap fileNameMap;
                    ContentHandlerFactory contentHandlerFactory;
                    URIResourceStreamFactory uRIResourceStreamFactory;
                    String string = System.getProperty("uri.content.handler.pkgs", "");
                    if (string.indexOf("vlc.net.content") == -1) {
                        System.setProperty("uri.content.handler.pkgs", "vlc.net.content");
                    }
                    if ((string = System.getProperty("uri.protocol.handler.pkgs", "")).indexOf("vlc.net.protocol") == -1) {
                        System.setProperty("uri.protocol.handler.pkgs", "vlc.net.protocol");
                    }
                    if (!((uRIResourceStreamFactory = URI.getURIResourceStreamFactory()) instanceof VRML97ResourceFactory)) {
                        uRIResourceStreamFactory = new VRML97ResourceFactory(uRIResourceStreamFactory);
                        URI.setURIResourceStreamFactory(uRIResourceStreamFactory);
                    }
                    if (!((contentHandlerFactory = URI.getContentHandlerFactory()) instanceof VRMLContentHandlerFactory)) {
                        contentHandlerFactory = new VRMLContentHandlerFactory(browserCore, worldLoaderManager);
                        URI.setContentHandlerFactory(contentHandlerFactory);
                    }
                    if (!((fileNameMap = URI.getFileNameMap()) instanceof VRMLFileNameMap)) {
                        fileNameMap = new VRMLFileNameMap(fileNameMap);
                        URI.setFileNameMap(fileNameMap);
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            System.out.println("Error setting Properties in BrowserJPanel");
        }
    }
}

