/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.ogl.browser;

import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import net.java.games.jogl.GL;
import net.java.games.jogl.GLCapabilities;
import net.java.games.jogl.GLDrawable;
import org.ietf.uri.ContentHandlerFactory;
import org.ietf.uri.FileNameMap;
import org.ietf.uri.ResourceConnection;
import org.ietf.uri.URI;
import org.ietf.uri.URIResourceStreamFactory;
import org.ietf.uri.URL;
import org.ietf.uri.event.ProgressListener;
import org.j3d.aviatrix3d.DrawableSurface;
import org.j3d.aviatrix3d.RenderEffectsProcessor;
import org.j3d.aviatrix3d.Scene;
import org.j3d.aviatrix3d.surface.ElumensAWTSurface;
import org.j3d.aviatrix3d.surface.SimpleAWTSurface;
import org.web3d.browser.BrowserComponent;
import org.web3d.browser.BrowserCore;
import org.web3d.browser.BrowserCoreListener;
import org.web3d.browser.DownloadProgressListener;
import org.web3d.browser.NavigationStateListener;
import org.web3d.browser.SensorStatusListener;
import org.web3d.browser.SwingConsoleWindow;
import org.web3d.browser.ViewpointStatusListener;
import org.web3d.browser.ViewpointToolbar;
import org.web3d.net.content.VRMLContentHandlerFactory;
import org.web3d.net.content.VRMLFileNameMap;
import org.web3d.net.protocol.X3DResourceFactory;
import org.web3d.ogl.browser.BrowserNavigationToolbar;
import org.web3d.ogl.browser.BrowserPanelUtilities;
import org.web3d.ogl.browser.SampleChooser;
import org.web3d.util.ErrorReporter;
import org.web3d.util.FileHandler;
import org.web3d.util.LoadURLAction;
import org.web3d.util.OpenAction;
import org.web3d.util.ReloadAction;
import org.web3d.vrml.nodes.FrameStateManager;
import org.web3d.vrml.nodes.VRMLClock;
import org.web3d.vrml.nodes.VRMLScene;
import org.web3d.vrml.nodes.loader.ScriptLoader;
import org.web3d.vrml.nodes.loader.WorldLoader;
import org.web3d.vrml.nodes.loader.WorldLoaderManager;
import org.web3d.vrml.nodes.runtime.ExternalView;
import org.web3d.vrml.nodes.runtime.RouteManager;
import org.web3d.vrml.nodes.runtime.ScriptManager;
import org.web3d.vrml.nodes.runtime.ViewpointManager;
import org.web3d.vrml.renderer.common.browser.CursorManager;
import org.web3d.vrml.renderer.ogl.browser.OGLBrowserCanvas;
import org.web3d.vrml.renderer.ogl.browser.OGLVRMLUniverse;
import org.web3d.vrml.sav.InputSource;
import org.web3d.vrml.sav.VRMLParseException;
import org.web3d.vrml.scripting.ScriptEngine;
import org.web3d.vrml.scripting.browser.X3DCommonBrowser;
import org.web3d.vrml.scripting.ecmascript.ECMAScriptEngine;
import org.web3d.vrml.scripting.external.buffer.ExternalEventQueue;
import org.web3d.vrml.scripting.external.sai.SAIBrowser;
import org.web3d.vrml.scripting.sai.JavaSAIScriptEngine;
import org.web3d.x3d.sai.ExternalBrowser;
import org.web3d.x3d.sai.X3DComponent;

public class X3DBrowserJPanel
extends JPanel
implements X3DComponent,
BrowserComponent,
BrowserCoreListener,
ComponentListener,
WindowListener,
FileHandler,
Runnable,
KeyListener,
RenderEffectsProcessor {
    private static final String BROWSER_BUTTON_PROPERTY = "CONSOLE.button";
    private static final String DEFAULT_BROWSER_BUTTON = "images/navigation/ButtonConsole.gif";
    private static final String BROWSER_OPEN_PROPERTY = "OPEN.button";
    private static final String DEFAULT_OPEN_BUTTON = "images/locationbar/openIcon32x32.gif";
    private static final String BROWSER_RELOAD_PROPERTY = "RELOAD.button";
    private static final String DEFAULT_RELOAD_BUTTON = "images/locationbar/reloadIcon32x32.gif";
    private static final int PAUSED_FPS = 1;
    private Canvas glCanvas;
    private OGLBrowserCanvas mainCanvas;
    private WorldLoaderManager worldLoader;
    private ViewpointToolbar vpToolbar;
    private BrowserNavigationToolbar navToolbar;
    private HashMap viewpointDefMap;
    private JTextField urlTextField;
    private JButton locationGoButton;
    private JButton openButton;
    private JButton reloadButton;
    private JLabel statusLabel;
    private SAIBrowser saiBrowser;
    private SwingConsoleWindow console;
    private VRMLClock clock;
    private OGLVRMLUniverse universe;
    private int frameMillis = -1;
    private float lastFPS;
    private JLabel fpsLabel;
    private boolean wireframe = false;
    private int polygonMode;
    private boolean showFPS;
    private String contentDirectory;
    private boolean elumensMode = false;
    private GLCapabilities caps;
    private int numSamples = 1;
    private boolean maxChooserStarted = false;
    private SampleChooser sampleChooser;
    private boolean firstFocused = false;

    public X3DBrowserJPanel(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, boolean bl10, boolean bl11, String string, String string2, String string3, String string4) {
        this(false, bl, bl2, bl3, bl4, bl5, bl6, bl7, bl8, bl9, bl10, string, bl11, string2, string3, string4, null);
    }

    public X3DBrowserJPanel(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, boolean bl10, boolean bl11, String string, boolean bl12, String string2, String string3, String string4) {
        this(bl, bl2, bl3, bl4, bl5, bl6, bl7, bl8, bl9, bl10, bl11, string, bl12, string2, string3, string4, null);
    }

    public X3DBrowserJPanel(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, boolean bl10, boolean bl11, String string, boolean bl12, String string2, String string3, String string4, Properties properties) {
        super(new BorderLayout());
        Image image;
        JPanel jPanel;
        Object object;
        Object object2;
        JComponent jComponent;
        this.showFPS = bl11;
        this.contentDirectory = string;
        this.setSize(800, 600);
        this.caps = new GLCapabilities();
        this.caps.setDoubleBuffered(true);
        this.caps.setHardwareAccelerated(true);
        if (string4.equals("medium")) {
            System.setProperty("org.web3d.vrml.renderer.common.nodes.shape.useMipMaps", "true");
            System.setProperty("org.web3d.vrml.renderer.common.nodes.shape.anisotropicDegree", "2");
        } else if (string4.equals("high")) {
            System.setProperty("org.web3d.vrml.renderer.common.nodes.shape.useMipMaps", "true");
            System.setProperty("org.web3d.vrml.renderer.common.nodes.shape.anisotropicDegree", "16");
        }
        if (bl12) {
            this.caps.setSampleBuffers(true);
            if (string2.equals("low")) {
                this.numSamples = 2;
                this.caps.setNumSamples(this.numSamples);
            } else if (string2.equals("medium")) {
                System.out.println("Trying for 4 samples of antialiasing.");
                this.numSamples = 4;
                this.caps.setNumSamples(this.numSamples);
            } else if (string2.equals("high")) {
                System.out.println("Trying for 8 samples of antialiasing.");
                this.numSamples = 8;
                this.caps.setNumSamples(this.numSamples);
            }
        }
        this.console = new SwingConsoleWindow();
        this.console.messageReport("Initializing OpenGL X3D browser.\n");
        SimpleAWTSurface simpleAWTSurface = new SimpleAWTSurface(this.caps);
        this.mainCanvas = new OGLBrowserCanvas((DrawableSurface)simpleAWTSurface, bl);
        this.mainCanvas.initialize();
        this.glCanvas = (Canvas)simpleAWTSurface.getSurfaceObject();
        this.glCanvas.addComponentListener(this);
        this.glCanvas.addKeyListener(this);
        CursorManager cursorManager = new CursorManager(this.glCanvas);
        cursorManager.setSensorStatusListener((SensorStatusListener)this.mainCanvas);
        RouteManager routeManager = this.mainCanvas.getRouteManager();
        ViewpointManager viewpointManager = this.mainCanvas.getViewpointManager();
        this.universe = this.mainCanvas.getUniverse();
        this.universe.addSensorStatusListener((SensorStatusListener)cursorManager);
        this.universe.addNavigationStateListener((NavigationStateListener)cursorManager);
        this.universe.addNavigationStateListener((NavigationStateListener)this.vpToolbar);
        FrameStateManager frameStateManager = this.mainCanvas.getFrameStateManager();
        this.worldLoader = this.mainCanvas.getWorldLoaderManager();
        ScriptManager scriptManager = this.mainCanvas.getScriptManager();
        ScriptLoader scriptLoader = scriptManager.getScriptLoader();
        JavaSAIScriptEngine javaSAIScriptEngine = new JavaSAIScriptEngine((BrowserCore)this.universe, viewpointManager, routeManager, frameStateManager, this.worldLoader);
        javaSAIScriptEngine.setErrorReporter((ErrorReporter)this.console);
        ECMAScriptEngine eCMAScriptEngine = new ECMAScriptEngine((BrowserCore)this.universe, viewpointManager, routeManager, frameStateManager, this.worldLoader);
        eCMAScriptEngine.setErrorReporter((ErrorReporter)this.console);
        scriptLoader.registerScriptingEngine((ScriptEngine)javaSAIScriptEngine);
        scriptLoader.registerScriptingEngine((ScriptEngine)eCMAScriptEngine);
        this.setupProperties(this.universe, this.worldLoader);
        X3DCommonBrowser x3DCommonBrowser = new X3DCommonBrowser((BrowserCore)this.universe, viewpointManager, routeManager, frameStateManager, this.worldLoader);
        x3DCommonBrowser.setErrorReporter((ErrorReporter)this.console);
        ExternalEventQueue externalEventQueue = new ExternalEventQueue((ErrorReporter)this.console);
        this.mainCanvas.getEventModelEvaluator().addExternalView((ExternalView)externalEventQueue);
        this.saiBrowser = new SAIBrowser((BrowserCore)this.universe, x3DCommonBrowser, routeManager, frameStateManager, externalEventQueue, (ErrorReporter)this.console);
        this.universe.addCoreListener(this);
        this.clock = this.universe.getVRMLClock();
        this.add((Component)this.glCanvas, "Center");
        this.urlTextField = new JTextField();
        this.statusLabel = new JLabel();
        this.fpsLabel = new JLabel();
        if (bl4) {
            jComponent = new JLabel(" Location: ");
            this.locationGoButton = new JButton(" Go! ");
            this.locationGoButton.setEnabled(!bl6);
            this.urlTextField.setEditable(!bl6);
            if (!bl6) {
                object2 = new LoadURLAction((FileHandler)this, this.urlTextField);
                this.locationGoButton.addActionListener((ActionListener)object2);
                this.urlTextField.addActionListener((ActionListener)object2);
            }
            object2 = new JPanel(new BorderLayout());
            ((Container)object2).add((Component)jComponent, "West");
            ((Container)object2).add((Component)this.locationGoButton, "East");
            ((Container)object2).add((Component)this.urlTextField, "Center");
            if (bl8 || bl9) {
                OpenAction openAction;
                object = new JPanel(new BorderLayout());
                jPanel = new JPanel(new BorderLayout());
                if (bl8) {
                    image = BrowserPanelUtilities.loadImage(properties.getProperty(BROWSER_OPEN_PROPERTY, DEFAULT_OPEN_BUTTON));
                    this.openButton = image == null ? new JButton("Open") : new JButton(new ImageIcon(image, "Open"));
                    this.openButton.setToolTipText("Open File");
                    this.openButton.setMargin(new Insets(0, 0, 0, 0));
                    openAction = new OpenAction((Component)this, (FileHandler)this, string);
                    this.openButton.addActionListener((ActionListener)openAction);
                    ((Container)object).add((Component)this.openButton, "West");
                }
                if (bl9) {
                    image = BrowserPanelUtilities.loadImage(properties.getProperty(BROWSER_RELOAD_PROPERTY, DEFAULT_RELOAD_BUTTON));
                    this.reloadButton = image == null ? new JButton("Reload") : new JButton(new ImageIcon(image, "Reload"));
                    this.reloadButton.setToolTipText("Reload File");
                    this.reloadButton.setMargin(new Insets(0, 0, 0, 0));
                    openAction = new ReloadAction((Component)this, (FileHandler)this, (JTextComponent)this.urlTextField);
                    this.reloadButton.addActionListener((ActionListener)openAction);
                    ((Container)object).add((Component)this.reloadButton, "East");
                }
                jPanel.add((Component)object, "West");
                jPanel.add((Component)object2, "Center");
                if (bl5) {
                    this.add((Component)jPanel, "North");
                } else {
                    this.add((Component)jPanel, "South");
                }
            } else if (bl5) {
                this.add((Component)object2, "North");
            } else {
                this.add((Component)object2, "South");
            }
        }
        if (bl2) {
            jComponent = new JPanel(new BorderLayout());
            if (bl3) {
                this.add((Component)jComponent, "North");
            } else {
                this.add((Component)jComponent, "South");
            }
            this.navToolbar = new BrowserNavigationToolbar(this.universe, properties);
            cursorManager.setNavigationStateListener((NavigationStateListener)this.navToolbar);
            jComponent.add((Component)this.navToolbar, "West");
            this.vpToolbar = new ViewpointToolbar((BrowserCore)this.universe, properties);
            this.vpToolbar.setEnabled(false);
            this.vpToolbar.setClock(this.clock);
            this.universe.addViewpointStatusListener((ViewpointStatusListener)this.vpToolbar);
            jComponent.add((Component)this.vpToolbar, "Center");
            this.universe.addNavigationStateListener((NavigationStateListener)cursorManager);
            this.universe.addNavigationStateListener((NavigationStateListener)this.vpToolbar);
            object2 = null;
            object = BrowserPanelUtilities.loadImage(properties.getProperty(BROWSER_BUTTON_PROPERTY, DEFAULT_BROWSER_BUTTON));
            object2 = object == null ? new JButton("Console") : new JButton(new ImageIcon((Image)object, "Console"));
            ((JComponent)object2).setToolTipText("Show browser console");
            ((AbstractButton)object2).setMargin(new Insets(0, 0, 0, 0));
            ((AbstractButton)object2).addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    X3DBrowserJPanel.this.console.setVisible(true);
                }
            });
            jComponent.add((Component)object2, "East");
            if (bl11 || bl10) {
                jPanel = new JPanel(new BorderLayout());
                jComponent.add((Component)jPanel, "South");
                if (bl10) {
                    jPanel.add((Component)this.statusLabel, "West");
                    image = new DownloadProgressListener(this.statusLabel, (ErrorReporter)this.console);
                    ResourceConnection.addGlobalProgressListener((ProgressListener)((Object)image));
                }
                if (bl11) {
                    jPanel.add((Component)this.fpsLabel, "East");
                }
            }
        }
        this.mainCanvas.setErrorReporter((ErrorReporter)this.console);
        if (bl7) {
            this.console.setVisible(true);
        }
        if (bl11) {
            new Thread(this).start();
        }
        this.getMaximumNumSamples();
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 65: {
                if ((keyEvent.getModifiers() & 8) == 0) break;
                this.numSamples *= 2;
                int n = this.getMaximumNumSamples();
                while (n < 0) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    n = this.getMaximumNumSamples();
                }
                if (this.numSamples > n) {
                    this.numSamples = 1;
                }
                this.statusLabel.setText("Antialiasing samples: " + this.numSamples + " out of max: " + n);
                this.caps.setSampleBuffers(true);
                this.caps.setNumSamples(this.numSamples);
                this.resetSurface();
                break;
            }
            case 34: {
                this.vpToolbar.nextViewpoint();
                break;
            }
            case 33: {
                this.vpToolbar.previousViewpoint();
                break;
            }
            case 36: {
                this.vpToolbar.firstViewpoint();
                break;
            }
            case 35: {
                this.vpToolbar.lastViewpoint();
                break;
            }
            case 70: {
                if ((keyEvent.getModifiers() & 2) == 0) break;
                this.universe.setNavigationMode("FLY");
                break;
            }
            case 87: {
                if ((keyEvent.getModifiers() & 2) != 0) {
                    this.universe.setNavigationMode("WALK");
                    break;
                }
                if ((keyEvent.getModifiers() & 8) == 0) break;
                boolean bl = this.wireframe = !this.wireframe;
                if (this.wireframe) {
                    this.polygonMode = 6913;
                    this.statusLabel.setText("Wireframe mode enabled");
                    Scene scene = this.universe.getRendererScene();
                    scene.setRenderEffectsProcessor((RenderEffectsProcessor)this);
                    break;
                }
                this.statusLabel.setText("Wireframe mode disabled");
                this.polygonMode = 6914;
                break;
            }
            case 69: {
                if ((keyEvent.getModifiers() & 2) == 0) break;
                this.universe.setNavigationMode("EXAMINE");
                break;
            }
            case 90: {
                if ((keyEvent.getModifiers() & 8) == 0) break;
                this.elumensMode = !this.elumensMode;
                this.resetSurface();
            }
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void preDraw(GLDrawable gLDrawable, Object object) {
        GL gL = gLDrawable.getGL();
        gL.glPolygonMode(1028, this.polygonMode);
        gL.glPolygonMode(1029, this.polygonMode);
    }

    public void postDraw(GLDrawable gLDrawable, Object object) {
    }

    public ExternalBrowser getBrowser() {
        return this.saiBrowser;
    }

    public Object getImplementation() {
        return this;
    }

    public void shutdown() {
        this.saiBrowser.dispose();
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
        if (this.frameMillis < 0) {
            this.mainCanvas.setMinimumFrameInterval(0);
        } else {
            this.mainCanvas.setMinimumFrameInterval(this.frameMillis);
        }
    }

    public void windowIconified(WindowEvent windowEvent) {
        this.mainCanvas.setMinimumFrameInterval(1000);
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
        this.mainCanvas.setMinimumFrameInterval(1000);
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        Container container;
        Dimension dimension = this.glCanvas.getSize();
        int n = (int)dimension.getWidth();
        int n2 = (int)dimension.getHeight();
        if (n > 0 && n2 > 0) {
            this.universe.setViewport(new Rectangle(0, 0, n, n2));
        }
        Container container2 = this.getParent();
        while ((container = container2.getParent()) != null) {
            container2 = container;
        }
        ((Window)container2).addWindowListener(this);
    }

    public void componentShown(ComponentEvent componentEvent) {
        if (this.frameMillis < 0) {
            this.mainCanvas.setMinimumFrameInterval(0);
        } else {
            this.mainCanvas.setMinimumFrameInterval(this.frameMillis);
        }
    }

    public int supportedSpecificationVersion() {
        return 3;
    }

    public Canvas getCanvas() {
        return this.glCanvas;
    }

    public int getRendererType() {
        return this.universe.getRendererType();
    }

    public BrowserCore getBrowserCore() {
        return this.universe;
    }

    public ErrorReporter getErrorReporter() {
        return this.console;
    }

    public void setMinimumFrameInterval(int n) {
        this.mainCanvas.setMinimumFrameInterval(n);
        this.frameMillis = n;
    }

    public void start() {
        this.mainCanvas.setEnabled(true);
    }

    public void stop() {
        this.mainCanvas.setEnabled(false);
    }

    public void destroy() {
        this.mainCanvas.setEnabled(false);
        this.mainCanvas.browserShutdown();
    }

    public void browserInitialized(VRMLScene vRMLScene) {
        this.urlTextField.setText(vRMLScene.getLoadedURI());
        this.console.messageReport("Main scene: " + vRMLScene.getLoadedURI() + " loaded.");
    }

    public void urlLoadFailed(String string) {
    }

    public void browserShutdown() {
        if (this.vpToolbar != null) {
            this.vpToolbar.clearViewpoints();
        }
    }

    public void browserDisposed() {
    }

    public void loadURL(String string) throws IOException {
        Object object;
        this.urlTextField.setText(string);
        URL uRL = new URL(string);
        VRMLScene vRMLScene = null;
        try {
            object = uRL.getResource();
            Object object2 = ((ResourceConnection)object).getContent();
            if (!(object2 instanceof VRMLScene)) {
                if (object2 != null) {
                    System.out.println("Type: " + object2.getClass().toString());
                }
                return;
            }
            vRMLScene = (VRMLScene)object2;
        }
        catch (IOException iOException) {
            return;
        }
        catch (VRMLParseException vRMLParseException) {
            this.console.errorReport("Exception parsing file at line: " + vRMLParseException.getLineNumber() + " col: " + vRMLParseException.getColumnNumber() + "\n" + vRMLParseException.getMessage(), (Exception)((Object)vRMLParseException));
        }
        catch (Exception exception) {
            this.console.errorReport("Unexpected exception during parsing", exception);
        }
        if (vRMLScene == null) {
            return;
        }
        object = uRL.getRef();
        this.universe.setScene(vRMLScene, (String)object);
    }

    public void loadURL(InputSource inputSource) throws IOException {
        WorldLoader worldLoader = this.worldLoader.fetchLoader();
        VRMLScene vRMLScene = worldLoader.loadNow((BrowserCore)this.universe, inputSource);
        URL uRL = new URL(inputSource.getBaseURL());
        if (this.frameMillis < 0) {
            this.mainCanvas.setMinimumFrameInterval(0);
        } else {
            this.mainCanvas.setMinimumFrameInterval(this.frameMillis);
        }
        this.universe.setScene(vRMLScene, uRL.getRef());
    }

    public void run() {
        if (!this.showFPS) {
            return;
        }
        while (true) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!this.firstFocused) {
                this.glCanvas.requestFocus();
                this.firstFocused = this.glCanvas.isFocusOwner();
            }
            this.displayFPS();
        }
    }

    public void setElumensMode(boolean bl) {
        this.elumensMode = bl;
        this.resetSurface();
    }

    public boolean getElumensMode() {
        return this.elumensMode;
    }

    private void resetSurface() {
        SimpleAWTSurface simpleAWTSurface;
        this.remove(this.glCanvas);
        this.glCanvas.removeComponentListener(this);
        this.glCanvas.removeKeyListener(this);
        if (this.elumensMode) {
            simpleAWTSurface = new ElumensAWTSurface(this.caps, 3);
            this.universe.setHardwareFOV(180.0f);
        } else {
            simpleAWTSurface = new SimpleAWTSurface(this.caps);
            this.universe.setHardwareFOV(0.0f);
        }
        this.mainCanvas.setSurface((DrawableSurface)simpleAWTSurface);
        this.glCanvas = (Canvas)simpleAWTSurface.getSurfaceObject();
        this.add(this.glCanvas);
        this.glCanvas.addComponentListener(this);
        this.glCanvas.addKeyListener(this);
        this.firstFocused = false;
    }

    private int getMaximumNumSamples() {
        int n = -1;
        if (!this.maxChooserStarted) {
            this.sampleChooser = new SampleChooser();
            Thread thread = new Thread(this.sampleChooser);
            thread.start();
            n = this.sampleChooser.getMaxSamples();
            this.maxChooserStarted = true;
        } else {
            n = this.sampleChooser.getMaxSamples();
        }
        return n;
    }

    private void displayFPS() {
        float f = this.universe.getCurrentFrameRate();
        if ((double)Math.abs(this.lastFPS - f) > 0.01) {
            String string = Float.toString(this.universe.getCurrentFrameRate());
            int n = string.length();
            if (n > 0) {
                this.fpsLabel.setText(string.substring(0, Math.min(5, n)));
            }
            this.lastFPS = f;
        }
    }

    private void setupProperties(final BrowserCore browserCore, final WorldLoaderManager worldLoaderManager) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    FileNameMap fileNameMap;
                    ContentHandlerFactory contentHandlerFactory;
                    URIResourceStreamFactory uRIResourceStreamFactory;
                    String string = System.getProperty("uri.content.handler.pkgs", "");
                    if (string.indexOf("vlc.net.content") == -1) {
                        System.setProperty("uri.content.handler.pkgs", "vlc.net.content");
                    }
                    if ((string = System.getProperty("uri.protocol.handler.pkgs", "")).indexOf("vlc.net.protocol") == -1) {
                        System.setProperty("uri.protocol.handler.pkgs", "vlc.net.protocol");
                    }
                    if (!((uRIResourceStreamFactory = URI.getURIResourceStreamFactory()) instanceof X3DResourceFactory)) {
                        uRIResourceStreamFactory = new X3DResourceFactory(uRIResourceStreamFactory);
                        URI.setURIResourceStreamFactory(uRIResourceStreamFactory);
                    }
                    if (!((contentHandlerFactory = URI.getContentHandlerFactory()) instanceof VRMLContentHandlerFactory)) {
                        contentHandlerFactory = new VRMLContentHandlerFactory(browserCore, worldLoaderManager);
                        URI.setContentHandlerFactory(contentHandlerFactory);
                    }
                    if (!((fileNameMap = URI.getFileNameMap()) instanceof VRMLFileNameMap)) {
                        fileNameMap = new VRMLFileNameMap(fileNameMap);
                        URI.setFileNameMap(fileNameMap);
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            System.out.println("Error setting Properties in BrowserJPanel");
        }
    }
}

