/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.ogl.browser;

import java.applet.Applet;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import net.java.games.jogl.GLCapabilities;
import org.ietf.uri.ContentHandlerFactory;
import org.ietf.uri.FileNameMap;
import org.ietf.uri.URI;
import org.ietf.uri.URIResourceStreamFactory;
import org.j3d.aviatrix3d.surface.SimpleAWTSurface;
import org.web3d.browser.BrowserCore;
import org.web3d.net.content.VRMLContentHandlerFactory;
import org.web3d.net.content.VRMLFileNameMap;
import org.web3d.net.protocol.X3DResourceFactory;
import org.web3d.vrml.nodes.FrameStateManager;
import org.web3d.vrml.nodes.VRMLClock;
import org.web3d.vrml.nodes.VRMLScene;
import org.web3d.vrml.nodes.loader.ScriptLoader;
import org.web3d.vrml.nodes.loader.WorldLoader;
import org.web3d.vrml.nodes.loader.WorldLoaderManager;
import org.web3d.vrml.nodes.runtime.ExternalView;
import org.web3d.vrml.nodes.runtime.RouteManager;
import org.web3d.vrml.nodes.runtime.ScriptManager;
import org.web3d.vrml.nodes.runtime.ViewpointManager;
import org.web3d.vrml.renderer.ogl.browser.OGLBrowserCanvas;
import org.web3d.vrml.renderer.ogl.browser.OGLVRMLUniverse;
import org.web3d.vrml.sav.InputSource;
import org.web3d.vrml.scripting.ScriptEngine;
import org.web3d.vrml.scripting.browser.X3DCommonBrowser;
import org.web3d.vrml.scripting.ecmascript.ECMAScriptEngine;
import org.web3d.vrml.scripting.external.buffer.ExternalEventQueue;
import org.web3d.vrml.scripting.external.sai.SAIBrowser;
import org.web3d.vrml.scripting.sai.JavaSAIScriptEngine;
import org.web3d.x3d.sai.BrowserFactoryImpl;
import org.web3d.x3d.sai.ConnectionException;
import org.web3d.x3d.sai.ExternalBrowser;
import org.web3d.x3d.sai.NoSuchBrowserException;
import org.web3d.x3d.sai.NotSupportedException;
import org.web3d.x3d.sai.X3DComponent;

public class X3DNRBrowserFactoryImpl
implements BrowserFactoryImpl,
X3DComponent {
    static final String NULL_PARAMETER_ERROR = "Null parameter strings not allowed.";
    static final String MALFORMED_PARAMETER_STRING_ERROR = "Malformed parameter string.  Expecting strings of the form A=B";
    private OGLBrowserCanvas mainCanvas;
    private WorldLoaderManager worldLoader;
    private HashMap viewpointDefMap;
    private SAIBrowser saiBrowser;
    private VRMLClock clock;
    private OGLVRMLUniverse universe;

    public X3DNRBrowserFactoryImpl() {
    }

    public X3DComponent createComponent(Map map) throws NotSupportedException {
        return new X3DNRBrowserFactoryImpl(true);
    }

    private X3DNRBrowserFactoryImpl(boolean bl) {
        GLCapabilities gLCapabilities = new GLCapabilities();
        gLCapabilities.setDoubleBuffered(true);
        gLCapabilities.setHardwareAccelerated(true);
        SimpleAWTSurface simpleAWTSurface = new SimpleAWTSurface(gLCapabilities);
        this.mainCanvas = new OGLBrowserCanvas(null, false);
        this.mainCanvas.initialize();
        this.mainCanvas.setMinimumFrameInterval(20);
        RouteManager routeManager = this.mainCanvas.getRouteManager();
        ViewpointManager viewpointManager = this.mainCanvas.getViewpointManager();
        this.universe = this.mainCanvas.getUniverse();
        FrameStateManager frameStateManager = this.mainCanvas.getFrameStateManager();
        this.worldLoader = this.mainCanvas.getWorldLoaderManager();
        ScriptManager scriptManager = this.mainCanvas.getScriptManager();
        ScriptLoader scriptLoader = scriptManager.getScriptLoader();
        JavaSAIScriptEngine javaSAIScriptEngine = new JavaSAIScriptEngine((BrowserCore)this.universe, viewpointManager, routeManager, frameStateManager, this.worldLoader);
        ECMAScriptEngine eCMAScriptEngine = new ECMAScriptEngine((BrowserCore)this.universe, viewpointManager, routeManager, frameStateManager, this.worldLoader);
        scriptLoader.registerScriptingEngine((ScriptEngine)javaSAIScriptEngine);
        scriptLoader.registerScriptingEngine((ScriptEngine)eCMAScriptEngine);
        this.setupProperties(this.universe, this.worldLoader);
        X3DCommonBrowser x3DCommonBrowser = new X3DCommonBrowser((BrowserCore)this.universe, viewpointManager, routeManager, frameStateManager, this.worldLoader);
        ExternalEventQueue externalEventQueue = new ExternalEventQueue(null);
        this.mainCanvas.getEventModelEvaluator().addExternalView((ExternalView)externalEventQueue);
        this.saiBrowser = new SAIBrowser((BrowserCore)this.universe, x3DCommonBrowser, routeManager, frameStateManager, externalEventQueue, null);
        this.clock = this.universe.getVRMLClock();
    }

    public ExternalBrowser getBrowser(Applet applet) throws NotSupportedException, NoSuchBrowserException, ConnectionException {
        throw new NotSupportedException();
    }

    public ExternalBrowser getBrowser(Applet applet, String string, int n) throws NotSupportedException, NoSuchBrowserException, ConnectionException {
        throw new NotSupportedException();
    }

    public ExternalBrowser getBrowser(InetAddress inetAddress, int n) throws NotSupportedException, NoSuchBrowserException, UnknownHostException, ConnectionException {
        throw new NotSupportedException();
    }

    public ExternalBrowser getBrowser() {
        return this.saiBrowser;
    }

    public Object getImplementation() {
        return this;
    }

    public void shutdown() {
        this.saiBrowser.dispose();
    }

    public VRMLScene getScene() {
        return this.universe.getScene();
    }

    public OGLVRMLUniverse getUniverse() {
        return this.universe;
    }

    public void loadURL(String string) throws IOException {
        URL uRL = new URL(string);
        WorldLoader worldLoader = this.worldLoader.fetchLoader();
        InputSource inputSource = new InputSource(string);
        VRMLScene vRMLScene = worldLoader.loadNow((BrowserCore)this.universe, inputSource);
        this.universe.setScene(vRMLScene, uRL.getRef());
    }

    public void loadURL(InputSource inputSource) throws IOException {
        WorldLoader worldLoader = this.worldLoader.fetchLoader();
        VRMLScene vRMLScene = worldLoader.loadNow((BrowserCore)this.universe, inputSource);
        URL uRL = new URL(inputSource.getBaseURL());
        this.universe.setScene(vRMLScene, uRL.getRef());
    }

    private void setupProperties(final BrowserCore browserCore, final WorldLoaderManager worldLoaderManager) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    FileNameMap fileNameMap;
                    ContentHandlerFactory contentHandlerFactory;
                    URIResourceStreamFactory uRIResourceStreamFactory;
                    String string = System.getProperty("uri.content.handler.pkgs", "");
                    if (string.indexOf("vlc.net.content") == -1) {
                        System.setProperty("uri.content.handler.pkgs", "vlc.net.content");
                    }
                    if ((string = System.getProperty("uri.protocol.handler.pkgs", "")).indexOf("vlc.net.protocol") == -1) {
                        System.setProperty("uri.protocol.handler.pkgs", "vlc.net.protocol");
                    }
                    if (!((uRIResourceStreamFactory = URI.getURIResourceStreamFactory()) instanceof X3DResourceFactory)) {
                        uRIResourceStreamFactory = new X3DResourceFactory(uRIResourceStreamFactory);
                        URI.setURIResourceStreamFactory(uRIResourceStreamFactory);
                    }
                    if (!((contentHandlerFactory = URI.getContentHandlerFactory()) instanceof VRMLContentHandlerFactory)) {
                        contentHandlerFactory = new VRMLContentHandlerFactory(browserCore, worldLoaderManager);
                        URI.setContentHandlerFactory(contentHandlerFactory);
                    }
                    if (!((fileNameMap = URI.getFileNameMap()) instanceof VRMLFileNameMap)) {
                        fileNameMap = new VRMLFileNameMap(fileNameMap);
                        URI.setFileNameMap(fileNameMap);
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            System.out.println("Error setting Properties in BrowserJPanel");
        }
    }
}

