/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.ogl.device.mouse;

import java.util.ArrayList;
import org.j3d.aviatrix3d.DrawableSurface;
import org.web3d.ogl.device.mouse.MouseDevice;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.device.DeviceListener;
import org.web3d.vrml.device.DeviceManager;
import org.web3d.vrml.device.InputDevice;

public class MouseManager
implements DeviceManager {
    private ArrayList devices = new ArrayList();
    private ArrayList deviceListeners = new ArrayList();
    private ErrorReporter errorReporter;

    public MouseManager(DrawableSurface drawableSurface) {
        MouseDevice mouseDevice = new MouseDevice(drawableSurface, "Mouse-0");
        this.devices.add(mouseDevice);
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
    }

    public int getNumDevices() {
        return this.devices.size();
    }

    public InputDevice[] getDevices() {
        InputDevice[] inputDeviceArray = new InputDevice[this.devices.size()];
        this.devices.toArray(inputDeviceArray);
        return inputDeviceArray;
    }

    public void addDeviceListener(DeviceListener deviceListener) {
        if (!this.deviceListeners.contains(deviceListener)) {
            this.deviceListeners.add(deviceListener);
        }
    }

    public void removeDeviceListener(DeviceListener deviceListener) {
        this.deviceListeners.remove(deviceListener);
    }
}

