/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.ogl.loaders;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.ietf.uri.ContentHandlerFactory;
import org.ietf.uri.FileNameMap;
import org.ietf.uri.URI;
import org.ietf.uri.URN;
import org.j3d.aviatrix3d.Group;
import org.j3d.renderer.aviatrix3d.loader.AVLoader;
import org.j3d.renderer.aviatrix3d.loader.AVModel;
import org.web3d.browser.BrowserCore;
import org.web3d.net.content.VRMLContentHandlerFactory;
import org.web3d.net.content.VRMLFileNameMap;
import org.web3d.net.resolve.Web3DURNResolver;
import org.web3d.ogl.loaders.StaticBrowserCore;
import org.web3d.ogl.loaders.UserInputRuntime;
import org.web3d.ogl.loaders.Xj3DClockRuntime;
import org.web3d.ogl.loaders.Xj3DModel;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.nodes.FrameStateManager;
import org.web3d.vrml.nodes.VRMLScene;
import org.web3d.vrml.nodes.loader.DefaultScriptLoader;
import org.web3d.vrml.nodes.loader.DefaultWorldLoaderManager;
import org.web3d.vrml.nodes.loader.ExternalLoadManager;
import org.web3d.vrml.nodes.loader.MemCacheLoadManager;
import org.web3d.vrml.nodes.loader.SceneBuilderFactory;
import org.web3d.vrml.nodes.loader.ScriptLoader;
import org.web3d.vrml.nodes.loader.WorldLoader;
import org.web3d.vrml.nodes.loader.WorldLoaderManager;
import org.web3d.vrml.nodes.runtime.DefaultHumanoidManager;
import org.web3d.vrml.nodes.runtime.DefaultNetworkManager;
import org.web3d.vrml.nodes.runtime.DefaultParticleSystemManager;
import org.web3d.vrml.nodes.runtime.DefaultRigidBodyPhysicsManager;
import org.web3d.vrml.nodes.runtime.DefaultRouteManager;
import org.web3d.vrml.nodes.runtime.DefaultScriptManager;
import org.web3d.vrml.nodes.runtime.EventModelEvaluator;
import org.web3d.vrml.nodes.runtime.GeneralisedEventModelEvaluator;
import org.web3d.vrml.nodes.runtime.GeneralisedFrameStateManager;
import org.web3d.vrml.nodes.runtime.GeneralisedViewpointManager;
import org.web3d.vrml.nodes.runtime.ListsRouterFactory;
import org.web3d.vrml.nodes.runtime.NetworkProtocolHandler;
import org.web3d.vrml.nodes.runtime.NodeManager;
import org.web3d.vrml.nodes.runtime.RouteManager;
import org.web3d.vrml.nodes.runtime.RouterFactory;
import org.web3d.vrml.nodes.runtime.ScriptManager;
import org.web3d.vrml.nodes.runtime.SensorManager;
import org.web3d.vrml.nodes.runtime.ViewpointManager;
import org.web3d.vrml.parser.FactoryConfigurationError;
import org.web3d.vrml.parser.VRMLParserFactory;
import org.web3d.vrml.renderer.common.input.dis.DISProtocolHandler;
import org.web3d.vrml.renderer.ogl.OGLSceneBuilderFactory;
import org.web3d.vrml.renderer.ogl.browser.OGLVRMLGroup;
import org.web3d.vrml.renderer.ogl.input.DefaultSensorManager;
import org.web3d.vrml.renderer.ogl.input.OGLUserInputHandler;
import org.web3d.vrml.renderer.ogl.nodes.OGLVRMLNode;
import org.web3d.vrml.sav.InputSource;
import org.web3d.vrml.scripting.ScriptEngine;
import org.web3d.vrml.scripting.ecmascript.ECMAScriptEngine;
import org.web3d.vrml.scripting.ecmascript.JavascriptScriptEngine;
import org.web3d.vrml.scripting.jsai.VRML97ScriptEngine;
import org.web3d.vrml.scripting.sai.JavaSAIScriptEngine;

public abstract class BaseLoader
implements AVLoader {
    private static boolean setupComplete = false;
    protected VRMLParserFactory parserFactory;
    protected boolean vrml97Only = false;
    private int loadFlags = -1;
    private boolean keepModel = false;
    protected ErrorReporter errorReporter;
    protected VRMLScene parsedScene;
    private boolean navigationEnabled = false;
    private Web3DURNResolver resolver = new Web3DURNResolver();

    protected BaseLoader() {
        try {
            this.parserFactory = VRMLParserFactory.newVRMLParserFactory();
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            throw new RuntimeException("Failed to load factory");
        }
    }

    public AVModel load(URL uRL) throws IOException {
        InputSource inputSource = new InputSource(uRL);
        return this.load(inputSource);
    }

    public AVModel load(InputStream inputStream) throws IOException {
        String string = null;
        try {
            string = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    return System.getProperty("user.dir");
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            System.out.println("Cannot get user dir in BaseLoader");
        }
        InputSource inputSource = new InputSource(string, inputStream);
        return this.load(inputSource);
    }

    public AVModel load(File file) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException("File does not exist");
        }
        if (file.isDirectory()) {
            throw new FileNotFoundException("File is a directory");
        }
        InputSource inputSource = new InputSource(file);
        return this.load(inputSource);
    }

    public void setLoadFlags(int n) {
        this.loadFlags = n;
    }

    public int getLoadFlags() {
        return this.loadFlags;
    }

    public void keepInternalModel(boolean bl) {
        this.keepModel = bl;
    }

    public boolean isInternalModelKept() {
        return this.keepModel;
    }

    public boolean getNavigationEnabled() {
        return this.navigationEnabled;
    }

    public void setNavigationEnabled(boolean bl) {
        this.navigationEnabled = bl;
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
    }

    public void registerURNLocation(String string, String string2) throws IllegalArgumentException {
        this.resolver.registerPrefixLocation(string, string2);
    }

    private AVModel load(InputSource inputSource) throws IOException {
        boolean bl = (this.loadFlags & 2) != 0;
        boolean bl2 = (this.loadFlags & 0x10) != 0;
        boolean bl3 = (this.loadFlags & 0x20) != 0;
        boolean bl4 = true;
        boolean bl5 = (this.loadFlags & 4) != 0;
        boolean bl6 = (this.loadFlags & 8) != 0;
        OGLSceneBuilderFactory oGLSceneBuilderFactory = new OGLSceneBuilderFactory(this.vrml97Only, bl, bl2, bl3, bl4, bl5, bl6);
        VRMLParserFactory vRMLParserFactory = null;
        try {
            vRMLParserFactory = VRMLParserFactory.newVRMLParserFactory();
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            throw new RuntimeException("Failed to load factory");
        }
        GeneralisedFrameStateManager generalisedFrameStateManager = new GeneralisedFrameStateManager();
        DefaultWorldLoaderManager defaultWorldLoaderManager = new DefaultWorldLoaderManager((FrameStateManager)generalisedFrameStateManager);
        defaultWorldLoaderManager.setErrorReporter(this.errorReporter);
        defaultWorldLoaderManager.registerBuilderFactory(3, (SceneBuilderFactory)oGLSceneBuilderFactory);
        defaultWorldLoaderManager.registerParserFactory(3, vRMLParserFactory);
        Xj3DModel xj3DModel = null;
        if (bl6) {
            DefaultRouteManager defaultRouteManager = new DefaultRouteManager();
            defaultRouteManager.setRouterFactory((RouterFactory)new ListsRouterFactory());
            DefaultScriptManager defaultScriptManager = new DefaultScriptManager();
            DefaultSensorManager defaultSensorManager = new DefaultSensorManager();
            defaultSensorManager.setNavigationEnabled(this.navigationEnabled);
            GeneralisedEventModelEvaluator generalisedEventModelEvaluator = new GeneralisedEventModelEvaluator();
            MemCacheLoadManager memCacheLoadManager = new MemCacheLoadManager();
            DefaultHumanoidManager defaultHumanoidManager = new DefaultHumanoidManager();
            DefaultNetworkManager defaultNetworkManager = new DefaultNetworkManager();
            DefaultRigidBodyPhysicsManager defaultRigidBodyPhysicsManager = new DefaultRigidBodyPhysicsManager();
            DefaultParticleSystemManager defaultParticleSystemManager = new DefaultParticleSystemManager();
            DISProtocolHandler dISProtocolHandler = new DISProtocolHandler();
            defaultNetworkManager.addProtocolHandler((NetworkProtocolHandler)dISProtocolHandler);
            NodeManager[] nodeManagerArray = new NodeManager[]{defaultNetworkManager, defaultHumanoidManager, defaultRigidBodyPhysicsManager, defaultParticleSystemManager};
            GeneralisedViewpointManager generalisedViewpointManager = new GeneralisedViewpointManager();
            generalisedEventModelEvaluator.initialize((ScriptManager)defaultScriptManager, (RouteManager)defaultRouteManager, (SensorManager)defaultSensorManager, (FrameStateManager)generalisedFrameStateManager, (ExternalLoadManager)memCacheLoadManager, (ViewpointManager)generalisedViewpointManager, nodeManagerArray);
            generalisedEventModelEvaluator.setErrorReporter(this.errorReporter);
            OGLVRMLGroup oGLVRMLGroup = new OGLVRMLGroup(!bl6, (EventModelEvaluator)generalisedEventModelEvaluator);
            Xj3DClockRuntime xj3DClockRuntime = new Xj3DClockRuntime((EventModelEvaluator)generalisedEventModelEvaluator, oGLVRMLGroup);
            oGLVRMLGroup.setPerFrameManager(xj3DClockRuntime);
            this.setupProperties(oGLVRMLGroup, (WorldLoaderManager)defaultWorldLoaderManager);
            WorldLoader worldLoader = defaultWorldLoaderManager.fetchLoader();
            this.parsedScene = worldLoader.loadNow((BrowserCore)oGLVRMLGroup, inputSource);
            defaultWorldLoaderManager.releaseLoader(worldLoader);
            xj3DModel = new Xj3DModel(oGLVRMLGroup, this.parsedScene);
            OGLUserInputHandler oGLUserInputHandler = (OGLUserInputHandler)defaultSensorManager.getUserInputHandler();
            oGLUserInputHandler.setNavigationEnabled(this.navigationEnabled);
            DefaultScriptLoader defaultScriptLoader = new DefaultScriptLoader();
            defaultScriptManager.setScriptLoader((ScriptLoader)defaultScriptLoader);
            VRML97ScriptEngine vRML97ScriptEngine = new VRML97ScriptEngine((BrowserCore)oGLVRMLGroup, (RouteManager)defaultRouteManager, (FrameStateManager)generalisedFrameStateManager, (WorldLoaderManager)defaultWorldLoaderManager);
            JavascriptScriptEngine javascriptScriptEngine = new JavascriptScriptEngine((BrowserCore)oGLVRMLGroup, (RouteManager)defaultRouteManager, (FrameStateManager)generalisedFrameStateManager, (WorldLoaderManager)defaultWorldLoaderManager);
            JavaSAIScriptEngine javaSAIScriptEngine = new JavaSAIScriptEngine((BrowserCore)oGLVRMLGroup, (ViewpointManager)generalisedViewpointManager, (RouteManager)defaultRouteManager, (FrameStateManager)generalisedFrameStateManager, (WorldLoaderManager)defaultWorldLoaderManager);
            ECMAScriptEngine eCMAScriptEngine = new ECMAScriptEngine((BrowserCore)oGLVRMLGroup, (ViewpointManager)generalisedViewpointManager, (RouteManager)defaultRouteManager, (FrameStateManager)generalisedFrameStateManager, (WorldLoaderManager)defaultWorldLoaderManager);
            vRML97ScriptEngine.setErrorReporter(this.errorReporter);
            javascriptScriptEngine.setErrorReporter(this.errorReporter);
            eCMAScriptEngine.setErrorReporter(this.errorReporter);
            javaSAIScriptEngine.setErrorReporter(this.errorReporter);
            defaultScriptLoader.registerScriptingEngine((ScriptEngine)vRML97ScriptEngine);
            defaultScriptLoader.registerScriptingEngine((ScriptEngine)javascriptScriptEngine);
            defaultScriptLoader.registerScriptingEngine((ScriptEngine)javaSAIScriptEngine);
            defaultScriptLoader.registerScriptingEngine((ScriptEngine)eCMAScriptEngine);
            oGLVRMLGroup.setScene(this.parsedScene, null);
            xj3DModel.addRuntimeComponent(xj3DClockRuntime);
            xj3DModel.addRuntimeComponent(new UserInputRuntime());
        } else {
            StaticBrowserCore staticBrowserCore = new StaticBrowserCore();
            this.setupProperties(staticBrowserCore, (WorldLoaderManager)defaultWorldLoaderManager);
            WorldLoader worldLoader = defaultWorldLoaderManager.fetchLoader();
            this.parsedScene = worldLoader.loadNow((BrowserCore)staticBrowserCore, inputSource);
            defaultWorldLoaderManager.releaseLoader(worldLoader);
            OGLVRMLNode oGLVRMLNode = (OGLVRMLNode)this.parsedScene.getRootNode();
            Group group = (Group)oGLVRMLNode.getSceneGraphObject();
            xj3DModel = new Xj3DModel(group, this.parsedScene);
        }
        xj3DModel.setValues(this.keepModel);
        return xj3DModel;
    }

    private void setupProperties(final BrowserCore browserCore, final WorldLoaderManager worldLoaderManager) {
        if (setupComplete) {
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                FileNameMap fileNameMap;
                ContentHandlerFactory contentHandlerFactory;
                System.setProperty("sun.awt.font.advancecache", "off");
                if (System.getProperty("uri.content.handler.pkgs") == null) {
                    System.setProperty("uri.content.handler.pkgs", "vlc.net.content");
                }
                if (System.getProperty("uri.protocol.handler.pkgs") == null) {
                    System.setProperty("uri.protocol.handler.pkgs", "vlc.net.protocol");
                }
                if (!((contentHandlerFactory = URI.getContentHandlerFactory()) instanceof VRMLContentHandlerFactory)) {
                    contentHandlerFactory = new VRMLContentHandlerFactory(browserCore, worldLoaderManager);
                    URI.setContentHandlerFactory(contentHandlerFactory);
                }
                if (!((fileNameMap = URI.getFileNameMap()) instanceof VRMLFileNameMap)) {
                    fileNameMap = new VRMLFileNameMap(fileNameMap);
                    URI.setFileNameMap(fileNameMap);
                }
                URN.addResolver(BaseLoader.this.resolver);
                BaseLoader.this.setupPropertiesProtected();
                return null;
            }
        });
        setupComplete = true;
    }

    void setupPropertiesProtected() {
    }
}

