/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.ogl;

import java.util.HashMap;
import java.util.Map;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLNodeFactory;
import org.web3d.vrml.nodes.FrameStateManager;
import org.web3d.vrml.nodes.VRMLExternProtoDeclare;
import org.web3d.vrml.nodes.VRMLProtoDeclare;
import org.web3d.vrml.nodes.VRMLScene;
import org.web3d.vrml.nodes.loader.SceneBuilder;
import org.web3d.vrml.nodes.proto.ExternalPrototypeDecl;
import org.web3d.vrml.nodes.proto.ProtoBuilder;
import org.web3d.vrml.nodes.proto.PrototypeDecl;
import org.web3d.vrml.renderer.CRVRMLScene;
import org.web3d.vrml.renderer.DefaultLocator;
import org.web3d.vrml.renderer.DefaultNodeFactory;
import org.web3d.vrml.renderer.ogl.OGLExternProtoBuilder;
import org.web3d.vrml.renderer.ogl.OGLMainSceneBuilder;
import org.web3d.vrml.renderer.ogl.OGLNodeFactory;
import org.web3d.vrml.sav.BinaryContentHandler;
import org.web3d.vrml.sav.Locator;
import org.web3d.vrml.sav.ProtoHandler;
import org.web3d.vrml.sav.RouteHandler;
import org.web3d.vrml.sav.SAVException;
import org.web3d.vrml.sav.ScriptHandler;
import org.web3d.vrml.sav.StringContentHandler;

public class OGLVRMLSceneBuilder
implements SceneBuilder {
    private ErrorReporter errorReporter;
    private Locator locator;
    private StringContentHandler contentHandler;
    private ProtoHandler protoHandler;
    private ScriptHandler scriptHandler;
    private RouteHandler routeHandler;
    private OGLMainSceneBuilder mainSceneBuilder;
    private ProtoBuilder protoBuilder;
    private OGLExternProtoBuilder externProtoBuilder;
    private VRMLNodeFactory nodeFactory;
    private boolean isVrml97;
    private HashMap protoMap;
    private HashMap externProtoMap;
    private boolean isParsing;
    private String worldURL;
    private int protoNestings;
    private String version;

    public OGLVRMLSceneBuilder() {
        this(null);
    }

    public OGLVRMLSceneBuilder(VRMLNodeFactory vRMLNodeFactory) {
        this.nodeFactory = vRMLNodeFactory != null ? vRMLNodeFactory : OGLNodeFactory.getOGLNodeFactory();
        HashMap hashMap = new HashMap();
        this.protoMap = new HashMap();
        this.externProtoMap = new HashMap();
        this.mainSceneBuilder = new OGLMainSceneBuilder(this.nodeFactory);
        this.mainSceneBuilder.setGlobals(hashMap, this.protoMap, this.externProtoMap);
        VRMLNodeFactory vRMLNodeFactory2 = DefaultNodeFactory.newInstance((String)"null");
        this.protoBuilder = new ProtoBuilder(vRMLNodeFactory2);
        this.protoBuilder.setGlobals(hashMap, (Map)this.protoMap, (Map)this.externProtoMap);
        this.externProtoBuilder = new OGLExternProtoBuilder(this.nodeFactory);
        this.externProtoBuilder.setGlobals(hashMap, this.protoMap, this.externProtoMap);
        this.isParsing = false;
        this.errorReporter = DefaultErrorReporter.getDefaultReporter();
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter == null ? DefaultErrorReporter.getDefaultReporter() : errorReporter;
        this.mainSceneBuilder.setErrorReporter(this.errorReporter);
        this.externProtoBuilder.setErrorReporter(this.errorReporter);
        this.protoBuilder.setErrorReporter(this.errorReporter);
    }

    public VRMLScene getScene() {
        return this.mainSceneBuilder.getScene();
    }

    public void reset() {
        this.isParsing = false;
        this.mainSceneBuilder.reset();
        this.protoBuilder.reset();
        this.externProtoBuilder.reset();
    }

    public void allowVRML97Only(boolean bl) {
        this.isVrml97 = bl;
    }

    public void setFrameStateManager(FrameStateManager frameStateManager) {
        this.mainSceneBuilder.setFrameStateManager(frameStateManager);
        this.externProtoBuilder.setFrameStateManager(frameStateManager);
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
        this.mainSceneBuilder.setDocumentLocator(locator);
        this.protoBuilder.setDocumentLocator(locator);
        this.externProtoBuilder.setDocumentLocator(locator);
    }

    public void startDocument(String string, String string2, String string3, String string4, String string5, String string6) throws SAVException, VRMLException {
        if (this.isParsing) {
            throw new SAVException("Currently parsing a document");
        }
        this.isParsing = true;
        if (this.locator == null) {
            this.setDocumentLocator((Locator)new DefaultLocator());
        }
        int n = 3;
        int n2 = 0;
        if (string5.charAt(0) == 'V') {
            boolean bl;
            boolean bl2 = bl = string5.charAt(1) == '2';
            if (bl) {
                n = 2;
            }
        } else {
            int n3 = string5.indexOf(46);
            String string7 = string5.substring(n3 + 1);
            n2 = Integer.parseInt(string7);
        }
        this.nodeFactory.setSpecVersion(n, n2);
        this.version = string5.substring(1);
        this.mainSceneBuilder.startDocument(string, string2, string3, string4, string5, string6);
        this.protoBuilder.startDocument(string, string2, string3, string4, string5, string6);
        this.externProtoBuilder.startDocument(string, string2, string3, string4, string5, string6);
        this.protoNestings = 0;
        this.contentHandler = this.mainSceneBuilder;
        this.protoHandler = this.mainSceneBuilder;
        this.scriptHandler = this.mainSceneBuilder;
        this.routeHandler = this.mainSceneBuilder;
    }

    public void profileDecl(String string) throws SAVException, VRMLException {
        this.mainSceneBuilder.profileDecl(string);
        this.protoBuilder.profileDecl(string);
    }

    public void componentDecl(String string) throws SAVException, VRMLException {
        this.mainSceneBuilder.componentDecl(string);
        this.protoBuilder.componentDecl(string);
    }

    public void metaDecl(String string, String string2) throws SAVException, VRMLException {
        this.contentHandler.metaDecl(string, string2);
    }

    public void importDecl(String string, String string2, String string3) throws SAVException, VRMLException {
        this.contentHandler.importDecl(string, string2, string3);
    }

    public void exportDecl(String string, String string2) throws SAVException, VRMLException {
        this.contentHandler.exportDecl(string, string2);
    }

    public void endDocument() throws SAVException, VRMLException {
        this.mainSceneBuilder.endDocument();
        this.protoBuilder.endDocument();
        this.externProtoBuilder.endDocument();
        this.isParsing = false;
    }

    public void startNode(String string, String string2) throws SAVException, VRMLException {
        this.contentHandler.startNode(string, string2);
    }

    public void endNode() throws SAVException, VRMLException {
        this.contentHandler.endNode();
    }

    public void startField(String string) throws SAVException, VRMLException {
        this.contentHandler.startField(string);
    }

    public void fieldValue(String string) throws SAVException, VRMLException {
        this.contentHandler.fieldValue(string);
    }

    public void fieldValue(String[] stringArray) throws SAVException, VRMLException {
        this.contentHandler.fieldValue(stringArray);
    }

    public void useDecl(String string) throws SAVException, VRMLException {
        this.contentHandler.useDecl(string);
    }

    public void endField() throws SAVException, VRMLException {
        this.contentHandler.endField();
    }

    public void fieldValue(int n) throws SAVException, VRMLException {
        ((BinaryContentHandler)((Object)this.contentHandler)).fieldValue(n);
    }

    public void fieldValue(int[] nArray, int n) throws SAVException, VRMLException {
        ((BinaryContentHandler)((Object)this.contentHandler)).fieldValue(nArray, n);
    }

    public void fieldValue(boolean bl) throws SAVException, VRMLException {
        ((BinaryContentHandler)((Object)this.contentHandler)).fieldValue(bl);
    }

    public void fieldValue(boolean[] blArray, int n) throws SAVException, VRMLException {
        ((BinaryContentHandler)((Object)this.contentHandler)).fieldValue(blArray, n);
    }

    public void fieldValue(float f) throws SAVException, VRMLException {
        ((BinaryContentHandler)((Object)this.contentHandler)).fieldValue(f);
    }

    public void fieldValue(float[] fArray, int n) throws SAVException, VRMLException {
        ((BinaryContentHandler)((Object)this.contentHandler)).fieldValue(fArray, n);
    }

    public void fieldValue(long l) throws SAVException, VRMLException {
        ((BinaryContentHandler)((Object)this.contentHandler)).fieldValue(l);
    }

    public void fieldValue(long[] lArray, int n) throws SAVException, VRMLException {
        ((BinaryContentHandler)((Object)this.contentHandler)).fieldValue(lArray, n);
    }

    public void fieldValue(double d) throws SAVException, VRMLException {
        ((BinaryContentHandler)((Object)this.contentHandler)).fieldValue(d);
    }

    public void fieldValue(double[] dArray, int n) throws SAVException, VRMLException {
        ((BinaryContentHandler)((Object)this.contentHandler)).fieldValue(dArray, n);
    }

    public void fieldValue(String[] stringArray, int n) throws SAVException, VRMLException {
        ((BinaryContentHandler)((Object)this.contentHandler)).fieldValue(stringArray, n);
    }

    public void startProtoDecl(String string) throws SAVException, VRMLException {
        if (this.protoNestings == 0) {
            this.contentHandler = this.protoBuilder;
            this.scriptHandler = this.protoBuilder;
            this.routeHandler = this.protoBuilder;
            this.protoHandler = this.protoBuilder;
            this.protoBuilder.newProto(this.mainSceneBuilder.getProtoCreator());
        }
        ++this.protoNestings;
        this.protoHandler.startProtoDecl(string);
    }

    public void endProtoDecl() throws SAVException, VRMLException {
        this.protoHandler.endProtoDecl();
    }

    public void protoFieldDecl(int n, String string, String string2, Object object) throws SAVException, VRMLException {
        this.protoHandler.protoFieldDecl(n, string, string2, object);
    }

    public void protoIsDecl(String string) throws SAVException, VRMLException {
        this.protoHandler.protoIsDecl(string);
    }

    public void startProtoBody() throws SAVException, VRMLException {
        this.protoHandler.startProtoBody();
    }

    public void endProtoBody() throws SAVException, VRMLException {
        this.protoHandler.endProtoBody();
        --this.protoNestings;
        if (this.protoNestings == 0) {
            this.contentHandler = this.mainSceneBuilder;
            this.protoHandler = this.mainSceneBuilder;
            this.scriptHandler = this.mainSceneBuilder;
            this.routeHandler = this.mainSceneBuilder;
            PrototypeDecl prototypeDecl = (PrototypeDecl)this.protoBuilder.getPrototype();
            this.protoMap.put(prototypeDecl.getVRMLNodeName(), prototypeDecl);
            CRVRMLScene cRVRMLScene = this.mainSceneBuilder.getScene();
            cRVRMLScene.addProto((VRMLProtoDeclare)prototypeDecl);
        }
    }

    public void startExternProtoDecl(String string) throws SAVException, VRMLException {
        if (this.protoNestings != 0) {
            this.contentHandler = this.protoBuilder;
            this.scriptHandler = this.protoBuilder;
            this.routeHandler = this.protoBuilder;
            this.protoHandler = this.protoBuilder;
            this.protoBuilder.newProto(this.mainSceneBuilder.getProtoCreator());
        } else {
            this.contentHandler = this.externProtoBuilder;
            this.scriptHandler = this.externProtoBuilder;
            this.routeHandler = this.externProtoBuilder;
            this.protoHandler = this.externProtoBuilder;
            this.externProtoBuilder.newProto(this.mainSceneBuilder.getProtoCreator());
        }
        ++this.protoNestings;
        this.protoHandler.startExternProtoDecl(string);
    }

    public void endExternProtoDecl() throws SAVException, VRMLException {
        this.protoHandler.endExternProtoDecl();
        --this.protoNestings;
    }

    public void externProtoURI(String[] stringArray) throws SAVException, VRMLException {
        this.protoHandler.externProtoURI(stringArray);
        if (this.protoNestings == 0) {
            this.contentHandler = this.mainSceneBuilder;
            this.protoHandler = this.mainSceneBuilder;
            this.scriptHandler = this.mainSceneBuilder;
            this.routeHandler = this.mainSceneBuilder;
            ExternalPrototypeDecl externalPrototypeDecl = (ExternalPrototypeDecl)this.externProtoBuilder.getPrototype();
            this.externProtoMap.put(externalPrototypeDecl.getVRMLNodeName(), externalPrototypeDecl);
            CRVRMLScene cRVRMLScene = this.mainSceneBuilder.getScene();
            cRVRMLScene.addExternProto((VRMLExternProtoDeclare)externalPrototypeDecl);
        }
    }

    public void startScriptDecl() throws SAVException, VRMLException {
        this.scriptHandler.startScriptDecl();
    }

    public void endScriptDecl() throws SAVException, VRMLException {
        this.scriptHandler.endScriptDecl();
    }

    public void scriptFieldDecl(int n, String string, String string2, Object object) throws SAVException, VRMLException {
        this.scriptHandler.scriptFieldDecl(n, string, string2, object);
    }

    public void routeDecl(String string, String string2, String string3, String string4) throws SAVException, VRMLException {
        this.routeHandler.routeDecl(string, string2, string3, string4);
    }

    public void setLoadRequirements(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        this.mainSceneBuilder.setLoadRequirements(this.isVrml97, bl, bl2, bl3, bl4, bl5, bl6);
        this.protoBuilder.setLoadRequirements(this.isVrml97, bl, bl2, bl3, bl4, bl5, bl6);
    }
}

