/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.ogl.browser;

import java.util.ArrayList;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import org.j3d.aviatrix3d.ApplicationUpdateObserver;
import org.j3d.aviatrix3d.BoundingVolume;
import org.j3d.aviatrix3d.Group;
import org.j3d.aviatrix3d.NodeUpdateListener;
import org.j3d.aviatrix3d.TransformGroup;
import org.j3d.aviatrix3d.ViewEnvironment;
import org.web3d.browser.BrowserCore;
import org.web3d.vrml.nodes.VRMLNavigationInfoNodeType;
import org.web3d.vrml.nodes.runtime.EventModelEvaluator;
import org.web3d.vrml.renderer.ogl.browser.PerFrameManager;
import org.web3d.vrml.renderer.ogl.input.OGLSensorManager;
import org.web3d.vrml.renderer.ogl.input.OGLUserInputHandler;
import org.web3d.vrml.renderer.ogl.nodes.OGLTransformNodeType;
import org.web3d.vrml.renderer.ogl.nodes.OGLUserData;

public class ApplicationFrameManager
extends PerFrameManager
implements ApplicationUpdateObserver,
NodeUpdateListener,
OGLTransformNodeType {
    private static final int TIME_FUDGE_FACTOR = 1;
    private TransformGroup sgTransformGroup;
    private Group sceneGroup;
    private OGLUserInputHandler inputHandler;
    private OGLSensorManager sensorManager;
    private Matrix4f worldScale;
    private ViewEnvironment viewEnvironment;
    private VRMLNavigationInfoNodeType navInfo;
    private float[] boundsMin;
    private float[] boundsMax;
    private Vector3f posVector;
    private float[] pos;
    private float zlen;
    private float scale;
    private float visibilityLimit;
    private boolean autoresize = false;
    private Matrix4f idenMatrix;
    private ArrayList[] laters;
    private int currentLater;
    float near = 0.0f;
    float far = 0.0f;
    int cnt = 0;
    boolean stop;
    boolean doSensor;

    public ApplicationFrameManager(EventModelEvaluator eventModelEvaluator, TransformGroup transformGroup, ViewEnvironment viewEnvironment, BrowserCore browserCore, OGLUserInputHandler oGLUserInputHandler, OGLSensorManager oGLSensorManager) throws IllegalArgumentException {
        super(eventModelEvaluator, browserCore, System.currentTimeMillis());
        this.viewEnvironment = viewEnvironment;
        this.worldScale = new Matrix4f();
        this.worldScale.setIdentity();
        this.sgTransformGroup = transformGroup;
        this.inputHandler = oGLUserInputHandler;
        this.sensorManager = oGLSensorManager;
        this.posVector = new Vector3f();
        this.pos = new float[3];
        OGLUserData oGLUserData = new OGLUserData();
        this.sgTransformGroup.setUserData((Object)oGLUserData);
        oGLUserData.owner = this;
        this.idenMatrix = new Matrix4f();
        this.idenMatrix.setIdentity();
        this.boundsMin = new float[3];
        this.boundsMax = new float[3];
        this.scale = 1.0f;
        this.currentLater = 0;
        this.laters = new ArrayList[2];
        this.laters[0] = new ArrayList(1);
        this.laters[1] = new ArrayList(1);
    }

    public void invokeLater(Runnable runnable) {
        this.laters[this.currentLater].add(runnable);
    }

    public void updateNodeBoundsChanges(Object object) {
        if (this.sceneGroup != null && this.navInfo != null) {
            if (this.near < this.far) {
                this.viewEnvironment.setNearClipDistance((double)(this.near * this.scale));
                this.viewEnvironment.setFarClipDistance((double)this.far);
            }
            this.sgTransformGroup.setTransform(this.worldScale);
        }
    }

    public void updateNodeDataChanges(Object object) {
    }

    public Matrix4f getTransform() {
        return this.worldScale;
    }

    public void updateSceneGraph() {
        ArrayList arrayList = this.laters[this.currentLater];
        ++this.currentLater;
        if (this.currentLater > 1) {
            this.currentLater = 0;
        }
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Runnable runnable = (Runnable)arrayList.get(i);
            runnable.run();
        }
        arrayList.clear();
        long l = System.currentTimeMillis();
        if (l - this.lastWallTime <= 0L) {
            ++l;
        }
        this.clockTick(l);
        if (this.doSensor) {
            System.out.println("*** Setting sensorManager.worldScale");
            this.sensorManager.setWorldScale(this.scale);
            if (this.sgTransformGroup.isLive()) {
                this.sgTransformGroup.boundsChanged((NodeUpdateListener)this);
            }
            this.doSensor = false;
            return;
        }
        if (!this.autoresize && this.sceneGroup != null) {
            BoundingVolume boundingVolume;
            float f;
            float f2;
            this.inputHandler.getPosition(this.posVector);
            int n2 = 3000;
            float[] fArray = null;
            if (this.navInfo != null) {
                this.visibilityLimit = this.navInfo.getVisibilityLimit();
                fArray = this.navInfo.getAvatarSize();
                f2 = fArray[0] / 2.0f;
            } else {
                this.visibilityLimit = 0.0f;
                f2 = 0.125f;
            }
            if ((double)f2 < 0.001) {
                f2 = 0.001f;
            }
            float f3 = this.visibilityLimit == 0.0f ? ((f = this.getMaxExtent(boundingVolume = this.sceneGroup.getBounds(), this.posVector)) > (float)n2 ? f : (float)n2) : this.visibilityLimit;
            if (f2 > f3) {
                f3 = f2 * 3000.0f;
            }
            this.viewEnvironment.setClipDistance((double)f2, (double)f3);
        }
        if (this.autoresize && this.sceneGroup != null) {
            double d;
            BoundingVolume boundingVolume = this.sceneGroup.getBounds();
            this.inputHandler.getPosition(this.posVector);
            double d2 = 1.0 / (double)this.scale;
            this.pos[0] = (float)((double)this.posVector.x * d2);
            this.pos[1] = (float)((double)this.posVector.y * d2);
            this.pos[2] = (float)((double)this.posVector.z * d2);
            double d3 = 0.0;
            if (boundingVolume.checkIntersectionPoint(this.pos)) {
                d3 = this.getMaxExtent(boundingVolume);
            } else {
                boundingVolume.getExtents(this.boundsMin, this.boundsMax);
                d = this.boundsMax[0] - this.pos[0];
                double d4 = this.boundsMax[1] - this.pos[1];
                double d5 = this.boundsMax[2] - this.pos[2];
                double d6 = d * d + d4 * d4 + d5 * d5;
                d6 = Math.sqrt(d6);
                d3 = Double.isInfinite(d6) ? Double.MAX_VALUE : d6;
                d = this.boundsMin[0] - this.pos[0];
                d4 = this.boundsMin[1] - this.pos[1];
                d5 = this.boundsMin[2] - this.pos[2];
                d6 = d * d + d4 * d4 + d5 * d5;
                d6 = Math.sqrt(d6);
                if (d6 > d3) {
                    d3 = Double.isInfinite(d6) ? Double.MAX_VALUE : d6;
                }
            }
            int n3 = 3000;
            if (this.navInfo != null) {
                this.visibilityLimit = this.navInfo.getVisibilityLimit();
                float[] fArray = this.navInfo.getAvatarSize();
                this.near = fArray[0] / 2.0f;
                this.far = this.near * (float)n3;
            } else {
                this.visibilityLimit = 0.0f;
                this.near = 0.125f;
                this.far = this.near * (float)n3;
            }
            this.zlen = this.far - this.near;
            d = this.visibilityLimit > 0.001f ? (double)(this.zlen / this.visibilityLimit) : (d3 > 0.0 ? (double)this.zlen / d3 : 1.0);
            if (d > 1.0) {
                d = 1.0;
            }
            if ((double)this.scale - d > 1.0E-6) {
                System.out.println("near: " + this.near + " far: " + this.far + " scale: " + d);
                this.scale = (float)d * 0.9f;
                this.worldScale.setScale(this.scale);
                this.inputHandler.setWorldScale(this.scale);
                this.doSensor = true;
            }
        }
    }

    public void appShutdown() {
    }

    private float getMaxExtent(BoundingVolume boundingVolume, Vector3f vector3f) {
        double d;
        boundingVolume.getExtents(this.boundsMin, this.boundsMax);
        float f = this.boundsMax[0] - this.boundsMin[0];
        float f2 = vector3f.x - this.boundsMin[0];
        float f3 = vector3f.x - this.boundsMax[0];
        float f4 = this.boundsMax[1] - this.boundsMin[1];
        float f5 = vector3f.y - this.boundsMin[1];
        float f6 = vector3f.y - this.boundsMax[1];
        float f7 = this.boundsMax[2] - this.boundsMin[2];
        float f8 = vector3f.z - this.boundsMin[2];
        float f9 = vector3f.z - this.boundsMax[2];
        double d2 = d = (double)(f * f + f4 * f4 + f7 * f7);
        d = f * f2 + f5 * f5 + f8 * f8;
        if (d > d2) {
            d2 = d;
        }
        if ((d = (double)(f3 * f3 + f6 * f6 + f9 * f9)) > d2) {
            d2 = d;
        }
        return (float)Math.sqrt(d2);
    }

    private double getMaxExtent(BoundingVolume boundingVolume) {
        boundingVolume.getExtents(this.boundsMin, this.boundsMax);
        float f = this.boundsMax[0] - this.boundsMin[0];
        float f2 = this.boundsMax[1] - this.boundsMin[1];
        float f3 = this.boundsMax[2] - this.boundsMin[2];
        double d = f * f + f2 * f2 + f3 * f3;
        d = Math.sqrt(d);
        return d;
    }

    public void setRoot(Group group) {
        this.sceneGroup = group;
    }

    public void setNavigationInfo(VRMLNavigationInfoNodeType vRMLNavigationInfoNodeType) {
        this.navInfo = vRMLNavigationInfoNodeType;
        float[] fArray = this.navInfo.getAvatarSize();
        this.sgTransformGroup.boundsChanged((NodeUpdateListener)this);
    }
}

