/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.ogl.browser;

import org.j3d.aviatrix3d.Appearance;
import org.j3d.aviatrix3d.Geometry;
import org.j3d.aviatrix3d.Material;
import org.j3d.aviatrix3d.NodeUpdateListener;
import org.j3d.aviatrix3d.Shape3D;
import org.j3d.aviatrix3d.TriangleStripArray;
import org.j3d.geom.GeometryData;
import org.j3d.geom.terrain.ColorRampGenerator;

class GroundSphere
extends Shape3D
implements NodeUpdateListener {
    private static final int DEFAULT_NUM_SPHERE_FACES = 32;
    private static final float[] SIN_TABLE;
    private static final float[] COS_TABLE;
    private GeometryData groundData = new GeometryData();
    private float[] gndHeights;
    private float gndMaxAngle = 0.0f;
    private float[][] gndColors;
    private int numGndColors;
    private ColorRampGenerator gndColorCreator;
    private TriangleStripArray groundGeometry;
    private Appearance appearance;

    public GroundSphere() {
        this.groundData.geometryType = 3;
        this.groundData.geometryComponents = 2;
        Material material = new Material();
        material.setLightingEnabled(false);
        this.appearance = new Appearance();
        this.appearance.setMaterial(material);
        this.appearance.setVisible(false);
        this.groundGeometry = new TriangleStripArray();
        this.setAppearance(this.appearance);
        this.setGeometry((Geometry)this.groundGeometry);
    }

    void updateGroundColors(float[] fArray, float[] fArray2, int n) {
        if (n < 2) {
            if (this.appearance.isVisible()) {
                if (this.appearance.isLive()) {
                    this.appearance.dataChanged((NodeUpdateListener)this);
                } else {
                    this.appearance.setVisible(false);
                }
            }
        } else {
            if (!this.appearance.isVisible()) {
                if (this.appearance.isLive()) {
                    this.appearance.dataChanged((NodeUpdateListener)this);
                } else {
                    this.appearance.setVisible(true);
                }
            }
            this.updateGroundSphereGeom(fArray, fArray2, n);
        }
        this.numGndColors = n;
    }

    public void updateNodeBoundsChanges(Object object) {
        this.groundGeometry.setVertices(3, this.groundData.coordinates, this.groundData.vertexCount);
        this.groundGeometry.setStripCount(this.groundData.stripCounts, this.groundData.numStrips);
    }

    public void updateNodeDataChanges(Object object) {
        if (object == this.appearance) {
            this.appearance.setVisible(this.numGndColors != 0);
        } else if (object == this.groundGeometry) {
            this.groundGeometry.setColors(false, this.groundData.colors);
        }
    }

    void updateGroundSphereGeom(float[] fArray, float[] fArray2, int n) {
        boolean bl;
        if (this.gndColorCreator == null) {
            this.gndColorCreator = new ColorRampGenerator();
        }
        boolean bl2 = bl = (double)fArray2[n - 1] < Math.PI;
        if (this.gndHeights == null || this.gndHeights.length != n) {
            this.gndHeights = new float[n];
        }
        this.gndHeights[0] = -1.0f;
        for (int i = 1; i < n; ++i) {
            this.gndHeights[i] = -((float)Math.cos(fArray2[i - 1]));
        }
        this.gndColorCreator.setColorRamp(this.gndHeights, fArray, n, false);
        if (fArray2[n - 2] != this.gndMaxAngle) {
            this.generateGroundCoords(fArray2[n - 2], n);
            this.gndMaxAngle = fArray2[n - 2];
            if (this.groundGeometry.isLive()) {
                this.groundGeometry.dataChanged((NodeUpdateListener)this);
            } else {
                this.updateNodeDataChanges(this.groundGeometry);
            }
        }
        this.gndColorCreator.generate(this.groundData);
        if (this.groundGeometry.isLive()) {
            this.groundGeometry.boundsChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeBoundsChanges(this.groundGeometry);
        }
    }

    private void generateGroundCoords(float f, int n) {
        int n2;
        int n3 = n > 32 ? n : 32;
        float f2 = f / (float)n3;
        int n4 = 33 * n3;
        if (this.groundData.coordinates == null || this.groundData.vertexCount < n4 * 6) {
            this.groundData.coordinates = new float[n4 * 6];
        }
        int[] nArray = new int[n3];
        this.groundData.stripCounts = nArray;
        this.groundData.numStrips = n3;
        int n5 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            float f3 = 0.8f * (float)Math.sin(f2 * (float)n2);
            float f4 = 0.8f * (float)Math.sin(f2 * (float)(n2 + 1));
            float f5 = -((float)Math.cos(f2 * (float)n2));
            float f6 = -((float)Math.cos(f2 * (float)(n2 + 1)));
            nArray[n2] = 66;
            for (int i = 0; i <= 32; ++i) {
                this.groundData.coordinates[n5++] = f3 * SIN_TABLE[i];
                this.groundData.coordinates[n5++] = f5;
                this.groundData.coordinates[n5++] = f3 * COS_TABLE[i];
                this.groundData.coordinates[n5++] = f4 * SIN_TABLE[i];
                this.groundData.coordinates[n5++] = f6;
                this.groundData.coordinates[n5++] = f4 * COS_TABLE[i];
            }
        }
        this.groundData.vertexCount = n5 / 3;
        n2 = this.groundData.vertexCount * 3;
        if (this.groundData.colors == null || this.groundData.colors.length < n2) {
            this.groundData.colors = new float[n2];
        }
    }

    static {
        COS_TABLE = new float[33];
        SIN_TABLE = new float[33];
        double d = 0.19634954084936207;
        for (int i = 0; i < 33; ++i) {
            GroundSphere.COS_TABLE[i] = (float)Math.cos(d * (double)i + 1.5707963267948966);
            GroundSphere.SIN_TABLE[i] = (float)Math.sin(d * (double)i + 1.5707963267948966);
        }
    }
}

