/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.ogl.browser;

import java.awt.Component;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyListener;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.j3d.aviatrix3d.AudioCullStage;
import org.j3d.aviatrix3d.AudioDevice;
import org.j3d.aviatrix3d.AudioPipeline;
import org.j3d.aviatrix3d.AudioSortStage;
import org.j3d.aviatrix3d.CullStage;
import org.j3d.aviatrix3d.DrawableSurface;
import org.j3d.aviatrix3d.RenderPipeline;
import org.j3d.aviatrix3d.RenderPipelineManager;
import org.j3d.aviatrix3d.SortStage;
import org.j3d.aviatrix3d.audio.OpenALAudioDevice;
import org.j3d.aviatrix3d.pipeline.DefaultAudioPipeline;
import org.j3d.aviatrix3d.pipeline.DefaultRenderPipeline;
import org.j3d.aviatrix3d.pipeline.NullAudioCullStage;
import org.j3d.aviatrix3d.pipeline.NullAudioSortStage;
import org.j3d.aviatrix3d.pipeline.SimpleFrustumCullStage;
import org.j3d.aviatrix3d.pipeline.SingleThreadRenderManager;
import org.j3d.aviatrix3d.pipeline.StateAndTransparencyDepthSortStage;
import org.j3d.aviatrix3d.surface.ElumensAWTSurface;
import org.web3d.browser.BrowserCore;
import org.web3d.browser.BrowserCoreListener;
import org.web3d.browser.InvalidConfigurationException;
import org.web3d.browser.SensorStatusListener;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.nodes.FrameStateManager;
import org.web3d.vrml.nodes.VRMLBindableNodeType;
import org.web3d.vrml.nodes.VRMLClock;
import org.web3d.vrml.nodes.VRMLScene;
import org.web3d.vrml.nodes.VRMLViewpointNodeType;
import org.web3d.vrml.nodes.loader.DefaultWorldLoaderManager;
import org.web3d.vrml.nodes.loader.ExternalLoadManager;
import org.web3d.vrml.nodes.loader.SceneBuilderFactory;
import org.web3d.vrml.nodes.loader.ScriptLoader;
import org.web3d.vrml.nodes.loader.WorldLoader;
import org.web3d.vrml.nodes.loader.WorldLoaderManager;
import org.web3d.vrml.nodes.runtime.DefaultHumanoidManager;
import org.web3d.vrml.nodes.runtime.DefaultParticleSystemManager;
import org.web3d.vrml.nodes.runtime.DefaultRigidBodyPhysicsManager;
import org.web3d.vrml.nodes.runtime.EventModelEvaluator;
import org.web3d.vrml.nodes.runtime.GeneralisedViewpointManager;
import org.web3d.vrml.nodes.runtime.InputDeviceManager;
import org.web3d.vrml.nodes.runtime.NetworkManager;
import org.web3d.vrml.nodes.runtime.NetworkProtocolHandler;
import org.web3d.vrml.nodes.runtime.NodeManager;
import org.web3d.vrml.nodes.runtime.PickingManager;
import org.web3d.vrml.nodes.runtime.RouteManager;
import org.web3d.vrml.nodes.runtime.RouterFactory;
import org.web3d.vrml.nodes.runtime.ScriptManager;
import org.web3d.vrml.nodes.runtime.SensorManager;
import org.web3d.vrml.nodes.runtime.ViewpointManager;
import org.web3d.vrml.parser.FactoryConfigurationError;
import org.web3d.vrml.parser.VRMLParserFactory;
import org.web3d.vrml.renderer.common.input.dis.DISProtocolHandler;
import org.web3d.vrml.renderer.ogl.OGLSceneBuilderFactory;
import org.web3d.vrml.renderer.ogl.browser.OGLVRMLUniverse;
import org.web3d.vrml.renderer.ogl.input.OGLSensorManager;
import org.web3d.vrml.sav.InputSource;

public class OGLBrowserCanvas
implements SensorStatusListener,
BrowserCoreListener,
Runnable,
ComponentListener {
    public static final String SCRIPT_LOADER_PROP = "org.web3d.xj3d.script.loader.class";
    public static final String SCRIPT_MANAGER_PROP = "org.web3d.xj3d.script.manager.class";
    public static final String FILE_LOADER_PROP = "org.web3d.xj3d.file.loader.class";
    public static final String ROUTER_FACTORY_PROP = "org.web3d.xj3d.router.factory.class";
    public static final String ROUTER_MANAGER_PROP = "org.web3d.xj3d.router.manager.class";
    public static final String STATE_MANAGER_PROP = "org.web3d.xj3d.state.manager.class";
    public static final String SENSOR_MANAGER_PROP = "org.web3d.xj3d.sensor.manager.class";
    public static final String PICKING_MANAGER_PROP = "org.web3d.xj3d.sensor.manager.class";
    public static final String NETWORK_MANAGER_PROP = "org.web3d.xj3d.network.manager.class";
    private static final String DEFAULT_NETWORK_MANAGER = "org.web3d.vrml.nodes.runtime.DefaultNetworkManager";
    public static final String HANIM_MANAGER_PROP = "org.web3d.xj3d.hanim.manager.class";
    private static final String DEFAULT_HANIM_MANAGER = "org.web3d.vrml.nodes.runtime.DefaultHumanoidManager";
    public static final String PHYSICS_MANAGER_PROP = "org.web3d.xj3d.physics.manager.class";
    private static final String DEFAULT_PHYSICS_MANAGER = "org.web3d.vrml.nodes.runtime.DefaultRigidBodyPhysicsManager";
    public static final String PARTICLE_MANAGER_PROP = "org.web3d.xj3d.particle.manager.class";
    private static final String DEFAULT_PARTICLE_MANAGER = "org.web3d.vrml.nodes.runtime.DefaultParticleSystemManager";
    public static final String EVENT_MODEL_PROP = "org.web3d.xj3d.eventmodel.evaluator.class";
    private static final String DEFAULT_SCRIPT_LOADER = "org.web3d.vrml.nodes.loader.DefaultScriptLoader";
    private static final String DEFAULT_SCRIPT_MANAGER = "org.web3d.vrml.nodes.runtime.DefaultScriptManager";
    private static final String DEFAULT_EXTERNAL = "org.web3d.vrml.nodes.loader.MemCacheLoadManager";
    private static final String DEFAULT_ROUTER_FACTORY = "org.web3d.vrml.nodes.runtime.ListsRouterFactory";
    private static final String DEFAULT_ROUTER_MANAGER = "org.web3d.vrml.nodes.runtime.DefaultRouteManager";
    private static final String DEFAULT_STATE_MANAGER = "org.web3d.vrml.nodes.runtime.GeneralisedFrameStateManager";
    private static final String DEFAULT_PICKING_MANAGER = "org.web3d.vrml.renderer.ogl.input.DefaultPickingManager";
    private static final String DEFAULT_SENSOR_MANAGER = "org.web3d.vrml.renderer.ogl.input.DefaultSensorManager";
    private static final String DEFAULT_EVENT_MODEL = "org.web3d.vrml.nodes.runtime.GeneralisedEventModelEvaluator";
    private static final String NOT_VP_MSG = "Referenced item is not a viewpoint";
    private static final String NO_SCRIPT_LOAD_MSG = "The class that you specificed for the script loader is not a  valid instance of ScriptLoader";
    private static final String NO_SCRIPT_MGR_MSG = "The class that you specificed for the script manager is not a valid instance of ScriptManager";
    private static final String NO_LOADER_LOAD_MSG = "The class that you specificed for the load manager is not a valid instance of ExternalLoadManager";
    private static final String NO_ROUTER_LOAD_MSG = "The class that you specificed for the router factory is not a valid instance of RouterFactory";
    private static final String NO_ROUTER_MGR_MSG = "The class that you specificed for the router manager is not a valid instance of RouteManager";
    private static final String NO_STATE_MGR_MSG = "The class that you specificed for the frame state manager is not a valid instance of FrameStateManager";
    private static final String NO_SENSOR_MGR_MSG = "The class that you specificed for the sensor manager is not a valid instance of OGLSensorManager";
    private static final String NO_EVENT_MODEL_MSG = "The class that you specificed for the event model is not a valid instance of EventModelEvaluator";
    private static final String NO_PICKING_MGR_MSG = "The class that you specificed for the sensor manager is not a valid instance of OGLPickingManager";
    private static final String NO_NETWORK_MGR_MSG = "The class that you specificed for the sensor manager is not a valid instance of NetworkManager";
    private static final String NO_HANIM_MGR_MSG = "The class that you specificed for the hanim manager is not a valid instance of HAnimManager";
    private static final String NO_PHYSICS_MGR_MSG = "The class that you specificed for the physics manager is not a valid instance of PhysicsManager";
    private static final String NO_PARTICLE_MGR_MSG = "The class that you specificed for the particle manager is not a valid instance of ParticleManager";
    private static final String SEND_LINK_MSG = "There was an error sending the link changed notification";
    private OGLVRMLUniverse universe;
    private ScriptManager scriptManager;
    private FrameStateManager stateManager;
    private ExternalLoadManager loadManager;
    private ScriptLoader s_loader;
    private NetworkManager networkManager;
    private NodeManager hanimManager;
    private NodeManager physicsManager;
    private NodeManager particleManager;
    private RouteManager routeManager;
    private OGLSensorManager sensorManager;
    private PickingManager pickingManager;
    private EventModelEvaluator eventModel;
    private WorldLoaderManager worldLoader;
    private HashMap viewpointDefMap;
    private ErrorReporter errorReporter;
    private boolean vrml97Only;
    private DrawableSurface surface;
    private SingleThreadRenderManager sceneManager;
    private DefaultRenderPipeline pipeline;
    private AudioDevice adevice;
    private DefaultAudioPipeline audioPipeline;
    private ViewpointManager viewpointManager;
    private int frame_millis;
    static final int PAUSED_FPS = 4;

    public OGLBrowserCanvas(DrawableSurface drawableSurface, boolean bl) {
        this.vrml97Only = bl;
        this.surface = drawableSurface;
        this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        Runtime runtime = Runtime.getRuntime();
        runtime.addShutdownHook(new Thread(this));
    }

    public void setSurface(DrawableSurface drawableSurface) {
        this.surface = drawableSurface;
        this.pipeline.setDrawableSurface(drawableSurface);
        this.sceneManager.setDrawableSurface(drawableSurface);
        if (drawableSurface instanceof ElumensAWTSurface) {
            this.universe.setHardwareFOV(180.0f);
        } else {
            this.universe.setHardwareFOV(0.0f);
        }
        Component component = (Component)drawableSurface.getSurfaceObject();
        component.addComponentListener(this);
        InputDeviceManager inputDeviceManager = new InputDeviceManager("aviatrix3d", component, (Object)drawableSurface);
        if (this.sensorManager != null) {
            this.sensorManager.setInputManager(inputDeviceManager);
        }
    }

    public void run() {
        this.shutdownApp();
    }

    public void deviceOver(int n, String string) {
    }

    public void deviceNotOver(int n) {
    }

    public void deviceActivated(int n) {
    }

    public void linkActivated(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].charAt(0) == '#') {
                String string = stringArray[i].substring(1);
                VRMLBindableNodeType vRMLBindableNodeType = (VRMLBindableNodeType)this.viewpointDefMap.get(string);
                if (vRMLBindableNodeType != null) {
                    VRMLClock vRMLClock = this.universe.getVRMLClock();
                    vRMLBindableNodeType.setBind(true, true, vRMLClock.getTime());
                    continue;
                }
                this.errorReporter.warningReport(NOT_VP_MSG, null);
                continue;
            }
            System.out.println("Warning only loading the first URL");
            this.loadWorld(stringArray[0]);
        }
    }

    public void browserShutdown() {
        this.sceneManager.setMinimumFrameInterval(250);
        this.viewpointDefMap.clear();
    }

    public void browserDisposed() {
        this.shutdownApp();
    }

    public void urlLoadFailed(String string) {
    }

    public void browserInitialized(VRMLScene vRMLScene) {
        Map map = vRMLScene.getDEFNodes();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object v = map.get(string);
            if (!(v instanceof VRMLViewpointNodeType)) continue;
            this.viewpointDefMap.put(string, v);
        }
        if (this.frame_millis < 0) {
            this.sceneManager.setMinimumFrameInterval(20);
        } else {
            this.sceneManager.setMinimumFrameInterval(this.frame_millis);
        }
    }

    public void initialize() {
        Object object;
        DISProtocolHandler dISProtocolHandler;
        String[] stringArray = (String[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String[] stringArray = new String[]{System.getProperty(OGLBrowserCanvas.SCRIPT_LOADER_PROP, OGLBrowserCanvas.DEFAULT_SCRIPT_LOADER), System.getProperty(OGLBrowserCanvas.SCRIPT_MANAGER_PROP, OGLBrowserCanvas.DEFAULT_SCRIPT_MANAGER), System.getProperty(OGLBrowserCanvas.FILE_LOADER_PROP, OGLBrowserCanvas.DEFAULT_EXTERNAL), System.getProperty(OGLBrowserCanvas.ROUTER_FACTORY_PROP, OGLBrowserCanvas.DEFAULT_ROUTER_FACTORY), System.getProperty(OGLBrowserCanvas.ROUTER_MANAGER_PROP, OGLBrowserCanvas.DEFAULT_ROUTER_MANAGER), System.getProperty(OGLBrowserCanvas.STATE_MANAGER_PROP, OGLBrowserCanvas.DEFAULT_STATE_MANAGER), System.getProperty("org.web3d.xj3d.sensor.manager.class", OGLBrowserCanvas.DEFAULT_SENSOR_MANAGER), System.getProperty("org.web3d.xj3d.sensor.manager.class", OGLBrowserCanvas.DEFAULT_PICKING_MANAGER), System.getProperty(OGLBrowserCanvas.EVENT_MODEL_PROP, OGLBrowserCanvas.DEFAULT_EVENT_MODEL), System.getProperty(OGLBrowserCanvas.NETWORK_MANAGER_PROP, OGLBrowserCanvas.DEFAULT_NETWORK_MANAGER), System.getProperty(OGLBrowserCanvas.HANIM_MANAGER_PROP, OGLBrowserCanvas.DEFAULT_HANIM_MANAGER), System.getProperty(OGLBrowserCanvas.PHYSICS_MANAGER_PROP, OGLBrowserCanvas.DEFAULT_PHYSICS_MANAGER), System.getProperty(OGLBrowserCanvas.PARTICLE_MANAGER_PROP, OGLBrowserCanvas.DEFAULT_PARTICLE_MANAGER)};
                return stringArray;
            }
        });
        RouterFactory routerFactory = null;
        int n = 0;
        this.s_loader = (ScriptLoader)this.loadClass(stringArray[0], true, NO_SCRIPT_LOAD_MSG);
        this.scriptManager = (ScriptManager)this.loadClass(stringArray[1], true, NO_SCRIPT_MGR_MSG);
        this.loadManager = (ExternalLoadManager)this.loadClass(stringArray[2], true, NO_LOADER_LOAD_MSG);
        routerFactory = (RouterFactory)this.loadClass(stringArray[3], true, NO_ROUTER_LOAD_MSG);
        this.routeManager = (RouteManager)this.loadClass(stringArray[4], true, NO_ROUTER_MGR_MSG);
        this.stateManager = (FrameStateManager)this.loadClass(stringArray[5], true, NO_STATE_MGR_MSG);
        this.sensorManager = (OGLSensorManager)this.loadClass(stringArray[6], true, NO_SENSOR_MGR_MSG);
        this.pickingManager = (PickingManager)this.loadClass(stringArray[7], false, NO_PICKING_MGR_MSG);
        this.eventModel = (EventModelEvaluator)this.loadClass(stringArray[8], true, NO_EVENT_MODEL_MSG);
        this.networkManager = (NetworkManager)this.loadClass(stringArray[9], false, NO_NETWORK_MGR_MSG);
        if (this.networkManager != null) {
            ++n;
        }
        this.hanimManager = (DefaultHumanoidManager)this.loadClass(stringArray[10], false, NO_HANIM_MGR_MSG);
        if (this.hanimManager != null) {
            ++n;
        }
        this.physicsManager = (DefaultRigidBodyPhysicsManager)this.loadClass(stringArray[11], false, NO_PHYSICS_MGR_MSG);
        if (this.physicsManager != null) {
            ++n;
        }
        this.particleManager = (DefaultParticleSystemManager)this.loadClass(stringArray[12], false, NO_PARTICLE_MGR_MSG);
        if (this.particleManager != null) {
            ++n;
        }
        this.setupAviatrix();
        if (this.surface != null) {
            dISProtocolHandler = (DISProtocolHandler)this.surface.getSurfaceObject();
            dISProtocolHandler.addComponentListener(this);
            object = new InputDeviceManager("aviatrix3d", (Component)dISProtocolHandler, (Object)this.surface);
            dISProtocolHandler.addKeyListener((KeyListener)object);
            if (this.sensorManager != null) {
                this.sensorManager.setInputManager((InputDeviceManager)object);
                this.sensorManager.setPickingManager(this.pickingManager);
            }
        } else if (this.sensorManager != null) {
            this.sensorManager.setPickingManager(this.pickingManager);
        }
        if (this.networkManager != null) {
            try {
                dISProtocolHandler = new DISProtocolHandler();
                this.networkManager.addProtocolHandler((NetworkProtocolHandler)dISProtocolHandler);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                this.errorReporter.warningReport("DISProtocol handler not found", null);
            }
        }
        dISProtocolHandler = new NodeManager[n];
        n = 0;
        if (this.networkManager != null) {
            dISProtocolHandler[n++] = this.networkManager;
        }
        if (this.hanimManager != null) {
            dISProtocolHandler[n++] = this.hanimManager;
        }
        if (this.physicsManager != null) {
            dISProtocolHandler[n++] = this.physicsManager;
        }
        if (this.particleManager != null) {
            dISProtocolHandler[n++] = this.particleManager;
        }
        this.viewpointManager = new GeneralisedViewpointManager();
        this.routeManager.setRouterFactory(routerFactory);
        this.scriptManager.setScriptLoader(this.s_loader);
        if (this.scriptManager == null || this.routeManager == null || this.sensorManager == null || this.stateManager == null || this.loadManager == null) {
            throw new InvalidConfigurationException("Missing required Manager");
        }
        this.eventModel.initialize(this.scriptManager, this.routeManager, (SensorManager)this.sensorManager, this.stateManager, this.loadManager, this.viewpointManager, (NodeManager[])dISProtocolHandler);
        this.universe = new OGLVRMLUniverse(this.eventModel, (RenderPipelineManager)this.sceneManager);
        this.universe.addSensorStatusListener(this);
        this.universe.addCoreListener(this);
        this.viewpointDefMap = new HashMap();
        object = new OGLSceneBuilderFactory(this.vrml97Only, true, true, true, true, true, true);
        VRMLParserFactory vRMLParserFactory = null;
        try {
            vRMLParserFactory = VRMLParserFactory.newVRMLParserFactory();
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            throw new RuntimeException("Failed to load factory");
        }
        this.worldLoader = new DefaultWorldLoaderManager(this.stateManager);
        this.worldLoader.setErrorReporter(this.errorReporter);
        this.worldLoader.registerBuilderFactory(3, (SceneBuilderFactory)object);
        this.worldLoader.registerParserFactory(3, vRMLParserFactory);
    }

    public void setEnabled(boolean bl) {
        this.sceneManager.setEnabled(bl);
    }

    public void setMinimumFrameInterval(int n) {
        this.sceneManager.setMinimumFrameInterval(n);
        this.frame_millis = n;
    }

    public void loadWorld(String string) {
        Object object;
        WorldLoader worldLoader = this.worldLoader.fetchLoader();
        VRMLScene vRMLScene = null;
        try {
            object = new InputSource(string);
            vRMLScene = worldLoader.loadNow((BrowserCore)this.universe, (InputSource)object);
        }
        catch (Exception exception) {
            this.errorReporter.errorReport("Failed to load ", exception);
            this.worldLoader.releaseLoader(worldLoader);
            return;
        }
        this.worldLoader.releaseLoader(worldLoader);
        object = null;
        int n = string.indexOf("#");
        if (n > -1) {
            object = string.substring(n + 1);
        }
        this.universe.setScene(vRMLScene, (String)object);
        this.viewpointDefMap.clear();
        Map map = vRMLScene.getDEFNodes();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            Object v = map.get(string2);
            if (!(v instanceof VRMLViewpointNodeType)) continue;
            this.viewpointDefMap.put(string2, v);
        }
    }

    public ScriptManager getScriptManager() {
        return this.scriptManager;
    }

    public ViewpointManager getViewpointManager() {
        return this.viewpointManager;
    }

    public ExternalLoadManager getExternalLoadManager() {
        return this.loadManager;
    }

    public RouteManager getRouteManager() {
        return this.routeManager;
    }

    public SensorManager getSensorManager() {
        return this.sensorManager;
    }

    public WorldLoaderManager getWorldLoaderManager() {
        return this.worldLoader;
    }

    public FrameStateManager getFrameStateManager() {
        return this.stateManager;
    }

    public EventModelEvaluator getEventModelEvaluator() {
        return this.eventModel;
    }

    public OGLVRMLUniverse getUniverse() {
        return this.universe;
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter == null ? new DefaultErrorReporter() : errorReporter;
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.universe.forceRender();
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    private void setupAviatrix() {
        StateAndTransparencyDepthSortStage stateAndTransparencyDepthSortStage = new StateAndTransparencyDepthSortStage();
        SimpleFrustumCullStage simpleFrustumCullStage = new SimpleFrustumCullStage();
        simpleFrustumCullStage.setOffscreenCheckEnabled(true);
        this.pipeline = new DefaultRenderPipeline();
        this.pipeline.setCuller((CullStage)simpleFrustumCullStage);
        this.pipeline.setSorter((SortStage)stateAndTransparencyDepthSortStage);
        this.pipeline.setDrawableSurface(this.surface);
        this.adevice = new OpenALAudioDevice();
        NullAudioCullStage nullAudioCullStage = new NullAudioCullStage();
        NullAudioSortStage nullAudioSortStage = new NullAudioSortStage();
        this.audioPipeline = new DefaultAudioPipeline();
        this.audioPipeline.setCuller((AudioCullStage)nullAudioCullStage);
        this.audioPipeline.setSorter((AudioSortStage)nullAudioSortStage);
        this.audioPipeline.setAudioDevice(this.adevice);
        this.sceneManager = new SingleThreadRenderManager();
        this.sceneManager.addPipeline((RenderPipeline)this.pipeline);
        this.sceneManager.setDrawableSurface(this.surface);
        this.sceneManager.addAudioPipeline((AudioPipeline)this.audioPipeline);
        this.sceneManager.setAudioDevice(this.adevice);
        this.sceneManager.setMinimumFrameInterval(2000);
    }

    private Object loadClass(final String string, final boolean bl, final String string2) {
        Object t = AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Class<?> clazz = Class.forName(string);
                    return clazz.newInstance();
                }
                catch (Error error) {
                    if (bl) {
                        Exception exception = new Exception(error.getMessage(), error);
                        OGLBrowserCanvas.this.errorReporter.errorReport(string2, exception);
                    } else {
                        OGLBrowserCanvas.this.errorReporter.warningReport(string2, null);
                    }
                }
                catch (Exception exception) {
                    if (bl) {
                        OGLBrowserCanvas.this.errorReporter.errorReport(string2, exception);
                    }
                    OGLBrowserCanvas.this.errorReporter.warningReport(string2, null);
                }
                return null;
            }
        });
        return t;
    }

    private void shutdownApp() {
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.loadManager.shutdown();
        if (this.s_loader != null) {
            this.s_loader.shutdown();
        }
        this.eventModel.shutdown();
        this.adevice.dispose();
        this.sceneManager.shutdown();
        this.surface.dispose();
        this.pipeline.halt();
        this.audioPipeline.halt();
    }
}

