/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.ogl.browser;

import java.awt.Rectangle;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import org.j3d.aviatrix3d.BoundingVolume;
import org.j3d.aviatrix3d.Group;
import org.j3d.aviatrix3d.Node;
import org.j3d.aviatrix3d.NodeUpdateListener;
import org.j3d.aviatrix3d.Scene;
import org.j3d.aviatrix3d.SceneGraphObject;
import org.j3d.aviatrix3d.SceneGraphPath;
import org.j3d.aviatrix3d.SharedGroup;
import org.j3d.aviatrix3d.TransformGroup;
import org.j3d.aviatrix3d.ViewEnvironment;
import org.web3d.browser.BrowserCore;
import org.web3d.browser.BrowserCoreListener;
import org.web3d.browser.EventModelStatusListener;
import org.web3d.browser.NavigationStateListener;
import org.web3d.browser.SensorStatusListener;
import org.web3d.browser.ViewpointStatusListener;
import org.web3d.vrml.lang.BasicScene;
import org.web3d.vrml.lang.UnsupportedProfileException;
import org.web3d.vrml.lang.VRMLExecutionSpace;
import org.web3d.vrml.lang.VRMLNodeFactory;
import org.web3d.vrml.nodes.VRMLBackgroundNodeType;
import org.web3d.vrml.nodes.VRMLBindableNodeType;
import org.web3d.vrml.nodes.VRMLClock;
import org.web3d.vrml.nodes.VRMLFogNodeType;
import org.web3d.vrml.nodes.VRMLInlineNodeType;
import org.web3d.vrml.nodes.VRMLNavigationInfoNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.nodes.VRMLScene;
import org.web3d.vrml.nodes.VRMLViewpointNodeType;
import org.web3d.vrml.nodes.runtime.BindableNodeListener;
import org.web3d.vrml.nodes.runtime.BindableNodeManager;
import org.web3d.vrml.nodes.runtime.EventModelEvaluator;
import org.web3d.vrml.nodes.runtime.EventModelInitListener;
import org.web3d.vrml.nodes.runtime.SensorManager;
import org.web3d.vrml.renderer.DefaultNodeFactory;
import org.web3d.vrml.renderer.ogl.browser.GlobalEffectsGroup;
import org.web3d.vrml.renderer.ogl.browser.PerFrameManager;
import org.web3d.vrml.renderer.ogl.input.OGLSensorManager;
import org.web3d.vrml.renderer.ogl.input.OGLUserInputHandler;
import org.web3d.vrml.renderer.ogl.nodes.OGLVRMLNode;
import org.web3d.vrml.renderer.ogl.nodes.OGLViewpointNodeType;

public class OGLVRMLGroup
extends Group
implements BrowserCore,
BindableNodeListener,
EventModelInitListener,
NodeUpdateListener {
    private static final float INFINITE_VIS_LIMIT = 10000.0f;
    private static final int VP_TRANSITION_TIME = 2000;
    private String worldDescription;
    private VRMLScene currentScene;
    private VRMLScene nextScene;
    private VRMLExecutionSpace currentSpace;
    private Map defMap;
    private ViewEnvironment viewEnvironment;
    private OGLViewpointNodeType currentViewpoint;
    private VRMLNavigationInfoNodeType currentNavInfo;
    private Group worldGroup;
    private TransformGroup sgTransformGroup;
    private Group commonSceneGraph;
    private BindableNodeManager viewpointStack;
    private BindableNodeManager navInfoStack;
    private BindableNodeManager backgroundStack;
    private BindableNodeManager fogStack;
    private ArrayList viewList;
    private Scene globalScene;
    private GlobalEffectsGroup globalEffects;
    private VRMLNodeFactory nodeFactory;
    private PerFrameManager frameManager;
    private EventModelEvaluator eventModel;
    private OGLUserInputHandler userInput;
    private OGLSensorManager sensorManager;
    private boolean inSetup;
    private ArrayList coreListeners;
    private float fieldOfView;
    private ArrayList pathList;
    private Node[] pathNodes;
    private TransformGroup vpTransformGroup;
    private Matrix4f vpMatrix;
    private long lastRenderTime;
    private Matrix4f oldTx;
    private Matrix4f destTx;
    private Matrix4f localTx;
    private static final float DEG_TO_RAD = 57.29578f;
    private float hardwareFOV;
    private ArrayList viewpointStatusListeners;
    private boolean isStatic;

    public OGLVRMLGroup(boolean bl, EventModelEvaluator eventModelEvaluator) {
        VRMLNodeFactory vRMLNodeFactory;
        this.isStatic = bl;
        this.eventModel = eventModelEvaluator;
        this.eventModel.setInitListener((EventModelInitListener)this);
        this.viewpointStack = new BindableNodeManager();
        this.navInfoStack = new BindableNodeManager();
        this.viewEnvironment = new ViewEnvironment();
        this.viewEnvironment.setAspectRatio(0.0);
        this.defMap = Collections.EMPTY_MAP;
        this.coreListeners = new ArrayList();
        if (!this.isStatic) {
            this.viewpointStatusListeners = new ArrayList(1);
            this.viewList = new ArrayList();
        }
        this.pathList = new ArrayList();
        this.pathNodes = new Node[20];
        this.oldTx = new Matrix4f();
        this.destTx = new Matrix4f();
        this.localTx = new Matrix4f();
        this.vpMatrix = new Matrix4f();
        this.fieldOfView = 0.0f;
        this.hardwareFOV = 0.0f;
        this.globalScene = new Scene();
        this.globalScene.setViewEnvironment(this.viewEnvironment);
        this.globalEffects = new GlobalEffectsGroup(this.globalScene);
        SensorManager sensorManager = this.eventModel.getSensorManager();
        if (!(sensorManager instanceof OGLSensorManager)) {
            throw new IllegalArgumentException("Not an OpenGL sensor manager");
        }
        this.sensorManager = (OGLSensorManager)sensorManager;
        this.sensorManager.setGlobalEffectsHandler(this.globalEffects);
        this.sensorManager.setViewEnvironment(this.viewEnvironment);
        this.userInput = (OGLUserInputHandler)this.sensorManager.getUserInputHandler();
        this.nodeFactory = vRMLNodeFactory = DefaultNodeFactory.createFactory((String)"ogl");
        try {
            vRMLNodeFactory.setSpecVersion(3, 1);
            vRMLNodeFactory.setProfile("Interactive");
            vRMLNodeFactory.addComponent("EnvironmentalEffects", 2);
        }
        catch (UnsupportedProfileException unsupportedProfileException) {
            // empty catch block
        }
        OGLViewpointNodeType oGLViewpointNodeType = (OGLViewpointNodeType)vRMLNodeFactory.createVRMLNode("Viewpoint", false);
        oGLViewpointNodeType.setDescription("Default viewpoint");
        oGLViewpointNodeType.setupFinished();
        VRMLNavigationInfoNodeType vRMLNavigationInfoNodeType = (VRMLNavigationInfoNodeType)vRMLNodeFactory.createVRMLNode("NavigationInfo", false);
        vRMLNavigationInfoNodeType.setupFinished();
        VRMLBackgroundNodeType vRMLBackgroundNodeType = (VRMLBackgroundNodeType)vRMLNodeFactory.createVRMLNode("Background", false);
        vRMLBackgroundNodeType.setupFinished();
        VRMLFogNodeType vRMLFogNodeType = (VRMLFogNodeType)vRMLNodeFactory.createVRMLNode("Fog", false);
        vRMLFogNodeType.setFogType(0);
        vRMLFogNodeType.setupFinished();
        this.eventModel.setDefaultBindables((VRMLViewpointNodeType)oGLViewpointNodeType, vRMLNavigationInfoNodeType, vRMLBackgroundNodeType, vRMLFogNodeType);
        this.viewpointStack = this.eventModel.getBindableManager(55);
        this.navInfoStack = this.eventModel.getBindableManager(31);
        this.backgroundStack = this.eventModel.getBindableManager(4);
        this.fogStack = this.eventModel.getBindableManager(18);
        Node node = (Node)oGLViewpointNodeType.getSceneGraphObject();
        this.commonSceneGraph = new Group();
        this.commonSceneGraph.addChild((Node)this.globalEffects);
        this.worldGroup = this;
        this.sgTransformGroup = new TransformGroup();
        this.sgTransformGroup.addChild(node);
        this.vpTransformGroup = (TransformGroup)node;
        this.worldGroup.addChild((Node)this.commonSceneGraph);
        this.worldGroup.addChild((Node)this.sgTransformGroup);
        this.globalScene.setRenderedGeometry(this.worldGroup);
        this.globalEffects.initialize();
        this.viewpointStack.setNodeChangeListener((BindableNodeListener)this);
        this.navInfoStack.setNodeChangeListener((BindableNodeListener)this);
        this.inSetup = false;
    }

    public void setHardwareFOV(float f) {
        this.hardwareFOV = f;
    }

    public Scene getRendererScene() {
        return this.globalScene;
    }

    public void worldInitComplete() {
        this.fireInitEvent();
        this.inSetup = false;
    }

    public void changeWorld() {
        if (this.isStatic) {
            return;
        }
        if (this.currentScene != null) {
            this.fireShutdownEvent();
            this.clearCurrentWorld();
        }
        this.currentScene = this.nextScene;
        if (this.currentScene == null) {
            return;
        }
        if (this.sgTransformGroup.isLive()) {
            this.sgTransformGroup.boundsChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeBoundsChanges(this.sgTransformGroup);
        }
    }

    public void newNodeBound(VRMLBindableNodeType vRMLBindableNodeType) {
        int n = vRMLBindableNodeType.getPrimaryType();
        if (vRMLBindableNodeType instanceof OGLViewpointNodeType) {
            this.changeViewpoints((OGLViewpointNodeType)vRMLBindableNodeType);
        } else if (vRMLBindableNodeType instanceof VRMLNavigationInfoNodeType) {
            this.changeNavInfo((VRMLNavigationInfoNodeType)vRMLBindableNodeType);
        }
    }

    public void bindableAdded(VRMLBindableNodeType vRMLBindableNodeType, boolean bl) {
        if (!(vRMLBindableNodeType instanceof VRMLViewpointNodeType)) {
            return;
        }
        int n = this.viewpointStatusListeners.size();
        for (int i = 0; i < n; ++i) {
            try {
                ViewpointStatusListener viewpointStatusListener = (ViewpointStatusListener)this.viewpointStatusListeners.get(i);
                viewpointStatusListener.viewpointAdded((VRMLViewpointNodeType)vRMLBindableNodeType, bl);
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error sending viewpoint list changed " + exception);
                exception.printStackTrace();
            }
        }
    }

    public void bindableRemoved(VRMLBindableNodeType vRMLBindableNodeType) {
        if (!(vRMLBindableNodeType instanceof VRMLViewpointNodeType)) {
            return;
        }
        int n = this.viewpointStatusListeners.size();
        for (int i = 0; i < n; ++i) {
            try {
                ViewpointStatusListener viewpointStatusListener = (ViewpointStatusListener)this.viewpointStatusListeners.get(i);
                viewpointStatusListener.viewpointRemoved((VRMLViewpointNodeType)vRMLBindableNodeType);
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error sending viewpoint list changed " + exception);
                exception.printStackTrace();
            }
        }
    }

    public int getRendererType() {
        return 3;
    }

    public String getIDString() {
        return "aviatrix3d";
    }

    public VRMLClock getVRMLClock() {
        return this.eventModel.getVRMLClock();
    }

    public Map getDEFMappings() {
        return this.defMap;
    }

    public VRMLExecutionSpace getWorldExecutionSpace() {
        return this.currentSpace;
    }

    public String getDescription() {
        return this.worldDescription;
    }

    public void setDescription(String string) {
        this.worldDescription = string;
    }

    public float getCurrentSpeed() {
        return 0.0f;
    }

    public float getCurrentFrameRate() {
        float f = (float)this.lastRenderTime / 1000.0f;
        return 1.0f / f;
    }

    public void setLastRenderTime(long l) {
        this.lastRenderTime = l;
    }

    public void setEventModelStatusListener(EventModelStatusListener eventModelStatusListener) {
        this.frameManager.setEventModelStatusListener(eventModelStatusListener);
    }

    public void addNavigationStateListener(NavigationStateListener navigationStateListener) {
        this.userInput.addNavigationStateListener(navigationStateListener);
    }

    public void removeNavigationStateListener(NavigationStateListener navigationStateListener) {
        this.userInput.removeNavigationStateListener(navigationStateListener);
    }

    public void addSensorStatusListener(SensorStatusListener sensorStatusListener) {
        this.userInput.addSensorStatusListener(sensorStatusListener);
    }

    public void removeSensorStatusListener(SensorStatusListener sensorStatusListener) {
        this.userInput.removeSensorStatusListener(sensorStatusListener);
    }

    public void addViewpointStatusListener(ViewpointStatusListener viewpointStatusListener) {
        if (viewpointStatusListener != null && !this.viewpointStatusListeners.contains(viewpointStatusListener)) {
            this.viewpointStatusListeners.add(viewpointStatusListener);
        }
    }

    public void removeViewpointStatusListener(ViewpointStatusListener viewpointStatusListener) {
        this.viewpointStatusListeners.remove(viewpointStatusListener);
    }

    public void dispose() {
        this.fireDisposeEvent();
    }

    public String getWorldURL() {
        String string = null;
        string = this.currentScene != null ? this.currentScene.getWorldRootURL() : (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("user.dir");
            }
        });
        return string;
    }

    public void setScene(VRMLScene vRMLScene, String string) {
        this.inSetup = true;
        if (!this.isLive()) {
            this.currentScene = vRMLScene;
            this.defMap = this.currentScene.getDEFNodes();
            OGLVRMLNode oGLVRMLNode = (OGLVRMLNode)this.currentScene.getRootNode();
            Group group = (Group)oGLVRMLNode.getSceneGraphObject();
            this.currentSpace = (VRMLExecutionSpace)oGLVRMLNode;
            this.userInput.setPickableScene(group);
            this.sensorManager.setWorldRoot(group);
            if (this.sgTransformGroup.getChild(1) != null) {
                this.sgTransformGroup.setChild((Node)group, 1);
            } else {
                this.sgTransformGroup.addChild((Node)group);
            }
            VRMLClock vRMLClock = this.eventModel.getVRMLClock();
            vRMLClock.resetTimeZero();
            this.eventModel.setScene(vRMLScene, string);
        } else if (!this.isStatic) {
            this.nextScene = vRMLScene;
            this.eventModel.setScene(vRMLScene, string);
        }
    }

    public void addCoreListener(BrowserCoreListener browserCoreListener) {
        if (browserCoreListener != null && !this.coreListeners.contains(browserCoreListener)) {
            this.coreListeners.add(browserCoreListener);
        }
    }

    public void removeCoreListener(BrowserCoreListener browserCoreListener) {
        this.coreListeners.remove(browserCoreListener);
    }

    public void sendURLFailEvent(String string) {
        this.fireFailedURL(string);
    }

    public void setNavigationMode(String string) {
        this.userInput.setNavigationMode(string);
    }

    public void fitToWorld(boolean bl) {
        this.vpMatrix.setIdentity();
        OGLVRMLNode oGLVRMLNode = (OGLVRMLNode)this.currentScene.getRootNode();
        Group group = (Group)oGLVRMLNode.getSceneGraphObject();
        float[] fArray = new float[3];
        BoundingVolume boundingVolume = group.getBounds();
        boundingVolume.getCenter(fArray);
        float[] fArray2 = new float[3];
        float[] fArray3 = new float[3];
        boundingVolume.getExtents(fArray2, fArray3);
        float f = Math.abs(fArray3[2] - fArray2[2]);
        float f2 = 1.0f;
        f2 = f > 1000.0f ? 1.25f : 2.0f;
        float f3 = fArray[2] + f * f2;
        this.vpMatrix.setTranslation(new Vector3f(fArray[0], fArray[1], f3));
        if (this.vpTransformGroup.isLive()) {
            this.vpTransformGroup.boundsChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeBoundsChanges(this.vpTransformGroup);
        }
    }

    public void updateNodeBoundsChanges(Object object) {
        if (object == this.sgTransformGroup) {
            if (this.nextScene != null) {
                this.defMap = this.currentScene.getDEFNodes();
                OGLVRMLNode oGLVRMLNode = (OGLVRMLNode)this.currentScene.getRootNode();
                Group group = (Group)oGLVRMLNode.getSceneGraphObject();
                this.currentSpace = (VRMLExecutionSpace)oGLVRMLNode;
                this.userInput.setPickableScene(group);
                this.sensorManager.setWorldRoot(group);
                if (this.sgTransformGroup.getChild(1) != null) {
                    this.sgTransformGroup.setChild((Node)group, 1);
                } else {
                    this.sgTransformGroup.addChild((Node)group);
                }
                VRMLClock vRMLClock = this.eventModel.getVRMLClock();
                vRMLClock.resetTimeZero();
                this.nextScene = null;
            }
        } else if (this.vpTransformGroup == object) {
            this.vpTransformGroup.setTransform(this.vpMatrix);
        } else {
            ((Group)object).removeAllChildren();
        }
    }

    public void updateNodeDataChanges(Object object) {
    }

    public void setViewport(Rectangle rectangle) {
        this.viewEnvironment.setViewport(rectangle);
    }

    public VRMLNodeFactory getNodeFactory() {
        return this.nodeFactory;
    }

    public VRMLScene getScene() {
        return this.currentScene;
    }

    public VRMLViewpointNodeType getViewpoint() {
        return this.currentViewpoint;
    }

    public void setPerFrameManager(PerFrameManager perFrameManager) {
        this.frameManager = perFrameManager;
    }

    private void clearCurrentWorld() {
        this.currentSpace = null;
        OGLVRMLNode oGLVRMLNode = (OGLVRMLNode)this.currentScene.getRootNode();
        Group group = (Group)oGLVRMLNode.getSceneGraphObject();
        if (this.sgTransformGroup.isLive()) {
            this.sgTransformGroup.boundsChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeBoundsChanges(this.sgTransformGroup);
        }
        this.eventModel.clear();
        this.clearInlines((BasicScene)this.currentScene);
        this.userInput.setPickableScene(null);
        this.userInput.setViewInfo(null, null, null);
    }

    private void changeViewpoints(OGLViewpointNodeType oGLViewpointNodeType) {
        Matrix4f matrix4f;
        if (oGLViewpointNodeType.getJump() || this.inSetup) {
            this.currentViewpoint = oGLViewpointNodeType;
            this.vpTransformGroup = this.currentViewpoint.getPlatformGroup();
            matrix4f = this.currentViewpoint.getViewTransform();
            if (this.vpTransformGroup.isLive()) {
                this.vpTransformGroup.boundsChanged((NodeUpdateListener)this);
            } else {
                this.updateNodeBoundsChanges(this.vpTransformGroup);
            }
            this.vpMatrix = matrix4f;
            if (this.hardwareFOV != 0.0f) {
                this.viewEnvironment.setFieldOfView((double)this.hardwareFOV);
            } else if (this.fieldOfView == 0.0f) {
                this.viewEnvironment.setFieldOfView((double)(this.currentViewpoint.getFieldOfView() * 57.29578f));
            } else {
                this.viewEnvironment.setFieldOfView((double)(this.fieldOfView * 57.29578f));
            }
        } else {
            System.out.println("non-jump transistions not handled yet");
            this.currentViewpoint = oGLViewpointNodeType;
            this.vpTransformGroup = this.currentViewpoint.getPlatformGroup();
            matrix4f = this.currentViewpoint.getViewTransform();
            if (this.vpTransformGroup.isLive()) {
                this.vpTransformGroup.boundsChanged((NodeUpdateListener)this);
            } else {
                this.updateNodeBoundsChanges(this.vpTransformGroup);
            }
            this.vpMatrix = matrix4f;
            if (this.hardwareFOV != 0.0f) {
                this.viewEnvironment.setFieldOfView((double)this.hardwareFOV);
            } else if (this.fieldOfView == 0.0f) {
                this.viewEnvironment.setFieldOfView((double)(this.currentViewpoint.getFieldOfView() * 57.29578f));
            } else {
                this.viewEnvironment.setFieldOfView((double)(this.fieldOfView * 57.29578f));
            }
        }
        matrix4f = this.generatePath((Node)this.vpTransformGroup);
        this.userInput.setViewInfo(this.currentViewpoint, this.vpTransformGroup, (SceneGraphPath)matrix4f);
        if (this.currentNavInfo != null) {
            this.globalEffects.useHeadlight(this.currentNavInfo.getHeadlight());
        }
    }

    private void changeNavInfo(VRMLNavigationInfoNodeType vRMLNavigationInfoNodeType) {
        this.currentNavInfo = vRMLNavigationInfoNodeType;
        float f = this.currentNavInfo.getVisibilityLimit();
        if (f <= 0.0f) {
            f = 10000.0f;
        }
        float[] fArray = this.currentNavInfo.getAvatarSize();
        float f2 = fArray[0] / 2.0f;
        float f3 = f;
        if (this.viewEnvironment.getNearClipDistance() >= (double)f3) {
            this.viewEnvironment.setNearClipDistance((double)f2);
            this.viewEnvironment.setFarClipDistance((double)f3);
        } else {
            this.viewEnvironment.setFarClipDistance((double)f3);
            this.viewEnvironment.setNearClipDistance((double)f2);
        }
        this.globalEffects.useHeadlight(this.currentNavInfo.getHeadlight());
        this.userInput.setNavigationInfo(this.currentNavInfo);
    }

    private void clearInlines(BasicScene basicScene) {
        OGLVRMLNode oGLVRMLNode;
        int n;
        ArrayList arrayList = basicScene.getByPrimaryType(24);
        int n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            VRMLScene vRMLScene;
            oGLVRMLNode = (OGLVRMLNode)arrayList.get(n);
            SceneGraphObject sceneGraphObject = oGLVRMLNode.getSceneGraphObject();
            if (sceneGraphObject instanceof Node) {
                Node node = (Node)sceneGraphObject;
                if (node.isLive()) {
                    node.boundsChanged((NodeUpdateListener)this);
                } else {
                    this.updateNodeBoundsChanges(node);
                }
            }
            if ((vRMLScene = (VRMLScene)((VRMLInlineNodeType)oGLVRMLNode).getContainedScene()) == null) continue;
            this.clearInlines((BasicScene)vRMLScene);
        }
        arrayList = basicScene.getByPrimaryType(38);
        n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            oGLVRMLNode = (VRMLProtoInstance)arrayList.get(n);
            this.clearInlines(oGLVRMLNode.getContainedScene());
        }
    }

    private SceneGraphPath generatePath(Node node) {
        Node node2 = node.getParent();
        this.pathList.clear();
        while (node2 != null) {
            if (node2 instanceof SharedGroup) {
                SharedGroup sharedGroup = (SharedGroup)node2;
                if (sharedGroup.numParents() == 0) break;
                sharedGroup.getParents(this.pathNodes);
                node2 = this.pathNodes[0];
                this.pathList.add(node2);
                continue;
            }
            this.pathList.add(node2);
            node2 = node2.getParent();
        }
        this.oldTx.setIdentity();
        int n = this.pathList.size();
        if (this.pathNodes.length < n) {
            this.pathNodes = new Node[n];
        }
        for (int i = 0; i < n; ++i) {
            this.pathNodes[i] = (Node)this.pathList.get(n - i - 1);
        }
        return new SceneGraphPath(this.pathNodes, n, this.oldTx, this.oldTx);
    }

    private void getLocalToVworld(Node node, Matrix4f matrix4f) {
        int n;
        Node node2 = node.getParent();
        this.pathList.clear();
        if (node2 instanceof TransformGroup) {
            this.pathList.add(node2);
        }
        while (node2 != null) {
            if (node2 instanceof SharedGroup) {
                SharedGroup sharedGroup = (SharedGroup)node2;
                n = sharedGroup.numParents();
                if (n == 0) break;
                if (n > this.pathNodes.length) {
                    this.pathNodes = new Node[n];
                }
                sharedGroup.getParents(this.pathNodes);
                node2 = this.pathNodes[0];
                continue;
            }
            if (node2 instanceof TransformGroup) {
                this.pathList.add(node2);
            }
            node2 = node2.getParent();
        }
        int n2 = this.pathList.size();
        matrix4f.setIdentity();
        for (n = n2 - 1; n >= 0; --n) {
            TransformGroup transformGroup = (TransformGroup)this.pathList.get(n);
            transformGroup.getTransform(this.localTx);
            matrix4f.mul(this.localTx);
        }
    }

    private void fireInitEvent() {
        int n = this.coreListeners.size();
        for (int i = 0; i < n; ++i) {
            try {
                BrowserCoreListener browserCoreListener = (BrowserCoreListener)this.coreListeners.get(i);
                browserCoreListener.browserInitialized(this.currentScene);
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error sending init event " + exception);
                exception.printStackTrace();
            }
        }
    }

    private void fireFailedURL(String string) {
        int n = this.coreListeners.size();
        for (int i = 0; i < n; ++i) {
            try {
                BrowserCoreListener browserCoreListener = (BrowserCoreListener)this.coreListeners.get(i);
                browserCoreListener.urlLoadFailed(string);
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error sending init event " + exception);
                exception.printStackTrace();
            }
        }
    }

    private void fireShutdownEvent() {
        int n = this.coreListeners.size();
        for (int i = 0; i < n; ++i) {
            try {
                BrowserCoreListener browserCoreListener = (BrowserCoreListener)this.coreListeners.get(i);
                browserCoreListener.browserShutdown();
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error sending init event " + exception);
                exception.printStackTrace();
            }
        }
    }

    private void fireDisposeEvent() {
        int n = this.coreListeners.size();
        for (int i = 0; i < n; ++i) {
            try {
                BrowserCoreListener browserCoreListener = (BrowserCoreListener)this.coreListeners.get(i);
                browserCoreListener.browserDisposed();
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error sending init event " + exception);
                exception.printStackTrace();
            }
        }
    }
}

