/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.ogl.browser;

import org.web3d.browser.BrowserCore;
import org.web3d.browser.EventModelStatusListener;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.nodes.runtime.EventModelEvaluator;

public abstract class PerFrameManager {
    private static final String NULL_EVENT_MSG = "The event model instance provided is null";
    protected ErrorReporter errorReporter;
    protected EventModelEvaluator eventModel;
    protected long currentWallTime;
    protected long lastWallTime;
    protected BrowserCore browser;
    private EventModelStatusListener eventModelStatusListener;
    private long timingTotal;
    private int timingCount;

    public PerFrameManager(EventModelEvaluator eventModelEvaluator, BrowserCore browserCore, long l) throws IllegalArgumentException {
        if (eventModelEvaluator == null) {
            throw new IllegalArgumentException(NULL_EVENT_MSG);
        }
        this.eventModel = eventModelEvaluator;
        this.browser = browserCore;
        this.currentWallTime = this.lastWallTime = l;
        this.errorReporter = DefaultErrorReporter.getDefaultReporter();
    }

    public void setEventModelStatusListener(EventModelStatusListener eventModelStatusListener) {
        this.eventModelStatusListener = eventModelStatusListener;
    }

    public void clockTick(long l) {
        if (this.eventModelStatusListener != null) {
            this.eventModelStatusListener.preEventEvaluation();
        }
        this.currentWallTime = l;
        this.timingTotal += this.currentWallTime - this.lastWallTime;
        ++this.timingCount;
        if (this.timingCount % 10 == 0) {
            this.browser.setLastRenderTime(this.timingTotal / 10L);
            this.timingTotal = 0L;
            this.timingCount = 0;
        }
        this.lastWallTime = this.currentWallTime;
        this.eventModel.evaluate(this.currentWallTime);
        if (this.eventModelStatusListener != null) {
            this.eventModelStatusListener.postEventEvaluation();
        }
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
    }

    public void shutdown() {
    }
}

