/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.ogl.input;

import java.util.ArrayList;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.j3d.aviatrix3d.Group;
import org.j3d.aviatrix3d.Node;
import org.j3d.aviatrix3d.SharedGroup;
import org.j3d.aviatrix3d.SharedNode;
import org.j3d.aviatrix3d.Texture2D;
import org.j3d.aviatrix3d.TransformGroup;
import org.j3d.aviatrix3d.ViewEnvironment;
import org.j3d.util.MatrixUtils;
import org.web3d.vrml.nodes.VRMLBackgroundNodeType;
import org.web3d.vrml.nodes.VRMLClock;
import org.web3d.vrml.nodes.VRMLFogNodeType;
import org.web3d.vrml.nodes.VRMLNavigationInfoNodeType;
import org.web3d.vrml.nodes.VRMLNodeListener;
import org.web3d.vrml.renderer.common.input.BaseSensorManager;
import org.web3d.vrml.renderer.ogl.input.AreaManager;
import org.web3d.vrml.renderer.ogl.input.DefaultUserInputHandler;
import org.web3d.vrml.renderer.ogl.input.OGLGlobalEffectsHandler;
import org.web3d.vrml.renderer.ogl.input.OGLSensorManager;
import org.web3d.vrml.renderer.ogl.input.VisibilityManager;
import org.web3d.vrml.renderer.ogl.nodes.OGLBackgroundNodeType;
import org.web3d.vrml.renderer.ogl.nodes.OGLTransformNodeType;
import org.web3d.vrml.renderer.ogl.nodes.OGLUserData;
import org.web3d.vrml.renderer.ogl.nodes.OGLVRMLNode;
import org.web3d.vrml.renderer.ogl.nodes.OGLViewpointNodeType;

public class DefaultSensorManager
extends BaseSensorManager
implements OGLSensorManager {
    private static final Vector3f Z_AXIS = new Vector3f(0.0f, 0.0f, -1.0f);
    private OGLViewpointNodeType currentViewpoint;
    private OGLBackgroundNodeType currentBackground;
    private VRMLFogNodeType currentFog;
    private Matrix4f vpMatrix;
    private Matrix4f localMatrix;
    private Vector3f t3dPosition;
    private Point3f position;
    private Vector3f orientation;
    private AxisAngle4f oriAxisAngle;
    private VisibilityManager visibilityHandler;
    private OGLGlobalEffectsHandler globalEffects;
    private AreaManager areaHandler;
    private Texture2D[] tmpTextures;
    private boolean[] tmpTextureFlags;
    private float[] tmpColor;
    private float[] tmpAngle;
    private ArrayList pathList;
    private Node[] pathNodes;
    private MatrixUtils matrixUtils;

    public DefaultSensorManager() {
        this.inputHandler = new DefaultUserInputHandler();
        this.inputHandler.setVRMLClock((VRMLClock)this.timeSensors);
        this.matrixUtils = new MatrixUtils();
        this.vpMatrix = new Matrix4f();
        this.localMatrix = new Matrix4f();
        this.t3dPosition = new Vector3f();
        this.position = new Point3f();
        this.orientation = new Vector3f();
        this.oriAxisAngle = new AxisAngle4f();
        this.visibilityHandler = new VisibilityManager();
        this.areaHandler = new AreaManager();
        this.pathList = new ArrayList();
        this.pathNodes = new Node[20];
        this.tmpTextures = new Texture2D[6];
        this.tmpTextureFlags = new boolean[6];
        this.tmpColor = new float[24];
        this.tmpAngle = new float[7];
    }

    public void setGlobalEffectsHandler(OGLGlobalEffectsHandler oGLGlobalEffectsHandler) {
        this.globalEffects = oGLGlobalEffectsHandler;
    }

    public void setWorldRoot(Group group) {
        this.areaHandler.setWorldRoot(group);
        this.visibilityHandler.setWorldRoot(group);
    }

    public void setViewEnvironment(ViewEnvironment viewEnvironment) {
        this.visibilityHandler.setViewEnvironment(viewEnvironment);
    }

    public void setWorldScale(float f) {
        this.worldScale = f;
        this.invWorldScale = 1.0f / f;
        if (this.currentViewpoint != null) {
            this.currentViewpoint.setWorldScale(f);
        }
        this.visibilityHandler.setWorldScale(f);
    }

    public void processUserInput(long l) {
        VRMLFogNodeType vRMLFogNodeType;
        OGLBackgroundNodeType oGLBackgroundNodeType;
        OGLViewpointNodeType oGLViewpointNodeType;
        this.timeSensors.clockTick(l);
        if (!this.navigationEnabled) {
            return;
        }
        if (!this.initialised) {
            this.initialise();
        }
        if ((oGLViewpointNodeType = (OGLViewpointNodeType)this.viewStack.getBoundNode()) != this.currentViewpoint) {
            this.inputHandler.setCenterOfRotation(oGLViewpointNodeType.getCenterOfRotation());
            this.currentViewpoint = oGLViewpointNodeType;
            this.currentViewpoint.setWorldScale(this.worldScale);
        }
        if ((oGLBackgroundNodeType = (OGLBackgroundNodeType)this.backgroundStack.getBoundNode()) != this.currentBackground) {
            vRMLFogNodeType = oGLBackgroundNodeType.getBackgroundTextures();
            for (int i = 0; i < 6; ++i) {
                this.tmpTextureFlags[i] = true;
            }
            this.globalEffects.updateBackgroundTextures((Texture2D[])vRMLFogNodeType, this.tmpTextureFlags);
            this.backgroundSkyChanged = true;
            this.backgroundGroundChanged = true;
            this.updateBackgroundSphere(oGLBackgroundNodeType);
            if (this.currentBackground != null) {
                this.currentBackground.removeNodeListener((VRMLNodeListener)this.backgroundListener);
            }
            oGLBackgroundNodeType.addNodeListener((VRMLNodeListener)this.backgroundListener);
            this.currentBackground = oGLBackgroundNodeType;
        } else {
            if (oGLBackgroundNodeType.getChangedTextures(this.tmpTextures, this.tmpTextureFlags)) {
                this.globalEffects.updateBackgroundTextures(this.tmpTextures, this.tmpTextureFlags);
            }
            this.updateBackgroundSphere(this.currentBackground);
        }
        vRMLFogNodeType = (VRMLFogNodeType)this.fogStack.getBoundNode();
        float f = vRMLFogNodeType.getVisibilityRange();
        vRMLFogNodeType.getColor(this.tmpColor);
        int n = vRMLFogNodeType.getFogType();
        if (vRMLFogNodeType != this.currentFog) {
            this.globalEffects.enableFog(n);
            this.globalEffects.setFogDetails(f, this.tmpColor[0], this.tmpColor[1], this.tmpColor[2]);
            if (this.currentFog != null) {
                this.currentFog.removeNodeListener((VRMLNodeListener)this.fogListener);
            }
            vRMLFogNodeType.addNodeListener((VRMLNodeListener)this.fogListener);
            this.currentFog = vRMLFogNodeType;
        } else {
            if (this.fogTypeChanged) {
                this.globalEffects.enableFog(n);
            }
            if (this.fogDetailsChanged) {
                this.globalEffects.setFogDetails(f, this.tmpColor[0], this.tmpColor[1], this.tmpColor[2]);
            }
        }
        this.clearChangeFlags();
        if (this.inputManager != null) {
            this.inputManager.processTrackers();
            int n2 = this.inputManager.getKeyEvents(this.keyEvents);
            if (n2 != 0) {
                this.keySensors.sendEvents(this.keyEvents, n2);
            }
        }
        VRMLNavigationInfoNodeType vRMLNavigationInfoNodeType = (VRMLNavigationInfoNodeType)this.navInfoStack.getBoundNode();
        TransformGroup transformGroup = this.currentViewpoint.getPlatformGroup();
        this.getLocalToVworld((Node)transformGroup, this.vpMatrix, true);
        this.vpMatrix.transform(Z_AXIS, this.orientation);
        this.vpMatrix.get(this.t3dPosition);
        this.position.set((Tuple3f)this.t3dPosition);
        this.oriAxisAngle.set(this.vpMatrix);
        if (this.numVisibilityListeners > 0) {
            this.visibilityHandler.processFrame(this.position, this.oriAxisAngle, this.vpMatrix);
        }
        float f2 = vRMLNavigationInfoNodeType.getVisibilityLimit();
        float f3 = oGLViewpointNodeType.getFieldOfView();
        if (this.numAreaListeners > 0) {
            this.matrixUtils.inverse(this.vpMatrix, this.vpMatrix);
            this.areaHandler.processFrame(this.position, this.orientation, this.vpMatrix, f2, f3);
        }
        Group group = (Group)this.currentBackground.getSceneGraphObject();
        this.getLocalToVworld((Node)group, this.vpMatrix, false);
        if (this.globalEffects != null) {
            this.globalEffects.setBackgroundMatrix(this.vpMatrix);
        }
        group = (Group)((OGLVRMLNode)this.currentFog).getSceneGraphObject();
        this.getLocalToVworld((Node)group, this.vpMatrix, false);
        if (this.globalEffects != null) {
            this.globalEffects.setFogMatrix(this.vpMatrix);
        }
        if (this.pickManager != null) {
            this.pickManager.processPickSensors((double)l);
        }
    }

    public void updateViewMatrix() {
        if (this.globalEffects == null || this.currentViewpoint == null) {
            return;
        }
        TransformGroup transformGroup = this.currentViewpoint.getPlatformGroup();
        this.getLocalToVworld((Node)transformGroup, this.vpMatrix, true);
        this.globalEffects.setViewMatrix(this.vpMatrix);
    }

    private void updateBackgroundSphere(VRMLBackgroundNodeType vRMLBackgroundNodeType) {
        int n;
        if (this.backgroundGroundChanged) {
            n = vRMLBackgroundNodeType.getNumGroundColors();
            if (n * 3 > this.tmpColor.length) {
                this.tmpColor = new float[n * 3];
                this.tmpAngle = new float[n - 1];
            }
            if (n != 0) {
                vRMLBackgroundNodeType.getGroundValues(this.tmpColor, this.tmpAngle);
            }
            this.globalEffects.updateBackgroundGround(this.tmpColor, this.tmpAngle, n);
        }
        if (this.backgroundSkyChanged) {
            n = vRMLBackgroundNodeType.getNumSkyColors();
            if (n * 3 > this.tmpColor.length) {
                this.tmpColor = new float[n * 3];
                this.tmpAngle = new float[n - 1];
            }
            if (n != 0) {
                vRMLBackgroundNodeType.getSkyValues(this.tmpColor, this.tmpAngle);
            }
            this.globalEffects.updateBackgroundSky(this.tmpColor, this.tmpAngle, n);
        }
    }

    private void getLocalToVworld(Node node, Matrix4f matrix4f, boolean bl) {
        OGLUserData oGLUserData;
        Node node2 = node.getParent();
        this.pathList.clear();
        if (node instanceof TransformGroup) {
            if (bl) {
                oGLUserData = (OGLUserData)node.getUserData();
                if (oGLUserData != null) {
                    this.pathList.add(oGLUserData.owner);
                }
            } else {
                this.pathList.add(node);
            }
        }
        while (node2 != null) {
            int n;
            SharedGroup sharedGroup;
            if (node2 instanceof SharedGroup) {
                sharedGroup = (SharedGroup)node2;
                n = sharedGroup.numParents();
                if (n == 0) break;
                if (n > this.pathNodes.length) {
                    this.pathNodes = new Node[n];
                }
                sharedGroup.getParents(this.pathNodes);
                node2 = this.pathNodes[0];
                continue;
            }
            if (node2 instanceof SharedNode) {
                sharedGroup = (SharedNode)node2;
                n = sharedGroup.numParents();
                if (n == 0) break;
                if (n > this.pathNodes.length) {
                    this.pathNodes = new Node[n];
                }
                sharedGroup.getParents(this.pathNodes);
                node2 = this.pathNodes[0];
                continue;
            }
            if (node2 instanceof TransformGroup) {
                ((TransformGroup)node2).getTransform(this.localMatrix);
                if (bl) {
                    oGLUserData = (OGLUserData)node2.getUserData();
                    if (oGLUserData != null) {
                        this.pathList.add(oGLUserData.owner);
                    }
                } else {
                    this.pathList.add(node2);
                }
            }
            node2 = node2.getParent();
        }
        int n = this.pathList.size();
        matrix4f.setIdentity();
        for (int i = n - 1; i >= 0; --i) {
            OGLTransformNodeType oGLTransformNodeType;
            Object e = this.pathList.get(i);
            if (e instanceof OGLTransformNodeType) {
                oGLTransformNodeType = (OGLTransformNodeType)e;
                this.localMatrix.set(oGLTransformNodeType.getTransform());
            } else {
                oGLTransformNodeType = (TransformGroup)e;
                oGLTransformNodeType.getTransform(this.localMatrix);
            }
            matrix4f.mul(this.localMatrix);
        }
    }
}

