/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.ogl.nodes.cadgeometry;

import org.j3d.aviatrix3d.Group;
import org.j3d.aviatrix3d.Node;
import org.j3d.aviatrix3d.NodeUpdateListener;
import org.j3d.aviatrix3d.SceneGraphObject;
import org.j3d.aviatrix3d.SharedGroup;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.nodes.FrameStateListener;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.nodes.VRMLShapeNodeType;
import org.web3d.vrml.renderer.common.nodes.cadgeometry.BaseCADFace;
import org.web3d.vrml.renderer.ogl.nodes.OGLVRMLNode;

public class OGLCADFace
extends BaseCADFace
implements OGLVRMLNode,
NodeUpdateListener {
    private static final String BAD_PROTO_MSG = "The resolved proto instance is not a X3DChildNode type. Grouping nodes may only use ChildNode types for the children field.";
    private Group implGroup;
    private Node newShape;

    public OGLCADFace() {
        this.init();
    }

    public OGLCADFace(VRMLNodeType vRMLNodeType) {
        super(vRMLNodeType);
        this.init();
    }

    public void allEventsComplete() {
        if (this.implGroup.isLive()) {
            this.implGroup.boundsChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeBoundsChanges(this.implGroup);
        }
        super.allEventsComplete();
    }

    public void updateNodeBoundsChanges(Object object) {
        if (this.implGroup.numChildren() > 0) {
            this.implGroup.setChild(this.newShape, 1);
        } else {
            this.implGroup.addChild(this.newShape);
        }
    }

    public void updateNodeDataChanges(Object object) {
    }

    public void setupFinished() {
        Node node;
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        OGLVRMLNode oGLVRMLNode = null;
        if (this.pShape != null) {
            oGLVRMLNode = (OGLVRMLNode)this.pShape;
        } else if (this.vfShape != null) {
            oGLVRMLNode = (OGLVRMLNode)this.vfShape;
        }
        if (oGLVRMLNode != null && (node = (Node)oGLVRMLNode.getSceneGraphObject()) != null) {
            this.implGroup.addChild(node);
        }
    }

    public synchronized void notifyExternProtoLoaded(int n, VRMLNodeType vRMLNodeType) {
        if (!(vRMLNodeType instanceof VRMLShapeNodeType) && !(vRMLNodeType instanceof VRMLProtoInstance)) {
            throw new InvalidFieldValueException(BAD_PROTO_MSG);
        }
        if (this.inSetup) {
            return;
        }
        OGLVRMLNode oGLVRMLNode = (OGLVRMLNode)vRMLNodeType;
        oGLVRMLNode.setupFinished();
        Node node = (Node)oGLVRMLNode.getSceneGraphObject();
        if (node != null) {
            if (this.implGroup.isLive()) {
                this.newShape = node;
                this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
            } else {
                this.implGroup.addChild(node);
            }
        }
    }

    public SceneGraphObject getSceneGraphObject() {
        return this.implGroup;
    }

    private void init() {
        this.implGroup = new SharedGroup();
    }
}

