/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.ogl.nodes.cadgeometry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import javax.vecmath.Matrix4f;
import org.j3d.aviatrix3d.Node;
import org.j3d.aviatrix3d.NodeUpdateListener;
import org.j3d.aviatrix3d.SceneGraphObject;
import org.j3d.aviatrix3d.SharedGroup;
import org.j3d.aviatrix3d.TransformGroup;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.nodes.FrameStateListener;
import org.web3d.vrml.nodes.VRMLChildNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLPointingDeviceSensorNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.renderer.common.nodes.cadgeometry.BaseCADPart;
import org.web3d.vrml.renderer.ogl.nodes.OGLTransformNodeType;
import org.web3d.vrml.renderer.ogl.nodes.OGLUserData;
import org.web3d.vrml.renderer.ogl.nodes.OGLVRMLNode;

public class OGLCADPart
extends BaseCADPart
implements OGLVRMLNode,
NodeUpdateListener,
OGLTransformNodeType {
    private static final String BAD_PROTO_MSG = "The resolved proto instance is not a X3DChildNode type. Grouping nodes may only use ChildNode types for the children field.";
    private TransformGroup implGroup;
    private Node oglImplGroup;
    private HashMap oglChildMap;
    private LinkedList addedChildren;
    private LinkedList removedChildren;
    private boolean matrixChanged;
    protected ArrayList sensorList;

    public OGLCADPart() {
        this.init();
    }

    public OGLCADPart(VRMLNodeType vRMLNodeType) {
        super(vRMLNodeType);
        this.init();
    }

    public void allEventsComplete() {
        if (this.implGroup.isLive()) {
            this.implGroup.boundsChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeBoundsChanges(this.implGroup);
        }
        super.allEventsComplete();
    }

    public void updateNodeBoundsChanges(Object object) {
        Node node;
        int n;
        if (this.matrixChanged) {
            this.implGroup.setTransform(this.tmatrix);
            this.matrixChanged = false;
        }
        int n2 = this.removedChildren == null ? 0 : this.removedChildren.size();
        for (n = 0; n < n2; ++n) {
            node = (Node)this.removedChildren.get(n);
            this.implGroup.removeChild(node);
        }
        n2 = this.addedChildren == null ? 0 : this.addedChildren.size();
        for (n = 0; n < n2; ++n) {
            node = (Node)this.addedChildren.get(n);
            this.implGroup.addChild(node);
        }
        this.addedChildren.clear();
        this.removedChildren.clear();
    }

    public void updateNodeDataChanges(Object object) {
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        this.oglChildMap = new HashMap();
        this.implGroup = new TransformGroup();
        if (this.isStatic && this.shareCount == 0) {
            this.oglImplGroup = this.implGroup;
        } else {
            this.oglImplGroup = new SharedGroup();
            ((SharedGroup)this.oglImplGroup).addChild((Node)this.implGroup);
        }
        OGLUserData oGLUserData = new OGLUserData();
        this.implGroup.setUserData((Object)oGLUserData);
        oGLUserData.owner = this;
        if (!this.isStatic && this.sensorList.size() != 0) {
            oGLUserData.sensors = new VRMLPointingDeviceSensorNodeType[this.sensorList.size()];
            this.sensorList.toArray(oGLUserData.sensors);
        }
        this.sensorList = null;
        for (int i = 0; i < this.childCount; ++i) {
            OGLVRMLNode oGLVRMLNode = (OGLVRMLNode)this.vfChildren.get(i);
            Node node = (Node)oGLVRMLNode.getSceneGraphObject();
            if (node != null) {
                this.implGroup.addChild(node);
            }
            this.oglChildMap.put(oGLVRMLNode, node);
        }
        if (!this.isStatic) {
            this.removedChildren = new LinkedList();
            this.addedChildren = new LinkedList();
        }
        this.updateMatrix();
        this.implGroup.setTransform(this.tmatrix);
    }

    public synchronized void notifyExternProtoLoaded(int n, VRMLNodeType vRMLNodeType) {
        if (!(vRMLNodeType instanceof VRMLChildNodeType) && !(vRMLNodeType instanceof VRMLProtoInstance)) {
            throw new InvalidFieldValueException(BAD_PROTO_MSG);
        }
        if (this.inSetup) {
            return;
        }
        OGLVRMLNode oGLVRMLNode = (OGLVRMLNode)vRMLNodeType;
        oGLVRMLNode.setupFinished();
        Node node = (Node)oGLVRMLNode.getSceneGraphObject();
        this.oglChildMap.put(vRMLNodeType, node);
        if (node != null) {
            if (this.implGroup.isLive()) {
                if (this.addedChildren == null) {
                    this.addedChildren = new LinkedList();
                }
                this.addedChildren.add(node);
                this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
            } else {
                this.implGroup.addChild(node);
            }
        }
    }

    public SceneGraphObject getSceneGraphObject() {
        return this.oglImplGroup;
    }

    public Matrix4f getTransform() {
        return this.tmatrix;
    }

    protected void clearChildren() {
        int n = this.vfChildren.size();
        for (int i = 0; i < n; ++i) {
            OGLVRMLNode oGLVRMLNode = (OGLVRMLNode)this.vfChildren.get(i);
            Node node = (Node)this.oglChildMap.get(oGLVRMLNode);
            this.removedChildren.add(node);
            this.oglChildMap.remove(oGLVRMLNode);
        }
        if (!this.inSetup) {
            if (this.implGroup.isLive()) {
                this.implGroup.boundsChanged((NodeUpdateListener)this);
            } else {
                this.removedChildren.clear();
                this.implGroup.removeAllChildren();
            }
        }
        super.clearChildren();
    }

    protected void addChildNode(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        Object object;
        Node node;
        super.addChildNode(vRMLNodeType);
        OGLVRMLNode oGLVRMLNode = (OGLVRMLNode)vRMLNodeType;
        if (!this.inSetup) {
            node = (Node)oGLVRMLNode.getSceneGraphObject();
            this.oglChildMap.put(vRMLNodeType, node);
            if (this.implGroup.isLive()) {
                this.addedChildren.add(node);
                this.implGroup.boundsChanged((NodeUpdateListener)this);
            } else {
                this.implGroup.addChild(node);
            }
        }
        node = null;
        if (vRMLNodeType instanceof VRMLPointingDeviceSensorNodeType) {
            node = (VRMLPointingDeviceSensorNodeType)vRMLNodeType;
        } else if (vRMLNodeType instanceof VRMLProtoInstance && (object = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode()) instanceof VRMLPointingDeviceSensorNodeType) {
            node = (VRMLPointingDeviceSensorNodeType)object;
        }
        if (node != null) {
            if (this.inSetup) {
                this.sensorList.add(node);
            } else {
                object = (OGLUserData)this.implGroup.getUserData();
                if (object == null) {
                    object = new OGLUserData();
                    this.implGroup.setUserData(object);
                }
                if (object.sensors == null) {
                    object.sensors = new VRMLPointingDeviceSensorNodeType[1];
                    object.sensors[0] = node;
                } else {
                    int n = object.sensors.length;
                    VRMLPointingDeviceSensorNodeType[] vRMLPointingDeviceSensorNodeTypeArray = new VRMLPointingDeviceSensorNodeType[n + 1];
                    System.arraycopy(object.sensors, 0, vRMLPointingDeviceSensorNodeTypeArray, 0, n);
                    vRMLPointingDeviceSensorNodeTypeArray[n] = node;
                    object.sensors = vRMLPointingDeviceSensorNodeTypeArray;
                }
            }
        }
    }

    protected void removeChildNode(VRMLNodeType vRMLNodeType) {
        Object object;
        Node node;
        if (!this.oglChildMap.containsKey(vRMLNodeType)) {
            return;
        }
        if (!this.inSetup) {
            node = (Node)this.oglChildMap.get(vRMLNodeType);
            this.oglChildMap.remove(vRMLNodeType);
            if (this.implGroup.isLive()) {
                this.removedChildren.add(node);
                this.implGroup.boundsChanged((NodeUpdateListener)this);
            } else {
                this.implGroup.removeChild(node);
            }
        }
        node = null;
        if (vRMLNodeType instanceof VRMLPointingDeviceSensorNodeType) {
            node = (VRMLPointingDeviceSensorNodeType)vRMLNodeType;
        } else if (vRMLNodeType instanceof VRMLProtoInstance && (object = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode()) instanceof VRMLPointingDeviceSensorNodeType) {
            node = (VRMLPointingDeviceSensorNodeType)object;
        }
        if (node != null) {
            object = (OGLUserData)this.oglImplGroup.getUserData();
            int n = object.sensors.length;
            if (n == 1) {
                object.sensors = null;
            } else {
                int n2;
                for (n2 = 0; n2 < n && object.sensors[n2] != node; ++n2) {
                }
                while (n2 < n - 1) {
                    object.sensors[n2] = object.sensors[n2 + 1];
                    ++n2;
                }
                VRMLPointingDeviceSensorNodeType[] vRMLPointingDeviceSensorNodeTypeArray = new VRMLPointingDeviceSensorNodeType[n - 1];
                System.arraycopy(object.sensors, 0, vRMLPointingDeviceSensorNodeTypeArray, 0, n - 1);
                object.sensors = vRMLPointingDeviceSensorNodeTypeArray;
            }
        }
        super.removeChildNode(vRMLNodeType);
    }

    protected void updateMatrix() {
        super.updateMatrix();
        this.matrixChanged = true;
        if (this.implGroup != null) {
            if (this.implGroup.isLive()) {
                this.implGroup.boundsChanged((NodeUpdateListener)this);
            } else {
                this.updateNodeBoundsChanges(this.implGroup);
            }
        }
    }

    private void init() {
        this.sensorList = new ArrayList();
    }
}

