/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.ogl.nodes.cadgeometry;

import org.j3d.aviatrix3d.Geometry;
import org.j3d.aviatrix3d.NodeUpdateListener;
import org.j3d.aviatrix3d.QuadArray;
import org.j3d.aviatrix3d.SceneGraphObject;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.nodes.VRMLColorNodeType;
import org.web3d.vrml.nodes.VRMLCoordinateNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLNormalNodeType;
import org.web3d.vrml.nodes.VRMLTextureCoordinateNodeType;
import org.web3d.vrml.renderer.common.nodes.cadgeometry.BaseQuadSet;
import org.web3d.vrml.renderer.ogl.nodes.OGLGeometryNodeType;

public class OGLQuadSet
extends BaseQuadSet
implements OGLGeometryNodeType,
NodeUpdateListener {
    private QuadArray implGeom;
    private float[] tmpColors;
    private float[][] tmpTexCoords;
    private int[] tmpTexSets;
    private int[] tmpTexTypes;
    private boolean colorChanged;
    private boolean texCoordChanged;
    private boolean normalChanged;

    public OGLQuadSet() {
        this.init();
    }

    public OGLQuadSet(VRMLNodeType vRMLNodeType) {
        super(vRMLNodeType);
        this.init();
    }

    public void allEventsComplete() {
        if ((this.changeFlags & 1) != 0) {
            if (this.implGeom.isLive()) {
                this.implGeom.boundsChanged((NodeUpdateListener)this);
            } else {
                this.updateNodeBoundsChanges(this.implGeom);
            }
        }
        if ((this.changeFlags & 8) != 0 || (this.changeFlags & 2) != 0 || (this.changeFlags & 4) != 0) {
            if (this.implGeom.isLive()) {
                this.implGeom.dataChanged((NodeUpdateListener)this);
            } else {
                this.updateNodeDataChanges(this.implGeom);
            }
        }
        this.changeFlags = 0;
    }

    public Geometry getGeometry() {
        return this.implGeom;
    }

    public int getNumSets() {
        int n = 0;
        if (this.vfTexCoord != null) {
            n = this.vfTexCoord.getNumSets();
        }
        return n;
    }

    public String getTexCoordGenMode(int n) {
        String string = null;
        if (this.vfTexCoord != null) {
            string = this.vfTexCoord.getTexCoordGenMode(n);
        }
        return string;
    }

    public SceneGraphObject getSceneGraphObject() {
        return this.implGeom;
    }

    public synchronized void notifyExternProtoLoaded(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        if (this.inSetup) {
            return;
        }
        super.setComponent(vRMLNodeType);
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        int n = this.vfCoord == null ? 0 : this.vfCoord.getNumPoints();
        int n2 = this.vfColor == null ? 0 : this.vfColor.getNumColors();
        int n3 = this.vfNormal == null ? 0 : this.vfNormal.getNumNormals();
        int n4 = this.vfTexCoord == null ? 0 : this.vfTexCoord.getNumSets();
        this.tmpTexCoords = new float[n4][];
        this.tmpTexSets = new int[n4];
        this.tmpTexTypes = new int[n4];
        for (int i = 0; i < n4; ++i) {
            this.tmpTexCoords[i] = new float[this.vfTexCoord.getSize(i)];
        }
        this.tmpColors = new float[n2];
        this.colorChanged = true;
        this.normalChanged = true;
        this.texCoordChanged = true;
        this.updateNodeBoundsChanges(null);
        this.updateNodeDataChanges(null);
    }

    public void fieldChanged(VRMLNodeType vRMLNodeType, int n) {
        if (vRMLNodeType instanceof VRMLCoordinateNodeType) {
            if (this.implGeom.isLive()) {
                this.implGeom.boundsChanged((NodeUpdateListener)this);
            } else {
                this.updateNodeBoundsChanges(this.implGeom);
            }
        } else if (vRMLNodeType instanceof VRMLNormalNodeType) {
            this.normalChanged = true;
            if (this.implGeom.isLive()) {
                this.implGeom.dataChanged((NodeUpdateListener)this);
            } else {
                this.updateNodeDataChanges(this.implGeom);
            }
        } else if (vRMLNodeType instanceof VRMLColorNodeType) {
            this.colorChanged = true;
            if (this.implGeom.isLive()) {
                this.implGeom.dataChanged((NodeUpdateListener)this);
            } else {
                this.updateNodeDataChanges(this.implGeom);
            }
        } else if (vRMLNodeType instanceof VRMLTextureCoordinateNodeType) {
            this.texCoordChanged = true;
            if (this.implGeom.isLive()) {
                this.implGeom.dataChanged((NodeUpdateListener)this);
            } else {
                this.updateNodeDataChanges(this.implGeom);
            }
        }
    }

    protected void setCoordinateNode(VRMLCoordinateNodeType vRMLCoordinateNodeType) {
        if (this.inSetup) {
            return;
        }
        if (this.implGeom.isLive()) {
            this.implGeom.boundsChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeBoundsChanges(this.implGeom);
        }
    }

    protected void setColorNode(VRMLColorNodeType vRMLColorNodeType) {
        if (!this.inSetup) {
            return;
        }
        this.colorChanged = true;
        if (this.implGeom.isLive()) {
            this.implGeom.dataChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeDataChanges(this.implGeom);
        }
    }

    protected void setTextureCoordinateNode(VRMLTextureCoordinateNodeType vRMLTextureCoordinateNodeType) {
        if (this.inSetup) {
            return;
        }
        this.texCoordChanged = true;
        if (this.implGeom.isLive()) {
            this.implGeom.dataChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeDataChanges(this.implGeom);
        }
    }

    protected void setNormalNode(VRMLNormalNodeType vRMLNormalNodeType) {
        if (!this.inSetup) {
            return;
        }
        this.normalChanged = true;
        if (this.implGeom.isLive()) {
            this.implGeom.dataChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeDataChanges(this.implGeom);
        }
    }

    public void updateNodeBoundsChanges(Object object) {
        if (this.vfCoord == null) {
            this.implGeom.setValidVertexCount(0);
        } else {
            int n = this.vfCoord.getNumPoints();
            float[] fArray = this.vfCoord.getPointRef();
            this.implGeom.setVertices(3, fArray, n / 3);
        }
    }

    public void updateNodeDataChanges(Object object) {
        int n;
        int n2;
        if (this.colorChanged) {
            if (this.vfColor == null) {
                this.implGeom.setColors(false, null);
            } else {
                n2 = this.vfColor.getNumColorComponents() == 4 ? 1 : 0;
                n = this.vfColor.getNumColors();
                if (this.tmpColors.length < n) {
                    this.tmpColors = new float[n];
                }
                this.vfColor.getColor(this.tmpColors);
                this.implGeom.setColors(n2 != 0, this.tmpColors);
            }
            this.colorChanged = false;
        }
        if (this.texCoordChanged) {
            if (this.vfTexCoord == null) {
                this.implGeom.setTextureCoordinates(null, (float[][])null, 0);
            } else {
                n2 = this.vfTexCoord.getNumSets();
                for (n = 0; n < n2; ++n) {
                    this.tmpTexCoords[n] = new float[this.vfTexCoord.getSize(n)];
                    int n3 = this.vfTexCoord.getNumTextureComponents();
                    switch (n3) {
                        case 1: {
                            this.tmpTexTypes[n] = 1;
                            break;
                        }
                        case 2: {
                            this.tmpTexTypes[n] = 2;
                            break;
                        }
                        case 3: {
                            this.tmpTexTypes[n] = 3;
                            break;
                        }
                        case 4: {
                            this.tmpTexTypes[n] = 4;
                        }
                    }
                    int n4 = this.vfTexCoord.getSize(n);
                    if (this.tmpTexCoords[n].length < n4) {
                        this.tmpTexCoords[n] = new float[n4];
                    }
                    this.tmpTexSets[n] = this.vfTexCoord.isShared(n);
                    if (this.tmpTexSets[n] != n) continue;
                    this.vfTexCoord.getPoint(n, this.tmpTexCoords[n]);
                }
                this.implGeom.setTextureCoordinates(this.tmpTexTypes, this.tmpTexCoords, n2);
                this.implGeom.setTextureSetMap(this.tmpTexSets);
            }
            this.texCoordChanged = false;
        }
        if (this.normalChanged) {
            if (this.vfNormal == null) {
                this.implGeom.setNormals(null);
            } else {
                n2 = this.vfNormal.getNumNormals();
                float[] fArray = this.vfNormal.getVectorRef();
                this.implGeom.setNormals(fArray);
            }
            this.normalChanged = false;
        }
    }

    private void init() {
        this.implGeom = new QuadArray();
        this.colorChanged = false;
        this.normalChanged = false;
        this.texCoordChanged = false;
    }
}

