/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.ogl.nodes.environment;

import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.j3d.aviatrix3d.Geometry;
import org.j3d.aviatrix3d.NodeUpdateListener;
import org.j3d.aviatrix3d.QuadArray;
import org.j3d.aviatrix3d.SceneGraphObject;
import org.j3d.aviatrix3d.Shape3D;
import org.j3d.geom.GeometryData;
import org.j3d.util.MatrixUtils;
import org.web3d.vrml.nodes.FrameStateListener;
import org.web3d.vrml.nodes.VRMLClock;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.environment.BaseProximitySensor;
import org.web3d.vrml.renderer.ogl.nodes.OGLAreaListener;
import org.web3d.vrml.renderer.ogl.nodes.OGLGlobalStatus;
import org.web3d.vrml.renderer.ogl.nodes.OGLUserData;
import org.web3d.vrml.renderer.ogl.nodes.OGLVRMLNode;

public class OGLProximitySensor
extends BaseProximitySensor
implements OGLVRMLNode,
OGLAreaListener,
NodeUpdateListener {
    private Shape3D shape;
    private QuadArray geometry;
    private Matrix3f scale;
    private Vector3f translation;
    private Vector3f direction;
    private AxisAngle4f axisAngle;
    private GeometryData geomData;
    private Vector3f lastPosition;
    private AxisAngle4f lastOrientation;
    private static MatrixUtils matrixUtils = new MatrixUtils();
    private static Matrix4f tmpMatrix = new Matrix4f();

    public OGLProximitySensor() {
        this.init();
    }

    public OGLProximitySensor(VRMLNodeType vRMLNodeType) {
        super(vRMLNodeType);
        this.init();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (bl) {
            this.shape.setPickMask(8);
        } else {
            this.shape.setPickMask(0);
        }
    }

    public SceneGraphObject getSceneGraphObject() {
        return this.shape;
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        this.updateShape();
        this.shape.setPickMask(0);
    }

    public void areaEntry(Point3f point3f, Vector3f vector3f, Matrix4f matrix4f, Matrix4f matrix4f2) {
        this.vfEnterTime = this.vrmlClock.getTime();
        this.updatePositionOutputs(point3f, vector3f, matrix4f, matrix4f2, false);
        this.hasChanged[7] = true;
        this.fireFieldChanged(7);
        this.vfIsActive = true;
        this.hasChanged[4] = true;
        this.fireFieldChanged(4);
    }

    public void userPositionChanged(Point3f point3f, Vector3f vector3f, Matrix4f matrix4f, Matrix4f matrix4f2) {
        this.updatePositionOutputs(point3f, vector3f, matrix4f, matrix4f2, true);
    }

    public void areaExit() {
        this.vfExitTime = this.vrmlClock.getTime();
        this.hasChanged[8] = true;
        this.fireFieldChanged(8);
        this.vfIsActive = false;
        this.hasChanged[4] = true;
        this.fireFieldChanged(4);
    }

    public void setVRMLClock(VRMLClock vRMLClock) {
        super.setVRMLClock(vRMLClock);
        if (this.vfEnabled) {
            this.shape.setPickMask(8);
        } else {
            this.shape.setPickMask(0);
        }
    }

    protected void setSize(float[] fArray) {
        super.setSize(fArray);
        if (!this.inSetup) {
            this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
        }
    }

    protected void setCenter(float[] fArray) {
        super.setCenter(fArray);
        if (!this.inSetup) {
            this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
        }
    }

    public void allEventsComplete() {
        this.updateShape();
    }

    public void updateNodeBoundsChanges(Object object) {
        this.geometry.setVertices(3, this.geomData.coordinates, this.geomData.vertexCount);
    }

    public void updateNodeDataChanges(Object object) {
    }

    private void init() {
        this.scale = new Matrix3f();
        this.translation = new Vector3f();
        this.direction = new Vector3f();
        this.axisAngle = new AxisAngle4f();
        this.lastPosition = new Vector3f();
        this.lastOrientation = new AxisAngle4f();
        this.geomData = new GeometryData();
        this.geomData.geometryType = 2;
        this.geomData.coordinates = new float[72];
        this.geomData.vertexCount = 24;
        OGLUserData oGLUserData = new OGLUserData();
        oGLUserData.geometryData = this.geomData;
        oGLUserData.collidable = false;
        oGLUserData.isTerrain = false;
        oGLUserData.areaListener = this;
        this.geometry = new QuadArray();
        this.shape = new Shape3D();
        this.shape.setAppearance(OGLGlobalStatus.invisibleAppearance);
        this.shape.setGeometry((Geometry)this.geometry);
        this.shape.setUserData((Object)oGLUserData);
    }

    private void updateShape() {
        float[] fArray = this.geomData.coordinates;
        float f = this.vfSize[0] * 0.5f;
        float f2 = this.vfSize[1] * 0.5f;
        float f3 = this.vfSize[2] * 0.5f;
        fArray[0] = f + this.vfCenter[0];
        fArray[1] = -f2 + this.vfCenter[1];
        fArray[2] = f3 + this.vfCenter[2];
        fArray[3] = f + this.vfCenter[0];
        fArray[4] = f2 + this.vfCenter[1];
        fArray[5] = f3 + this.vfCenter[2];
        fArray[6] = -f + this.vfCenter[0];
        fArray[7] = f2 + this.vfCenter[1];
        fArray[8] = f3 + this.vfCenter[2];
        fArray[9] = -f + this.vfCenter[0];
        fArray[10] = -f2 + this.vfCenter[1];
        fArray[11] = f3 + this.vfCenter[2];
        fArray[12] = f + this.vfCenter[0];
        fArray[13] = -f2 + this.vfCenter[1];
        fArray[14] = -f3 + this.vfCenter[2];
        fArray[15] = f + this.vfCenter[0];
        fArray[16] = f2 + this.vfCenter[1];
        fArray[17] = -f3 + this.vfCenter[2];
        fArray[18] = f + this.vfCenter[0];
        fArray[19] = f2 + this.vfCenter[1];
        fArray[20] = f3 + this.vfCenter[2];
        fArray[21] = f + this.vfCenter[0];
        fArray[22] = -f2 + this.vfCenter[1];
        fArray[23] = f3 + this.vfCenter[2];
        fArray[24] = -f + this.vfCenter[0];
        fArray[25] = -f2 + this.vfCenter[1];
        fArray[26] = -f3 + this.vfCenter[2];
        fArray[27] = -f + this.vfCenter[0];
        fArray[28] = f2 + this.vfCenter[1];
        fArray[29] = -f3 + this.vfCenter[2];
        fArray[30] = f + this.vfCenter[0];
        fArray[31] = f2 + this.vfCenter[1];
        fArray[32] = -f3 + this.vfCenter[2];
        fArray[33] = f + this.vfCenter[0];
        fArray[34] = -f2 + this.vfCenter[1];
        fArray[35] = -f3 + this.vfCenter[2];
        fArray[36] = -f + this.vfCenter[0];
        fArray[37] = -f2 + this.vfCenter[1];
        fArray[38] = f3 + this.vfCenter[2];
        fArray[39] = -f + this.vfCenter[0];
        fArray[40] = f2 + this.vfCenter[1];
        fArray[41] = f3 + this.vfCenter[2];
        fArray[42] = -f + this.vfCenter[0];
        fArray[43] = f2 + this.vfCenter[1];
        fArray[44] = -f3 + this.vfCenter[2];
        fArray[45] = -f + this.vfCenter[0];
        fArray[46] = -f2 + this.vfCenter[1];
        fArray[47] = -f3 + this.vfCenter[2];
        fArray[48] = f + this.vfCenter[0];
        fArray[49] = f2 + this.vfCenter[1];
        fArray[50] = f3 + this.vfCenter[2];
        fArray[51] = f + this.vfCenter[0];
        fArray[52] = f2 + this.vfCenter[1];
        fArray[53] = -f3 + this.vfCenter[2];
        fArray[54] = -f + this.vfCenter[0];
        fArray[55] = f2 + this.vfCenter[1];
        fArray[56] = -f3 + this.vfCenter[2];
        fArray[57] = -f + this.vfCenter[0];
        fArray[58] = f2 + this.vfCenter[1];
        fArray[59] = f3 + this.vfCenter[2];
        fArray[60] = -f + this.vfCenter[0];
        fArray[61] = -f2 + this.vfCenter[1];
        fArray[62] = -f3 + this.vfCenter[2];
        fArray[63] = -f + this.vfCenter[0];
        fArray[64] = -f2 + this.vfCenter[1];
        fArray[65] = f3 + this.vfCenter[2];
        fArray[66] = f + this.vfCenter[0];
        fArray[67] = -f2 + this.vfCenter[1];
        fArray[68] = f3 + this.vfCenter[2];
        fArray[69] = f + this.vfCenter[0];
        fArray[70] = -f2 + this.vfCenter[1];
        fArray[71] = -f3 + this.vfCenter[2];
        if (this.geometry.isLive()) {
            this.geometry.boundsChanged((NodeUpdateListener)this);
        } else {
            this.geometry.setVertices(3, this.geomData.coordinates, this.geomData.vertexCount);
        }
    }

    private void updatePositionOutputs(Point3f point3f, Vector3f vector3f, Matrix4f matrix4f, Matrix4f matrix4f2, boolean bl) {
        tmpMatrix.mul(matrix4f, matrix4f2);
        matrixUtils.inverse(tmpMatrix, tmpMatrix);
        tmpMatrix.get(this.translation);
        this.axisAngle.set(tmpMatrix);
        if (!bl || !this.axisAngle.equals(this.lastOrientation)) {
            this.vfOrientationChanged[0] = this.axisAngle.x;
            this.vfOrientationChanged[1] = this.axisAngle.y;
            this.vfOrientationChanged[2] = this.axisAngle.z;
            this.vfOrientationChanged[3] = this.axisAngle.angle;
            this.hasChanged[6] = true;
            this.fireFieldChanged(6);
            this.lastOrientation.set(this.axisAngle);
        }
        if (!bl || !this.translation.equals((Tuple3f)this.lastPosition)) {
            this.vfPositionChanged[0] = this.translation.x;
            this.vfPositionChanged[1] = this.translation.y;
            this.vfPositionChanged[2] = this.translation.z;
            this.hasChanged[5] = true;
            this.fireFieldChanged(5);
            this.lastPosition.set((Tuple3f)this.translation);
        }
    }
}

