/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.ogl.nodes.geom3d;

import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import org.j3d.aviatrix3d.Geometry;
import org.j3d.aviatrix3d.IndexedTriangleStripArray;
import org.j3d.aviatrix3d.SceneGraphObject;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.nodes.FrameStateListener;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.geom3d.BaseExtrusion;
import org.web3d.vrml.renderer.ogl.nodes.OGLGeometryNodeType;

public class OGLExtrusion
extends BaseExtrusion
implements OGLGeometryNodeType {
    private static final String SOR_ERR = "Invalid Extrusion data; looks like a solid of revolution";
    private static final String Y_NORM_MSG = "Error normalizing Y in Extrusion";
    private IndexedTriangleStripArray implGeom;
    private float[] coords;
    private int[] coordIndex;
    private int[] stripCounts;
    private Point3f[] spines;
    private Vector3f[] scales;
    private AxisAngle4f[] orientations;
    private Point3f[] crossSectionPts;
    private Matrix3f[] rotations;
    private Matrix4f[] transforms;
    private boolean collinear;
    private boolean spineClosed;
    private boolean xSectionClosed;

    public OGLExtrusion() {
    }

    public OGLExtrusion(VRMLNodeType vRMLNodeType) {
        super(vRMLNodeType);
    }

    public Geometry getGeometry() {
        return this.implGeom;
    }

    public int getNumSets() {
        return 0;
    }

    public String getTexCoordGenMode(int n) {
        return null;
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        super.setValue(n, fArray, n2);
        if (!this.inSetup) {
            this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
        }
    }

    public void allEventsComplete() {
        this.buildImpl();
    }

    public SceneGraphObject getSceneGraphObject() {
        return this.implGeom;
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        this.implGeom = new IndexedTriangleStripArray();
        this.buildImpl();
    }

    private void buildImpl() {
        this.initSetup();
        if (!this.calculateSCP()) {
            return;
        }
        this.createExtrusion();
        this.createIndices();
        this.implGeom.setVertices(3, this.coords);
        this.implGeom.setIndices(this.coordIndex, this.coordIndex.length);
        this.implGeom.setStripCount(this.stripCounts, this.stripCounts.length);
        float f = this.vfCreaseAngle;
        if (f < 0.0f) {
            f = 0.0f;
        } else if (f > (float)Math.PI) {
            f -= (float)Math.PI;
        }
        this.generateNormals();
        this.generateTexCoords();
    }

    private void initSetup() {
        int n;
        this.collinear = false;
        this.spineClosed = false;
        this.xSectionClosed = false;
        int n2 = this.vfCrossSection.length >> 1;
        this.crossSectionPts = new Point3f[n2];
        for (n = 0; n < n2; ++n) {
            this.crossSectionPts[n] = new Point3f(this.vfCrossSection[n * 2], 0.0f, this.vfCrossSection[n * 2 + 1]);
        }
        if (this.crossSectionPts[0].equals((Tuple3f)this.crossSectionPts[n2 - 1])) {
            this.xSectionClosed = true;
        }
        this.scales = new Vector3f[this.vfSpine.length / 3];
        for (n = 0; n < this.scales.length; ++n) {
            this.scales[n] = n * 2 < this.vfScale.length ? new Vector3f(this.vfScale[n * 2], 1.0f, this.vfScale[n * 2 + 1]) : new Vector3f(this.vfScale[this.vfScale.length - 2], 1.0f, this.vfScale[this.vfScale.length - 1]);
        }
        this.spines = new Point3f[this.vfSpine.length / 3];
        for (n = 0; n < this.spines.length; ++n) {
            this.spines[n] = new Point3f(this.vfSpine[n * 3], this.vfSpine[n * 3 + 1], this.vfSpine[n * 3 + 2]);
        }
        this.orientations = new AxisAngle4f[this.vfSpine.length / 3];
        for (n = 0; n < this.orientations.length; ++n) {
            this.orientations[n] = n * 4 < this.vfOrientation.length ? new AxisAngle4f(this.vfOrientation[n * 4], this.vfOrientation[n * 4 + 1], this.vfOrientation[n * 4 + 2], this.vfOrientation[n * 4 + 3]) : new AxisAngle4f(this.vfOrientation[this.vfOrientation.length - 4], this.vfOrientation[this.vfOrientation.length - 3], this.vfOrientation[this.vfOrientation.length - 2], this.vfOrientation[this.vfOrientation.length - 1]);
        }
        this.rotations = new Matrix3f[this.vfSpine.length / 3];
        if (this.spines[0].equals((Tuple3f)this.spines[this.spines.length - 1])) {
            this.spineClosed = true;
        }
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        double d = 0.0;
        for (int i = 1; i < this.spines.length - 1; ++i) {
            vector3d.set((Tuple3f)this.spines[i + 1]);
            vector3d2.set((Tuple3f)this.spines[i]);
            vector3d3.set((Tuple3f)this.spines[i - 1]);
            vector3d.sub((Tuple3d)vector3d2);
            vector3d2.sub((Tuple3d)vector3d3);
            vector3d3.cross(vector3d, vector3d2);
            d += vector3d3.dot(vector3d3);
        }
        this.collinear = d == 0.0;
    }

    private boolean calculateSCP() {
        int n;
        Vector3f vector3f = new Vector3f(0.0f, 0.0f, 0.0f);
        int n2 = this.spines.length - 1;
        Vector3f[] vector3fArray = new Vector3f[this.spines.length];
        Vector3f[] vector3fArray2 = new Vector3f[this.spines.length];
        Vector3f[] vector3fArray3 = new Vector3f[this.spines.length];
        if (this.collinear) {
            if (this.spineClosed) {
                this.errorReporter.warningReport(SOR_ERR, null);
                StringBuffer stringBuffer = new StringBuffer("Spine data:");
                for (int i = 0; i < this.spines.length; ++i) {
                    stringBuffer.append(this.spines[i]);
                    stringBuffer.append(' ');
                }
                this.errorReporter.messageReport(stringBuffer.toString());
                return false;
            }
            Vector3f vector3f2 = null;
            for (n = 0; n < this.spines.length; ++n) {
                if (this.spines[0].equals((Tuple3f)this.spines[n])) continue;
                vector3f2 = new Vector3f((Tuple3f)this.spines[n]);
            }
            vector3fArray2[0] = new Vector3f();
            vector3fArray2[0].sub(vector3f2, (Tuple3f)this.spines[0]);
            if (!this.norm(vector3fArray2[0])) {
                this.errorReporter.warningReport(Y_NORM_MSG, null);
            }
            vector3fArray[0] = vector3fArray2[0].x == 1.0f ? new Vector3f(0.0f, -1.0f, 0.0f) : (vector3fArray2[0].x == -1.0f ? new Vector3f(0.0f, 1.0f, 0.0f) : new Vector3f(1.0f, 0.0f, 0.0f));
            vector3fArray3[0] = new Vector3f();
            vector3fArray3[0].cross(vector3fArray[0], vector3fArray2[0]);
            vector3fArray[0].cross(vector3fArray2[0], vector3fArray3[0]);
            for (n = 1; n < this.spines.length; ++n) {
                vector3fArray[n] = new Vector3f(vector3fArray[0]);
                vector3fArray2[n] = new Vector3f(vector3fArray2[0]);
                vector3fArray3[n] = new Vector3f(vector3fArray3[0]);
            }
        } else {
            Vector3f vector3f3;
            Vector3f vector3f4;
            int n3;
            int n4;
            for (n4 = 1; n4 < n2; ++n4) {
                vector3fArray2[n4] = new Vector3f();
                vector3fArray2[n4].sub((Tuple3f)this.spines[n4 + 1], (Tuple3f)this.spines[n4 - 1]);
                if (this.norm(vector3fArray2[n4])) continue;
                vector3fArray2[n4].sub((Tuple3f)this.spines[n4 + 1], (Tuple3f)this.spines[n4]);
                if (this.norm(vector3fArray2[n4])) continue;
                vector3fArray2[n4].sub((Tuple3f)this.spines[n4], (Tuple3f)this.spines[n4 - 1]);
                if (this.norm(vector3fArray2[n4])) continue;
                for (n3 = n4 + 2; n3 < n2 + 1 && this.spines[n4 - 1].equals((Tuple3f)this.spines[n3]); ++n3) {
                }
                if (n3 < n2 + 1) {
                    vector3fArray2[n4].sub((Tuple3f)this.spines[n3], (Tuple3f)this.spines[n4 - 1]);
                    this.norm(vector3fArray2[n4]);
                    continue;
                }
                vector3fArray2[n4] = new Vector3f(0.0f, 1.0f, 0.0f);
            }
            if (this.spineClosed) {
                vector3fArray2[0] = new Vector3f();
                vector3fArray2[0].sub((Tuple3f)this.spines[1], (Tuple3f)this.spines[n2 - 1]);
                if (!this.norm(vector3fArray2[0])) {
                    for (n4 = n2 - 2; n4 > 1 && this.spines[1].equals((Tuple3f)this.spines[n4]); --n4) {
                    }
                    if (n4 > 1) {
                        vector3fArray2[0].sub((Tuple3f)this.spines[1], (Tuple3f)this.spines[n4]);
                        this.norm(vector3fArray2[0]);
                    } else {
                        vector3fArray2[0].set(0.0f, 0.0f, 1.0f);
                    }
                }
                vector3fArray2[n2] = new Vector3f(vector3fArray2[0]);
            } else {
                vector3fArray2[0] = new Vector3f();
                vector3fArray2[n2] = new Vector3f();
                vector3fArray2[0].sub((Tuple3f)this.spines[1], (Tuple3f)this.spines[0]);
                if (!this.norm(vector3fArray2[0])) {
                    for (n4 = 2; n4 < n2 && this.spines[0].equals((Tuple3f)this.spines[n4]); ++n4) {
                    }
                    if (n4 < n2) {
                        vector3fArray2[0].sub((Tuple3f)this.spines[n4], (Tuple3f)this.spines[0]);
                        this.norm(vector3fArray2[0]);
                    } else {
                        vector3fArray2[0].set(0.0f, 0.0f, 1.0f);
                    }
                }
                vector3fArray2[n2] = new Vector3f();
                vector3fArray2[n2].sub((Tuple3f)this.spines[n2], (Tuple3f)this.spines[n2 - 1]);
                if (!this.norm(vector3fArray2[n2])) {
                    for (n4 = n2 - 2; n4 > -1 && this.spines[n2].equals((Tuple3f)this.spines[n4]); --n4) {
                    }
                    if (n4 > -1) {
                        vector3fArray2[n2].sub((Tuple3f)this.spines[n2], (Tuple3f)this.spines[n4]);
                        this.norm(vector3fArray2[n2]);
                    } else {
                        vector3fArray2[n2].set(0.0f, 0.0f, 1.0f);
                    }
                }
            }
            n4 = 0;
            for (n3 = 1; n3 < n2; ++n3) {
                vector3f4 = new Vector3f();
                vector3f3 = new Vector3f();
                vector3fArray3[n3] = new Vector3f();
                vector3f4.sub((Tuple3f)this.spines[n3 - 1], (Tuple3f)this.spines[n3]);
                vector3f3.sub((Tuple3f)this.spines[n3 + 1], (Tuple3f)this.spines[n3]);
                vector3fArray3[n3].cross(vector3f4, vector3f3);
                if (this.norm(vector3fArray3[n3])) continue;
                n4 = 1;
            }
            if (this.spineClosed) {
                vector3fArray3[0] = vector3fArray3[n2] = new Vector3f();
                vector3f4 = new Vector3f();
                vector3f3 = new Vector3f();
                vector3f4.sub((Tuple3f)this.spines[n2 - 1], (Tuple3f)this.spines[0]);
                vector3f3.sub((Tuple3f)this.spines[1], (Tuple3f)this.spines[0]);
                try {
                    vector3fArray3[0].cross(vector3f4, vector3f3);
                }
                catch (ArithmeticException arithmeticException) {
                    n4 = 1;
                }
            } else {
                vector3fArray3[0] = new Vector3f(vector3fArray3[1]);
                vector3fArray3[n2] = new Vector3f(vector3fArray3[n2 - 1]);
            }
            if (n4 != 0) {
                if (vector3fArray3[0].dot(vector3fArray3[0]) == 0.0f) {
                    for (int i = 1; i < this.spines.length; ++i) {
                        if (!(vector3fArray3[i].dot(vector3fArray3[i]) > 0.0f)) continue;
                        vector3fArray3[0] = new Vector3f(vector3fArray3[i]);
                    }
                    if (vector3fArray3[0].dot(vector3fArray3[0]) == 0.0f) {
                        vector3fArray3[0] = new Vector3f(0.0f, 0.0f, 1.0f);
                    }
                }
                for (int i = 1; i < n2 + 1; ++i) {
                    if (vector3fArray3[i].dot(vector3fArray3[i]) != 0.0f) continue;
                    vector3fArray3[i] = new Vector3f(vector3fArray3[i - 1]);
                }
            }
            for (n = 0; n < this.spines.length; ++n) {
                if (n > 0 && vector3fArray3[n].dot(vector3fArray3[n - 1]) < 0.0f) {
                    vector3fArray3[n].negate();
                }
                vector3fArray[n] = new Vector3f();
                vector3fArray[n].cross(vector3fArray2[n], vector3fArray3[n]);
                this.norm(vector3fArray[n]);
            }
        }
        Matrix3f matrix3f = new Matrix3f();
        this.transforms = new Matrix4f[this.spines.length];
        for (n = 0; n < this.spines.length; ++n) {
            this.rotations[n] = new Matrix3f();
            this.rotations[n].setColumn(0, vector3fArray[n]);
            this.rotations[n].setColumn(1, vector3fArray2[n]);
            this.rotations[n].setColumn(2, vector3fArray3[n]);
        }
        Matrix3f[] matrix3fArray = this.createCorrectionRotations(vector3fArray3);
        Vector3f vector3f5 = new Vector3f();
        for (int i = 0; i < this.spines.length; ++i) {
            this.rotations[i].mul(matrix3fArray[i]);
            matrix3f.set(this.orientations[i]);
            this.rotations[i].mul(matrix3f);
            this.transforms[i] = new Matrix4f();
            this.transforms[i].setIdentity();
            matrix3f.m00 = this.scales[i].x;
            matrix3f.m11 = this.scales[i].y;
            matrix3f.m22 = this.scales[i].z;
            matrix3f.mul(this.rotations[i]);
            this.transforms[i].setRotationScale(matrix3f);
            vector3f5.set((Tuple3f)this.spines[i]);
            this.transforms[i].setTranslation(vector3f5);
        }
        return true;
    }

    private Matrix3f[] createCorrectionRotations(Vector3f[] vector3fArray) {
        int n;
        Matrix3f[] matrix3fArray = new Matrix3f[this.spines.length];
        matrix3fArray[0] = new Matrix3f();
        matrix3fArray[0].setIdentity();
        AxisAngle4f axisAngle4f = new AxisAngle4f();
        Point3f point3f = this.crossSectionPts[0];
        for (n = 0; n < this.crossSectionPts.length; ++n) {
            if (this.crossSectionPts[n].x == 0.0f && this.crossSectionPts[n].z == 0.0f) continue;
            point3f = this.crossSectionPts[n];
            break;
        }
        for (n = 1; n < this.spines.length; ++n) {
            float f = vector3fArray[n].angle(vector3fArray[n - 1]);
            matrix3fArray[n] = matrix3fArray[n - 1];
            if (f == 0.0f) continue;
            matrix3fArray[n] = new Matrix3f(matrix3fArray[n - 1]);
            Point3f point3f2 = new Point3f();
            Matrix3f matrix3f = new Matrix3f(this.rotations[n - 1]);
            matrix3f.mul(matrix3fArray[n - 1]);
            matrix3f.transform((Tuple3f)point3f, (Tuple3f)point3f2);
            Matrix3f matrix3f2 = new Matrix3f();
            matrix3f2.setIdentity();
            matrix3f2.rotY(-f);
            matrix3fArray[n].mul(matrix3f2);
            Matrix3f matrix3f3 = new Matrix3f(this.rotations[n]);
            matrix3f3.mul(matrix3fArray[n]);
            Point3f point3f3 = new Point3f();
            matrix3f3.transform((Tuple3f)point3f, (Tuple3f)point3f3);
            float f2 = point3f3.distance(point3f2);
            matrix3f2.rotY(f * 2.0f);
            matrix3fArray[n].mul(matrix3f2);
            Matrix3f matrix3f4 = new Matrix3f(this.rotations[n]);
            matrix3f4.mul(matrix3fArray[n]);
            Point3f point3f4 = new Point3f();
            matrix3f4.transform((Tuple3f)point3f4);
            float f3 = point3f4.distance(point3f2);
            if (f3 > f2) {
                matrix3f2.rotY(-f * 2.0f);
                matrix3fArray[n].mul(matrix3f2);
            }
            axisAngle4f.set(matrix3fArray[n]);
            if (!((double)((float)Math.PI - axisAngle4f.angle) < 0.001)) continue;
            matrix3fArray[n].rotY((float)((double)axisAngle4f.angle - Math.PI));
        }
        return matrix3fArray;
    }

    private void createExtrusion() {
        int n = this.spines.length * this.crossSectionPts.length * 3;
        if (this.coords == null || this.coords.length < n) {
            this.coords = new float[n];
        }
        for (int i = 0; i < this.spines.length; ++i) {
            Matrix4f matrix4f = this.transforms[i];
            for (int j = 0; j < this.crossSectionPts.length; ++j) {
                int n2 = (i * this.crossSectionPts.length + j) * 3;
                float f = this.crossSectionPts[j].x;
                float f2 = this.crossSectionPts[j].y;
                float f3 = this.crossSectionPts[j].z;
                float f4 = f * matrix4f.m00 + f2 * matrix4f.m01 + f3 * matrix4f.m02 + matrix4f.m03;
                float f5 = f * matrix4f.m10 + f2 * matrix4f.m11 + f3 * matrix4f.m12 + matrix4f.m13;
                float f6 = f * matrix4f.m20 + f2 * matrix4f.m21 + f3 * matrix4f.m22 + matrix4f.m23;
                this.coords[n2] = f4;
                this.coords[n2 + 1] = f5;
                this.coords[n2 + 2] = f6;
            }
        }
    }

    private void createIndices() {
        int n;
        int n2;
        int n3;
        int n4 = 0;
        int n5 = this.crossSectionPts.length;
        int n6 = 0;
        int n7 = 0;
        if (this.vfEndCap) {
            n4 += n5 - 1;
            ++n6;
        }
        if (this.vfBeginCap) {
            n4 += n5 - 1;
            ++n6;
        }
        this.coordIndex = new int[n4 += (this.spines.length - 1) * (4 * (n5 - 1))];
        this.stripCounts = new int[n6 + (this.spines.length - 1) * (n5 - 1)];
        n6 = 0;
        if (this.vfCCW) {
            for (n3 = 0; n3 < this.spines.length - 1; ++n3) {
                for (n2 = 0; n2 < n5 - 1; ++n2) {
                    this.coordIndex[n7] = n3 * n5 + n2 + 1;
                    this.coordIndex[n7 + 1] = (n3 + 1) * n5 + n2 + 1;
                    this.coordIndex[n7 + 2] = n3 * n5 + n2;
                    this.coordIndex[n7 + 3] = (n3 + 1) * n5 + n2;
                    this.stripCounts[n6++] = 4;
                    n7 += 4;
                }
            }
        } else {
            for (n3 = 0; n3 < this.spines.length - 1; ++n3) {
                for (n2 = 0; n2 < n5 - 1; ++n2) {
                    this.coordIndex[n7] = (n3 + 1) * n5 + n2;
                    this.coordIndex[n7 + 1] = (n3 + 1) * n5 + n2 + 1;
                    this.coordIndex[n7 + 2] = n3 * n5 + n2;
                    this.coordIndex[n7 + 3] = n3 * n5 + n2 + 1;
                    this.stripCounts[n6++] = 4;
                    n7 += 4;
                }
            }
        }
        if (this.vfBeginCap && this.vfEndCap) {
            int n8;
            n3 = n4 - 2 * (n5 - 1);
            n2 = n4 - (n5 - 1);
            n = this.coords.length / 3;
            if (!this.vfCCW) {
                n8 = 0;
                while (n8 < n5 - 1) {
                    this.coordIndex[n3++] = n8++;
                }
                n8 = n - 1;
                while (n8 > n - n5) {
                    this.coordIndex[n2++] = n8--;
                }
            } else {
                n8 = n5 - 1;
                while (n8 > 0) {
                    this.coordIndex[n3++] = n8--;
                }
                for (n8 = 0; n8 < n5 - 1; ++n8) {
                    this.coordIndex[n2++] = n - (n5 - 1) + n8;
                }
            }
            this.stripCounts[n6++] = n5 - 1;
            this.stripCounts[n6++] = n5 - 1;
        } else if (this.vfBeginCap) {
            n3 = this.coords.length / 3;
            n2 = n4 - (n5 - 1);
            if (!this.vfCCW) {
                n = 0;
                while (n < n5 - 1) {
                    this.coordIndex[n2++] = n++;
                }
            } else {
                n = n5 - 1;
                while (n > 0) {
                    this.coordIndex[n2++] = n--;
                }
            }
            this.stripCounts[n6++] = n5 - 1;
        } else if (this.vfEndCap) {
            n3 = this.coords.length / 3;
            n2 = n4 - (n5 - 1);
            if (this.vfCCW) {
                n = n3 - (n5 - 1);
                while (n < n3) {
                    this.coordIndex[n2++] = n++;
                }
            } else {
                n = n3 - 1;
                while (n > n3 - n5) {
                    this.coordIndex[n2++] = n--;
                }
            }
            this.stripCounts[n6++] = n5 - 1;
        }
        if (this.xSectionClosed) {
            for (n3 = 0; n3 < this.coordIndex.length; ++n3) {
                if ((this.coordIndex[n3] + 1) % n5 != 0 || this.coordIndex[n3] == 0) continue;
                int n9 = n3;
                this.coordIndex[n9] = this.coordIndex[n9] - (n5 - 1);
            }
        }
    }

    private void generateNormals() {
        int n;
        int n2;
        int n3;
        int n4 = 0;
        for (int i = 0; i < this.stripCounts.length; ++i) {
            n4 += this.stripCounts[i] - 2;
        }
        float[] fArray = new float[n4 * 3];
        int n5 = 0;
        int n6 = 0;
        boolean bl = false;
        for (n3 = 0; n3 < this.stripCounts.length; ++n3) {
            int n7 = this.coordIndex[n6] * 3;
            int n8 = this.coordIndex[n6 + 1] * 3;
            n6 += 2;
            for (n2 = 2; n2 < this.stripCounts[n3]; ++n2) {
                int n9 = this.coordIndex[n6++] * 3;
                if (!bl) {
                    this.createFaceNormal(n8, n9, n7, fArray, n5);
                    bl = true;
                } else {
                    this.createFaceNormal(n8, n7, n9, fArray, n5);
                    bl = false;
                }
                n5 += 3;
                n7 = n8;
                n8 = n9;
            }
        }
        n3 = 0;
        for (n2 = 0; n2 < this.stripCounts.length - 2; ++n2) {
            n3 += this.stripCounts[n2];
        }
        int[] nArray = new int[this.coords.length / 3];
        for (int i = 0; i < n3; ++i) {
            int n10 = this.coordIndex[i];
            nArray[n10] = nArray[n10] + 1;
        }
        int[][] nArrayArray = new int[this.coords.length / 3][];
        for (n = 0; n < nArray.length; ++n) {
            nArrayArray[n] = new int[nArray[n]];
            nArray[n] = 0;
        }
        int n11 = 0;
        for (int i = 0; i < n3; ++i) {
            n = this.coordIndex[i];
            nArrayArray[n][nArray[n]] = n11++;
            int n12 = n;
            nArray[n12] = nArray[n12] + 1;
            if ((i + 1) % 2 != 0) continue;
        }
        float[] fArray2 = new float[this.coords.length];
        for (int i = 0; i < nArrayArray.length; ++i) {
            if (nArrayArray[i].length == 0) continue;
            float f = fArray[nArrayArray[i][0] * 3];
            float f2 = fArray[nArrayArray[i][0] * 3 + 1];
            float f3 = fArray[nArrayArray[i][0] * 3 + 2];
            for (int j = 1; j < nArrayArray[i].length; ++j) {
                f += fArray[nArrayArray[i][j] * 3];
                f2 += fArray[nArrayArray[i][j] * 3 + 1];
                f3 += fArray[nArrayArray[i][j] * 3 + 2];
            }
            fArray2[i * 3] = f / (float)nArrayArray[i].length;
            fArray2[i * 3 + 1] = f2 / (float)nArrayArray[i].length;
            fArray2[i * 3 + 2] = f3 / (float)nArrayArray[i].length;
        }
        this.implGeom.setNormals(fArray2);
    }

    private void generateTexCoords() {
    }

    private boolean norm(Vector3f vector3f) {
        float f = vector3f.x * vector3f.x + vector3f.y * vector3f.y + vector3f.z * vector3f.z;
        if (f == 0.0f) {
            return false;
        }
        f = 1.0f / (float)Math.sqrt(f);
        vector3f.x *= f;
        vector3f.y *= f;
        vector3f.z *= f;
        return true;
    }

    private void createFaceNormal(int n, int n2, int n3, float[] fArray, int n4) {
        float f = this.coords[n + 1] - this.coords[n3 + 1];
        float f2 = this.coords[n2 + 2] - this.coords[n + 2];
        float f3 = this.coords[n + 2] - this.coords[n3 + 2];
        float f4 = this.coords[n2 + 1] - this.coords[n + 1];
        float f5 = f * f2 - f3 * f4;
        float f6 = this.coords[n2] - this.coords[n];
        float f7 = this.coords[n] - this.coords[n3];
        float f8 = f3 * f6 - f7 * f2;
        float f9 = f7 * f4 - f * f6;
        float f10 = f5 * f5 + f8 * f8 + f9 * f9;
        if (f10 != 0.0f) {
            f10 = 1.0f / (float)Math.sqrt(f10);
            fArray[n4] = f5 * f10;
            fArray[n4 + 1] = f8 * f10;
            fArray[n4 + 2] = f9 * f10;
        } else {
            fArray[n4] = 0.0f;
            fArray[n4 + 1] = 1.0f;
            fArray[n4 + 2] = 0.0f;
        }
    }
}

