/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.ogl.nodes.geom3d;

import org.j3d.aviatrix3d.Geometry;
import org.j3d.aviatrix3d.NodeUpdateListener;
import org.j3d.aviatrix3d.SceneGraphObject;
import org.j3d.aviatrix3d.TriangleArray;
import org.j3d.geom.GeometryData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.GeometryHolder;
import org.web3d.vrml.renderer.common.nodes.GeometryUtils;
import org.web3d.vrml.renderer.common.nodes.geom3d.BaseIndexedFaceSet;
import org.web3d.vrml.renderer.ogl.nodes.OGLGeometryNodeType;
import org.web3d.vrml.renderer.ogl.nodes.OGLUserData;

public class OGLIndexedFaceSet
extends BaseIndexedFaceSet
implements OGLGeometryNodeType,
NodeUpdateListener {
    private TriangleArray implGeom;
    private boolean normalsChanged;
    private boolean texCoordsChanged;
    private boolean colorsChanged;
    private float[][] texCoords;
    private int[] texTypes;
    private int[] texSetMap;
    private int numTexSets;
    private int numUniqueTexSets;
    private GeometryUtils gutils;
    private int numBuilds;
    private boolean initialBuild;

    public OGLIndexedFaceSet() {
        this.init();
    }

    public OGLIndexedFaceSet(VRMLNodeType vRMLNodeType) {
        super(vRMLNodeType);
        this.init();
    }

    public void allEventsComplete() {
        this.buildImpl();
    }

    public void updateNodeBoundsChanges(Object object) {
        this.implGeom.setVertices(3, this.geomData.coordinates, this.geomData.vertexCount);
    }

    public void updateNodeDataChanges(Object object) {
        if (this.colorsChanged) {
            int n = this.vfColor == null ? 0 : this.vfColor.getNumColorComponents();
            boolean bl = n == 4;
            this.implGeom.setColors(bl, this.geomData.colors);
            this.colorsChanged = false;
            if (this.vfColor == null) {
                this.localColors = false;
            }
        }
        if (this.normalsChanged) {
            this.implGeom.setNormals(this.geomData.normals);
            this.normalsChanged = false;
        }
        if (this.texCoordsChanged) {
            this.implGeom.setTextureCoordinates(this.texTypes, this.texCoords, this.numUniqueTexSets);
            this.implGeom.setTextureSetMap(this.texSetMap, this.numTexSets);
            this.texCoordsChanged = false;
        }
    }

    public Geometry getGeometry() {
        return this.implGeom;
    }

    public SceneGraphObject getSceneGraphObject() {
        return this.implGeom;
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        this.implGeom = new TriangleArray();
        OGLUserData oGLUserData = new OGLUserData();
        oGLUserData.geometryData = this.geomData;
        this.implGeom.setUserData((Object)oGLUserData);
        this.buildImpl();
    }

    private void init() {
        this.geomData = new GeometryData();
        this.geomData.geometryType = 1;
        this.changeFlags = 0;
        this.initialBuild = true;
        this.normalsChanged = false;
        this.texCoordsChanged = false;
        this.colorsChanged = false;
        this.numBuilds = 0;
    }

    private void buildImpl() {
        if (this.vfCoordIndex == null || this.vfCoord == null || !this.inSetup && this.changeFlags == 0) {
            return;
        }
        int n = this.vfCoord.getNumPoints();
        if (n < 3) {
            return;
        }
        if (this.gutils == null) {
            this.gutils = new GeometryUtils();
        }
        GeometryHolder geometryHolder = new GeometryHolder();
        this.gutils.generateTriangleArrays(this.changeFlags, true, true, this.vfCoord, this.vfColor, this.vfNormal, this.vfTexCoord, this.vfCoordIndex, this.numCoordIndex, this.vfColorIndex, this.vfNormalIndex, this.vfTexCoordIndex, this.vfCcw, this.vfConvex, this.vfColorPerVertex, this.vfNormalPerVertex, this.vfCreaseAngle, this.initialBuild, geometryHolder);
        if (geometryHolder.coordinates == null) {
            return;
        }
        this.gutils.copyData(geometryHolder, this.geomData);
        this.texCoords = geometryHolder.textureCoordinates;
        this.numTexSets = geometryHolder.numTexSets;
        this.numUniqueTexSets = geometryHolder.numUniqueTexSets;
        if ((this.changeFlags & 1) != 0 || this.initialBuild) {
            if (this.implGeom.isLive()) {
                this.implGeom.boundsChanged((NodeUpdateListener)this);
            } else {
                this.updateNodeBoundsChanges(this.implGeom);
            }
        }
        if ((this.changeFlags & 1) != 0 && this.vfNormal == null || (this.changeFlags & 2) != 0 || this.initialBuild) {
            this.normalsChanged = true;
            if (this.implGeom.isLive()) {
                this.implGeom.dataChanged((NodeUpdateListener)this);
            } else {
                this.updateNodeDataChanges(this.implGeom);
            }
        }
        if ((this.changeFlags & 4) != 0 || this.initialBuild) {
            if (this.vfTexCoord == null) {
                this.numTexSets = 1;
                this.numUniqueTexSets = 1;
                if (this.texSetMap == null || this.texSetMap.length != this.numTexSets) {
                    this.texSetMap = new int[this.numTexSets];
                }
                this.texSetMap[0] = 0;
                if (this.texTypes == null || this.texTypes.length != this.numUniqueTexSets) {
                    this.texTypes = new int[this.numUniqueTexSets];
                }
                this.texTypes[0] = 2;
                this.texCoordsChanged = true;
                if (this.implGeom.isLive()) {
                    this.implGeom.dataChanged((NodeUpdateListener)this);
                } else {
                    this.updateNodeDataChanges(this.implGeom);
                }
            } else {
                int n2;
                int n3 = 0;
                int n4 = this.vfTexCoord.getNumTextureComponents();
                switch (n4) {
                    case 1: {
                        n3 = 1;
                        break;
                    }
                    case 2: {
                        n3 = 2;
                        break;
                    }
                    case 3: {
                        n3 = 3;
                        break;
                    }
                    case 4: {
                        n3 = 4;
                        break;
                    }
                    default: {
                        System.out.println("Invalid number of texture components " + this.vfTexCoord.getNumTextureComponents());
                    }
                }
                if (this.texSetMap == null || this.texSetMap.length != this.numTexSets) {
                    this.texSetMap = new int[this.numTexSets];
                }
                for (n2 = 0; n2 < this.numTexSets; ++n2) {
                    this.texSetMap[n2] = this.vfTexCoord.isShared(n2);
                }
                if (this.texTypes == null || this.texTypes.length != this.numUniqueTexSets) {
                    this.texTypes = new int[this.numUniqueTexSets];
                }
                for (n2 = 0; n2 < this.numUniqueTexSets; ++n2) {
                    this.texTypes[n2] = n3;
                }
                this.texCoordsChanged = true;
                if (this.implGeom.isLive()) {
                    this.implGeom.dataChanged((NodeUpdateListener)this);
                } else {
                    this.updateNodeDataChanges(this.implGeom);
                }
            }
        }
        if ((this.changeFlags & 8) != 0 || this.initialBuild) {
            this.colorsChanged = true;
            if (this.implGeom.isLive()) {
                this.implGeom.dataChanged((NodeUpdateListener)this);
            } else {
                this.updateNodeDataChanges(this.implGeom);
            }
        }
        this.initialBuild = false;
        this.changeFlags = 0;
        if (this.isStatic || this.numBuilds < 1) {
            this.gutils.reset();
            this.gutils = null;
            if (this.inSetup) {
                this.texCoords = null;
                this.texTypes = null;
                this.texSetMap = null;
            }
        }
        ++this.numBuilds;
    }
}

