/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.ogl.nodes.geospatial;

import org.j3d.aviatrix3d.Geometry;
import org.j3d.aviatrix3d.IndexedQuadArray;
import org.j3d.aviatrix3d.NodeUpdateListener;
import org.j3d.aviatrix3d.SceneGraphObject;
import org.j3d.geom.GeometryData;
import org.opengis.referencing.operation.TransformException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.nodes.VRMLColorNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLNormalNodeType;
import org.web3d.vrml.nodes.VRMLTextureCoordinateNodeType;
import org.web3d.vrml.renderer.common.nodes.geospatial.BaseGeoElevationGrid;
import org.web3d.vrml.renderer.common.nodes.geospatial.BaseGeoOrigin;
import org.web3d.vrml.renderer.common.nodes.geospatial.ElevationGridGenerator;
import org.web3d.vrml.renderer.ogl.nodes.OGLGeometryNodeType;
import org.web3d.vrml.renderer.ogl.nodes.OGLUserData;

public class OGLGeoElevationGrid
extends BaseGeoElevationGrid
implements OGLGeometryNodeType,
NodeUpdateListener {
    private IndexedQuadArray implGeom;
    private ElevationGridGenerator generator;
    private GeometryData data;

    public OGLGeoElevationGrid() {
        this.init();
    }

    public OGLGeoElevationGrid(VRMLNodeType vRMLNodeType) {
        super(vRMLNodeType);
        this.init();
    }

    public Geometry getGeometry() {
        return this.implGeom;
    }

    public SceneGraphObject getSceneGraphObject() {
        return this.implGeom;
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        this.implGeom = new IndexedQuadArray();
        this.buildImpl();
    }

    public void setValue(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldException, InvalidFieldValueException {
        super.setValue(n, vRMLNodeType);
        if (this.inSetup) {
            return;
        }
        switch (n) {
            case 2: 
            case 3: 
            case 4: {
                if (this.implGeom.isLive()) {
                    this.implGeom.boundsChanged((NodeUpdateListener)this);
                    break;
                }
                this.updateNodeBoundsChanges(this.implGeom);
            }
        }
    }

    public void setComponents(VRMLNodeType[] vRMLNodeTypeArray) throws InvalidFieldValueException {
        super.setComponents(vRMLNodeTypeArray);
        if (this.inSetup) {
            return;
        }
        if (this.implGeom.isLive()) {
            this.implGeom.boundsChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeBoundsChanges(this.implGeom);
        }
    }

    public void setComponent(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        super.setComponent(vRMLNodeType);
        if (this.inSetup) {
            return;
        }
        if (this.implGeom.isLive()) {
            this.implGeom.boundsChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeBoundsChanges(this.implGeom);
        }
    }

    public void updateNodeBoundsChanges(Object object) {
        this.buildImpl();
    }

    public void updateNodeDataChanges(Object object) {
    }

    private void buildImpl() {
        Object[] objectArray;
        Object object;
        Object object2;
        Object object3;
        if (this.vfHeight == null || this.vfHeight.length == 0) {
            return;
        }
        this.generator = new ElevationGridGenerator((double)(this.vfXDimension - 1) * this.vfXSpacing, (double)(this.vfZDimension - 1) * this.vfZSpacing, this.vfXDimension, this.vfZDimension, this.vfYScale, this.vfHeight);
        this.data.geometryType = 5;
        boolean bl = false;
        if (this.vfTexCoord == null && this.pTexCoord == null) {
            bl = true;
            this.data.geometryComponents = 4;
        }
        if (this.vfNormal == null && this.pNormal == null) {
            this.data.geometryComponents |= 2;
        }
        double[] dArray = null;
        if (this.vfGeoOrigin != null) {
            dArray = ((BaseGeoOrigin)this.vfGeoOrigin).getConvertedCoordRef();
        }
        try {
            if (this.geoCoordSwap) {
                double d = this.vfGeoGridOrigin[0];
                this.vfGeoGridOrigin[0] = this.vfGeoGridOrigin[1];
                this.vfGeoGridOrigin[1] = d;
                this.generator.generateIndexedQuads(this.data, this.geoTransform, this.vfGeoGridOrigin, dArray, false, this.vfCreaseAngle);
                d = this.vfGeoGridOrigin[0];
                this.vfGeoGridOrigin[0] = this.vfGeoGridOrigin[1];
                this.vfGeoGridOrigin[1] = d;
            } else {
                this.generator.generateIndexedQuads(this.data, this.geoTransform, this.vfGeoGridOrigin, dArray, false, this.vfCreaseAngle);
            }
        }
        catch (TransformException transformException) {
            this.errorReporter.warningReport("Unable to transform the coordinate values for some reason.", (Exception)((Object)transformException));
            return;
        }
        OGLUserData oGLUserData = new OGLUserData();
        oGLUserData.geometryData = this.data;
        this.implGeom.setUserData((Object)oGLUserData);
        this.implGeom.setVertices(3, this.data.coordinates, this.data.vertexCount);
        this.implGeom.setIndices(this.data.indexes, this.data.indexesCount);
        if (bl) {
            object3 = new int[]{2};
            object2 = new float[][]{this.data.textureCoordinates};
            this.implGeom.setTextureCoordinates((int[])object3, (float[][])object2, 1);
        } else {
            object3 = this.pTexCoord != null ? (VRMLTextureCoordinateNodeType)this.pTexCoord.getImplementationNode() : this.vfTexCoord;
            int n = object3.getNumSets();
            object = new float[n][];
            objectArray = new int[n];
            int[] nArray = new int[n];
            float[] fArray = new float[object3.getSize(0) * 2];
            for (int i = 0; i < n; ++i) {
                int n2 = object3.getNumTextureComponents();
                switch (n2) {
                    case 1: {
                        nArray[i] = 1;
                        break;
                    }
                    case 2: {
                        nArray[i] = 2;
                        break;
                    }
                    case 3: {
                        nArray[i] = 3;
                        break;
                    }
                    case 4: {
                        nArray[i] = 4;
                    }
                }
                int n3 = object3.getSize(i);
                objectArray[i] = object3.isShared(i);
                int n4 = this.data.vertexCount * n2;
                if (n3 < n4) {
                    n3 = n4;
                }
                if (object[i] == null || object[i].length < n3) {
                    object[i] = new float[n3];
                }
                if (fArray.length < n3) {
                    fArray = new float[n3];
                }
                object3.getPoint(i, fArray);
                int n5 = this.vfZDimension * n2;
                int n6 = n4 - 1;
                int n7 = this.vfXDimension * this.vfZDimension * n2 - 1;
                for (int j = 0; j < this.vfXDimension - 1; ++j) {
                    for (int k = 0; k < this.vfZDimension; ++k) {
                        object[i][n6--] = fArray[n7];
                        object[i][n6--] = fArray[n7 - 1];
                        object[i][n6--] = fArray[n7 - n5];
                        object[i][n6--] = fArray[n7 - n5 - 1];
                        n7 -= n2;
                    }
                }
            }
            this.implGeom.setTextureCoordinates(nArray, (float[][])object, n);
            this.implGeom.setTextureSetMap(objectArray, n);
        }
        if (this.vfNormal != null || this.pNormal != null) {
            object3 = this.pNormal != null ? (VRMLNormalNodeType)this.pNormal.getImplementationNode() : this.vfNormal;
            object2 = new float[object3.getNumNormals()];
            object3.getVector((float[])object2);
            float[] fArray = new float[this.data.vertexCount * 3];
            this.setupArray((float[])object2, fArray, this.vfNormalPerVertex);
            this.implGeom.setNormals(fArray);
        } else if (this.vfCcw) {
            this.implGeom.setNormals(this.data.normals);
        } else {
            for (int i = 1; i < this.data.normals.length / 3; i += 3) {
                this.data.normals[i] = -this.data.normals[i];
            }
            this.implGeom.setNormals(this.data.normals);
        }
        if (this.vfColor != null || this.pColor != null) {
            VRMLColorNodeType vRMLColorNodeType = this.pColor != null ? (VRMLColorNodeType)this.pColor.getImplementationNode() : this.vfColor;
            int n = vRMLColorNodeType.getNumColorComponents();
            int n8 = vRMLColorNodeType.getNumColors();
            object = new float[n8];
            vRMLColorNodeType.getColor((float[])object);
            objectArray = new float[this.data.vertexCount * n];
            this.setupArray((float[])object, (float[])objectArray, this.vfColorPerVertex);
            this.implGeom.setColors(n == 4, (float[])objectArray);
        }
    }

    private void setupArray(float[] fArray, float[] fArray2, boolean bl) {
        int n = 0;
        int n2 = 0;
        int n3 = this.vfXDimension * 3;
        int n4 = this.vfXDimension * (this.vfZDimension - 1);
        if (bl) {
            if (this.vfCcw) {
                int n5 = n4;
                while (--n5 >= 0) {
                    fArray2[n++] = fArray[n2];
                    fArray2[n++] = fArray[n2 + 1];
                    fArray2[n++] = fArray[n2 + 2];
                    fArray2[n++] = fArray[n2 + n3];
                    fArray2[n++] = fArray[n2 + n3 + 1];
                    fArray2[n++] = fArray[n2 + n3 + 2];
                    n2 += 3;
                }
            } else {
                int n6 = n4;
                while (--n6 >= 0) {
                    fArray2[n++] = fArray[n2 + n3];
                    fArray2[n++] = fArray[n2 + n3 + 1];
                    fArray2[n++] = fArray[n2 + n3 + 2];
                    fArray2[n++] = fArray[n2];
                    fArray2[n++] = fArray[n2 + 1];
                    fArray2[n++] = fArray[n2 + 2];
                    n2 += 3;
                }
            }
        } else {
            int n7 = n4;
            while (--n7 >= 0) {
                fArray2[n++] = fArray[n2];
                fArray2[n++] = fArray[n2 + 1];
                fArray2[n++] = fArray[n2 + 2];
                fArray2[n++] = fArray[n2];
                fArray2[n++] = fArray[n2 + 1];
                fArray2[n++] = fArray[n2 + 2];
                if (n7 % 2 == 0) continue;
                n2 += 3;
            }
        }
    }

    private void init() {
        this.data = new GeometryData();
    }
}

