/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.ogl.nodes.geospatial;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.j3d.aviatrix3d.BoundingBox;
import org.j3d.aviatrix3d.BoundingVolume;
import org.j3d.aviatrix3d.Geometry;
import org.j3d.aviatrix3d.Group;
import org.j3d.aviatrix3d.Node;
import org.j3d.aviatrix3d.NodeUpdateListener;
import org.j3d.aviatrix3d.QuadArray;
import org.j3d.aviatrix3d.SceneGraphObject;
import org.j3d.aviatrix3d.Shape3D;
import org.j3d.aviatrix3d.SharedGroup;
import org.j3d.aviatrix3d.SwitchGroup;
import org.j3d.geom.GeometryData;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLExecutionSpace;
import org.web3d.vrml.nodes.FrameStateListener;
import org.web3d.vrml.nodes.VRMLChildNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLPointingDeviceSensorNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.nodes.VRMLScene;
import org.web3d.vrml.renderer.common.nodes.geospatial.BaseGeoLOD;
import org.web3d.vrml.renderer.common.nodes.geospatial.SceneWrapper;
import org.web3d.vrml.renderer.ogl.nodes.OGLGlobalStatus;
import org.web3d.vrml.renderer.ogl.nodes.OGLUserData;
import org.web3d.vrml.renderer.ogl.nodes.OGLVRMLNode;
import org.web3d.vrml.renderer.ogl.nodes.OGLVisibilityListener;

public class OGLGeoLOD
extends BaseGeoLOD
implements OGLVRMLNode,
OGLVisibilityListener,
NodeUpdateListener {
    private static final String BAD_PROTO_MSG = "The resolved proto instance is not a X3DChildNode type. Grouping nodes may only use ChildNode types for the children field.";
    private Group oglImplGroup;
    private SwitchGroup implSwitch;
    private Group childGroup;
    private Group rootGroup;
    private Shape3D proxyShape;
    private QuadArray proxyGeometry;
    private HashMap oglChildMap;
    private LinkedList addedChildren;
    private LinkedList removedChildren;
    private ArrayList sensorList;
    private GeometryData geomData;
    private Vector3f translation;
    private VRMLScene rootScene;
    private boolean[] loadedChildUrls;
    private boolean rootGroupChanged;

    public OGLGeoLOD() {
        this.init();
    }

    public OGLGeoLOD(VRMLNodeType vRMLNodeType) {
        super(vRMLNodeType);
        this.init();
    }

    public void allEventsComplete() {
        if (this.rootGroupChanged) {
            if (this.rootGroup.isLive()) {
                this.rootGroup.boundsChanged((NodeUpdateListener)this);
            } else {
                this.updateNodeBoundsChanges(this.rootGroup);
            }
        } else if (this.childGroup.isLive()) {
            this.childGroup.boundsChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeBoundsChanges(this.childGroup);
        }
    }

    public SceneGraphObject getSceneGraphObject() {
        return this.oglImplGroup;
    }

    public void setupFinished() {
        Node node;
        OGLVRMLNode oGLVRMLNode;
        int n;
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        this.oglChildMap = new HashMap();
        this.oglImplGroup = this.isStatic && this.shareCount == 0 ? new Group() : new SharedGroup();
        this.implSwitch = new SwitchGroup();
        this.oglImplGroup.addChild((Node)this.proxyShape);
        this.oglImplGroup.addChild((Node)this.implSwitch);
        this.rootGroup = new Group();
        this.childGroup = new Group();
        this.childGroup.addChild(null);
        this.childGroup.addChild(null);
        this.childGroup.addChild(null);
        this.childGroup.addChild(null);
        this.implSwitch.addChild((Node)this.rootGroup);
        this.implSwitch.addChild((Node)this.childGroup);
        if (!this.isStatic && this.sensorList.size() != 0) {
            OGLUserData oGLUserData = new OGLUserData();
            oGLUserData.collidable = false;
            oGLUserData.isTerrain = false;
            oGLUserData.visibilityListener = this;
            this.implSwitch.setUserData((Object)oGLUserData);
            oGLUserData.sensors = new VRMLPointingDeviceSensorNodeType[this.sensorList.size()];
            this.sensorList.toArray(oGLUserData.sensors);
        }
        this.sensorList = null;
        int n2 = this.childCount < 4 ? this.childCount : 4;
        for (n = 0; n < n2; ++n) {
            oGLVRMLNode = (OGLVRMLNode)this.vfChildren.get(n);
            if (oGLVRMLNode == null) continue;
            node = (Node)oGLVRMLNode.getSceneGraphObject();
            if (node != null) {
                this.childGroup.setChild(node, n);
            }
            this.oglChildMap.put(oGLVRMLNode, node);
        }
        this.implSwitch.setActiveChild(0);
        if (!this.isStatic) {
            this.removedChildren = new LinkedList();
            this.addedChildren = new LinkedList();
        }
        n = this.vfRootNode.size();
        for (int i = 0; i < n; ++i) {
            oGLVRMLNode = (OGLVRMLNode)this.vfRootNode.get(i);
            node = (Node)oGLVRMLNode.getSceneGraphObject();
            this.rootGroup.addChild(node);
        }
        this.setupShape();
        if (this.vfBboxSize[0] != -1.0f && this.vfBboxSize[1] != -1.0f && this.vfBboxSize[2] != -1.0f) {
            float[] fArray = new float[]{this.vfBboxCenter[0] - this.vfBboxSize[0] / 2.0f, this.vfBboxCenter[1] - this.vfBboxSize[1] / 2.0f, this.vfBboxCenter[2] - this.vfBboxSize[2] / 2.0f};
            float[] fArray2 = new float[]{this.vfBboxCenter[0] + this.vfBboxSize[0] / 2.0f, this.vfBboxCenter[1] + this.vfBboxSize[1] / 2.0f, this.vfBboxCenter[2] + this.vfBboxSize[2] / 2.0f};
            BoundingBox boundingBox = new BoundingBox(fArray, fArray2);
            this.oglImplGroup.setBounds((BoundingVolume)boundingBox);
        }
    }

    public synchronized void notifyExternProtoLoaded(int n, VRMLNodeType vRMLNodeType) {
        if (!(vRMLNodeType instanceof VRMLChildNodeType) && !(vRMLNodeType instanceof VRMLProtoInstance)) {
            throw new InvalidFieldValueException(BAD_PROTO_MSG);
        }
        if (this.inSetup) {
            return;
        }
        OGLVRMLNode oGLVRMLNode = (OGLVRMLNode)vRMLNodeType;
        oGLVRMLNode.setupFinished();
        Node node = (Node)oGLVRMLNode.getSceneGraphObject();
        if (n == 6) {
            if (this.rootGroup.isLive()) {
                this.rootGroupChanged = true;
                this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
            } else {
                this.rootGroup.addChild(node);
            }
        } else {
            this.oglChildMap.put(vRMLNodeType, node);
            if (node != null) {
                if (this.childGroup.isLive()) {
                    if (this.addedChildren == null) {
                        this.addedChildren = new LinkedList();
                    }
                    this.addedChildren.add(node);
                    this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
                } else {
                    this.childGroup.addChild(node);
                }
            }
        }
    }

    public void setContent(int n, String string, Object object) throws IllegalArgumentException {
        if (object == null) {
            return;
        }
        if (!(object instanceof VRMLScene)) {
            throw new IllegalArgumentException("Not a VRML Scene instance");
        }
        switch (n) {
            case 7: {
                this.rootScene = (VRMLScene)object;
                break;
            }
            case 8: {
                this.loadedChildUrls[0] = true;
                this.childScenes[0] = (VRMLScene)object;
                break;
            }
            case 9: {
                this.loadedChildUrls[1] = true;
                this.childScenes[1] = (VRMLScene)object;
                break;
            }
            case 10: {
                this.loadedChildUrls[2] = true;
                this.childScenes[2] = (VRMLScene)object;
                break;
            }
            case 11: {
                this.loadedChildUrls[3] = true;
                this.childScenes[3] = (VRMLScene)object;
            }
        }
        if (this.rootGroup.isLive() || this.childGroup.isLive()) {
            this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
        } else if (n == 7) {
            if (this.rootGroup.isLive()) {
                this.rootGroup.boundsChanged((NodeUpdateListener)this);
            } else {
                this.updateNodeBoundsChanges(this.rootGroup);
            }
        } else if (this.childGroup.isLive()) {
            this.childGroup.boundsChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeBoundsChanges(this.childGroup);
        }
    }

    public void visibilityStateChange(boolean bl, Point3f point3f, AxisAngle4f axisAngle4f, Matrix4f matrix4f) {
        if (!bl) {
            if (this.implSwitch.isLive()) {
                this.implSwitch.boundsChanged((NodeUpdateListener)this);
            } else {
                this.updateNodeBoundsChanges(this.implSwitch);
            }
        } else {
            boolean bl2;
            matrix4f.get(this.translation);
            this.translation.x = (float)((double)this.translation.x + this.localCenter[0]);
            this.translation.y = (float)((double)this.translation.y + this.localCenter[1]);
            this.translation.z = (float)((double)this.translation.z + this.localCenter[2]);
            this.translation.sub((Tuple3f)point3f);
            double d = this.translation.lengthSquared();
            boolean bl3 = bl2 = d <= (double)this.vfRange * (double)this.vfRange;
            if (bl2 != this.childrenShown) {
                this.childrenShown = bl2;
                this.loadScene(bl2);
                if (this.implSwitch.isLive()) {
                    this.implSwitch.boundsChanged((NodeUpdateListener)this);
                } else {
                    this.updateNodeBoundsChanges(this.implSwitch);
                }
            }
        }
    }

    public void viewPositionChanged(Point3f point3f, AxisAngle4f axisAngle4f, Matrix4f matrix4f) {
        boolean bl;
        matrix4f.get(this.translation);
        this.translation.x = (float)((double)this.translation.x + this.localCenter[0]);
        this.translation.y = (float)((double)this.translation.y + this.localCenter[1]);
        this.translation.z = (float)((double)this.translation.z + this.localCenter[2]);
        this.translation.sub((Tuple3f)point3f);
        double d = this.translation.lengthSquared();
        boolean bl2 = bl = d <= (double)this.vfRange * (double)this.vfRange;
        if (bl != this.childrenShown) {
            this.childrenShown = bl;
            this.loadScene(bl);
            if (this.implSwitch.isLive()) {
                this.implSwitch.boundsChanged((NodeUpdateListener)this);
            } else {
                this.updateNodeBoundsChanges(this.implSwitch);
            }
        }
    }

    public void updateNodeBoundsChanges(Object object) {
        if (object == this.implSwitch) {
            this.implSwitch.setActiveChild(this.childrenShown ? 1 : 0);
        } else if (object == this.childGroup) {
            for (int i = 0; i < 4; ++i) {
                if (!this.loadedChildUrls[i]) continue;
                OGLVRMLNode oGLVRMLNode = (OGLVRMLNode)this.childScenes[i].getRootNode();
                Group group = (Group)oGLVRMLNode.getSceneGraphObject();
                this.childGroup.setChild((Node)group, i);
                this.loadedChildUrls[i] = false;
                this.loadedScenes[i] = new SceneWrapper(this.childScenes[i]);
                this.stateManager.registerAddedScene((VRMLExecutionSpace)this.loadedScenes[i]);
            }
        } else if (object == this.rootGroup) {
            this.rootGroup.removeAllChildren();
            OGLVRMLNode oGLVRMLNode = (OGLVRMLNode)this.rootScene.getRootNode();
            Group group = (Group)oGLVRMLNode.getSceneGraphObject();
            this.rootGroup.addChild((Node)group);
        }
    }

    public void updateNodeDataChanges(Object object) {
    }

    protected void clearChildren() {
        int n = this.vfChildren.size();
        for (int i = 0; i < n; ++i) {
            OGLVRMLNode oGLVRMLNode = (OGLVRMLNode)this.vfChildren.get(i);
            Node node = (Node)this.oglChildMap.get(oGLVRMLNode);
            this.removedChildren.add(node);
            this.oglChildMap.remove(oGLVRMLNode);
        }
        if (!this.inSetup) {
            if (this.implSwitch.isLive()) {
                this.implSwitch.boundsChanged((NodeUpdateListener)this);
            } else {
                this.updateNodeBoundsChanges(this.implSwitch);
            }
        }
        super.clearChildren();
    }

    protected void addChildNode(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        Object object;
        Node node;
        super.addChildNode(vRMLNodeType);
        OGLVRMLNode oGLVRMLNode = (OGLVRMLNode)vRMLNodeType;
        if (!this.inSetup) {
            node = (Node)oGLVRMLNode.getSceneGraphObject();
            this.addedChildren.add(node);
            this.oglChildMap.put(vRMLNodeType, node);
        }
        node = null;
        if (vRMLNodeType instanceof VRMLPointingDeviceSensorNodeType) {
            node = (VRMLPointingDeviceSensorNodeType)vRMLNodeType;
        } else if (vRMLNodeType instanceof VRMLProtoInstance && (object = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode()) instanceof VRMLPointingDeviceSensorNodeType) {
            node = (VRMLPointingDeviceSensorNodeType)object;
        }
        if (node != null) {
            if (this.inSetup) {
                this.sensorList.add(node);
            } else {
                object = (OGLUserData)this.implSwitch.getUserData();
                if (object.sensors == null) {
                    object.sensors = new VRMLPointingDeviceSensorNodeType[1];
                    object.sensors[0] = node;
                } else {
                    int n = object.sensors.length;
                    VRMLPointingDeviceSensorNodeType[] vRMLPointingDeviceSensorNodeTypeArray = new VRMLPointingDeviceSensorNodeType[n + 1];
                    System.arraycopy(object.sensors, 0, vRMLPointingDeviceSensorNodeTypeArray, 0, n);
                    vRMLPointingDeviceSensorNodeTypeArray[n] = node;
                    object.sensors = vRMLPointingDeviceSensorNodeTypeArray;
                }
            }
        }
        if (!this.inSetup) {
            if (this.implSwitch.isLive()) {
                this.implSwitch.boundsChanged((NodeUpdateListener)this);
            } else {
                this.updateNodeBoundsChanges(this.implSwitch);
            }
        }
    }

    protected void removeChildNode(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        if (!this.oglChildMap.containsKey(vRMLNodeType)) {
            return;
        }
        if (!this.inSetup) {
            Node node = (Node)this.oglChildMap.get(vRMLNodeType);
            this.removedChildren.add(node);
            this.oglChildMap.remove(vRMLNodeType);
            if (this.implSwitch.isLive()) {
                this.implSwitch.boundsChanged((NodeUpdateListener)this);
            } else {
                this.updateNodeBoundsChanges(this.implSwitch);
            }
        }
        super.removeChildNode(vRMLNodeType);
    }

    private void init() {
        this.childrenShown = false;
        this.sensorList = new ArrayList();
        this.translation = new Vector3f();
        this.geomData = new GeometryData();
        this.geomData.geometryType = 2;
        this.geomData.coordinates = new float[72];
        this.geomData.vertexCount = 24;
        OGLUserData oGLUserData = new OGLUserData();
        oGLUserData.geometryData = this.geomData;
        oGLUserData.collidable = false;
        oGLUserData.isTerrain = false;
        oGLUserData.visibilityListener = this;
        this.proxyGeometry = new QuadArray();
        this.proxyShape = new Shape3D();
        this.proxyShape.setAppearance(OGLGlobalStatus.invisibleAppearance);
        this.proxyShape.setGeometry((Geometry)this.proxyGeometry);
        this.proxyShape.setUserData((Object)oGLUserData);
        this.proxyShape.setPickMask(12);
        this.childScenes = new VRMLScene[4];
        this.loadedChildUrls = new boolean[4];
        this.loadedScenes = new SceneWrapper[4];
        this.loadState[8] = 3;
        this.loadState[9] = 3;
        this.loadState[10] = 3;
        this.loadState[11] = 3;
    }

    private void setupShape() {
        float[] fArray = this.geomData.coordinates;
        fArray[0] = (float)this.localCenter[0] + this.vfRange;
        fArray[1] = (float)this.localCenter[1] - this.vfRange;
        fArray[2] = (float)this.localCenter[2] + this.vfRange;
        fArray[3] = (float)this.localCenter[0] + this.vfRange;
        fArray[4] = (float)this.localCenter[1] + this.vfRange;
        fArray[5] = (float)this.localCenter[2] + this.vfRange;
        fArray[6] = (float)this.localCenter[0] - this.vfRange;
        fArray[7] = (float)this.localCenter[1] + this.vfRange;
        fArray[8] = (float)this.localCenter[2] + this.vfRange;
        fArray[9] = (float)this.localCenter[0] - this.vfRange;
        fArray[10] = (float)this.localCenter[1] - this.vfRange;
        fArray[11] = (float)this.localCenter[2] + this.vfRange;
        fArray[12] = (float)this.localCenter[0] + this.vfRange;
        fArray[13] = (float)this.localCenter[1] - this.vfRange;
        fArray[14] = (float)this.localCenter[2] - this.vfRange;
        fArray[12] = (float)this.localCenter[0] + this.vfRange;
        fArray[13] = (float)this.localCenter[1] + this.vfRange;
        fArray[14] = (float)this.localCenter[2] - this.vfRange;
        fArray[12] = (float)this.localCenter[0] + this.vfRange;
        fArray[13] = (float)this.localCenter[1] + this.vfRange;
        fArray[14] = (float)this.localCenter[2] + this.vfRange;
        fArray[12] = (float)this.localCenter[0] + this.vfRange;
        fArray[13] = (float)this.localCenter[1] - this.vfRange;
        fArray[14] = (float)this.localCenter[2] + this.vfRange;
        fArray[12] = (float)this.localCenter[0] - this.vfRange;
        fArray[13] = (float)this.localCenter[1] - this.vfRange;
        fArray[14] = (float)this.localCenter[2] - this.vfRange;
        fArray[12] = (float)this.localCenter[0] - this.vfRange;
        fArray[13] = (float)this.localCenter[1] + this.vfRange;
        fArray[14] = (float)this.localCenter[2] - this.vfRange;
        fArray[12] = (float)this.localCenter[0] + this.vfRange;
        fArray[13] = (float)this.localCenter[1] + this.vfRange;
        fArray[14] = (float)this.localCenter[2] - this.vfRange;
        fArray[12] = (float)this.localCenter[0] + this.vfRange;
        fArray[13] = (float)this.localCenter[1] - this.vfRange;
        fArray[14] = (float)this.localCenter[2] - this.vfRange;
        fArray[12] = (float)this.localCenter[0] - this.vfRange;
        fArray[13] = (float)this.localCenter[1] - this.vfRange;
        fArray[14] = (float)this.localCenter[2] + this.vfRange;
        fArray[12] = (float)this.localCenter[0] - this.vfRange;
        fArray[13] = (float)this.localCenter[1] + this.vfRange;
        fArray[14] = (float)this.localCenter[2] + this.vfRange;
        fArray[12] = (float)this.localCenter[0] - this.vfRange;
        fArray[13] = (float)this.localCenter[1] + this.vfRange;
        fArray[14] = (float)this.localCenter[2] - this.vfRange;
        fArray[12] = (float)this.localCenter[0] - this.vfRange;
        fArray[13] = (float)this.localCenter[1] - this.vfRange;
        fArray[14] = (float)this.localCenter[2] - this.vfRange;
        fArray[12] = (float)this.localCenter[0] + this.vfRange;
        fArray[13] = (float)this.localCenter[1] + this.vfRange;
        fArray[14] = (float)this.localCenter[2] + this.vfRange;
        fArray[12] = (float)this.localCenter[0] + this.vfRange;
        fArray[13] = (float)this.localCenter[1] + this.vfRange;
        fArray[14] = (float)this.localCenter[2] - this.vfRange;
        fArray[12] = (float)this.localCenter[0] - this.vfRange;
        fArray[13] = (float)this.localCenter[1] + this.vfRange;
        fArray[14] = (float)this.localCenter[2] - this.vfRange;
        fArray[12] = (float)this.localCenter[0] - this.vfRange;
        fArray[13] = (float)this.localCenter[1] + this.vfRange;
        fArray[14] = (float)this.localCenter[2] + this.vfRange;
        fArray[12] = (float)this.localCenter[0] - this.vfRange;
        fArray[13] = (float)this.localCenter[1] - this.vfRange;
        fArray[14] = (float)this.localCenter[2] - this.vfRange;
        fArray[12] = (float)this.localCenter[0] - this.vfRange;
        fArray[13] = (float)this.localCenter[1] - this.vfRange;
        fArray[14] = (float)this.localCenter[2] + this.vfRange;
        fArray[12] = (float)this.localCenter[0] + this.vfRange;
        fArray[13] = (float)this.localCenter[1] - this.vfRange;
        fArray[14] = (float)this.localCenter[2] + this.vfRange;
        fArray[12] = (float)this.localCenter[0] + this.vfRange;
        fArray[13] = (float)this.localCenter[1] - this.vfRange;
        fArray[14] = (float)this.localCenter[2] - this.vfRange;
        this.proxyGeometry.setVertices(3, this.geomData.coordinates, this.geomData.vertexCount);
    }
}

