/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.ogl.nodes.lighting;

import org.j3d.aviatrix3d.DirectionalLight;
import org.j3d.aviatrix3d.Light;
import org.j3d.aviatrix3d.NodeUpdateListener;
import org.j3d.aviatrix3d.SceneGraphObject;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.lighting.BaseDirectionalLight;
import org.web3d.vrml.renderer.ogl.nodes.OGLLightNodeType;

public class OGLDirectionalLight
extends BaseDirectionalLight
implements OGLLightNodeType,
NodeUpdateListener {
    private DirectionalLight implLight;
    private float[] flScratch;

    public OGLDirectionalLight() {
        this.init();
    }

    public OGLDirectionalLight(VRMLNodeType vRMLNodeType) {
        super(vRMLNodeType);
        this.init();
    }

    public Light getLight() {
        return this.implLight;
    }

    public void updateNodeBoundsChanges(Object object) {
    }

    public void updateNodeDataChanges(Object object) {
        this.flScratch[0] = this.vfColor[0] * this.vfIntensity;
        this.flScratch[1] = this.vfColor[1] * this.vfIntensity;
        this.flScratch[2] = this.vfColor[2] * this.vfIntensity;
        this.implLight.setDiffuseColor(this.flScratch);
        this.implLight.setSpecularColor(this.flScratch);
        this.flScratch[0] = this.vfColor[0] * this.vfAmbientIntensity;
        this.flScratch[1] = this.vfColor[1] * this.vfAmbientIntensity;
        this.flScratch[2] = this.vfColor[2] * this.vfAmbientIntensity;
        this.implLight.setAmbientColor(this.flScratch);
        this.implLight.setEnabled(this.vfOn);
        this.flScratch[0] = -this.vfDirection[0];
        this.flScratch[1] = -this.vfDirection[1];
        this.flScratch[2] = -this.vfDirection[2];
        this.implLight.setDirection(this.flScratch);
    }

    public void setAmbientIntensity(float f) throws InvalidFieldValueException {
        super.setAmbientIntensity(f);
        if (this.inSetup) {
            return;
        }
        if (this.implLight.isLive()) {
            this.implLight.dataChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeDataChanges(this.implLight);
        }
    }

    public void setColor(float[] fArray) throws InvalidFieldValueException {
        super.setColor(fArray);
        if (this.inSetup) {
            return;
        }
        if (this.implLight.isLive()) {
            this.implLight.dataChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeDataChanges(this.implLight);
        }
    }

    public void setIntensity(float f) throws InvalidFieldValueException {
        super.setIntensity(f);
        if (this.inSetup) {
            return;
        }
        if (this.implLight.isLive()) {
            this.implLight.dataChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeDataChanges(this.implLight);
        }
    }

    public void setOn(boolean bl) {
        super.setOn(bl);
        if (this.inSetup) {
            return;
        }
        if (this.implLight.isLive()) {
            this.implLight.dataChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeDataChanges(this.implLight);
        }
    }

    public SceneGraphObject getSceneGraphObject() {
        return this.implLight;
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        this.updateNodeDataChanges(null);
    }

    protected void setDirection(float[] fArray) {
        super.setDirection(fArray);
        if (this.inSetup) {
            return;
        }
        if (this.implLight.isLive()) {
            this.implLight.dataChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeDataChanges(this.implLight);
        }
    }

    private void init() {
        this.flScratch = new float[3];
        this.implLight = new DirectionalLight();
    }
}

