/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.ogl.nodes.lighting;

import org.j3d.aviatrix3d.BoundingSphere;
import org.j3d.aviatrix3d.BoundingVolume;
import org.j3d.aviatrix3d.Light;
import org.j3d.aviatrix3d.NodeUpdateListener;
import org.j3d.aviatrix3d.SceneGraphObject;
import org.j3d.aviatrix3d.SpotLight;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.lighting.BaseSpotLight;
import org.web3d.vrml.renderer.ogl.nodes.OGLLightNodeType;

public class OGLSpotLight
extends BaseSpotLight
implements OGLLightNodeType,
NodeUpdateListener {
    private SpotLight implLight;
    private float[] flScratch;
    private BoundingSphere radiusBounds;

    public OGLSpotLight() {
        this.init();
    }

    public OGLSpotLight(VRMLNodeType vRMLNodeType) {
        super(vRMLNodeType);
        this.init();
    }

    public Light getLight() {
        return this.implLight;
    }

    public void updateNodeBoundsChanges(Object object) {
    }

    public void updateNodeDataChanges(Object object) {
        this.flScratch[0] = this.vfColor[0] * this.vfAmbientIntensity;
        this.flScratch[1] = this.vfColor[1] * this.vfAmbientIntensity;
        this.flScratch[2] = this.vfColor[2] * this.vfAmbientIntensity;
        this.implLight.setAmbientColor(this.flScratch);
        this.flScratch[0] = this.vfColor[0] * this.vfIntensity;
        this.flScratch[1] = this.vfColor[1] * this.vfIntensity;
        this.flScratch[2] = this.vfColor[2] * this.vfIntensity;
        this.implLight.setDiffuseColor(this.flScratch);
        this.implLight.setSpecularColor(this.flScratch);
        this.implLight.setEnabled(this.vfOn);
        this.implLight.setPosition(this.vfLocation);
        this.implLight.setAttenuation(this.vfAttenuation);
        this.implLight.setCutOffAngle((float)((double)this.vfCutOffAngle / Math.PI * 180.0));
        this.flScratch[0] = this.vfDirection[0];
        this.flScratch[1] = this.vfDirection[1];
        this.flScratch[2] = this.vfDirection[2];
        this.implLight.setDirection(this.flScratch);
        float f = 0.5f / this.vfBeamWidth;
        this.implLight.setDropOffRateExponent(f);
        this.radiusBounds.setRadius(this.vfRadius);
        this.implLight.setEffectBounds((BoundingVolume)this.radiusBounds);
    }

    public void setAmbientIntensity(float f) throws InvalidFieldValueException {
        super.setAmbientIntensity(f);
        if (this.inSetup) {
            return;
        }
        if (this.implLight.isLive()) {
            this.implLight.dataChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeDataChanges(this.implLight);
        }
    }

    public void setColor(float[] fArray) throws InvalidFieldValueException {
        super.setColor(fArray);
        if (this.inSetup) {
            return;
        }
        if (this.implLight.isLive()) {
            this.implLight.dataChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeDataChanges(this.implLight);
        }
    }

    public void setIntensity(float f) throws InvalidFieldValueException {
        super.setIntensity(f);
        if (this.inSetup) {
            return;
        }
        if (this.implLight.isLive()) {
            this.implLight.dataChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeDataChanges(this.implLight);
        }
    }

    public void setOn(boolean bl) {
        super.setOn(bl);
        if (this.inSetup) {
            return;
        }
        if (this.implLight.isLive()) {
            this.implLight.dataChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeDataChanges(this.implLight);
        }
    }

    public SceneGraphObject getSceneGraphObject() {
        return this.implLight;
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        if (this.vrmlMajorVersion < 3 || this.vrmlMajorVersion == 3 && this.vrmlMinorVersion == 0) {
            this.implLight.setGlobalScope(true);
        } else {
            this.implLight.setGlobalScope(false);
        }
        this.updateNodeDataChanges(null);
    }

    protected void setDirection(float[] fArray) {
        super.setDirection(fArray);
        if (this.inSetup) {
            return;
        }
        if (this.implLight.isLive()) {
            this.implLight.dataChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeDataChanges(this.implLight);
        }
    }

    protected void setLocation(float[] fArray) {
        super.setLocation(fArray);
        if (this.inSetup) {
            return;
        }
        if (this.implLight.isLive()) {
            this.implLight.dataChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeDataChanges(this.implLight);
        }
    }

    protected void setRadius(float f) throws InvalidFieldValueException {
        super.setRadius(f);
        if (this.inSetup) {
            return;
        }
        if (this.implLight.isLive()) {
            this.implLight.dataChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeDataChanges(this.implLight);
        }
    }

    protected void setAttenuation(float[] fArray) throws InvalidFieldValueException {
        super.setAttenuation(fArray);
        if (this.inSetup) {
            return;
        }
        if (this.implLight.isLive()) {
            this.implLight.dataChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeDataChanges(this.implLight);
        }
    }

    protected void setBeamWidth(float f) throws InvalidFieldValueException {
        super.setBeamWidth(f);
        if (this.inSetup) {
            return;
        }
        if (this.implLight.isLive()) {
            this.implLight.dataChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeDataChanges(this.implLight);
        }
    }

    protected void setCutOffAngle(float f) throws InvalidFieldValueException {
        super.setCutOffAngle(f);
        if (this.inSetup) {
            return;
        }
        if (this.implLight.isLive()) {
            this.implLight.dataChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeDataChanges(this.implLight);
        }
    }

    private void init() {
        this.flScratch = new float[3];
        this.implLight = new SpotLight();
        this.radiusBounds = new BoundingSphere(this.vfRadius);
    }
}

