/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.ogl.nodes.navigation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.j3d.aviatrix3d.BoundingBox;
import org.j3d.aviatrix3d.BoundingVolume;
import org.j3d.aviatrix3d.Geometry;
import org.j3d.aviatrix3d.Group;
import org.j3d.aviatrix3d.Node;
import org.j3d.aviatrix3d.NodeUpdateListener;
import org.j3d.aviatrix3d.QuadArray;
import org.j3d.aviatrix3d.SceneGraphObject;
import org.j3d.aviatrix3d.Shape3D;
import org.j3d.aviatrix3d.SharedGroup;
import org.j3d.aviatrix3d.TransformGroup;
import org.j3d.geom.GeometryData;
import org.j3d.util.MatrixUtils;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.nodes.FrameStateListener;
import org.web3d.vrml.nodes.VRMLChildNodeType;
import org.web3d.vrml.nodes.VRMLExternalSynchronizedNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLPointingDeviceSensorNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.renderer.common.nodes.navigation.BaseBillboard;
import org.web3d.vrml.renderer.ogl.nodes.OGLGlobalStatus;
import org.web3d.vrml.renderer.ogl.nodes.OGLTransformNodeType;
import org.web3d.vrml.renderer.ogl.nodes.OGLUserData;
import org.web3d.vrml.renderer.ogl.nodes.OGLVRMLNode;
import org.web3d.vrml.renderer.ogl.nodes.OGLVisibilityListener;

public class OGLBillboard
extends BaseBillboard
implements OGLVRMLNode,
VRMLExternalSynchronizedNodeType,
OGLVisibilityListener,
NodeUpdateListener,
OGLTransformNodeType {
    private static final int[] SECONDARY_TYPE = new int[]{74, 88};
    private static final String BAD_PROTO_MSG = "The resolved proto instance is not a X3DChildNode type. Grouping nodes may only use ChildNode types for the children field.";
    private static final Vector3f Y_UP = new Vector3f(0.0f, 1.0f, 0.0f);
    private static final Vector3f Z_UP = new Vector3f(0.0f, 0.0f, 1.0f);
    private static final Point3f ORIGIN = new Point3f(0.0f, 0.0f, 0.0f);
    private Group oglImplGroup;
    private TransformGroup implGroup;
    private Group kidsGroup;
    private Shape3D proxyShape;
    private QuadArray proxyGeometry;
    private HashMap oglChildMap;
    private LinkedList addedChildren;
    private LinkedList removedChildren;
    private boolean matrixChanged;
    private ArrayList sensorList;
    private Matrix4f transform;
    private Matrix4f invertedTransform;
    private Matrix4f scratchTransform;
    private Vector3f axis;
    private GeometryData geomData;
    private float[] minExtents;
    private float[] maxExtents;
    private boolean transformChanged;
    private MatrixUtils matrixUtils;
    private Vector3f up;
    private Vector3f z;
    private Vector3f ax;
    private Point3f bbpos;
    private Vector3f vpos;
    private Vector3f arcp;
    private Vector3f cp;
    private Vector3f cp2;
    private AxisAngle4f aa;

    public OGLBillboard() {
        this.init();
    }

    public OGLBillboard(VRMLNodeType vRMLNodeType) {
        super(vRMLNodeType);
        this.init();
    }

    public void allEventsComplete() {
        if (this.implGroup.isLive()) {
            this.implGroup.boundsChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeBoundsChanges(this.implGroup);
        }
        super.allEventsComplete();
    }

    public SceneGraphObject getSceneGraphObject() {
        return this.oglImplGroup;
    }

    public int[] getSecondaryType() {
        return SECONDARY_TYPE;
    }

    public void setupFinished() {
        Node node;
        Object object;
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        this.oglChildMap = new HashMap();
        this.implGroup = new TransformGroup();
        this.implGroup.addChild((Node)this.proxyShape);
        this.kidsGroup = new Group();
        this.implGroup.addChild((Node)this.kidsGroup);
        if (this.isStatic && this.shareCount == 0) {
            this.oglImplGroup = this.implGroup;
        } else {
            this.oglImplGroup = new SharedGroup();
            this.oglImplGroup.addChild((Node)this.implGroup);
        }
        OGLUserData oGLUserData = new OGLUserData();
        this.implGroup.setUserData((Object)oGLUserData);
        oGLUserData.owner = this;
        if (!this.isStatic && this.sensorList.size() != 0) {
            oGLUserData.collidable = true;
            oGLUserData.isTerrain = false;
            oGLUserData.visibilityListener = this;
            oGLUserData.sensors = new VRMLPointingDeviceSensorNodeType[this.sensorList.size()];
            this.sensorList.toArray(oGLUserData.sensors);
        }
        this.sensorList = null;
        for (int i = 0; i < this.childCount; ++i) {
            object = (OGLVRMLNode)this.vfChildren.get(i);
            node = (Node)object.getSceneGraphObject();
            if (node != null) {
                this.kidsGroup.addChild(node);
            }
            this.oglChildMap.put(object, node);
        }
        if (!this.isStatic) {
            this.removedChildren = new LinkedList();
            this.addedChildren = new LinkedList();
        }
        this.axis.set(this.vfAxisOfRotation[0], this.vfAxisOfRotation[1], this.vfAxisOfRotation[2]);
        if (this.vfBboxSize[0] != -1.0f && this.vfBboxSize[1] != -1.0f && this.vfBboxSize[2] != -1.0f) {
            float[] fArray = new float[]{this.vfBboxCenter[0] - this.vfBboxSize[0] / 2.0f, this.vfBboxCenter[1] - this.vfBboxSize[1] / 2.0f, this.vfBboxCenter[2] - this.vfBboxSize[2] / 2.0f};
            object = new float[3];
            object[0] = this.vfBboxCenter[0] + this.vfBboxSize[0] / 2.0f;
            object[1] = this.vfBboxCenter[1] + this.vfBboxSize[1] / 2.0f;
            object[2] = this.vfBboxCenter[2] + this.vfBboxSize[2] / 2.0f;
            node = new BoundingBox(fArray, (float[])object);
            this.implGroup.setBounds((BoundingVolume)node);
        }
    }

    public void preEventEvaluation() {
        float f = this.minExtents[0];
        float f2 = this.minExtents[1];
        float f3 = this.minExtents[2];
        float f4 = this.maxExtents[0];
        float f5 = this.maxExtents[1];
        float f6 = this.maxExtents[2];
        BoundingVolume boundingVolume = this.kidsGroup.getBounds();
        boundingVolume.getExtents(this.minExtents, this.maxExtents);
        if (f != this.minExtents[0] || f2 != this.minExtents[1] || f3 != this.minExtents[2] || f4 != this.maxExtents[0] || f5 != this.maxExtents[1] || f6 != this.maxExtents[2]) {
            if (this.proxyGeometry.isLive()) {
                this.proxyGeometry.boundsChanged((NodeUpdateListener)this);
            } else {
                this.updateNodeBoundsChanges(this.proxyGeometry);
            }
        }
    }

    public void postEventEvaluation() {
    }

    public void visibilityStateChange(boolean bl, Point3f point3f, AxisAngle4f axisAngle4f, Matrix4f matrix4f) {
    }

    public void viewPositionChanged(Point3f point3f, AxisAngle4f axisAngle4f, Matrix4f matrix4f) {
        this.scratchTransform.mul(matrix4f, this.invertedTransform);
        this.ax.x = this.axis.x;
        this.ax.y = this.axis.y;
        this.ax.z = this.axis.z;
        float f = this.ax.lengthSquared();
        boolean bl = (double)f <= 0.001;
        this.bbpos.x = 0.0f;
        this.bbpos.y = 0.0f;
        this.bbpos.z = 0.0f;
        this.scratchTransform.transform(this.bbpos);
        this.vpos.x = point3f.x - this.bbpos.x;
        this.vpos.y = point3f.y - this.bbpos.y;
        this.vpos.z = point3f.z - this.bbpos.z;
        this.vpos.normalize();
        if (bl) {
            this.ax.x = axisAngle4f.x;
            this.ax.y = axisAngle4f.y;
            this.ax.z = axisAngle4f.z;
        }
        this.scratchTransform.transform(Z_UP, this.up);
        this.arcp.cross(this.ax, this.up);
        if ((double)this.arcp.lengthSquared() < 0.001) {
            this.transform.setIdentity();
        }
        if ((double)this.ax.lengthSquared() < 0.001) {
            this.transform.setIdentity();
        }
        this.ax.normalize();
        this.cp.cross(this.vpos, this.ax);
        if ((double)this.cp.length() < 1.0E-7) {
            this.aa.x = this.ax.x;
            this.aa.y = this.ax.y;
            this.aa.z = this.ax.z;
            this.aa.angle = -axisAngle4f.angle;
            this.transform.setIdentity();
            this.transform.setRotation(this.aa);
            this.matrixUtils.inverse(this.transform, this.invertedTransform);
            this.transformChanged = true;
            if (this.implGroup.isLive()) {
                this.implGroup.boundsChanged((NodeUpdateListener)this);
            } else {
                this.updateNodeBoundsChanges(this.implGroup);
            }
            return;
        }
        this.cp.normalize();
        this.cp2.cross(this.cp, this.up);
        double d = this.cp.dot(this.up);
        double d2 = this.cp2.length();
        double d3 = this.cp.dot(this.arcp) > 0.0f ? -1.0 : 1.0;
        float f2 = (float)Math.atan2(d, d3 * d2);
        this.aa.x = this.ax.x;
        this.aa.y = this.ax.y;
        this.aa.z = this.ax.z;
        this.aa.angle = f2;
        this.transform.setIdentity();
        this.transform.setRotation(this.aa);
        this.matrixUtils.inverse(this.transform, this.invertedTransform);
        this.transformChanged = true;
        if (this.implGroup.isLive()) {
            this.implGroup.boundsChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeBoundsChanges(this.implGroup);
        }
    }

    public Matrix4f getTransform() {
        return this.transform;
    }

    public void updateNodeBoundsChanges(Object object) {
        if (object == this.implGroup) {
            if (this.transformChanged) {
                this.implGroup.setTransform(this.transform);
                this.transformChanged = false;
            }
        } else if (object == this.kidsGroup) {
            Node node;
            int n;
            int n2 = this.addedChildren == null ? 0 : this.addedChildren.size();
            for (n = 0; n < n2; ++n) {
                node = (Node)this.addedChildren.get(n);
                this.kidsGroup.addChild(node);
            }
            n2 = this.removedChildren == null ? 0 : this.removedChildren.size();
            for (n = 0; n < n2; ++n) {
                node = (Node)this.removedChildren.get(n);
                this.kidsGroup.removeChild(node);
            }
        } else if (object == this.proxyGeometry) {
            this.updateShape();
        }
    }

    public void updateNodeDataChanges(Object object) {
    }

    public synchronized void notifyExternProtoLoaded(int n, VRMLNodeType vRMLNodeType) {
        if (!(vRMLNodeType instanceof VRMLChildNodeType) && !(vRMLNodeType instanceof VRMLProtoInstance)) {
            throw new InvalidFieldValueException(BAD_PROTO_MSG);
        }
        if (this.inSetup) {
            return;
        }
        OGLVRMLNode oGLVRMLNode = (OGLVRMLNode)vRMLNodeType;
        oGLVRMLNode.setupFinished();
        Node node = (Node)oGLVRMLNode.getSceneGraphObject();
        this.oglChildMap.put(vRMLNodeType, node);
        if (node != null) {
            if (this.implGroup.isLive()) {
                if (this.addedChildren == null) {
                    this.addedChildren = new LinkedList();
                }
                this.addedChildren.add(node);
                this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
            } else {
                this.implGroup.addChild(node);
            }
        }
    }

    protected void clearChildren() {
        int n = this.vfChildren.size();
        for (int i = 0; i < n; ++i) {
            OGLVRMLNode oGLVRMLNode = (OGLVRMLNode)this.vfChildren.get(i);
            Node node = (Node)this.oglChildMap.get(oGLVRMLNode);
            this.removedChildren.add(node);
            this.oglChildMap.remove(oGLVRMLNode);
        }
        if (!this.inSetup) {
            if (this.kidsGroup.isLive()) {
                this.kidsGroup.boundsChanged((NodeUpdateListener)this);
            } else {
                this.updateNodeBoundsChanges(this.kidsGroup);
            }
        }
        super.clearChildren();
    }

    protected void addChildNode(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        Object object;
        Node node;
        super.addChildNode(vRMLNodeType);
        OGLVRMLNode oGLVRMLNode = (OGLVRMLNode)vRMLNodeType;
        if (!this.inSetup) {
            node = (Node)oGLVRMLNode.getSceneGraphObject();
            this.addedChildren.add(node);
            this.oglChildMap.put(vRMLNodeType, node);
        }
        node = null;
        if (vRMLNodeType instanceof VRMLPointingDeviceSensorNodeType) {
            node = (VRMLPointingDeviceSensorNodeType)vRMLNodeType;
        } else if (vRMLNodeType instanceof VRMLProtoInstance && (object = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode()) instanceof VRMLPointingDeviceSensorNodeType) {
            node = (VRMLPointingDeviceSensorNodeType)object;
        }
        if (node != null) {
            if (this.inSetup) {
                this.sensorList.add(node);
            } else {
                object = (OGLUserData)this.implGroup.getUserData();
                if (object == null) {
                    object = new OGLUserData();
                    this.implGroup.setUserData(object);
                }
                if (object.sensors == null) {
                    object.sensors = new VRMLPointingDeviceSensorNodeType[1];
                    object.sensors[0] = node;
                } else {
                    int n = object.sensors.length;
                    VRMLPointingDeviceSensorNodeType[] vRMLPointingDeviceSensorNodeTypeArray = new VRMLPointingDeviceSensorNodeType[n + 1];
                    System.arraycopy(object.sensors, 0, vRMLPointingDeviceSensorNodeTypeArray, 0, n);
                    vRMLPointingDeviceSensorNodeTypeArray[n] = node;
                    object.sensors = vRMLPointingDeviceSensorNodeTypeArray;
                }
            }
        }
        if (!this.inSetup) {
            if (this.kidsGroup.isLive()) {
                this.kidsGroup.boundsChanged((NodeUpdateListener)this);
            } else {
                this.updateNodeBoundsChanges(this.kidsGroup);
            }
        }
    }

    protected void removeChildNode(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        Object object;
        Node node;
        if (!this.oglChildMap.containsKey(vRMLNodeType)) {
            return;
        }
        if (!this.inSetup) {
            node = (Node)this.oglChildMap.get(vRMLNodeType);
            this.removedChildren.add(node);
            this.oglChildMap.remove(vRMLNodeType);
            if (this.kidsGroup.isLive()) {
                this.kidsGroup.boundsChanged((NodeUpdateListener)this);
            } else {
                this.updateNodeBoundsChanges(this.kidsGroup);
            }
        }
        node = null;
        if (vRMLNodeType instanceof VRMLPointingDeviceSensorNodeType) {
            node = (VRMLPointingDeviceSensorNodeType)vRMLNodeType;
        } else if (vRMLNodeType instanceof VRMLProtoInstance && (object = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode()) instanceof VRMLPointingDeviceSensorNodeType) {
            node = (VRMLPointingDeviceSensorNodeType)object;
        }
        if (node != null) {
            object = (OGLUserData)this.oglImplGroup.getUserData();
            int n = object.sensors.length;
            if (n == 1) {
                object.sensors = null;
            } else {
                int n2;
                for (n2 = 0; n2 < n && object.sensors[n2] != node; ++n2) {
                }
                while (n2 < n - 1) {
                    object.sensors[n2] = object.sensors[n2 + 1];
                    ++n2;
                }
                VRMLPointingDeviceSensorNodeType[] vRMLPointingDeviceSensorNodeTypeArray = new VRMLPointingDeviceSensorNodeType[n - 1];
                System.arraycopy(object.sensors, 0, vRMLPointingDeviceSensorNodeTypeArray, 0, n - 1);
                object.sensors = vRMLPointingDeviceSensorNodeTypeArray;
            }
        }
        super.removeChildNode(vRMLNodeType);
    }

    private void init() {
        this.transformChanged = false;
        this.sensorList = new ArrayList();
        this.transform = new Matrix4f();
        this.invertedTransform = new Matrix4f();
        this.scratchTransform = new Matrix4f();
        this.scratchTransform.setIdentity();
        this.axis = new Vector3f();
        this.up = new Vector3f();
        this.z = new Vector3f();
        this.ax = new Vector3f();
        this.bbpos = new Point3f();
        this.vpos = new Vector3f();
        this.arcp = new Vector3f();
        this.cp = new Vector3f();
        this.cp2 = new Vector3f();
        this.aa = new AxisAngle4f();
        this.minExtents = new float[3];
        this.maxExtents = new float[3];
        this.geomData = new GeometryData();
        this.geomData.geometryType = 2;
        this.geomData.coordinates = new float[72];
        this.geomData.vertexCount = 24;
        OGLUserData oGLUserData = new OGLUserData();
        oGLUserData.geometryData = this.geomData;
        oGLUserData.collidable = false;
        oGLUserData.isTerrain = false;
        oGLUserData.visibilityListener = this;
        this.proxyGeometry = new QuadArray();
        this.proxyShape = new Shape3D();
        this.proxyShape.setAppearance(OGLGlobalStatus.invisibleAppearance);
        this.proxyShape.setGeometry((Geometry)this.proxyGeometry);
        this.proxyShape.setUserData((Object)oGLUserData);
        this.transform.setIdentity();
        this.invertedTransform.setIdentity();
        this.matrixUtils = new MatrixUtils();
    }

    private void updateShape() {
        float[] fArray = this.geomData.coordinates;
        fArray[0] = this.maxExtents[0];
        fArray[1] = this.minExtents[1];
        fArray[2] = this.maxExtents[2];
        fArray[3] = this.maxExtents[0];
        fArray[4] = this.maxExtents[1];
        fArray[5] = this.maxExtents[2];
        fArray[6] = this.minExtents[0];
        fArray[7] = this.maxExtents[1];
        fArray[8] = this.maxExtents[2];
        fArray[9] = this.minExtents[0];
        fArray[10] = this.minExtents[1];
        fArray[11] = this.maxExtents[2];
        fArray[12] = this.maxExtents[0];
        fArray[13] = this.minExtents[1];
        fArray[14] = this.minExtents[2];
        fArray[15] = this.maxExtents[0];
        fArray[16] = this.maxExtents[1];
        fArray[17] = this.minExtents[2];
        fArray[18] = this.maxExtents[0];
        fArray[19] = this.maxExtents[1];
        fArray[20] = this.maxExtents[2];
        fArray[21] = this.maxExtents[0];
        fArray[22] = this.minExtents[1];
        fArray[23] = this.maxExtents[2];
        fArray[24] = this.minExtents[0];
        fArray[25] = this.minExtents[1];
        fArray[26] = this.minExtents[2];
        fArray[27] = this.minExtents[0];
        fArray[28] = this.maxExtents[1];
        fArray[29] = this.minExtents[2];
        fArray[30] = this.maxExtents[0];
        fArray[31] = this.maxExtents[1];
        fArray[32] = this.minExtents[2];
        fArray[33] = this.maxExtents[0];
        fArray[34] = this.minExtents[1];
        fArray[35] = this.minExtents[2];
        fArray[36] = this.minExtents[0];
        fArray[37] = this.minExtents[1];
        fArray[38] = this.maxExtents[2];
        fArray[39] = this.minExtents[0];
        fArray[40] = this.maxExtents[1];
        fArray[41] = this.maxExtents[2];
        fArray[42] = this.minExtents[0];
        fArray[43] = this.maxExtents[1];
        fArray[44] = this.minExtents[2];
        fArray[45] = this.minExtents[0];
        fArray[46] = this.minExtents[1];
        fArray[47] = this.minExtents[2];
        fArray[48] = this.maxExtents[0];
        fArray[49] = this.maxExtents[1];
        fArray[50] = this.maxExtents[2];
        fArray[51] = this.maxExtents[0];
        fArray[52] = this.maxExtents[1];
        fArray[53] = this.minExtents[2];
        fArray[54] = this.minExtents[0];
        fArray[55] = this.maxExtents[1];
        fArray[56] = this.minExtents[2];
        fArray[57] = this.minExtents[0];
        fArray[58] = this.maxExtents[1];
        fArray[59] = this.maxExtents[2];
        fArray[60] = this.minExtents[0];
        fArray[61] = this.minExtents[1];
        fArray[62] = this.minExtents[2];
        fArray[63] = this.minExtents[0];
        fArray[64] = this.minExtents[1];
        fArray[65] = this.maxExtents[2];
        fArray[66] = this.maxExtents[0];
        fArray[67] = this.minExtents[1];
        fArray[68] = this.maxExtents[2];
        fArray[69] = this.maxExtents[0];
        fArray[70] = this.minExtents[1];
        fArray[71] = this.minExtents[2];
        this.proxyGeometry.setVertices(3, this.geomData.coordinates, this.geomData.vertexCount);
    }
}

