/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.ogl.nodes.navigation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import org.j3d.aviatrix3d.BoundingBox;
import org.j3d.aviatrix3d.BoundingGeometry;
import org.j3d.aviatrix3d.BoundingVolume;
import org.j3d.aviatrix3d.Group;
import org.j3d.aviatrix3d.Node;
import org.j3d.aviatrix3d.NodeUpdateListener;
import org.j3d.aviatrix3d.SceneGraphObject;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.nodes.FrameStateListener;
import org.web3d.vrml.nodes.VRMLChildNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLPointingDeviceSensorNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.renderer.common.nodes.navigation.BaseCollision;
import org.web3d.vrml.renderer.ogl.nodes.OGLUserData;
import org.web3d.vrml.renderer.ogl.nodes.OGLVRMLNode;

public class OGLCollision
extends BaseCollision
implements OGLVRMLNode,
NodeUpdateListener {
    private static final String BAD_PROTO_MSG = "The resolved proto instance is not a X3DChildNode type. Collision nodes may only use ChildNode types for the children and proxy fields.";
    private Group implGroup;
    private HashMap oglChildMap;
    private ArrayList sensorList;
    private LinkedList addedChildren;
    private LinkedList removedChildren;
    private BoundingGeometry proxyBounds;
    private boolean proxyChanged;
    private int oglChildCount;

    public OGLCollision() {
        this.init();
    }

    public OGLCollision(VRMLNodeType vRMLNodeType) {
        super(vRMLNodeType);
        this.init();
    }

    public void allEventsComplete() {
        if (this.implGroup.isLive()) {
            this.implGroup.boundsChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeBoundsChanges(this.implGroup);
        }
        super.allEventsComplete();
    }

    public void updateNodeBoundsChanges(Object object) {
        Node node;
        int n;
        int n2 = this.addedChildren == null ? 0 : this.addedChildren.size();
        for (n = 0; n < n2; ++n) {
            node = (Node)this.addedChildren.get(n);
            this.implGroup.addChild(node);
        }
        n2 = this.removedChildren == null ? 0 : this.removedChildren.size();
        for (n = 0; n < n2; ++n) {
            node = (Node)this.removedChildren.get(n);
            this.implGroup.removeChild(node);
        }
        if (this.proxyChanged) {
            this.implGroup.setBounds((BoundingVolume)this.proxyBounds);
        }
    }

    public void updateNodeDataChanges(Object object) {
        int n = 1;
        if (this.vfCollide) {
            n |= 2;
        }
        this.implGroup.setPickMask(n);
    }

    protected void setCollide(boolean bl) {
        boolean bl2 = this.vfCollide;
        super.setCollide(bl);
        if (this.inSetup) {
            return;
        }
        if (bl2 != bl) {
            if (this.implGroup.isLive()) {
                this.implGroup.dataChanged((NodeUpdateListener)this);
            } else {
                this.updateNodeDataChanges(this.implGroup);
            }
        }
    }

    public SceneGraphObject getSceneGraphObject() {
        return this.implGroup;
    }

    public void setupFinished() {
        Object object;
        int n;
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        int n2 = this.vfChildren.size();
        for (n = 0; n < n2; ++n) {
            OGLVRMLNode oGLVRMLNode = (OGLVRMLNode)this.vfChildren.get(n);
            oGLVRMLNode.setupFinished();
            object = (Node)oGLVRMLNode.getSceneGraphObject();
            if (object == null) continue;
            ++this.oglChildCount;
            this.implGroup.addChild(object);
        }
        if (!this.isStatic) {
            this.removedChildren = new LinkedList();
            this.addedChildren = new LinkedList();
        }
        this.createProxyBounds();
        n = 13;
        if (this.vfCollide) {
            n |= 2;
        }
        this.implGroup.setPickMask(n);
        if (this.proxyBounds == null && this.vfBboxSize[0] != -1.0f && this.vfBboxSize[1] != -1.0f && this.vfBboxSize[2] != -1.0f) {
            object = new float[3];
            object[0] = (Node)(this.vfBboxCenter[0] - this.vfBboxSize[0] / 2.0f);
            object[1] = (Node)(this.vfBboxCenter[1] - this.vfBboxSize[1] / 2.0f);
            object[2] = (Node)(this.vfBboxCenter[2] - this.vfBboxSize[2] / 2.0f);
            float[] fArray = new float[]{this.vfBboxCenter[0] + this.vfBboxSize[0] / 2.0f, this.vfBboxCenter[1] + this.vfBboxSize[1] / 2.0f, this.vfBboxCenter[2] + this.vfBboxSize[2] / 2.0f};
            BoundingBox boundingBox = new BoundingBox((float[])object, fArray);
            this.implGroup.setBounds((BoundingVolume)boundingBox);
        }
    }

    public synchronized void notifyExternProtoLoaded(int n, VRMLNodeType vRMLNodeType) {
        if (!(vRMLNodeType instanceof VRMLChildNodeType) && !(vRMLNodeType instanceof VRMLProtoInstance)) {
            throw new InvalidFieldValueException(BAD_PROTO_MSG);
        }
        if (this.inSetup) {
            return;
        }
        OGLVRMLNode oGLVRMLNode = (OGLVRMLNode)vRMLNodeType;
        oGLVRMLNode.setupFinished();
        Node node = (Node)oGLVRMLNode.getSceneGraphObject();
        if (n == 7) {
            this.createProxyBounds();
        } else {
            this.oglChildMap.put(vRMLNodeType, node);
            if (node != null) {
                if (this.implGroup.isLive()) {
                    if (this.addedChildren == null) {
                        this.addedChildren = new LinkedList();
                    }
                    this.addedChildren.add(node);
                    this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
                } else {
                    this.implGroup.addChild(node);
                }
            }
        }
    }

    protected void clearChildren() {
        this.oglChildCount = 0;
        super.clearChildren();
        if (!this.inSetup) {
            return;
        }
        if (this.implGroup.isLive()) {
            this.implGroup.boundsChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeBoundsChanges(this.implGroup);
        }
    }

    protected void addChildNode(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        Object object;
        Node node;
        super.addChildNode(vRMLNodeType);
        OGLVRMLNode oGLVRMLNode = (OGLVRMLNode)vRMLNodeType;
        if (!this.inSetup) {
            node = (Node)oGLVRMLNode.getSceneGraphObject();
            this.addedChildren.add(node);
            this.oglChildMap.put(vRMLNodeType, node);
            if (this.implGroup.isLive()) {
                this.addedChildren.add(node);
                this.implGroup.boundsChanged((NodeUpdateListener)this);
            } else {
                this.implGroup.addChild(node);
            }
        }
        node = null;
        if (vRMLNodeType instanceof VRMLPointingDeviceSensorNodeType) {
            node = (VRMLPointingDeviceSensorNodeType)vRMLNodeType;
        } else if (vRMLNodeType instanceof VRMLProtoInstance && (object = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode()) instanceof VRMLPointingDeviceSensorNodeType) {
            node = (VRMLPointingDeviceSensorNodeType)object;
        }
        if (node != null) {
            if (this.inSetup) {
                this.sensorList.add(node);
            } else {
                object = (OGLUserData)this.implGroup.getUserData();
                if (object == null) {
                    object = new OGLUserData();
                    this.implGroup.setUserData(object);
                }
                if (object.sensors == null) {
                    object.sensors = new VRMLPointingDeviceSensorNodeType[1];
                    object.sensors[0] = node;
                } else {
                    int n = object.sensors.length;
                    VRMLPointingDeviceSensorNodeType[] vRMLPointingDeviceSensorNodeTypeArray = new VRMLPointingDeviceSensorNodeType[n + 1];
                    System.arraycopy(object.sensors, 0, vRMLPointingDeviceSensorNodeTypeArray, 0, n);
                    vRMLPointingDeviceSensorNodeTypeArray[n] = node;
                    object.sensors = vRMLPointingDeviceSensorNodeTypeArray;
                }
            }
        }
    }

    protected void removeChildNode(VRMLNodeType vRMLNodeType) {
        Object object;
        Node node;
        if (!this.oglChildMap.containsKey(vRMLNodeType)) {
            return;
        }
        if (!this.inSetup) {
            node = (Node)this.oglChildMap.get(vRMLNodeType);
            this.oglChildMap.remove(vRMLNodeType);
            if (this.implGroup.isLive()) {
                this.removedChildren.add(node);
                this.implGroup.boundsChanged((NodeUpdateListener)this);
            } else {
                this.implGroup.removeChild(node);
            }
        }
        node = null;
        if (vRMLNodeType instanceof VRMLPointingDeviceSensorNodeType) {
            node = (VRMLPointingDeviceSensorNodeType)vRMLNodeType;
        } else if (vRMLNodeType instanceof VRMLProtoInstance && (object = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode()) instanceof VRMLPointingDeviceSensorNodeType) {
            node = (VRMLPointingDeviceSensorNodeType)object;
        }
        if (node != null) {
            object = (OGLUserData)this.implGroup.getUserData();
            int n = object.sensors.length;
            if (n == 1) {
                object.sensors = null;
            } else {
                int n2;
                for (n2 = 0; n2 < n && object.sensors[n2] != node; ++n2) {
                }
                while (n2 < n - 1) {
                    object.sensors[n2] = object.sensors[n2 + 1];
                    ++n2;
                }
                VRMLPointingDeviceSensorNodeType[] vRMLPointingDeviceSensorNodeTypeArray = new VRMLPointingDeviceSensorNodeType[n - 1];
                System.arraycopy(object.sensors, 0, vRMLPointingDeviceSensorNodeTypeArray, 0, n - 1);
                object.sensors = vRMLPointingDeviceSensorNodeTypeArray;
            }
        }
        super.removeChildNode(vRMLNodeType);
    }

    protected void setProxy(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        super.setProxy(vRMLNodeType);
        this.createProxyBounds();
    }

    private void createProxyBounds() {
        if (this.vfProxy == null) {
            return;
        }
        OGLVRMLNode oGLVRMLNode = (OGLVRMLNode)this.vfProxy;
        SceneGraphObject sceneGraphObject = oGLVRMLNode.getSceneGraphObject();
        if (sceneGraphObject == null || !(sceneGraphObject instanceof Node)) {
            return;
        }
        this.proxyBounds = new BoundingGeometry((Node)sceneGraphObject);
        if (this.implGroup.isLive()) {
            this.proxyChanged = true;
            this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
        } else {
            this.implGroup.setBounds((BoundingVolume)this.proxyBounds);
        }
    }

    private void init() {
        this.implGroup = new Group();
        this.oglChildCount = 0;
        this.oglChildMap = new HashMap();
        this.sensorList = new ArrayList();
        this.proxyChanged = false;
    }
}

