/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.ogl.nodes.navigation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.j3d.aviatrix3d.BoundingBox;
import org.j3d.aviatrix3d.BoundingVolume;
import org.j3d.aviatrix3d.Geometry;
import org.j3d.aviatrix3d.Group;
import org.j3d.aviatrix3d.Node;
import org.j3d.aviatrix3d.NodeUpdateListener;
import org.j3d.aviatrix3d.QuadArray;
import org.j3d.aviatrix3d.SceneGraphObject;
import org.j3d.aviatrix3d.Shape3D;
import org.j3d.aviatrix3d.SharedGroup;
import org.j3d.aviatrix3d.SwitchGroup;
import org.j3d.geom.GeometryData;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.nodes.FrameStateListener;
import org.web3d.vrml.nodes.VRMLChildNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLPointingDeviceSensorNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.renderer.common.nodes.navigation.BaseLOD;
import org.web3d.vrml.renderer.ogl.nodes.OGLGlobalStatus;
import org.web3d.vrml.renderer.ogl.nodes.OGLUserData;
import org.web3d.vrml.renderer.ogl.nodes.OGLVRMLNode;
import org.web3d.vrml.renderer.ogl.nodes.OGLVisibilityListener;

public class OGLLOD
extends BaseLOD
implements OGLVRMLNode,
OGLVisibilityListener,
NodeUpdateListener {
    private static final String BAD_PROTO_MSG = "The resolved proto instance is not a X3DChildNode type. Grouping nodes may only use ChildNode types for the children field.";
    private Group oglImplGroup;
    private SwitchGroup implSwitch;
    private Shape3D proxyShape;
    private QuadArray proxyGeometry;
    private HashMap oglChildMap;
    private LinkedList addedChildren;
    private LinkedList removedChildren;
    private ArrayList sensorList;
    private GeometryData geomData;
    private boolean activeChildChanged;
    private int activeObject;
    private Vector3f translation;

    public OGLLOD() {
        this.init();
    }

    public OGLLOD(VRMLNodeType vRMLNodeType) {
        super(vRMLNodeType);
        this.init();
    }

    public SceneGraphObject getSceneGraphObject() {
        return this.oglImplGroup;
    }

    public void setupFinished() {
        Node node;
        Object object;
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        this.oglChildMap = new HashMap();
        this.oglImplGroup = this.isStatic && this.shareCount == 0 ? new Group() : new SharedGroup();
        this.implSwitch = new SwitchGroup();
        this.oglImplGroup.addChild((Node)this.proxyShape);
        this.oglImplGroup.addChild((Node)this.implSwitch);
        if (!this.isStatic && this.sensorList.size() != 0) {
            OGLUserData oGLUserData = new OGLUserData();
            oGLUserData.collidable = false;
            oGLUserData.isTerrain = false;
            oGLUserData.visibilityListener = this;
            this.implSwitch.setUserData((Object)oGLUserData);
            oGLUserData.sensors = new VRMLPointingDeviceSensorNodeType[this.sensorList.size()];
            this.sensorList.toArray(oGLUserData.sensors);
        }
        this.sensorList = null;
        for (int i = 0; i < this.childCount; ++i) {
            object = (OGLVRMLNode)this.vfChildren.get(i);
            node = (Node)object.getSceneGraphObject();
            if (node != null) {
                this.implSwitch.addChild(node);
            }
            this.oglChildMap.put(object, node);
        }
        this.activeObject = this.rangeLen > this.childCount ? this.childCount : this.rangeLen;
        this.implSwitch.setActiveChild(this.activeObject);
        if (!this.isStatic) {
            this.removedChildren = new LinkedList();
            this.addedChildren = new LinkedList();
        }
        this.setupShape();
        if (this.vfBboxSize[0] != -1.0f && this.vfBboxSize[1] != -1.0f && this.vfBboxSize[2] != -1.0f) {
            float[] fArray = new float[]{this.vfBboxCenter[0] - this.vfBboxSize[0] / 2.0f, this.vfBboxCenter[1] - this.vfBboxSize[1] / 2.0f, this.vfBboxCenter[2] - this.vfBboxSize[2] / 2.0f};
            object = new float[3];
            object[0] = this.vfBboxCenter[0] + this.vfBboxSize[0] / 2.0f;
            object[1] = this.vfBboxCenter[1] + this.vfBboxSize[1] / 2.0f;
            object[2] = this.vfBboxCenter[2] + this.vfBboxSize[2] / 2.0f;
            node = new BoundingBox(fArray, (float[])object);
            this.oglImplGroup.setBounds((BoundingVolume)node);
        }
    }

    public void visibilityStateChange(boolean bl, Point3f point3f, AxisAngle4f axisAngle4f, Matrix4f matrix4f) {
        if (!bl) {
            this.activeChildChanged = true;
            if (this.implSwitch.isLive()) {
                this.implSwitch.boundsChanged((NodeUpdateListener)this);
            } else {
                this.updateNodeBoundsChanges(this.implSwitch);
            }
        } else {
            matrix4f.get(this.translation);
            this.translation.x += this.vfCenter[0];
            this.translation.y += this.vfCenter[1];
            this.translation.z += this.vfCenter[2];
            this.translation.sub((Tuple3f)point3f);
            double d = this.translation.lengthSquared();
            int n = this.activeObject;
            this.activeObject = this.rangeLen;
            for (int i = 0; i < this.rangeLen; ++i) {
                if (!(d <= (double)this.rangeSquared[i])) continue;
                this.activeObject = i;
                break;
            }
            if (this.activeObject > this.childCount) {
                this.activeObject = this.childCount;
            }
            if (n != this.activeObject) {
                this.activeChildChanged = true;
                if (this.implSwitch.isLive()) {
                    this.implSwitch.boundsChanged((NodeUpdateListener)this);
                } else {
                    this.updateNodeBoundsChanges(this.implSwitch);
                }
            }
            if (this.activeChildChanged) {
                this.setLevelChanged(this.activeObject);
            }
        }
    }

    public void viewPositionChanged(Point3f point3f, AxisAngle4f axisAngle4f, Matrix4f matrix4f) {
        matrix4f.get(this.translation);
        this.translation.x += this.vfCenter[0];
        this.translation.y += this.vfCenter[1];
        this.translation.z += this.vfCenter[2];
        this.translation.sub((Tuple3f)point3f);
        double d = this.translation.lengthSquared();
        int n = this.rangeLen;
        for (int i = 0; i < this.rangeLen; ++i) {
            if (!(d <= (double)this.rangeSquared[i])) continue;
            n = i;
            break;
        }
        if (n != this.activeObject) {
            this.activeChildChanged = true;
            this.activeObject = n;
            if (this.implSwitch.isLive()) {
                this.implSwitch.boundsChanged((NodeUpdateListener)this);
            } else {
                this.updateNodeBoundsChanges(this.implSwitch);
            }
            this.setLevelChanged(this.activeObject);
        }
    }

    public void allEventsComplete() {
        if (this.oglImplGroup.isLive()) {
            this.oglImplGroup.boundsChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeBoundsChanges(this.oglImplGroup);
        }
        super.allEventsComplete();
    }

    public void updateNodeBoundsChanges(Object object) {
        if (object == this.implSwitch) {
            Node node;
            int n;
            if (this.activeChildChanged) {
                this.implSwitch.setActiveChild(this.activeObject);
                this.activeChildChanged = false;
            }
            int n2 = this.addedChildren == null ? 0 : this.addedChildren.size();
            for (n = 0; n < n2; ++n) {
                node = (Node)this.addedChildren.get(n);
                this.implSwitch.addChild(node);
            }
            n2 = this.removedChildren == null ? 0 : this.removedChildren.size();
            for (n = 0; n < n2; ++n) {
                node = (Node)this.removedChildren.get(n);
                this.implSwitch.removeChild(node);
            }
        }
    }

    public void updateNodeDataChanges(Object object) {
    }

    public synchronized void notifyExternProtoLoaded(int n, VRMLNodeType vRMLNodeType) {
        if (!(vRMLNodeType instanceof VRMLChildNodeType) && !(vRMLNodeType instanceof VRMLProtoInstance)) {
            throw new InvalidFieldValueException(BAD_PROTO_MSG);
        }
        if (this.inSetup) {
            return;
        }
        OGLVRMLNode oGLVRMLNode = (OGLVRMLNode)vRMLNodeType;
        oGLVRMLNode.setupFinished();
        Node node = (Node)oGLVRMLNode.getSceneGraphObject();
        this.oglChildMap.put(vRMLNodeType, node);
        if (node != null) {
            if (this.oglImplGroup.isLive()) {
                if (this.addedChildren == null) {
                    this.addedChildren = new LinkedList();
                }
                this.addedChildren.add(node);
                this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
            } else {
                this.oglImplGroup.addChild(node);
            }
        }
    }

    protected void clearChildren() {
        int n = this.vfChildren.size();
        for (int i = 0; i < n; ++i) {
            OGLVRMLNode oGLVRMLNode = (OGLVRMLNode)this.vfChildren.get(i);
            Node node = (Node)this.oglChildMap.get(oGLVRMLNode);
            this.removedChildren.add(node);
            this.oglChildMap.remove(oGLVRMLNode);
        }
        if (!this.inSetup) {
            if (this.implSwitch.isLive()) {
                this.implSwitch.boundsChanged((NodeUpdateListener)this);
            } else {
                this.updateNodeBoundsChanges(this.implSwitch);
            }
        }
        super.clearChildren();
    }

    protected void addChildNode(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        Object object;
        Node node;
        super.addChildNode(vRMLNodeType);
        OGLVRMLNode oGLVRMLNode = (OGLVRMLNode)vRMLNodeType;
        if (!this.inSetup) {
            node = (Node)oGLVRMLNode.getSceneGraphObject();
            this.addedChildren.add(node);
            this.oglChildMap.put(vRMLNodeType, node);
        }
        node = null;
        if (vRMLNodeType instanceof VRMLPointingDeviceSensorNodeType) {
            node = (VRMLPointingDeviceSensorNodeType)vRMLNodeType;
        } else if (vRMLNodeType instanceof VRMLProtoInstance && (object = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode()) instanceof VRMLPointingDeviceSensorNodeType) {
            node = (VRMLPointingDeviceSensorNodeType)object;
        }
        if (node != null) {
            if (this.inSetup) {
                this.sensorList.add(node);
            } else {
                object = (OGLUserData)this.implSwitch.getUserData();
                if (object.sensors == null) {
                    object.sensors = new VRMLPointingDeviceSensorNodeType[1];
                    object.sensors[0] = node;
                } else {
                    int n = object.sensors.length;
                    VRMLPointingDeviceSensorNodeType[] vRMLPointingDeviceSensorNodeTypeArray = new VRMLPointingDeviceSensorNodeType[n + 1];
                    System.arraycopy(object.sensors, 0, vRMLPointingDeviceSensorNodeTypeArray, 0, n);
                    vRMLPointingDeviceSensorNodeTypeArray[n] = node;
                    object.sensors = vRMLPointingDeviceSensorNodeTypeArray;
                }
            }
        }
        if (!this.inSetup) {
            if (this.implSwitch.isLive()) {
                this.implSwitch.boundsChanged((NodeUpdateListener)this);
            } else {
                this.updateNodeBoundsChanges(this.implSwitch);
            }
        }
    }

    protected void removeChildNode(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        if (!this.oglChildMap.containsKey(vRMLNodeType)) {
            return;
        }
        if (!this.inSetup) {
            Node node = (Node)this.oglChildMap.get(vRMLNodeType);
            this.removedChildren.add(node);
            this.oglChildMap.remove(vRMLNodeType);
            if (this.implSwitch.isLive()) {
                this.implSwitch.boundsChanged((NodeUpdateListener)this);
            } else {
                this.updateNodeBoundsChanges(this.implSwitch);
            }
        }
        super.removeChildNode(vRMLNodeType);
    }

    private void init() {
        this.activeChildChanged = false;
        this.sensorList = new ArrayList();
        this.translation = new Vector3f();
        this.geomData = new GeometryData();
        this.geomData.geometryType = 2;
        this.geomData.coordinates = new float[72];
        this.geomData.vertexCount = 24;
        OGLUserData oGLUserData = new OGLUserData();
        oGLUserData.geometryData = this.geomData;
        oGLUserData.collidable = false;
        oGLUserData.isTerrain = false;
        oGLUserData.visibilityListener = this;
        this.proxyGeometry = new QuadArray();
        this.proxyShape = new Shape3D();
        this.proxyShape.setAppearance(OGLGlobalStatus.invisibleAppearance);
        this.proxyShape.setGeometry((Geometry)this.proxyGeometry);
        this.proxyShape.setUserData((Object)oGLUserData);
        this.proxyShape.setPickMask(12);
    }

    private void setupShape() {
        if (this.rangeLen == 0) {
            return;
        }
        float f = this.vfRange[this.rangeLen - 1];
        float[] fArray = this.geomData.coordinates;
        fArray[0] = this.vfCenter[0] + f;
        fArray[1] = this.vfCenter[1] - f;
        fArray[2] = this.vfCenter[2] + f;
        fArray[3] = this.vfCenter[0] + f;
        fArray[4] = this.vfCenter[1] + f;
        fArray[5] = this.vfCenter[2] + f;
        fArray[6] = this.vfCenter[0] - f;
        fArray[7] = this.vfCenter[1] + f;
        fArray[8] = this.vfCenter[2] + f;
        fArray[9] = this.vfCenter[0] - f;
        fArray[10] = this.vfCenter[1] - f;
        fArray[11] = this.vfCenter[2] + f;
        fArray[12] = this.vfCenter[0] + f;
        fArray[13] = this.vfCenter[1] - f;
        fArray[14] = this.vfCenter[2] - f;
        fArray[12] = this.vfCenter[0] + f;
        fArray[13] = this.vfCenter[1] + f;
        fArray[14] = this.vfCenter[2] - f;
        fArray[12] = this.vfCenter[0] + f;
        fArray[13] = this.vfCenter[1] + f;
        fArray[14] = this.vfCenter[2] + f;
        fArray[12] = this.vfCenter[0] + f;
        fArray[13] = this.vfCenter[1] - f;
        fArray[14] = this.vfCenter[2] + f;
        fArray[12] = this.vfCenter[0] - f;
        fArray[13] = this.vfCenter[1] - f;
        fArray[14] = this.vfCenter[2] - f;
        fArray[12] = this.vfCenter[0] - f;
        fArray[13] = this.vfCenter[1] + f;
        fArray[14] = this.vfCenter[2] - f;
        fArray[12] = this.vfCenter[0] + f;
        fArray[13] = this.vfCenter[1] + f;
        fArray[14] = this.vfCenter[2] - f;
        fArray[12] = this.vfCenter[0] + f;
        fArray[13] = this.vfCenter[1] - f;
        fArray[14] = this.vfCenter[2] - f;
        fArray[12] = this.vfCenter[0] - f;
        fArray[13] = this.vfCenter[1] - f;
        fArray[14] = this.vfCenter[2] + f;
        fArray[12] = this.vfCenter[0] - f;
        fArray[13] = this.vfCenter[1] + f;
        fArray[14] = this.vfCenter[2] + f;
        fArray[12] = this.vfCenter[0] - f;
        fArray[13] = this.vfCenter[1] + f;
        fArray[14] = this.vfCenter[2] - f;
        fArray[12] = this.vfCenter[0] - f;
        fArray[13] = this.vfCenter[1] - f;
        fArray[14] = this.vfCenter[2] - f;
        fArray[12] = this.vfCenter[0] + f;
        fArray[13] = this.vfCenter[1] + f;
        fArray[14] = this.vfCenter[2] + f;
        fArray[12] = this.vfCenter[0] + f;
        fArray[13] = this.vfCenter[1] + f;
        fArray[14] = this.vfCenter[2] - f;
        fArray[12] = this.vfCenter[0] - f;
        fArray[13] = this.vfCenter[1] + f;
        fArray[14] = this.vfCenter[2] - f;
        fArray[12] = this.vfCenter[0] - f;
        fArray[13] = this.vfCenter[1] + f;
        fArray[14] = this.vfCenter[2] + f;
        fArray[12] = this.vfCenter[0] - f;
        fArray[13] = this.vfCenter[1] - f;
        fArray[14] = this.vfCenter[2] - f;
        fArray[12] = this.vfCenter[0] - f;
        fArray[13] = this.vfCenter[1] - f;
        fArray[14] = this.vfCenter[2] + f;
        fArray[12] = this.vfCenter[0] + f;
        fArray[13] = this.vfCenter[1] - f;
        fArray[14] = this.vfCenter[2] + f;
        fArray[12] = this.vfCenter[0] + f;
        fArray[13] = this.vfCenter[1] - f;
        fArray[14] = this.vfCenter[2] - f;
        this.proxyGeometry.setVertices(3, this.geomData.coordinates, this.geomData.vertexCount);
    }
}

